/*
 * @(#)StandardSingleRcptBufferedCommunicationActor.java            2004. 12. 6.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.mass.actor;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.mail.SendState;

/**
 * <br>
 * 1 to 1 메일 발송의 단계를 구체화 해 놓은 객체. <br>
 * 실제 메일 발송의 작업을 정의해 놓았다.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class StandardSingleRcptBufferedCommunicationActor extends AbstractSingleRcptCommunicationActor {
	

	/** Creates a new instance of StandardSingleRcptBufferedCommunicationActor */
	public StandardSingleRcptBufferedCommunicationActor() throws Exception {
		super();
	}

	protected void work() throws Exception {
		// 자 시작 합니다.
		this.CURR_STEP = SendState.WAIT;

		boolean __RSET_SUCCESS_FLAG__ = true;
		boolean __RECONNECT_FLAG__ = false;

		String __CURRENT_DOMAIN = "^^";

		int __RSET_SUCCESS_COUNT__ = 0;

		while (true) {
			// 없으면 다시 받아온다.
			if( this.RCPT_TO == null ) {
				this.RCPT_TO = this.INNER_BUFFERED_BIN.popupNoWait();
			}

			if( this.RCPT_TO == null )
				return;

			if( this.splitRcptInfo() == null ) {
				continue;
			}

			// 여러개 뭉친 녀석들을 쪼갠거를 하나씩 처리를 한다.
			
			int resetsize = this.PARSED_RCPT_INFO.size();
			
			while (this.PARSED_RCPT_INFO.size() > 0) {
				Object NEXT_SPOOL = this.PARSED_RCPT_INFO.removeFirst();

				if( !this.parseRcptInfo(NEXT_SPOOL) ) {
					continue;
				}

				// 연결이 된 상태에서 딜레이 시간이 있으면 잠시 쉬어 간다.
				if( this.connection_delay > 0 && isConnect() ) {
					// 연결이 되어 있다면
					if (log.isDebugEnabled()) {
						log("connection close and into sleep....");
						log.debug("connection close and into sleep....");
					}

					closeConnection();

					try {
						Thread.currentThread().sleep(this.connection_delay);
					}
					catch(Exception e) {
					}
					if (log.isDebugEnabled()) {
						log.debug("wake up....");
					}
				}

				// RCPT 보내기 전에 보낸다고 54-00 을 마킹해야한다.
				// 다른 도메인을 보내는 녀석이기 때문에 어디로 붙을지는 모른다.
				// 그래서 연결 호스트는 널이다.
				super.resetConnectionTime();
				start_process(RCPT_ARRAY);
				/* jinkwon
				 * resetsize 적용 하면서 이부분은 필요가 없어 졌음.
				 */
				// 도메인이 같고 네트웍오류가 아니라면 RSET을 시도한다.
				/*if( isConnect() && __CURRENT_DOMAIN.equals(RCPT_ARRAY[INDEX_OF_DOMAIN]) && (__RSET_SUCCESS_COUNT__ < this.rset_count) ) {
					if( this.CURR_STEP > SendState.HELO && this.send_state.getLogLevel() != LOG_LEVEL_N_ERROR && __RSET_SUCCESS_FLAG__ ) {
						// RSET 하러 갑니다.
						step(SendState.RSET, null, RCPT_ARRAY[INDEX_OF_DOMAIN], RCPT_ARRAY[INDEX_OF_STEP]);

						*//**
						 * RSET이 실패하면 연결부터 다시한다.
						 *//*
						if( this.send_state.isError() ) {
							__RSET_SUCCESS_FLAG__ = false;
						}
						else {
							__RSET_SUCCESS_FLAG__ = true;
							__RECONNECT_FLAG__ = false;
							__RSET_SUCCESS_COUNT__++;
						}
					}
					else {
						__RECONNECT_FLAG__ = true;
					}
				}else {*/
					if( STEP_DEBUG ){
						log("DIFFERENT DOMAIN RECONNECT");
					}
					__CURRENT_DOMAIN = RCPT_ARRAY[INDEX_OF_DOMAIN];
					__RECONNECT_FLAG__ = true;
					__RSET_SUCCESS_FLAG__ = true;
				//}

				if( __RECONNECT_FLAG__ || !__RSET_SUCCESS_FLAG__ ) {
					// 다시연결하면 재연결 카운트를 0으로 한다.
					__RSET_SUCCESS_COUNT__ = 0;

					// 연결 되어 있다면 일단 연결을 종료하고
					if( isConnect() ){
						closeConnection();
					}

					// 한번 에러가 발생한 도메인은 RSET을 다시 시도하지 않는것이 좋다.

					// 대상 도메인의 메일 서버로 연결을 시도 합니다.
					if( STEP_DEBUG ){
						log("step connect DOMAIN");
					}
					connect(RCPT_ARRAY[INDEX_OF_DOMAIN], RCPT_ARRAY[INDEX_OF_STEP]);

					if( this.sendState.isError() ) {
						if( STEP_DEBUG ){
							log("step connect DOMAIN FAIL");
						}
						_error_process();
						continue;
					}

					// HELO 하러 갑니다.
					step(SendState.HELO, eMsLocale.SMTP_LOCAL_HOST[0], RCPT_ARRAY[INDEX_OF_DOMAIN], RCPT_ARRAY[INDEX_OF_STEP]);

					if( this.sendState.isError() ) {
						_error_process();
						continue;
					}
				}
				else if( eMsLocale.RSET_HELO_RESEND_DOMAIN.indexOf(RCPT_ARRAY[INDEX_OF_DOMAIN]) > 0 ) {
					// RSET에 성공하였다면 HELO 다시 보내야 하는 도메인은 HELO를 다시 보낸다.
					// 다시 HELO 하러 갑니다.
					step(SendState.HELO, eMsLocale.SMTP_LOCAL_HOST[0], RCPT_ARRAY[INDEX_OF_DOMAIN], RCPT_ARRAY[INDEX_OF_STEP]);

					if( this.sendState.isError() ) {
						_error_process();
						continue;
					}
				}

				if (eMsLocale.MGS_FLAG) {
					// MGS SEQ 하러 갑니다.
					step(SendState.SEQ, RCPT_ARRAY[INDEX_OF_MAIL_FROM], RCPT_ARRAY[INDEX_OF_DOMAIN], RCPT_ARRAY[INDEX_OF_STEP]);
				}
				
				// MAIL_FROM 하러 갑니다.
				step(SendState.MAIL_FROM, RCPT_ARRAY[INDEX_OF_MAIL_FROM], RCPT_ARRAY[INDEX_OF_DOMAIN], RCPT_ARRAY[INDEX_OF_STEP]);
				if( this.sendState.isError() ) {
					_error_process();
					continue;
				}

				// 이제 중요한 RCPT 입니다.
				step(SendState.RCPT_TO, RCPT_ARRAY[INDEX_OF_TOKEN_ID], RCPT_ARRAY[INDEX_OF_DOMAIN], RCPT_ARRAY[INDEX_OF_STEP]);

				if( this.sendState.isError() ) {
					error_process(RCPT_ARRAY);
					continue;
				}

				// DATA 를 전송합니다.
				step(SendState.DATA, null, RCPT_ARRAY[INDEX_OF_DOMAIN], RCPT_ARRAY[INDEX_OF_STEP]);
				if( this.sendState.isError() ) {
					error_process(RCPT_ARRAY);
					continue;
				}

				// 실제 메일 바디를 전송합니다.
				step(SendState.DATA_BODY, RCPT_ARRAY[INDEX_OF_CONTENT], RCPT_ARRAY[INDEX_OF_DOMAIN], RCPT_ARRAY[INDEX_OF_STEP]);
				if( this.sendState.isError() ) {
					error_process(RCPT_ARRAY);
					continue;
				}

				success_process(RCPT_ARRAY);
			}
		}
	}

	/**
	 */
	protected void all_error_process() {

		if( STEP_DEBUG )
			log("all error");
		error_process(RCPT_ARRAY);

		parsedListAllErrorProcess();
	}
}
