/*
 * @(#)StandardMutipleRcptBufferedCommunicationActor.java            2004. 12. 6.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.mass.actor;

import java.util.Iterator;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.mail.SendState;

/**
 * <br>
 * 동보 메일 발송의 단계를 구체화 해 놓은 객체. <br>
 * 실제 메일 발송의 작업을 정의해 놓았다.
 * 
 * @version
 * @author lena
 *  
 */
@Slf4j
public class StandardMultipleRcptBufferedCommunicationActor extends AbstractMultipleRcptCommunicationActor {

	/** Creates a new instance of StandardMutipleRcptBufferedCommunicationActor */
	public StandardMultipleRcptBufferedCommunicationActor() throws Exception {
		super();
	}

	/**
	 * ConnectException이 발생한 도메인에 대한 처리를 담당한다.
	 * 
	 * @param hostname
	 */
	protected void processBlanListHost(String hostname) {
		//		BlackListContainer.registBlackListDomain(hostname);
	}

	protected void work() throws Exception {

		//자 시작 합니다.
		this.CURR_STEP = SendState.WAIT;

		boolean __RSET_SUCCESS_FLAG__ = true;
		boolean __RECONNECT_FLAG__ = false;

		String __CURRENT_DOMAIN = "^^";

		int __RSET_SUCCESS_COUNT__ = 0;

		while (true) {

			//없으면 다시 받아온다.
			if( this.RCPT_TO == null ) {
				this.RCPT_TO = this.INNER_BUFFERED_BIN.popupNoWait();
			}

			if( this.RCPT_TO == null ) {
				return;
			}

			if (log.isDebugEnabled()) {
				log("patch next spool:" + this.RCPT_TO.toString());
			}

			//초기화하고
			this.sendState.reset();

			//하나를 끄집어 낸다.
			String __NOW_DOMAIN = super.splitRcptInfo();

			// 도메인이 같고 네트웍오류가 아니라면 RSET을 시도한다.
			if( __CURRENT_DOMAIN.equals(__NOW_DOMAIN) ) {
				if( this.CURR_STEP > SendState.HELO && this.sendState.getLogLevel() != LOG_LEVEL_N_ERROR && __RSET_SUCCESS_FLAG__ ) {

					// RSET 하러 갑니다.
					step(SendState.RSET, null, __NOW_DOMAIN, RCPT_ARRAY[INDEX_OF_STEP]);

					//RSET이 실패하면 연결부터 다시한다.
					if( this.sendState.isError() ) {
						__RSET_SUCCESS_FLAG__ = false;
					}
					else {
						__RSET_SUCCESS_FLAG__ = true;
						__RECONNECT_FLAG__ = false;
						__RSET_SUCCESS_COUNT__++;
					}
				}
				else {
					__RECONNECT_FLAG__ = true;
				}
			}
			else {
				if( STEP_DEBUG ) {
					log("DIFFERENT DOMAIN RECONNECT");
				}
				__CURRENT_DOMAIN = __NOW_DOMAIN;
				__RECONNECT_FLAG__ = true;
				__RSET_SUCCESS_FLAG__ = false;
			}

			if( __RECONNECT_FLAG__ || !__RSET_SUCCESS_FLAG__ ) {
				// 다시연결하면 재연결 카운트를 0으로 한다.
				__RSET_SUCCESS_COUNT__ = 0;

				// 연결 되어 있다면 일단 연결을 종료하고
				if( isConnect() )
					closeConnection();

				// 한번 에러가 발생한 도메인은 RSET을 다시 시도하지 않는것이 좋다.

				// 대상 도메인의 메일 서버로 연결을 시도 합니다.
				if (log.isDebugEnabled()) {
					log("step connect DOMAIN:" + __NOW_DOMAIN);
				}

				connect(__NOW_DOMAIN, RCPT_ARRAY[INDEX_OF_STEP]);

				if( this.sendState.isError() ) {
					all_error_process();
					continue;
				}

				// HELO 하러 갑니다.
				step(SendState.HELO, eMsLocale.SMTP_LOCAL_HOST[0], __NOW_DOMAIN, RCPT_ARRAY[INDEX_OF_STEP]);

				if( this.sendState.isError() ) {
					all_error_process();
					continue;
				}
			}
			else if( eMsLocale.RSET_HELO_RESEND_DOMAIN.indexOf(__NOW_DOMAIN) > 0 ) {
				// RSET에 성공하였다면 HELO 다시 보내야 하는 도메인은 HELO를 다시 보낸다.
				// 다시 HELO 하러 갑니다.
				step(SendState.HELO, eMsLocale.SMTP_LOCAL_HOST[0], __NOW_DOMAIN, RCPT_ARRAY[INDEX_OF_STEP]);

				if( this.sendState.isError() ) {
					all_error_process();
					continue;
				}
				super.resetConnectionTime();
			}
			else {
				super.resetConnectionTime();
			}
			
			if (eMsLocale.MGS_FLAG) {
				// MGS SEQ 하러 갑니다.
				step(SendState.SEQ, RCPT_ARRAY[INDEX_OF_MAIL_FROM], RCPT_ARRAY[INDEX_OF_DOMAIN], RCPT_ARRAY[INDEX_OF_STEP]);
			}

			// MAIL_FROM 하러 갑니다.
			step(SendState.MAIL_FROM, RCPT_ARRAY[INDEX_OF_MAIL_FROM], __NOW_DOMAIN, RCPT_ARRAY[INDEX_OF_STEP]);
			if( this.sendState.isError() ) {
				all_error_process();
				continue;
			}

			// 이제 중요한 RCPT 입니다. RCPT리스트 수만큼 RCPT를 보낸다.
			for (Iterator iter = this.PARSED_RCPT_INFO.iterator(); iter.hasNext();) {
				Object __NEXT_SPOOL__ = iter.next();

				if( !this.parseMemberInfoOnly(__NEXT_SPOOL__) ) {
					// 파싱해서 에러가 나면 제외시킨다.
					log("work.parseMemberInfoOnly fail spool:" + __NEXT_SPOOL__);
					iter.remove();
					continue;
				}

				step(SendState.RCPT_TO, RCPT_ARRAY[INDEX_OF_TOKEN_ID], RCPT_ARRAY[INDEX_OF_DOMAIN], RCPT_ARRAY[INDEX_OF_STEP]);

				if (log.isDebugEnabled()) {
					log("step rcpt done:" + RCPT_ARRAY[INDEX_OF_TOKEN_ID]);
				}

				switch (this.sendState.getLogLevel()) {
					case LOG_LEVEL_SUCCESS: {
						continue;
					}

					case LOG_LEVEL_N_ERROR:
					case LOG_LEVEL_DENY_ERROR: {
						// 네트웍 에러면 다음으로 진행을 할수 없으므로 전체 에러처리
						all_error_process();
						continue;
					}

					default: {
						// 기타 에러가 아니라면 그녀석만 에러처리하고 진행
						error_process(RCPT_ARRAY);
						iter.remove();
						continue;
					}
				}
			}

			/**
			 * RCPT에서 모두 에러거나 네트웍 에러일 경우에는 그냥 돌아가야한다.
			 */
			if( this.PARSED_RCPT_INFO.size() == 0 )
				continue;

			// DATA 를 전송합니다.
			step(SendState.DATA, null, RCPT_ARRAY[INDEX_OF_DOMAIN], RCPT_ARRAY[INDEX_OF_STEP]);
			if( this.sendState.isError() ) {
				all_error_process();
				continue;
			}

			// 실제 메일 바디를 전송합니다.
			step(SendState.DATA_BODY, RCPT_ARRAY[INDEX_OF_CONTENT], RCPT_ARRAY[INDEX_OF_DOMAIN], RCPT_ARRAY[INDEX_OF_STEP]);
			if( this.sendState.isError() ) {
				all_error_process();
				continue;
			}

			all_success_process();

			if (log.isDebugEnabled()) {
				log("step success done:" + __NOW_DOMAIN);
			}
		}
	}

	/**
	 */
	protected void all_error_process() {
		if( STEP_DEBUG )
			log("all error");

		/**
		 * 현재 파싱되어 있는 애들을 전부 에러처리한다.
		 */
		super.all_error_process();

		String BASE_DOMAIN = RCPT_ARRAY[INDEX_OF_DOMAIN];

		while ((this.RCPT_TO = this.INNER_BUFFERED_BIN.popupNoWait()) != null) {
			/**
			 * 하나를 끄집어 낸다.
			 */
			String spool = this.RCPT_TO.toString();
			String domain = null;

			/**
			 * 도메인이 같은지를 점검해서 같으면 끄집어내어 에러처리하고 아니면 그냥 보내야한다. 변수를 계속 만들기 뭐해서 그냥 spool을 사용함.. 헤깔리지 말기... 여러개가 묶여 있더라도 앞에 도메인 찝어오는 것은 같기때문에 Single과 동일하게 뽑아낸다.
			 */
			try {
				domain = SPOOL_ANALYZER.pickupDomain(spool);

				if( !BASE_DOMAIN.equals(domain) ) {
					return;
				}
			}
			catch(Exception e) {
				log.error(getName(), e);
				return;
			}

			domain = super.splitRcptInfo();

			if( domain == null ) {
				continue;
			}

			super.all_error_process();
		}
	}
}
