/*
 * @(#)SmsBroadcastFixedDomainSingleRcptBufferedCommunicationActor.java            2004. 12. 6.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.mass.actor;


import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.ioutil.FileUtil;
import pluto.mail.SendState;
import pluto.util.StringUtil;

/**
 * <br>
 * Innter Container에 있는 메일 발송 대상이 모두 같은 도메인의 경우 <br>
 * 동보 SMS 발송의 처리.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class SmsBroadcastDomainSingleRcptBufferedCommunicationActor extends AbstractSingleRcptCommunicationActor {
	
	
	
	private static String QUERY_INSERT_SMS_DONGBO_SEND = null;
	
	private static String QUERY_INSERT_SMS_CLIENT_SEND = null;
	
	private static String QUERY_SELECT_SMS_DONGBO_SEQ = null;
	
	private static String QUERY_UPDATE_SMS_DONGBO_SEND = null;
	
	public static String ERROR_MESSAGE = null;
	
	private eMsConnection EMS_CONNECTION = null;
	
	private eMsPreparedStatement PSTMT = null;
	
	private eMsPreparedStatement PSTMT_SUB = null;
	
	private eMsPreparedStatement PSTMT_UPDATE = null;
	
	private eMsPreparedStatement PSTMT_SEQ = null;
	
	private eMsResultSet RS_SEQ = null;
	
	private Map	__SMS_SEND_HASH__	= new Hashtable();
	
	private Map	__SMS_SEND_CLINET_HASH__	= new Hashtable();
	
	private static int th_cnt = 0;
	
	private static ConnectInfo	TARGET_CONNECT_INFO					= null;
	
	
	
	static {
		//SMS
		QUERY_INSERT_SMS_DONGBO_SEND = SqlManager.getQuery("COMMON", "QUERY_INSERT_SMS_DONGBO_SEND");
		QUERY_INSERT_SMS_CLIENT_SEND = SqlManager.getQuery("COMMON", "QUERY_INSERT_SMS_CLIENT_SEND");
		QUERY_SELECT_SMS_DONGBO_SEQ = SqlManager.getQuery("COMMON", "QUERY_SELECT_SMS_DONGBO_SEQ");
		QUERY_UPDATE_SMS_DONGBO_SEND = SqlManager.getQuery("COMMON", "QUERY_UPDATE_SMS_DONGBO_SEND");
		
		TARGET_CONNECT_INFO = new ConnectInfo();
		TARGET_CONNECT_INFO.setDRIVER(eMsSystem.getProperty("sms.db.driver"));
		TARGET_CONNECT_INFO.setDB_URL(eMsSystem.getProperty("sms.db.url"));
		TARGET_CONNECT_INFO.setDB_UID(eMsSystem.getProperty("sms.db.id"));
		TARGET_CONNECT_INFO.setDB_PASS(eMsSystem.getProperty("sms.db.pass"));
		TARGET_CONNECT_INFO.setDB_INIT_QUERY(eMsSystem.getProperty("sms.db.init"));
		TARGET_CONNECT_INFO.setDB_BASE_CHARSET(eMsSystem.getProperty("sms.db.base.charset"));
		TARGET_CONNECT_INFO.setDB_OUT_CHARSET(eMsSystem.getProperty("sms.db.out.charset"));
		TARGET_CONNECT_INFO.setDB_IN_CHARSET(eMsSystem.getProperty("sms.db.in.charset"));
	}

	/** Creates a new instance of FixedDomainSingleRcptBufferedCommunicationActor */
	public SmsBroadcastDomainSingleRcptBufferedCommunicationActor() throws Exception {
		
		super();
		
	}

	protected void work() throws Exception {
		try{
			//get connection
			EMS_CONNECTION = ConnectionPool.getConnection(TARGET_CONNECT_INFO);
			PSTMT_SEQ = EMS_CONNECTION.prepareStatement(QUERY_SELECT_SMS_DONGBO_SEQ,"${","}");
			PSTMT = EMS_CONNECTION.prepareStatement(QUERY_INSERT_SMS_DONGBO_SEND,"${","}"); 
			PSTMT_SUB = EMS_CONNECTION.prepareStatement(QUERY_INSERT_SMS_CLIENT_SEND,"${","}");
			PSTMT_UPDATE = EMS_CONNECTION.prepareStatement(QUERY_UPDATE_SMS_DONGBO_SEND, "${","}");
			
			th_cnt ++;
			boolean insertYn = false;
			
			/**
			 * 자 시작 합니다.
			 */
			this.CURR_STEP = SendState.WAIT;
	
			while (true) {
				/**
				 * 없으면 다시 받아온다.
				 */
				if( this.RCPT_TO == null ) {
					this.RCPT_TO = this.INNER_BUFFERED_BIN.popupNoWait();
				}
	
				if( this.RCPT_TO == null ) {
					return;
				}
				
				if (log.isDebugEnabled()) {
					log("pop up:" + this.RCPT_TO.toString());
				}
	
				if( this.splitRcptInfo() == null ) {
					if (log.isDebugEnabled()) {
						log("split fail continue");
					}
					continue;
				}else{
					
				}
				
				log.debug("[this.PARSED_RCPT_INFO.size()]"+this.PARSED_RCPT_INFO.size());
				
				long i=0;
				int insResult =0; 
				String sms_seq = "";
				
				
				/*
				 * TMS 동보발송을 위한 시퀀스발번 
				 */
				try{
					RS_SEQ = PSTMT_SEQ.executeQuery(__SMS_SEND_HASH__);
					
					if(RS_SEQ.next()){
						sms_seq = RS_SEQ.getString(1);
					}			
					
				}catch(Exception e){
					log.error("seq generate error", e);
					continue; 
				}finally{
					if(RS_SEQ != null){
						RS_SEQ.close();
					}
				}
							
				log.debug("SMS DONGBO - START : [th_cnt]"+th_cnt+"[size]"+this.PARSED_RCPT_INFO.size());
				try {
					EMS_CONNECTION.setAutoCommit(false);
					long time = System.currentTimeMillis();
					// 여러개 뭉친 녀석들을 쪼갠거를 하나씩 처리를 한다.
					while (this.PARSED_RCPT_INFO.size() > 0) {
						
						i++;
						
						Object NEXT_SPOOL = this.PARSED_RCPT_INFO.removeFirst();
						
						putFormNumber(NEXT_SPOOL.toString());
						
						if( !this.parseRcptInfo(NEXT_SPOOL) ) { 
							if (log.isDebugEnabled()) {
								log("parseRcptInfo fail continue");
							}
							continue; 
						}
						
						//delay 시간이 있다면
						if( this.connection_delay > 0 ) {
							try {
								Thread.currentThread().sleep(this.connection_delay);
							}catch(Exception e) {
							}
						}
						// RCPT 보내기 전에 보낸다고 54-00 을 마킹해야한다.
						start_process(RCPT_ARRAY);				
						
						/*
						 * TMS SMS 업체 테이블로 인서트 하는 로직 
						 */
						try{
							
							//client insert (SC_CLIENT)
							setMapping(RCPT_ARRAY, sms_seq , i);						
							int cnt = PSTMT_SUB.executeUpdate(__SMS_SEND_CLINET_HASH__);
							log.debug("cnt:"+cnt+" SC_CLIENT Insert");
							if(cnt > 0){
								//250 2.0.0 Message accepted for delivery
								this.success_process(RCPT_ARRAY, __SMS_SEND_CLINET_HASH__.get("TR_NUM").toString());
							}else{
								this.error_process(RCPT_ARRAY, __SMS_SEND_CLINET_HASH__.get("TR_NUM").toString());
							}

						}catch(Exception e){
							log.error("SMS INSERT ERROR : ", e);
							continue; 
						}finally{
							__SMS_SEND_HASH__.clear();
							__SMS_SEND_CLINET_HASH__.clear();
						}
					}
					//동보 발송인 경우 SC_CLIENT에 먼저 값을 입력하고 마지막에 master 테이블 성격의 SC_TRAN에 입력하는것이 맞다.
					//master insert (SC_TRAN)
					if(!insertYn){		// 1번만 INSERT
						setMasterMapping(RCPT_ARRAY, sms_seq);
						insResult = PSTMT.executeUpdate(__SMS_SEND_HASH__);
						insertYn = true;
						log.debug("insResult:"+insResult+" SC_TRAN Insert");
						if(insResult > 0){
							//250 2.0.0 Message accepted for delivery
							this.master_success_process(RCPT_ARRAY, __SMS_SEND_HASH__.get("TR_NUM").toString());
						}else{
							this.master_error_process(RCPT_ARRAY, __SMS_SEND_HASH__.get("TR_NUM").toString());
						}
					//master status update
					int upint = PSTMT_UPDATE.executeUpdate(__SMS_SEND_HASH__);
					//log.debug("upint:"+upint+" SC_TRAN STATUS UPDATE");
					}
					
					log.debug("SMS DONGBO - END : [th_cnt]"+th_cnt+"[size]"+this.PARSED_RCPT_INFO.size()+"[loop_time]:"+(System.currentTimeMillis() - time)+"ms");
				} catch (Exception e) {
					ERROR_MESSAGE = e.toString();
					EMS_CONNECTION.rollback();
					log.error("SMS DONGBO - ROLLBACK!!! SMS 등록 오류",e);
				} finally {
					
					if(EMS_CONNECTION != null){
						log.debug("SMS DONGBO - COMMIT TRUE : [th_cnt]"+th_cnt+"[size]"+this.PARSED_RCPT_INFO.size());
						EMS_CONNECTION.commit();
						EMS_CONNECTION.setAutoCommit(true);
					}
				}
			}//end of while (true)
			
		} finally {		
			
			if(PSTMT != null){
				PSTMT.close();
			}
			if(PSTMT_SEQ != null){
				PSTMT_SEQ.close();
			}
			if(PSTMT_SUB != null){
				PSTMT_SUB.close();
			}
			if(PSTMT_UPDATE != null){
				PSTMT_UPDATE.close();
			}
			if(EMS_CONNECTION != null){
				EMS_CONNECTION.recycle();
			}
		}	
	}
	
	public void putFormNumber(String line){
		try {
			__SMS_SEND_HASH__.put("FROM_NUMBER", line.substring(line.lastIndexOf("|")+1));	
		} catch (Exception e) {
			log.error(e.getMessage());
			__SMS_SEND_HASH__.put("FROM_NUMBER", "02-2149-4936");
		}
	}
	/**
	 * 한건에 대한 성공여부를 전송한다. 아마도 원투원 발송할때 RSET으로 초기화 하기 전에 호출이 되지 않을까... 생각된다.
	 * 
	 * @param RCPT_INFO
	 */
	protected void success_process(String[] _AGENT_ARRAY_, String msg) {
		this.resultLog(_AGENT_ARRAY_, "54", "10", "250 SMS Message accepted for send TR_NUM :"+msg, LOG_LEVEL_SUCCESS);
	}
	
	/**
	 */
	protected void error_process(String[] _AGENT_ARRAY_, String msg) {
		this.resultLog(_AGENT_ARRAY_, "55", this.sendState.getRETURN_CODE(), "SMS fail "+ERROR_MESSAGE+" TR_NUM :"+msg, this.sendState.getLogLevel());
	}
	/**
	 * 한건에 대한 성공여부를 전송한다. 아마도 원투원 발송할때 RSET으로 초기화 하기 전에 호출이 되지 않을까... 생각된다.
	 * 
	 * @param RCPT_INFO
	 */
	protected void master_success_process(String[] _AGENT_ARRAY_, String msg) {
		this.resultLog(_AGENT_ARRAY_, "54", "10", "250 SMS SC_TRAN Insert for send TR_NUM :"+msg, LOG_LEVEL_SUCCESS);
	}
	
	/**
	 */
	protected void master_error_process(String[] _AGENT_ARRAY_, String msg) {
		this.resultLog(_AGENT_ARRAY_, "55", this.sendState.getRETURN_CODE(), "SMS SC_TRAN Insert fail "+ERROR_MESSAGE, this.sendState.getLogLevel());
	}
	
	public Map setMasterMapping(String[] array, String seq) throws Exception {
		
		String post_id    	= "";
		String member_id  	= "";
		String from_number 	= "";
		String to_number   	= "";
		String content    	= "";
		
		try{
			post_id    = array[INDEX_OF_POST_ID];
			member_id  = array[INDEX_OF_MEMBER_ID];
			from_number= array[INDEX_OF_MAIL_FROM];
			to_number  = array[INDEX_OF_TOKEN_ID];
			
			__SMS_SEND_HASH__.put("TR_NUM", seq);
			__SMS_SEND_HASH__.put("MEMBER_ID", member_id);
			__SMS_SEND_HASH__.put("FROM_NUMBER", from_number);
			__SMS_SEND_HASH__.put("TO_NUMBER", to_number);
			__SMS_SEND_HASH__.put("POST_ID", post_id);
			
			
			ContentInfo sendContentInfo = ContentInfoManager.getContentInfo(post_id);
			
			Properties prop = sendContentInfo.getScheduleInfo();
			
			content = FileUtil.readLocal(prop.getProperty("CONTENT").substring(7));
			
			content = content.replaceAll("\\$\\{FIELD1\\}", "\\%CHANGEWORD1\\%");
			content = content.replaceAll("\\$\\{FIELD2\\}", "\\%CHANGEWORD2\\%");
			content = content.replaceAll("\\$\\{FIELD3\\}", "\\%CHANGEWORD3\\%");
			content = content.replaceAll("\\$\\{FIELD4\\}", "\\%CHANGEWORD4\\%");
			content = content.replaceAll("\\$\\{FIELD5\\}", "\\%CHANGEWORD5\\%");
			
			
			__SMS_SEND_HASH__.put("CONTENT", content);		//동보일 경우는 매핑안된 컨텐츠 가져온다.
			
			__SMS_SEND_HASH__.put("USER_ID", prop.getProperty("USER_ID",""));
			
			__SMS_SEND_HASH__.put("USER_DEPT", prop.getProperty("USER_DEPT",""));
			
			__SMS_SEND_HASH__.put("FROM_NUMBER", prop.getProperty("FROM_NUMBER",""));
			
			return __SMS_SEND_HASH__;
			
		}catch(Exception e){
			
			return null;
		
		}finally{
			
		}
	}

	public Map setMapping(String[] array , String seq , long cnt) throws Exception {
		
		String send_type	= "";
		String post_id    	= "";
		String member_id  	= "";
		String to_number   	= "";
		String spool    	= "";
		String list_table	= "";
		int spoolMaxLen		= 18;
			
		
		try{
			send_type  = array[INDEX_OF_SEND_KIND];
			post_id    = array[INDEX_OF_POST_ID];
			member_id  = array[INDEX_OF_MEMBER_ID];
			to_number  = array[INDEX_OF_TOKEN_ID];
			spool 	   = array[INDEX_OF_SPOOL];
			list_table = array[INDEX_OF_LIST_TABLE];
			
			String[] arrMapping = StringUtil.split(spool, "|");
			
			__SMS_SEND_CLINET_HASH__.put("TR_NUM", seq);
			__SMS_SEND_CLINET_HASH__.put("TR_SEQ", cnt);
			__SMS_SEND_CLINET_HASH__.put("MEMBER_ID", member_id);
			__SMS_SEND_CLINET_HASH__.put("TO_NUMBER", to_number);
			__SMS_SEND_CLINET_HASH__.put("POST_ID", post_id);
			
			ContentInfo sendContentInfo = ContentInfoManager.getContentInfo(post_id);
			
			Properties prop = sendContentInfo.getScheduleInfo();
			
			if(prop.getProperty("SEND_STATE").equals("TEST"))
				__SMS_SEND_CLINET_HASH__.put("POST_ID", post_id+"^TT^"+member_id);		//SMS TEST
			else{
//				if(send_type.equals("AUTO"))			
//					__SMS_SEND_CLINET_HASH__.put("POST_ID", post_id+"_TA_"+member_id+"_"+list_table.substring(list_table.lastIndexOf("_")+1));				
//				else
				__SMS_SEND_CLINET_HASH__.put("POST_ID", post_id.substring(0, 13)+"^TC^"+member_id);		//SMS AUTO
			}
			
			if(arrMapping.length >= spoolMaxLen){
				__SMS_SEND_CLINET_HASH__.put("CHANGE_WORD1", arrMapping[14]);
				__SMS_SEND_CLINET_HASH__.put("CHANGE_WORD2", arrMapping[15]);
				__SMS_SEND_CLINET_HASH__.put("CHANGE_WORD3", arrMapping[16]);
				__SMS_SEND_CLINET_HASH__.put("CHANGE_WORD4", arrMapping[17]);
				__SMS_SEND_CLINET_HASH__.put("CHANGE_WORD5", arrMapping[18]);
			}

			return __SMS_SEND_CLINET_HASH__;
			
		}catch(Exception e){
			
			return null;
		
		}finally{
			
		}
	}
	
	
	/**
	 * 같은 도메인들이므로 걍 모두 에러처리를 한다.
	 */
	protected void all_error_process() {
		if( STEP_DEBUG )
			log("all error");
		//start_process( RCPT_ARRAY );
		error_process(RCPT_ARRAY);

		parsedListAllErrorProcess();
	}
}
