/*
 * @(#)FixedDomainSingleRcptBufferedCommunicationActor.java            2004. 12. 6.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.mass.actor;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.DeliveryMode;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;

import org.apache.activemq.ActiveMQConnectionFactory;
import org.json.simple.JSONObject;

import com.humuson.tms.common.security.HumusonEncryptor;
import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.CommonType;
import com.humuson.tms.constrants.PushResponseCodeConstants;
import com.humuson.tms.constrants.StatusType;
import com.humuson.tms.mq.model.MgsPush;
import com.humuson.tms.mq.model.MgsPush.PushChnType;
import com.humuson.tms.mq.model.MgsPush.Request.AckMode;
import com.humuson.tms.mq.model.MgsPush.Request.SendType;

import lombok.extern.slf4j.Slf4j;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import moon.logprocess.module.App;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.log.ErrorSpoolLogger;
import pluto.mail.SendState;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;

/**
 * <br>
 * Innter Container에 있는 메일 발송 대상이 모두 같은 도메인의 경우 <br>
 * 1 to 1 메일 발송의 처리.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class PushFixedDomainSingleRcptBufferedCommunicationActor extends AbstractSingleRcptCommunicationActor {
	
	private eMsConnection EMS_CONNECTION = null;
	private eMsConnection EMS_CONNECTION2 = null;
	private eMsPreparedStatement PSTMT = null;
	private eMsPreparedStatement PSTMT1 = null;
	private eMsPreparedStatement PSTMT3 = null;
	// PSTMT2 는 Update SendList 를 처리하기 위한 preparedStatement.
	// send list 테이블명이 바뀔수 있기 때문에 updateSendListPreparedMap 저장한 후 사용
	private eMsPreparedStatement PSTMT2 = null;
	
	private eMsStatement EMS_STATEMENT = null;
	private eMsResultSet rs = null;
	
	public static int th_cnt = 0;
	public static String QUERY_INSERT_PUSH_SEND = null;
	public static String QUERY_INSERT_INAPP_MSG = null;
	public static String QUERY_UPDATE_SEND_LIST = null;
	public static String QUERY_UPDATE_SCHD_INFO = null;
	public static String QUERY_SELECT_PUSH_CERT_INFO = null;
	public static String QUERY_SELECT_PUSH_OS_INFO = null;
	
	public static int sparePlusMinute = 0;
	public static int spareCount = 0;
	public static int commitSize = 1000;
	public static String activeMqUseYN = "";
	public static String activeMqAddr = "";
	public static String activeMqQueName = "";
	
	public static String encryptYn = "";
	public static String encKey = "";
	
	static {
		// 푸시는 Expire_Time이 지나면 GCM Resend로 전환됨
		// 발송량을 고려하여 동적으로 Expire_time을 늘려주는 용도로 사용
		sparePlusMinute = Integer.parseInt(eMsSystem.getProperty("push.spare.time.plus.minute","0"));
		commitSize = Integer.parseInt(eMsSystem.getProperty("commit.size","1000"));
		spareCount = Integer.parseInt(eMsSystem.getProperty("push.spare.time.plus.count","1"));
		activeMqAddr = eMsSystem.getProperty("batch.activemq.addr","");
		activeMqQueName = eMsSystem.getProperty("batch.activemq.request.que.name","");	
		activeMqUseYN = eMsSystem.getProperty("batch.activemq.use.yn","Y");
		
		QUERY_INSERT_PUSH_SEND = SqlManager.getQuery("COMMON", "QUERY_INSERT_PUSH_SEND");
		
		QUERY_SELECT_PUSH_CERT_INFO = SqlManager.getQuery("COMMON", "QUERY_SELECT_PUSH_CERT_INFO");
		QUERY_SELECT_PUSH_OS_INFO = SqlManager.getQuery("COMMON", "QUERY_SELECT_PUSH_OS_INFO");
		QUERY_INSERT_INAPP_MSG = SqlManager.getQuery("COMMON", "QUERY_INSERT_INAPP_MSG");
		QUERY_UPDATE_SEND_LIST = SqlManager.getQuery("COMMON", "QUERY_UPDATE_SEND_LIST");
		QUERY_UPDATE_SCHD_INFO = SqlManager.getQuery("COMMON", "QUERY_UPDATE_SCHD_INFO");
		
		encryptYn = eMsSystem.getProperty("member.info.encrypt.yn","N");
		encKey = eMsSystem.getProperty("member.info.encrypt.key");
	}

	/** Creates a new instance of FixedDomainSingleRcptBufferedCommunicationActor */
	public PushFixedDomainSingleRcptBufferedCommunicationActor() throws Exception {
		super();
	}
	
	protected void work() throws Exception {
		log.info("Push Sending init Start....");
		long startTime = System.currentTimeMillis();
		
		Map<String,String> currentAppKeyMapIos = new HashMap<String,String>();
		Map<String,String> currentAppKeyMapAndroid = new HashMap<String,String>();
		
		int processCount = 0;
		int insertedCount = 0;
		int failedCount = 0;
		
		// Batch ActiveMQ INIT
		ActiveMQConnectionFactory connectionFactory = null;
		Connection connection = null;
        Session session = null;
        Destination destination = null;
		MessageProducer producer = null;
		
		try {
			//get connection
			EMS_CONNECTION = ConnectionPool.getConnection();
			PSTMT = EMS_CONNECTION.prepareStatement(QUERY_INSERT_PUSH_SEND,"${","}");
			PSTMT1 = EMS_CONNECTION.prepareStatement(QUERY_INSERT_INAPP_MSG,"${","}");
			
			PSTMT3 = EMS_CONNECTION.prepareStatement(QUERY_UPDATE_SCHD_INFO,"${","}");
			
			HashMap<String, eMsPreparedStatement> updateSendListPreparedMap = new HashMap<String, eMsPreparedStatement>();
			th_cnt ++;
			
			this.CURR_STEP = SendState.WAIT;
			
			ArrayList<String[]> currentList = new ArrayList<String[]>(); 
			
			MgsPush.Request.Builder gcmRequestBuilder = null;
			MgsPush.Request.Builder apnsRequestBuilder = null;
			MgsPush.Request.Builder gcmFastRequestBuilder = null;
			MgsPush.Request.Builder apnsFastRequestBuilder = null;
			MgsPush.PushPayload.Builder pushPayloadBuilder = null;
			
			CommonType sendCommonType = null;
			StringBuilder sb = null;
			String id = null;
			
			// ActiveMq 사용중일때
			if("Y".equals(activeMqUseYN)){
				connectionFactory = new ActiveMQConnectionFactory(activeMqAddr);
				connection = connectionFactory.createConnection();
				connection.start();
				session = connection.createSession(false, Session.AUTO_ACKNOWLEDGE);
				destination = session.createQueue(activeMqQueName);
				producer = session.createProducer(destination);
				producer.setDeliveryMode(DeliveryMode.NON_PERSISTENT);
				
				// GCM
	            gcmRequestBuilder = MgsPush.Request.newBuilder();
	            gcmFastRequestBuilder = MgsPush.Request.newBuilder();
	            // APNS
	            apnsRequestBuilder  = MgsPush.Request.newBuilder();
	            apnsFastRequestBuilder  = MgsPush.Request.newBuilder();
	            // PAYLOAD
	            pushPayloadBuilder = MgsPush.PushPayload.newBuilder();
	            
	            sb = new StringBuilder();
	            
	            Properties prop = null;
	            // OS/APP_KEY 정보 가져옴
				StringBuffer	TMP_STRING_BUFFER = new StringBuffer(1024);
				StringConvertUtil.ConvertString(TMP_STRING_BUFFER, QUERY_SELECT_PUSH_CERT_INFO, prop, "${", "}", true, false);
				try {
					EMS_CONNECTION2 = ConnectionPool.getConnection();
					EMS_STATEMENT = EMS_CONNECTION2.createStatement();
					rs = EMS_STATEMENT.executeQuery(TMP_STRING_BUFFER.toString());

					while( rs.next() ) {	
						if( App.IOS.equals(rs.getString("OS")) ){
							currentAppKeyMapIos.put( rs.getString("APP_GRP_KEY"), rs.getString("APP_KEY") );
						} else if( App.ANDROID.equals(rs.getString("OS"))){
							currentAppKeyMapAndroid.put( rs.getString("APP_GRP_KEY"), rs.getString("APP_KEY") );
						}
//						log.info("APP_GRP_KEY:{},OS :{},APP_KEY:{}",rs.getString("APP_GRP_KEY"),rs.getString("OS"),rs.getString("APP_KEY"));
					}
					 
				} catch (Exception e ){
					log.error("[QUERY_SELECT_PUSH_CERT_INFO] Exception... {}", e);
					throw e;
				} finally {
					if(rs != null) {rs.close();}
					if(EMS_STATEMENT != null) {EMS_STATEMENT.close();}
					if(EMS_CONNECTION2 != null){ EMS_CONNECTION2.recycle(); }
				}
			}// END ActiveMq 사용중일때
			
			while (true) {
				/**
				 * 없으면 다시 받아온다.
				 */
				if( this.RCPT_TO == null ) {
					this.RCPT_TO = this.INNER_BUFFERED_BIN.popupNoWait();
				}
	
				if( this.RCPT_TO == null ) {
					return;
				}
	
				if (log.isDebugEnabled()) {
					log("pop up:" + this.RCPT_TO.toString());
				}
	
				if( this.splitRcptInfo() == null ) {
					if (log.isDebugEnabled()) {
						log("split fail continue");
					}
					continue;
				}
				
				try{
					
					EMS_CONNECTION.setAutoCommit(false);
					// 여러개 뭉친 녀석들을 쪼갠거를 하나씩 처리를 한다.
					long time = System.currentTimeMillis();
					Map<String, String>	__PUSH_SEND_HASH__	= null;
					
					while (this.PARSED_RCPT_INFO.size() > 0) {
						
						Object NEXT_SPOOL = this.PARSED_RCPT_INFO.removeFirst();
						
						if( !this.parseRcptInfo(NEXT_SPOOL) ) { 
							if (log.isDebugEnabled()) {
								log("parseRcptInfo fail continue");
							}
							continue; 
						}
						
						//delay 시간이 있다면
						if( this.connection_delay > 0 ) {
							try {
								Thread.currentThread().sleep(this.connection_delay);
							}catch(Exception e) {
							}
						}
						
						currentList.add(RCPT_ARRAY);
//						start_process(RCPT_ARRAY);
						String notiFlag = "N";
						String os = "A";
						String appGrpKey = "";
						String serverId = "01";
						//[TMS3.2.0] 우선순위
						int priority = 0;
						//[17.04.24]TMSP-628 푸시 전송 타입(MP:수신함+푸시, OP:푸시, OM:수신함)
						String pushType="MP";
						
						try{
							__PUSH_SEND_HASH__ = setMapping(RCPT_ARRAY, spareMinute);
//							log.info("[PushFixedDomainSingleRcptBufferedCommunicationActor] __PUSH_SEND_HASH__ :\n{}",__PUSH_SEND_HASH__);
//							log.info("{} : {} : {} : {}",
//									__PUSH_SEND_HASH__.get("DEVICE_ID")
//									,__PUSH_SEND_HASH__.get("REQ_UID")
//									,__PUSH_SEND_HASH__.get("CUST_ID")
//									,__PUSH_SEND_HASH__.get("PUSH_TYPE"));
							
							if("Y".equals(activeMqUseYN)){
								// SEND_LIST 업데이트관련 쿼리세팅
								if(updateSendListPreparedMap.containsKey(__PUSH_SEND_HASH__.get("LIST_TABLE"))){
									PSTMT2 = updateSendListPreparedMap.get(__PUSH_SEND_HASH__.get("LIST_TABLE"));
								}else{
									String query = StringConvertUtil.ppsParseSQL(QUERY_UPDATE_SEND_LIST, "LIST_TABLE", __PUSH_SEND_HASH__.get("LIST_TABLE"), "@{", "}");
									PSTMT2 = EMS_CONNECTION.prepareStatement(query,"${","}");
									updateSendListPreparedMap.put(__PUSH_SEND_HASH__.get("LIST_TABLE"), PSTMT2);
								}
	
								os = __PUSH_SEND_HASH__.get("OS");
								notiFlag = __PUSH_SEND_HASH__.get("NOTI_FLAG");
								appGrpKey = __PUSH_SEND_HASH__.get("APP_GRP_KEY");
								serverId = __PUSH_SEND_HASH__.get("SERVER_ID");
								//[17.04.24]TMSP-628 푸시 전송 타입(MP:수신함+푸시, OP:푸시, OM:수신함)
								pushType = __PUSH_SEND_HASH__.get("PUSH_TYPE");
								
								if(  __PUSH_SEND_HASH__.get("SEND_STATE").equals(CommonType.TEST.getCode())  ){
									sendCommonType = CommonType.TEST;
								}
								
								if("Y".equals(notiFlag) || CommonType.TEST.equals(sendCommonType) ){
									// ACTIVE_MQ 발송을 위한 준비
									sb.setLength(0);
									id = sb.append("PUSH_ID_VALUE").append("&&")
										.append( __PUSH_SEND_HASH__.get("DEVICE_ID") ).append("&&")
										.append( __PUSH_SEND_HASH__.get("REQ_UID")).append("&&")
										.append( __PUSH_SEND_HASH__.get("CUST_ID")).toString();
									/*
									if(App.IOS.equals(os)){ // IOS
										if(currentAppKeyMapIos.containsKey( appGrpKey )){
											apnsRequestBuilder.setAppKey( currentAppKeyMapIos.get(appGrpKey) )
											.setAckMode(AckMode.ACK)
											.setPushChnType(PushChnType.APNS)
											.setSendType(SendType.ONE2ONE)
											.setSeverId(serverId);
											pushPayloadBuilder.clear();
											pushPayloadBuilder.setToken(__PUSH_SEND_HASH__.get("TOKEN_ID"))
															  .setId(id)
															  .setApnsMessage(makeApnsMqMessage(__PUSH_SEND_HASH__));
											apnsRequestBuilder.addPayload(pushPayloadBuilder.build());
										}
									} else { // ANDROID
										if(currentAppKeyMapAndroid.containsKey(appGrpKey)){
											gcmRequestBuilder.setAppKey( currentAppKeyMapAndroid.get(appGrpKey) )
											.setAckMode(AckMode.ACK)
											.setPushChnType(PushChnType.GCM)
											.setSendType(SendType.ONE2ONE)
											.setSeverId(serverId);
											pushPayloadBuilder.clear();
											pushPayloadBuilder.setToken(__PUSH_SEND_HASH__.get("TOKEN_ID"))
															  .setId(id)
															  .setGcmMessage(makeGcmMqMessage(__PUSH_SEND_HASH__));
											gcmRequestBuilder.addPayload(pushPayloadBuilder.build());
										}
									}
									*/
									//[TMS3.2.0] 우선순위
									priority = Integer.parseInt(__PUSH_SEND_HASH__.get("PRIORITY"));
									//[17.04.24]TMSP-628 푸시 전송 타입(MP:수신함+푸시, OP:푸시, OM:수신함) OM 이면 푸시 발송 요청 자체를 하지 않음
									if (pushType != null && !"OM".equals(pushType)) {
										if(App.IOS.equals(os) && currentAppKeyMapIos.containsKey(appGrpKey)){ // IOS
											if( priority > 0 ){
												apnsFastRequestBuilder = apnsBuilder(apnsFastRequestBuilder, pushPayloadBuilder,
														__PUSH_SEND_HASH__, currentAppKeyMapIos, appGrpKey, serverId, id);
											} else {
												apnsRequestBuilder = apnsBuilder(apnsRequestBuilder, pushPayloadBuilder,
														__PUSH_SEND_HASH__, currentAppKeyMapIos, appGrpKey, serverId, id);
											}
										} else if (App.ANDROID.equals(os) && currentAppKeyMapAndroid.containsKey(appGrpKey)){ // ANDROID
											if( priority > 0 ){
												gcmFastRequestBuilder = fcmBuilder(gcmFastRequestBuilder, pushPayloadBuilder, 
														__PUSH_SEND_HASH__, currentAppKeyMapAndroid, appGrpKey, serverId, id);
											} else {
												gcmRequestBuilder = fcmBuilder(gcmRequestBuilder, pushPayloadBuilder, 
														__PUSH_SEND_HASH__, currentAppKeyMapAndroid, appGrpKey, serverId, id);
											}
										} else {
											log.error("[RequestBuilderError] id: {}", id);
										}
									}
								}
								
								if("Y".equals(notiFlag)){
									if(!CommonType.TEST.equals(sendCommonType)){
										__PUSH_SEND_HASH__.put("SEND_STATE",StatusType.SENDING.getCode());
										__PUSH_SEND_HASH__.put("ERROR_CODE",PushResponseCodeConstants.APPROVAL);
										// SEND_LIST UPDATE (00 -> 05)
										if(PSTMT2.executeUpdate(__PUSH_SEND_HASH__) > 0) {
										} else {
											log.info("[QUERY_UPDATE_SEND_LIST][05] update Count 0");
										}
									}
								// PUSH NOTI 수신거부자
								} else {
									if(!CommonType.TEST.equals(sendCommonType)){
										__PUSH_SEND_HASH__.put("SEND_STATE", StatusType.ERROR.getCode());
										__PUSH_SEND_HASH__.put("ERROR_CODE", PushResponseCodeConstants.DENY_PUSH);
										// SEND_LIST UPDATE (00 -> 44)
										if(PSTMT2.executeUpdate(__PUSH_SEND_HASH__) > 0) {
											//[17.04.24]TMSP-628 OM 아닐때 처리 : stat 테이블 update 수행
											//while 문 end 이후 PSTMT3.executeUpdate 로직때문에 여기서 선 처리
											if(pushType != null && !"OM".equals(pushType)){
												failedCount++;
												log.info("failedCount: {}", failedCount);
											}
										} else {
											log.info("[QUERY_UPDATE_SEND_LIST][44] update Count 0");
										}
									}
								}
								
								// IN_APP_MSG INSERT
								//[17.04.24]TMSP-628 푸시 전송 타입(MP:수신함+푸시, OP:푸시, OM:수신함)
								//while 문 end 이후 PSTMT3.executeUpdate 로직때문에 여기서 선 처리
								if (pushType != null && !"OP".equals(pushType)) {
									if(PSTMT1.executeUpdate(__PUSH_SEND_HASH__) > 0) {
//										insertedCount++;
									} else {
										log.info("INAPP_MSG INSERT FAIL => DEVICE_ID:{}",__PUSH_SEND_HASH__.get("DEVICE_ID"));
									}
								}
								int tempCheckTotalCount = totalSendCount.incrementAndGet();
								if (tempCheckTotalCount % spareCount == 0) {
									synchronized (spareMinute) { spareMinute += sparePlusMinute;  }
									log.info("Change Spare Minute: getName: {}, totalCount: {}, spareMinute: {}", getName(), totalSendCount.get(), spareMinute);
								}
								//[17.04.24]TMSP-628 OM 아닐때 처리 : stat 테이블 update 수행
								//while 문 end 이후 PSTMT3.executeUpdate 로직때문에 여기서 선 처리
								if(pushType != null && !"OM".equals(pushType)){
									insertedCount++;
								}
								processCount++;
								
							//기존로직
							} else {
								if(PSTMT.executeUpdate(__PUSH_SEND_HASH__) > 0) {
									insertedCount++;
//									log.info("insertedCount: {}, {}", getName(), insertedCount);
									int tempCheckTotalCount = totalSendCount.incrementAndGet();
									if (tempCheckTotalCount % spareCount == 0) {
										synchronized (spareMinute) {
											spareMinute += sparePlusMinute;
										}
										log.info("Change Spare Minute: getName: {}, totalCount: {}, spareMinute: {}", getName(), totalSendCount.get(), spareMinute);
									}
									//250 2.0.0 Message accepted for delivery
//									this.success_process(RCPT_ARRAY);
								} else {
//									this.error_process(RCPT_ARRAY, "TMS_PUSH_QUE INSERT CNT IS 0");
								}
								processCount++;
							}
						}catch(Exception e){
							log.error("[PushFixedDomainSingleRcptBufferedCommunicationActor error] e:{}", e);
							log.error("MEMBER_ID:{},POST_ID:{}",__PUSH_SEND_HASH__.get("MEMBER_ID"),__PUSH_SEND_HASH__.get("POST_ID"));
//							this.error_process(RCPT_ARRAY, e.getMessage());
							continue; 
						} finally {
							
//							if (insertedCount % commitSize == 0) {
							if (processCount % commitSize == 0) {
								if(EMS_CONNECTION != null){
									
									if("Y".equals(activeMqUseYN)){
										__PUSH_SEND_HASH__.put("PUSHED_CNT",  String.valueOf(insertedCount));
										__PUSH_SEND_HASH__.put("FAIL_CNT",  String.valueOf(failedCount));
										// CAMP_SCHD_INFO UPDATE
										if(!CommonType.TEST.equals(sendCommonType)
												&& (pushType != null && !"OM".equals(pushType))){ //[17.04.24]TMSP-628 OM 아닐때 처리 : stat 테이블 update 수행
											if(PSTMT3.executeUpdate(__PUSH_SEND_HASH__) > 0) {
//												log.info("[418] CAMP_SCHD_INFO +PUSHED_CNT:{}", insertedCount);
											} else {
												log.info("CAMP_SCHD_INFO UPDATE CNT IS 0");
											}
										}
										insertedCount = 0;
										processCount = 0;
										failedCount = 0;
									}
									
									try{
										EMS_CONNECTION.commit();
//										EMS_CONNECTION.setAutoCommit(true);
									} catch(Exception e){
										log.error("Commit error : ", e);
										Map<String, String>	__PUSH_SEND_HASH__2	= null;
										for(String[] queData : currentList){
											__PUSH_SEND_HASH__2 = setMapping(queData,spareMinute);
											eMsPreparedStatement PSTMT2ONE = null;
											if(  __PUSH_SEND_HASH__2.get("SEND_STATE").equals(CommonType.TEST.getCode())  ){
												sendCommonType = CommonType.TEST;
											}
											
											notiFlag = __PUSH_SEND_HASH__2.get("NOTI_FLAG");
//											int cnt = 0;
											//[17.04.24]TMSP-628 푸시 전송 타입(MP:수신함+푸시, OP:푸시, OM:수신함)
											pushType = __PUSH_SEND_HASH__2.get("PUSH_TYPE");
											try{
												
												if("Y".equals(activeMqUseYN)){
													// SEND_LIST 업데이트관련 쿼리세팅 
													QUERY_UPDATE_SEND_LIST = StringConvertUtil.ppsParseSQL(QUERY_UPDATE_SEND_LIST, "LIST_TABLE", __PUSH_SEND_HASH__2.get("LIST_TABLE"), "@{", "}");
													PSTMT2ONE = EMS_CONNECTION.prepareStatement(QUERY_UPDATE_SEND_LIST,"${","}");
													// INSERT INAPP_MSG
//													cnt = PSTMT1.executeUpdate(__PUSH_SEND_HASH__2);
													//[17.04.24]TMSP-628 푸시 전송 타입(MP:수신함+푸시, OP:푸시, OM:수신함)
													if (pushType != null && !"OP".equals(pushType)) {
														PSTMT1.executeUpdate(__PUSH_SEND_HASH__2);
													}
													
													try {
														// 테스트발송여부 체크
														if(!CommonType.TEST.equals(sendCommonType)){
															if("Y".equals(notiFlag)){
																__PUSH_SEND_HASH__2.put("SEND_STATE",StatusType.SENDING.getCode());
																__PUSH_SEND_HASH__2.put("ERROR_CODE",PushResponseCodeConstants.APPROVAL);
																__PUSH_SEND_HASH__2.put("PUSHED_CNT",  "1");
																__PUSH_SEND_HASH__2.put("FAIL_CNT",  "0");
															} else {
																__PUSH_SEND_HASH__2.put("SEND_STATE", StatusType.ERROR.getCode());
																__PUSH_SEND_HASH__2.put("ERROR_CODE", PushResponseCodeConstants.DENY_PUSH);
																__PUSH_SEND_HASH__2.put("PUSHED_CNT",  "1");
																__PUSH_SEND_HASH__2.put("FAIL_CNT",  "1");
															}
															// SEND_LIST UPDATE
															if(PSTMT2ONE.executeUpdate(__PUSH_SEND_HASH__2) > 0){
																
															} else {
																log.info("SEND_LIST UPDATE CNT IS 0");
															}
															//[17.04.24]TMSP-628 OM 아닐때 처리 : stat 테이블 update 수행
															if(pushType != null && !"OM".equals(pushType)){
																// CAMP_SCHD_INFO UPDATE
																if(PSTMT3.executeUpdate(__PUSH_SEND_HASH__2) > 0) {
	//																log.info("CAMP_SCHD_INFO +PUSHED_CNT:{},+FAIL_CNT:{}", __PUSH_SEND_HASH__2.get("PUSHED_CNT"),__PUSH_SEND_HASH__2.get("FAIL_CNT"));
																} else {
																	log.info("SCHD_INFO UPDATE CNT IS 0");
																}
															}
														}
													} catch(Exception err2){
														log.error("[Update error]", err2);
													}
													
												// 기존로직(PUSH_QUE)
												} else {
//													cnt = PSTMT.executeUpdate(__PUSH_SEND_HASH__2);
													PSTMT.executeUpdate(__PUSH_SEND_HASH__2);
												}
												/*
												if(cnt > 0){
													//250 2.0.0 Message accepted for delivery
//													this.success_process(RCPT_ARRAY);
												} else {
//													this.error_process(RCPT_ARRAY, "TMS_PUSH_QUE INSERT CNT IS 0");
													log.info(" UPDATE CNT IS 0");
												}
												*/
												EMS_CONNECTION.commit();
												
											}catch(Exception err){
												log.error("[Insert TMS_PUSH_QUE error]", err);
//												this.error_process(RCPT_ARRAY, e.getMessage());
												continue;
											} finally {
												if (PSTMT2ONE != null) try { PSTMT2ONE.close(); } catch(Exception ee) {}
											}
										}
									}finally{
										currentList.clear();
									}
								}
							}
							
						}
					}// end while loop
					
					if("Y".equals(activeMqUseYN)){
						// 가져온 스풀 사이즈만큼 돌았으면 스케줄에 업데이트를 친다.
						__PUSH_SEND_HASH__.put("PUSHED_CNT",  String.valueOf(insertedCount));
						__PUSH_SEND_HASH__.put("FAIL_CNT",  String.valueOf(failedCount));
						// SCHD_INFO UPDATE
						if(!CommonType.TEST.equals(sendCommonType)){
							if(PSTMT3.executeUpdate(__PUSH_SEND_HASH__) > 0) {
//								log.info("[523]CAMP_SCHD_INFO +PUSHED_CNT:{}", insertedCount);
								insertedCount = 0;
								processCount = 0;
								failedCount = 0;
							} else {
								log.info("CAMP_SCHD_INFO UPDATE CNT IS 0");
							}
						}
						
						// APNS SEND
						if (!apnsRequestBuilder.getPayloadList().isEmpty()) {
//							MgsPush.Request request = apnsRequestBuilder.build();
//							producer.send( toMessage(request, session));
							producer.send( toMessage(apnsRequestBuilder.build(), session));
						}
						// GCM SEND
						if (!gcmRequestBuilder.getPayloadList().isEmpty()) {
							producer.send( toMessage(gcmRequestBuilder.build(), session));
						}
						// APNS SEND priority 9
						if (!apnsFastRequestBuilder.getPayloadList().isEmpty()) {
							producer.send( toMessage(apnsFastRequestBuilder.build(), session), 
									DeliveryMode.NON_PERSISTENT, 9, Message.DEFAULT_TIME_TO_LIVE);
						}
						// GCM SEND priority 9
						if (!gcmFastRequestBuilder.getPayloadList().isEmpty()) {
							producer.send( toMessage(gcmFastRequestBuilder.build(), session), 
									DeliveryMode.NON_PERSISTENT, 9, Message.DEFAULT_TIME_TO_LIVE);
						}
						log.info("ActiveMQ SEND [END] APNS:{},GCM:{},APNS_fast:{},GCM_fast:{}",
								apnsRequestBuilder.getPayloadList().size(),gcmRequestBuilder.getPayloadList().size(),
								apnsFastRequestBuilder.getPayloadList().size(),gcmFastRequestBuilder.getPayloadList().size());
						
						if(apnsRequestBuilder != null)		apnsRequestBuilder.clear();
						if(gcmRequestBuilder != null)		gcmRequestBuilder.clear();
						if(apnsFastRequestBuilder != null)	apnsFastRequestBuilder.clear();
						if(gcmFastRequestBuilder != null)	gcmFastRequestBuilder.clear();
					}
//					log.debug("END : [th_cnt]"+th_cnt+"[size]"+this.PARSED_RCPT_INFO.size()+"[loop_time]:"+(System.currentTimeMillis() - time)+"ms");
				} catch (JMSException je){
					if(connection == null){
						connectionFactory = new ActiveMQConnectionFactory(activeMqAddr);
						connection = connectionFactory.createConnection();
						connection.start();
						session = connection.createSession(false, Session.AUTO_ACKNOWLEDGE);
						destination = session.createQueue(activeMqQueName);
						producer = session.createProducer(destination);
						producer.setDeliveryMode(DeliveryMode.NON_PERSISTENT);
					}
					continue;
				} catch(Exception e){
					EMS_CONNECTION.rollback();
					log.error("ROLLBACK!!! PUSH 등록 오류 ["+RCPT_ARRAY.toString()+"]", e);
				} finally {
					
					if(EMS_CONNECTION != null){
						try{
							EMS_CONNECTION.commit();
//							EMS_CONNECTION.setAutoCommit(true);
						}catch(Exception e){
							log.error("Commit Error:{}",e);
							Map<String, String>	__PUSH_SEND_HASH__3	= null;
							for(String[] queData : currentList){
								__PUSH_SEND_HASH__3 = setMapping(queData,spareMinute);
								
								eMsPreparedStatement PSTMT2ONE = null;
								if(  __PUSH_SEND_HASH__3.get("SEND_STATE").equals(CommonType.TEST.getCode())  ){
									sendCommonType = CommonType.TEST;
								}

								String notiFlag = __PUSH_SEND_HASH__3.get("NOTI_FLAG");
//								int cnt = 0;
								//[17.04.24]TMSP-628 푸시 전송 타입(MP:수신함+푸시, OP:푸시, OM:수신함)
								String pushType = __PUSH_SEND_HASH__3.get("PUSH_TYPE");
								try{
									
									if("Y".equals(activeMqUseYN)){
										// SEND_LIST 업데이트관련 쿼리세팅 
										QUERY_UPDATE_SEND_LIST = StringConvertUtil.ppsParseSQL(QUERY_UPDATE_SEND_LIST, "LIST_TABLE", __PUSH_SEND_HASH__3.get("LIST_TABLE"), "@{", "}");
										PSTMT2ONE = EMS_CONNECTION.prepareStatement(QUERY_UPDATE_SEND_LIST,"${","}");
										// INSERT INAPP_MSG
//										cnt = PSTMT1.executeUpdate(__PUSH_SEND_HASH__3);
										//[17.04.24]TMSP-628 푸시 전송 타입(MP:수신함+푸시, OP:푸시, OM:수신함)
										if (pushType != null && !"OP".equals(pushType)) {
											PSTMT1.executeUpdate(__PUSH_SEND_HASH__3);
										}
										
										try {
											if( !CommonType.TEST.equals(sendCommonType) ){
												if("Y".equals(notiFlag)){
													__PUSH_SEND_HASH__3.put("SEND_STATE",StatusType.PENDDING.getCode());
													__PUSH_SEND_HASH__3.put("ERROR_CODE",PushResponseCodeConstants.APPROVAL);
													__PUSH_SEND_HASH__3.put("PUSHED_CNT",  "1");
													__PUSH_SEND_HASH__3.put("FAIL_CNT",  "0");
												} else {
													__PUSH_SEND_HASH__3.put("SEND_STATE", StatusType.ERROR.getCode());
													__PUSH_SEND_HASH__3.put("ERROR_CODE", PushResponseCodeConstants.DENY_PUSH);
													__PUSH_SEND_HASH__3.put("PUSHED_CNT",  "1");
													__PUSH_SEND_HASH__3.put("FAIL_CNT",  "1");
												}
												// SEND_LIST UPDATE
												if(PSTMT2ONE.executeUpdate(__PUSH_SEND_HASH__3) > 0){

												} else {
													log.info("SEND_LIST UPDATE CNT IS 0");
												}
												
												//[17.04.24]TMSP-628 OM 아닐때 처리 : stat 테이블 update 수행
												if(pushType != null && !"OM".equals(pushType)){
													// CAMP_SCHD_INFO UPDATE
													if(PSTMT3.executeUpdate(__PUSH_SEND_HASH__3) > 0) {
//													log.info("CAMP_SCHD_INFO +PUSHED_CNT:{},+FAIL_CNT:{}", __PUSH_SEND_HASH__2.get("PUSHED_CNT"),__PUSH_SEND_HASH__2.get("FAIL_CNT"));
													} else {
														log.info("CAMP_SCHD_INFO UPDATE CNT IS 0");
													}
												}
											}
										} catch(Exception err2){
											log.error("[Update error]", err2);
										}
										
									// 기존로직(PUSH_QUE)
									} else {
//										cnt = PSTMT.executeUpdate(__PUSH_SEND_HASH__3);
										PSTMT.executeUpdate(__PUSH_SEND_HASH__3);
									}
									/*
									if(cnt > 0){
										//250 2.0.0 Message accepted for delivery
//										this.success_process(RCPT_ARRAY);
									}else{
//										this.error_process(RCPT_ARRAY, "TMS_PUSH_QUE INSERT CNT IS 0");
										log.info(" UPDATE CNT IS 0");
									}
									*/
									EMS_CONNECTION.commit();
									
								}catch(Exception err){
									log.error("[Insert TMS_PUSH_QUE error]", err);
//									this.error_process(RCPT_ARRAY, e.getMessage());
									continue;
								} finally {
									if (PSTMT2ONE != null) try { PSTMT2ONE.close(); } catch(Exception ee) {}
								}
							}
							
						} finally {
							insertedCount = 0;
							processCount = 0;
							failedCount = 0;
							currentList.clear();
						}
					}
					currentList.clear();
				}
				
				EMS_CONNECTION.commit();
				
			}//end of while (true)
			
		} catch (JMSException je){
			log.error("JMSExcption()", je);
			throw je;
		}finally{
			
			if(PSTMT != null){
				PSTMT.close();
			}
			if(PSTMT1 != null){
				PSTMT1.close();
			}

			if(PSTMT3 != null){
				PSTMT3.close();
			}
			
			if(EMS_CONNECTION != null){
				EMS_CONNECTION.commit();
				EMS_CONNECTION.setAutoCommit(true);
				EMS_CONNECTION.recycle();
			}
			//ActiveMQ close
			if (producer != null){
				producer.close();
			}
			if (session != null){
				session.close();
			}
			if (connection != null){
				connection.stop();
				connection.close();
			}
			log.info("Push Sending End....elapsedTime:{}", System.currentTimeMillis() - startTime);
			//ActiveMQ close
		}
	}
	
	
	public Message toMessage(Object object, Session session) throws JMSException {
		BytesMessage byteMessage = session.createBytesMessage();
		
		if (object instanceof MgsPush.Request) {
			byteMessage.writeBytes(((MgsPush.Request) object).toByteArray());
		} else if (object instanceof MgsPush.Response) {
			byteMessage.writeBytes(((MgsPush.Response) object).toByteArray());
		} else if (object instanceof MgsPush.ApnsFeedback) {
			byteMessage.writeBytes(((MgsPush.ApnsFeedback) object).toByteArray());
		}
		return byteMessage;
	}
	
	
	private MgsPush.ApnsMessage makeApnsMqMessage(Map<String, String> pushMessage) {
		MgsPush.ApnsMessage.Builder apnsMsgBuilder = MgsPush.ApnsMessage.newBuilder();
		apnsMsgBuilder
			.setMessage(pushMessage.get("PUSH_TITLE")+"\n"+pushMessage.get("PUSH_MSG"))
			.setSound(StringUtils.validString(""))
			.setMsgType(pushMessage.get("CONTENT_TYPE"))
			.setMsgId(String.valueOf(pushMessage.get("MSG_UID")));
		
		if (!StringUtils.isNull(pushMessage.get("PUSH_KEY"))) {
			apnsMsgBuilder.setPushKey(pushMessage.get("PUSH_KEY"))
				.setPushValue(StringUtils.validString(pushMessage.get("PUSH_VALUE")));
		}
		return apnsMsgBuilder.build();
	}
	
	private MgsPush.GcmMessage makeGcmMqMessage(Map<String, String> pushMessage) {
		MgsPush.GcmMessage.Builder gcmMsgBuilder = MgsPush.GcmMessage.newBuilder();

		gcmMsgBuilder.setTimeToLive( Integer.parseInt(pushMessage.get("PUSH_TTL")) )
		.setDelayWhileIdle(false)
		.setPushNotiMsg(StringUtils.validString(pushMessage.get("PUSH_MSG")))
		.setPushRichContent(StringUtils.validString(pushMessage.get("POPUP_CONTENT").toString()))
		.setPushNotiTitle(StringUtils.validString(pushMessage.get("PUSH_TITLE")))
		.setPushNotiImg(StringUtils.validString(pushMessage.get("PUSH_IMG")))
		.setMsgType(pushMessage.get("CONTENT_TYPE"))
		.setMsgId(pushMessage.get("MSG_UID"));
		
		JSONObject json = new JSONObject();
		if (!StringUtils.isNull(pushMessage.get("PUSH_KEY"))) {
			json.put( "l", StringUtils.validString(pushMessage.get("PUSH_VALUE")));
		}
		gcmMsgBuilder.setPushData(json.toString());
		
		return gcmMsgBuilder.build();
	}
	
	
	/**
	 * 한건에 대한 성공여부를 전송한다. 아마도 원투원 발송할때 RSET으로 초기화 하기 전에 호출이 되지 않을까... 생각된다.
	 * 
	 * @param RCPT_INFO
	 */
	protected void success_process(String[] _AGENT_ARRAY_) {
		this.resultLog(_AGENT_ARRAY_, "54", "10", "250 PUSH Message accepted for send", LOG_LEVEL_SUCCESS);
	}
	
	/**
	 */
	protected void error_process(String[] _AGENT_ARRAY_, String errorMessage) {
		this.resultLog(_AGENT_ARRAY_, "55", this.sendState.getRETURN_CODE(), "PUSH fail "+errorMessage, this.sendState.getLogLevel());
	}
	
	/**
	 * PUSH 데이터 매핑
	 * @param array 스풀에서 읽어온 데이터
	 * @return 
	 * @throws Exception
	 */
	public Map<String, String> setMapping(String[] array, int spareMinute ) throws Exception {
		Map<String, String>	__PUSH_SEND_HASH__	= new HashMap<String, String>();
		String postId    = "";
		String memberId  = "";
		String token = "";
		//String to_number   = "";
		String content    = "";
		String contentPop = "";
		String listTable = "";
		String rowId = "";
		String os = "";
		String notiFlag = "";
		int idx1 = 0;
		int idx2 = "/**PUSH_DELIM**/".length();
		long uniKey = System.nanoTime();
		String sUniKey = String.valueOf(uniKey).substring(0,13);
		//[TMS3.2.0] 우선순위
		String priority = "4";
		
		int posMid = 0;
		String mId = "";
		String mIdSeq = "";
		String custId = "";
		String deviceId = "";
		ContentInfo sendContentInfo = null;
		Properties prop = null;
		
		int tokenIdx = 0;
		try{
//			send_type  = array[INDEX_OF_SEND_KIND];
			postId    	= array[INDEX_OF_POST_ID];
			memberId  	= array[INDEX_OF_MEMBER_ID];
			token  		= array[INDEX_OF_TOKEN_ID];
			content    	= array[INDEX_OF_CONTENT];
			listTable 	= array[INDEX_OF_LIST_TABLE];
			rowId	 	= array[INDEX_OF_ROWID];
			os	 		= array[INDEX_OF_OS];
			notiFlag	= array[INDEX_OF_NOTI_FLAG];
			
			//[TMS3.2.0] 우선순위
			if (array.length > INDEX_OF_PRIORITY && array[INDEX_OF_PRIORITY] != null) {
				priority	= array[INDEX_OF_PRIORITY];
			} 
			
			if(content.length() > 0){
				idx1 = content.indexOf("/**PUSH_DELIM**/");
				if(idx1 > -1){
					contentPop = content.substring(0, idx1).trim();
					content = content.substring(idx1+idx2, content.length()).trim();
				}
			}
			
			//스케쥴에서 push정보 받아옴 
			sendContentInfo = ContentInfoManager.getContentInfo(postId);		
			prop = sendContentInfo.getScheduleInfo();
			
			if(token.length() > 0){
				tokenIdx = token.indexOf("^^");
				if(tokenIdx > -1){
					String[] tokens = token.split("\\^\\^");
					token =  tokens[0];
					deviceId = tokens[1];
					if (tokens.length > 2) {
						custId = tokens[2];
					}
				}
			}
	
			// 자동push일경우에는 member_id & member_id_seq 분리
			if(memberId.lastIndexOf('_') > 0){
				posMid = memberId.indexOf('_');
				mId = memberId.substring(0, posMid);
				mIdSeq = memberId.substring(posMid+1);
			}
			
			String list_table_num = listTable.substring(listTable.lastIndexOf("_")+1);
			//테스트 발송인 경우 POST_ID 입력 후 예약으로 발송 하면 PMS TTL 타입 채크부분에 문제가 있어 G_POST_ID를 POST_ID ID로 입력한다.
			
			/*
			 * REQ_UID 값 정의
			 * MASS : POST_ID^MEMBER_ID
			 * AUTO : WORKDAY_SEQNO^MEMBER_ID"_"MEMBER_ID_SEQ
			 * 
			 */
			if(prop.getProperty("SEND_STATE").equals("TEST") || prop.getProperty("SEND_STATE").equals("WFTEST")){	//테스트발송일경우
				//테스트 발송 자동push
				if(postId.length() > 13|| prop.getProperty("M_TYPE").equals("AUTO")){	//자동일경우
					__PUSH_SEND_HASH__.put("REQ_UID", "AT"+postId+"^"+memberId+"|"+list_table_num+"-"+sUniKey);	// AT20140207_6^39703465_01|01-123
					__PUSH_SEND_HASH__.put("MSG_UID", postId+"-"+sUniKey);//동일 폰으로 여러번 발송 시도를 할 수 있기 때문에 Unique한 수가 들어가도록 처리
					__PUSH_SEND_HASH__.put("MEMBER_ID", mId); 
					__PUSH_SEND_HASH__.put("MEMBER_ID_SEQ", mIdSeq); 
					__PUSH_SEND_HASH__.put("CUST_ID", mId);
				//테스트 발송 대량push
				}else{
					if("Y".equals(activeMqUseYN)){
						__PUSH_SEND_HASH__.put("REQ_UID", "CT"+postId.substring(0, 13)+"^"+custId+"-"+sUniKey);
					} else {
						__PUSH_SEND_HASH__.put("REQ_UID", "CT"+postId.substring(0, 13)+"^"+memberId+"-"+sUniKey);	// CT2014022100001^123
					}
					__PUSH_SEND_HASH__.put("MSG_UID", postId+"-"+sUniKey);	// 테스트 발송은 post_id + 난수 추가
					__PUSH_SEND_HASH__.put("MEMBER_ID", memberId); 
					__PUSH_SEND_HASH__.put("CUST_ID", custId);
					
					prop.setProperty("DEVICE_ID", deviceId);
					
					if("Y".equals(activeMqUseYN)){
						// MQ 사용하고 테스트 발송일 경우 OS정보를 가져와야 함
						StringBuffer	sb = new StringBuffer(1024);
						StringConvertUtil.ConvertString(sb, QUERY_SELECT_PUSH_OS_INFO, prop, "${", "}", true, false);
						try {
							EMS_CONNECTION2 = ConnectionPool.getConnection();
							EMS_STATEMENT = EMS_CONNECTION2.createStatement();
							rs = EMS_STATEMENT.executeQuery(sb.toString());
							while( rs.next() ) {				
								os = rs.getString("OS");
							}
							
						} catch (Exception e ){
							log.error("[QUERY_SELECT_PUSH_OS_INFO] Exception... {}", e);
							throw e;
						} finally {
							if(rs != null) {rs.close();}
							if(EMS_STATEMENT != null) {EMS_STATEMENT.close();}
							if(EMS_CONNECTION2 != null){ EMS_CONNECTION2.close(); }
						}
					}
					
				}
			}else{
				//실발송 자동push
				if(postId.indexOf('_') > -1 && postId.length() != 13){	//자동일경우			
					__PUSH_SEND_HASH__.put("REQ_UID", "AA"+postId+"^"+memberId+"|"+list_table_num);	// AA20140207_6^39703465|01-123
					__PUSH_SEND_HASH__.put("MSG_UID",postId.concat("^").concat(memberId));//실발송은 1회 진행되기 때문에 post_id, member_id만 입력 되도록 처리
					__PUSH_SEND_HASH__.put("MEMBER_ID", mId); 
					__PUSH_SEND_HASH__.put("MEMBER_ID_SEQ", mIdSeq); 
					__PUSH_SEND_HASH__.put("CUST_ID", mId);
				//실발송 대량push
				}else{
					__PUSH_SEND_HASH__.put("REQ_UID", "CC"+postId.substring(0, 13)+"^"+memberId);	// CC2014022100001^123
					if ((prop.getProperty("PUSH_TITLE", "").indexOf("${") >= 0
							&& prop.getProperty("PUSH_TITLE", "").indexOf("}") >= 0)
						|| (prop.getProperty("PUSH_MSG", "").indexOf("${") >= 0
							&& prop.getProperty("PUSH_MSG", "").indexOf("}") >= 0)) {
						__PUSH_SEND_HASH__.put("MSG_UID",postId.substring(0, 13).concat("^").concat(sUniKey));
					} else {
						__PUSH_SEND_HASH__.put("MSG_UID",postId.substring(0, 13));
					}
					__PUSH_SEND_HASH__.put("CUST_ID", memberId);
					__PUSH_SEND_HASH__.put("MEMBER_ID", memberId); 
					__PUSH_SEND_HASH__.put("TOTAL_TYPE", prop.getProperty("TOTAL_TYPE"));
				}
			}
			
			__PUSH_SEND_HASH__.put("TOKEN_ID", token);
			__PUSH_SEND_HASH__.put("MEMBER_NAME", _MEMBER_HASH_.getAsString("TMS_M_NAME", "")); 
			__PUSH_SEND_HASH__.put("INFO_CP", "");	//전화번호없음
			__PUSH_SEND_HASH__.put("APP_GRP_KEY", prop.getProperty("APP_GRP_KEY"));
			__PUSH_SEND_HASH__.put("APP_GRP_ID", prop.getProperty("APP_GRP_ID"));
			__PUSH_SEND_HASH__.put("DEVICE_ID", deviceId);
			
			StringBuffer buffer = new StringBuffer(512);
			
			__PUSH_SEND_HASH__.put("CONTENT_TYPE", prop.getProperty("CONTENT_TYPE", "T"));
			for( Enumeration<?> eNum = prop.propertyNames(); eNum.hasMoreElements(); ){
				String key = eNum.nextElement().toString();
				String value = prop.getProperty(key);
				
				buffer.setLength(0);
				
				StringConvertUtil.ConvertString(buffer, value, _MEMBER_HASH_, "${", "}", true, false);
				
				if(!key.equals("CONTENT") && !__PUSH_SEND_HASH__.containsKey(key))
					__PUSH_SEND_HASH__.put(key, StringUtil.trimNull(buffer));
			}
			
			
			__PUSH_SEND_HASH__.put("POPUP_CONTENT", contentPop);
			__PUSH_SEND_HASH__.put("INAPP_CONTENT", content);
			__PUSH_SEND_HASH__.put("PUSH_KEY", "I");
			String pushTtl = "".equals(prop.getProperty("PUSH_TTL","")) ? "1800" :  prop.getProperty("PUSH_TTL","");
			__PUSH_SEND_HASH__.put("PUSH_TTL", pushTtl);
			
			__PUSH_SEND_HASH__.put("SPARE_MINUTE", spareMinute+"");
			
			__PUSH_SEND_HASH__.put("ROW_ID", rowId);
			
			if("Y".equals(activeMqUseYN)){
				__PUSH_SEND_HASH__.put("OS", os);
				__PUSH_SEND_HASH__.put("NOTI_FLAG", notiFlag);
				__PUSH_SEND_HASH__.put("LIST_TABLE", listTable);
			}
			
			__PUSH_SEND_HASH__.put("ETC1", "");
			__PUSH_SEND_HASH__.put("ETC2", "");
			__PUSH_SEND_HASH__.put("ETC3", "");
			__PUSH_SEND_HASH__.put("ETC4", "");
			__PUSH_SEND_HASH__.put("ETC5", "");
			__PUSH_SEND_HASH__.put("ETC6", "");
			
			//[TMS3.2.0] 우선순위
			__PUSH_SEND_HASH__.put("PRIORITY", priority);
			
			
			//부달 발송 관련
			String swType = prop.getProperty("SWITCH_YN","N");
			__PUSH_SEND_HASH__.put("RESEND_TYPE", "NO");
			if(!swType.equals("N")) {
				String contentSplit[] = content.split("\\/\\*\\*KAKAO\\_DELIM\\*\\*\\/");
				
				__PUSH_SEND_HASH__.put("INAPP_CONTENT", contentSplit[0]);
				__PUSH_SEND_HASH__.put("CONTENT", contentSplit[0]);
				
				
				boolean isSwMapping = true;
				if (!StringUtils.isNull(_MEMBER_HASH_.getAsString("SWITCH_YN", ""))) {
					if ("N".equals(_MEMBER_HASH_.getAsString("SWITCH_YN", ""))) {
						isSwMapping = false;
					}
				}
				
				if (isSwMapping && contentSplit.length > 1) {
					//부달 문자 본문
					__PUSH_SEND_HASH__.put("SWITCH_MSG", contentSplit[1]);
					String to_number = _MEMBER_HASH_.getAsString("TMS_M_PHONE", "");
					if(postId.indexOf('_') > -1 && postId.length() != 13){	//자동일경우	
						if ("Y".equals(encryptYn) ) {
							if (to_number != null && !"".equals(to_number)) {
								to_number = HumusonEncryptor.encrypt(to_number, encKey, false);
							}
						}
					}
					__PUSH_SEND_HASH__.put("TMS_M_PHONE", to_number);
					if(contentSplit[1] != null && !"".equals(contentSplit[1])){
						if (swType.equals("S")) {
							if(contentSplit[1].getBytes().length<=90){
								__PUSH_SEND_HASH__.put("RESEND_TYPE", "SM");
							}else{
								__PUSH_SEND_HASH__.put("RESEND_TYPE", "LM");
							}
						} else {
							__PUSH_SEND_HASH__.put("RESEND_TYPE", "KA");
						}
					}
				} else {
					__PUSH_SEND_HASH__.put("TMS_M_PHONE", "");
				}
			}else{
				__PUSH_SEND_HASH__.put("CONTENT", content);
				__PUSH_SEND_HASH__.put("TMS_M_PHONE", "");
				
			}
			return __PUSH_SEND_HASH__;
			
		}catch(Exception e){
			log.error(getName(), e);
			throw e;
		}
	}
	
	protected MgsPush.Request.Builder apnsBuilder(MgsPush.Request.Builder rb, MgsPush.PushPayload.Builder pb,
			Map<String, String>	__PUSH_SEND_HASH__, Map<String,String> appKeyMap,
			String appGrpKey, String serverId, String id) {
		rb.setAppKey( appKeyMap.get(appGrpKey) )
			.setAckMode(AckMode.ACK)
			.setPushChnType(PushChnType.APNS)
			.setSendType(SendType.ONE2ONE)
			.setSeverId(serverId);
		pb.clear();
		pb.setToken(__PUSH_SEND_HASH__.get("TOKEN_ID"))
		  .setId(id)
		  .setApnsMessage(makeApnsMqMessage(__PUSH_SEND_HASH__));
		rb.addPayload(pb.build());
		return rb;
	}
	protected MgsPush.Request.Builder fcmBuilder(MgsPush.Request.Builder rb, MgsPush.PushPayload.Builder pb,
			Map<String, String>	__PUSH_SEND_HASH__, Map<String,String> appKeyMap,
			String appGrpKey, String serverId, String id) {
		rb.setAppKey( appKeyMap.get(appGrpKey) )
			.setAckMode(AckMode.ACK)
			.setPushChnType(PushChnType.GCM)
			.setSendType(SendType.ONE2ONE)
			.setSeverId(serverId);
		pb.clear();
		pb.setToken(__PUSH_SEND_HASH__.get("TOKEN_ID"))
		  .setId(id)
		  .setGcmMessage(makeGcmMqMessage(__PUSH_SEND_HASH__));
		rb.addPayload(pb.build());
		return rb;
	}
	
	/**
	 * 같은 도메인들이므로 걍 모두 에러처리를 한다.
	 */
	protected void all_error_process() {
		if( STEP_DEBUG )
			log("all error");
		error_process(RCPT_ARRAY, "all error");

		parsedListAllErrorProcess();
	}
	
	public static void main(String[] args) {
		String str = "123456789^^1";
		
		if (str.indexOf("^^") > -1) {
			System.out.println(str.split("\\^\\^")[1]);
		}
		
		String contentSplit[] = str.split("9");
		System.out.println(contentSplit[0]);
		System.out.println(contentSplit.length);
		
	}
}
