/*
 * @(#)LmsFixedDomainSingleRcptBufferedCommunicationActor.java            2004. 12. 6.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.mass.actor;

//import gems.esb.EsbSendUtil;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

import com.humuson.tms.constrants.CommonType;

import jupiter.common.task.RealTimeCheckTask;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import lombok.extern.slf4j.Slf4j;
import pluto.mail.SendState;
import pluto.secure.crypto.CryptoUtil;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;

/**
 * <br>
 * Innter Container에 있는 메일 발송 대상이 모두 같은 도메인의 경우 <br>
 * 1 to 1 메일 발송의 처리.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class LmsFixedDomainSingleRcptBufferedCommunicationActor extends AbstractSingleRcptCommunicationActor {
	
	private static final String SEND_TYPE = "SEND_TYPE";
	private static final String POST_ID = "POST_ID";
	private static final String TO_NUMBER = "TO_NUMBER";
	private static final String FROM_NUMBER = "FROM_NUMBER";
	
	// Use Encrypt
	private static String encYn = null;
	private static String encKey = null;
	
	// Module Name
	private static String smsModuleName = null;
	
	// 문자 모듈 디비가 솔루션과 같은 곳에 위치하는지 아니면 다른 곳에 위치하는지 지정
	private static boolean smsDbUse = false;
	
	// Query
	public static String queryInsertLmsSend = null;
	
	private static int th_cnt = 0;
	private static ConnectInfo moduleConnectionInfo = null;
	
	private String errorMessage = null;
//	private Map<String,String> memberHash = new Hashtable<String,String>();
	
	static {
		
		encYn = eMsSystem.getProperty("member.info.encrypt.yn","N");
		encKey = eMsSystem.getProperty("member.info.encrypt.key","");
		
		smsModuleName = eMsSystem.getProperty("sms.module.name","imc");
		smsDbUse = Boolean.parseBoolean(eMsSystem.getProperty("sms.db.use","false"));
		
		queryInsertLmsSend = SqlManager.getQuery("IMC", "QUERY_INSERT_LMS_SEND");
		
		if (smsDbUse) {
			moduleConnectionInfo = new ConnectInfo();
			moduleConnectionInfo.setDRIVER(eMsSystem.getProperty("sms.db.driver"));
			moduleConnectionInfo.setDB_URL(eMsSystem.getProperty("sms.db.url"));
			moduleConnectionInfo.setDB_UID(eMsSystem.getProperty("sms.db.id"));
			moduleConnectionInfo.setDB_PASS(eMsSystem.getProperty("sms.db.pass"));
			moduleConnectionInfo.setDB_INIT_QUERY(eMsSystem.getProperty("sms.db.init"));
			moduleConnectionInfo.setDB_BASE_CHARSET(eMsSystem.getProperty("sms.db.base.charset"));
			moduleConnectionInfo.setDB_OUT_CHARSET(eMsSystem.getProperty("sms.db.out.charset"));
			moduleConnectionInfo.setDB_IN_CHARSET(eMsSystem.getProperty("sms.db.in.charset"));
		}
	}
	
	public LmsFixedDomainSingleRcptBufferedCommunicationActor() throws Exception {
		super();
	}

	protected void work() throws Exception {
		th_cnt ++;
		
		eMsConnection emsConnection = null;
		eMsPreparedStatement pstmt = null;
		
		try {
			
			//get connection
			if (smsDbUse) {
				emsConnection = ConnectionPool.getConnection(moduleConnectionInfo);
			} else {
				emsConnection = ConnectionPool.getConnection();
			}
			
			pstmt = emsConnection.prepareStatement(queryInsertLmsSend, "${", "}");
			
			/**
			 * 자 시작 합니다.
			 */
			this.CURR_STEP = SendState.WAIT;
			Map<String, String>	memberHash	= null;
			
			while (true) {
				/**
				 * 없으면 다시 받아온다.
				 */
				if (this.RCPT_TO == null) {
					this.RCPT_TO = this.INNER_BUFFERED_BIN.popupNoWait();
				}
	
				if (this.RCPT_TO == null) {
					return;
				}
				
				if (log.isDebugEnabled()) {
					log("pop up:" + this.RCPT_TO.toString());
				}
	
				if (this.splitRcptInfo() == null) {
					if (log.isDebugEnabled()) {
						log("split fail continue");
					}
					continue;
				}
				
				log.debug("LMS 1TO1 - START : [th_cnt]: {} / [size]: {}", th_cnt, this.PARSED_RCPT_INFO.size());
				
				int i = 0;
				
				try {
					
					emsConnection.setAutoCommit(false);
					
					long time = System.currentTimeMillis();
					// 여러개 뭉친 녀석들을 쪼갠거를 하나씩 처리를 한다.
					while (this.PARSED_RCPT_INFO.size() > 0) {
						Object nextSpool = this.PARSED_RCPT_INFO.removeFirst();
						
						if (!this.parseRcptInfo(nextSpool)) {
							if (log.isDebugEnabled()) {
								log("parseRcptInfo fail continue");
							}
							continue; 
						}
						
						//delay 시간이 있다면
						if (this.connection_delay > 0) {
							try {
								Thread.currentThread().sleep(this.connection_delay);
							} catch(Exception e) {}
						}
						
						// RCPT 보내기 전에 보낸다고 54-00 을 마킹해야한다.
						start_process(RCPT_ARRAY);
						
						// 업체 테이블로 인서트 하는 로직
						try {
							
							memberHash = setMapping(RCPT_ARRAY);
							
							if (log.isDebugEnabled()) {
								log.debug("MEMBER HASH: {}", memberHash);
							}
							
							if (pstmt.executeUpdate(memberHash) > 0) {
								this.success_process(RCPT_ARRAY);
							} else {
								this.error_process(RCPT_ARRAY);
							}
						} catch(Exception e) {
							errorMessage = e.toString();
							this.error_process(RCPT_ARRAY);
							log.error("LMS INSERT ERROR", e);
							continue; 
						} finally {
							memberHash.clear();
						}
					}
					
					if (log.isDebugEnabled()) {
						log.debug("LMS 1TO1 - END : [th_cnt]: {} / [size]: {} / [loop_time]: {}", th_cnt, this.PARSED_RCPT_INFO.size(), (System.currentTimeMillis() - time)+"ms");
					}
				} catch (Exception e) {
					emsConnection.rollback();
					log.error("LMS 1TO1 - ROLLBACK!!! LMS 등록 오류", e);
				} finally {
					if (emsConnection != null) {
						log.debug("LMS 1TO1 - COMMIT TRUE : [th_cnt]: {} / [size]: {}", th_cnt, this.PARSED_RCPT_INFO.size());
						emsConnection.commit();
						emsConnection.setAutoCommit(true);
					}
				}	
			}  // end while loop
		} finally {
			if (pstmt != null) {
				pstmt.close();
			}
			
			if (emsConnection != null) {
				emsConnection.destroy();
			}
		}
	}
	
	/**
	 * 한건에 대한 성공여부를 전송한다. 아마도 원투원 발송할때 RSET으로 초기화 하기 전에 호출이 되지 않을까... 생각된다.
	 * 
	 * @param RCPT_INFO
	 */
	protected void success_process(String[] _AGENT_ARRAY_) {
		this.resultLog(_AGENT_ARRAY_, "54", "10", "250 LMS Message accepted for send", LOG_LEVEL_SUCCESS);
	}
	
	/**
	 */
	protected void error_process(String[] _AGENT_ARRAY_) {
		this.resultLog(_AGENT_ARRAY_, "55", this.sendState.getRETURN_CODE(), "LMS fail "+errorMessage, this.sendState.getLogLevel());
	}
	
	public Map<String,String> setMapping(String[] array) throws Exception {
		String sendType = null;
		String postId = null;
		String memberId = null;
		String toNumber = null;
		String content = null;
		String listTable = null;
		String rowId = null;
		Map<String, String>	memberHash	= new HashMap<String, String>();
		
		try {
			
			sendType = array[INDEX_OF_SEND_KIND];
			postId = array[INDEX_OF_POST_ID];
			memberId = array[INDEX_OF_MEMBER_ID];
			content = array[INDEX_OF_CONTENT];
			listTable = array[INDEX_OF_LIST_TABLE];
			rowId = array[INDEX_OF_ROWID];
			
			// 암/복호화 관련 부분
			if (encYn.equals("Y")) {
				toNumber  = array[INDEX_OF_EMAIL_ENCRYPT];
				
				if (encKey.equals("")) {
					memberHash.put(TO_NUMBER, CryptoUtil.decrypt(toNumber, CryptoUtil.TEL_NUM));
				} else {
					memberHash.put(TO_NUMBER, CryptoUtil.decrypt(toNumber, CryptoUtil.TEL_NUM, encKey));
				}
			} else {
				toNumber  = array[INDEX_OF_TOKEN_ID];
				memberHash.put(TO_NUMBER, toNumber);
			}
			
			memberHash.put(POST_ID, postId);
			memberHash.put("MEMBER_ID", memberId);
			memberHash.put("CONTENT", content);
			memberHash.put("LIST_TABLE", listTable);
			memberHash.put("ROW_ID", rowId);
			
			ContentInfo sendContentInfo = ContentInfoManager.getContentInfo(postId);
			Properties scheduleInfoProp = sendContentInfo.getScheduleInfo();
			
			String sendState = scheduleInfoProp.getProperty("SEND_STATE","");
			if (sendState.equals("TEST") || sendState.equals("WFTEST")) {
				memberHash.put(SEND_TYPE, CommonType.TEST.getCode());
			} else {
				if (postId.indexOf("_") > -1 || sendType.equals("AUTORESEND")) {
					memberHash.put(SEND_TYPE, CommonType.AUTO.getCode());
				} else {
					memberHash.put(SEND_TYPE, CommonType.CAMP.getCode());
				}
			}
			
			StringBuffer buffer = new StringBuffer(512);
			//SCHD_INFO 에서 가져온 정보 중 매핑이 존재할 수 있다. 매핑 처리 하여 발송에 꼭 필요.!!  ex) push_img, from_number 
			for (Enumeration<?> eNum = scheduleInfoProp.propertyNames(); eNum.hasMoreElements();) {
				String key = eNum.nextElement().toString();
				String value = scheduleInfoProp.getProperty(key);
				
				buffer.setLength(0);
				StringConvertUtil.ConvertString(buffer, value, _MEMBER_HASH_, "${", "}", true, false);
				
				if (!key.equals("CONTENT") && !memberHash.containsKey(key)) {
					memberHash.put(key, StringUtil.trimNull(buffer));
				}
			}
			
			memberHash.put(FROM_NUMBER, scheduleInfoProp.getProperty(FROM_NUMBER,""));
			memberHash.put("USER_ID", scheduleInfoProp.getProperty("USER_ID",""));
			memberHash.put("USER_DEPT", scheduleInfoProp.getProperty("USER_DEPT",""));
			memberHash.put("SMS_ID", scheduleInfoProp.getProperty("SMS_ID",""));
			
			return memberHash;
			
		} catch(Exception e) {
			log.error("ERROR setMapping.", e);
			return null;
		}
	}
	
	/**
	 * 같은 도메인들이므로 걍 모두 에러처리를 한다.
	 */
	protected void all_error_process() {
		if( STEP_DEBUG )
			log("all error");
		//start_process( RCPT_ARRAY );
		error_process(RCPT_ARRAY);

		parsedListAllErrorProcess();
	}
}
