/*
 * @(#)LmsBroadcastDomainSingleRcptBufferedCommunicationActor.java            2004. 12. 6.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.mass.actor;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

import jupiter.common.task.RealTimeCheckTask;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;


import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.ioutil.FileUtil;
import lombok.extern.slf4j.Slf4j;
import pluto.mail.SendState;
import pluto.util.PlutoLinkedList;
import pluto.util.StringUtil;

/**
 * <br>
 * 
 * Broadcast(동보) SMS 발송의 처리.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class LmsBroadcastDomainSingleRcptBufferedCommunicationActor extends AbstractSingleRcptCommunicationActor {
	
	
	
	private static String QUERY_INSERT_LMS_DONGBO_SEND = null;
	
	private static String QUERY_INSERT_LMS_CLIENT_SEND = null;
	
	private static String QUERY_SELECT_LMS_DONGBO_SEQ = null;
	
	private static String QUERY_UPDATE_LMS_DONGBO_SEND = null;
	
	public static String ERROR_MESSAGE = null;
	
	private eMsConnection EMS_CONNECTION = null;
	
	private eMsPreparedStatement PSTMT = null;
	
	private eMsPreparedStatement PSTMT_SUB = null;
	
	private eMsPreparedStatement PSTMT_UPDATE = null;
	
	private eMsPreparedStatement PSTMT_SEQ = null;
	
	private eMsResultSet RS_SEQ = null;
	
	private Map	__LMS_SEND_HASH__	= new Hashtable();
	
	private Map	__LMS_SEND_CLINET_HASH__	= new Hashtable();
	
	private static int th_cnt = 0;
	
	
	private static ConnectInfo	TARGET_CONNECT_INFO					= null;
	
	
	
	static {
		//LMS
		QUERY_INSERT_LMS_DONGBO_SEND = SqlManager.getQuery("COMMON", "QUERY_INSERT_LMS_DONGBO_SEND");
		QUERY_INSERT_LMS_CLIENT_SEND = SqlManager.getQuery("COMMON", "QUERY_INSERT_LMS_CLIENT_SEND");
		QUERY_SELECT_LMS_DONGBO_SEQ = SqlManager.getQuery("COMMON", "QUERY_SELECT_LMS_DONGBO_SEQ");
		QUERY_UPDATE_LMS_DONGBO_SEND = SqlManager.getQuery("COMMON", "QUERY_UPDATE_LMS_DONGBO_SEND");
				
		TARGET_CONNECT_INFO = new ConnectInfo();
		TARGET_CONNECT_INFO.setDRIVER(eMsSystem.getProperty("sms.db.driver"));
		TARGET_CONNECT_INFO.setDB_URL(eMsSystem.getProperty("sms.db.url"));
		TARGET_CONNECT_INFO.setDB_UID(eMsSystem.getProperty("sms.db.id"));
		TARGET_CONNECT_INFO.setDB_PASS(eMsSystem.getProperty("sms.db.pass"));
		TARGET_CONNECT_INFO.setDB_INIT_QUERY(eMsSystem.getProperty("sms.db.init"));
		TARGET_CONNECT_INFO.setDB_BASE_CHARSET(eMsSystem.getProperty("sms.db.base.charset"));
		TARGET_CONNECT_INFO.setDB_OUT_CHARSET(eMsSystem.getProperty("sms.db.out.charset"));
		TARGET_CONNECT_INFO.setDB_IN_CHARSET(eMsSystem.getProperty("sms.db.in.charset"));
		
	}

	/** Creates a new instance of LmsFixedDomainSingleRcptBufferedCommunicationActor */
	public LmsBroadcastDomainSingleRcptBufferedCommunicationActor() throws Exception {
		
		super();
		
	}

	protected void work() throws Exception {
		
		try{
			//get connection
			log("1000 db connection start");
			EMS_CONNECTION = ConnectionPool.getConnection(TARGET_CONNECT_INFO);
			PSTMT_SEQ = EMS_CONNECTION.prepareStatement(QUERY_SELECT_LMS_DONGBO_SEQ,"${","}");
			PSTMT = EMS_CONNECTION.prepareStatement(QUERY_INSERT_LMS_DONGBO_SEND,"${","}"); 
			PSTMT_SUB = EMS_CONNECTION.prepareStatement(QUERY_INSERT_LMS_CLIENT_SEND,"${","}");
			PSTMT_UPDATE = EMS_CONNECTION.prepareStatement(QUERY_UPDATE_LMS_DONGBO_SEND, "${","}");
			log("1000 db connection end"); 			
			
			th_cnt ++;
			boolean insertYn = false;
			
			/**
			 * 자 시작 합니다.
			 */
			this.CURR_STEP = SendState.WAIT;
	
			while (true) {
				/**
				 * 없으면 다시 받아온다.
				 */
				if( this.RCPT_TO == null ) {
					this.RCPT_TO = this.INNER_BUFFERED_BIN.popupNoWait();
				}
	
				if( this.RCPT_TO == null ) {
					return;
				}
							
				if (log.isDebugEnabled()) {
					log("pop up:" + this.RCPT_TO.toString());
				}
	
				if( this.splitRcptInfo() == null ) {
					if (log.isDebugEnabled()) {
						log("split fail continue");
					}
					continue;
				}else{

				
				}
				
				log.debug("LMS DONGBO - START : [th_cnt]"+th_cnt+"[size]"+this.PARSED_RCPT_INFO.size());
		
				int i=0;
				int insResult =0; 
				String sms_seq = "";
				
				/*
				 * TMS 동보발송을 위한 시퀀스발번 
				 */
				try{
					RS_SEQ = PSTMT_SEQ.executeQuery(__LMS_SEND_HASH__);
					
					if(RS_SEQ.next()){
						sms_seq = RS_SEQ.getString(1);
					}				
					
				}catch(Exception e){
					log.error(e.getMessage());
					continue; 
				}
				try{
					EMS_CONNECTION.setAutoCommit(false);
					long time = System.currentTimeMillis();
					// 여러개 뭉친 녀석들을 쪼갠거를 하나씩 처리를 한다.
					while (this.PARSED_RCPT_INFO.size() > 0) {
						
						i++;
						
						try {
							
						
						Object NEXT_SPOOL = this.PARSED_RCPT_INFO.removeFirst();
		
						if( !this.parseRcptInfo(NEXT_SPOOL) ) { 
							if (log.isDebugEnabled()) {
								log("parseRcptInfo fail continue");
							}
							continue; 
						}
						
						//delay 시간이 있다면
						if( this.connection_delay > 0 ) {
							try {
								Thread.currentThread().sleep(this.connection_delay);
							}catch(Exception e) {
								log("1001="+e.getMessage());
							}
						}
						
						} catch (Exception e) {
							log("1002="+e.getMessage());
						}
						try{
							// RCPT 보내기 전에 보낸다고 54-00 을 마킹해야한다.
							start_process(RCPT_ARRAY);				
							/*
							 * TMS SMS 업체 테이블로 인서트 하는 로직 
							 */
							try{
								
								//client insert (SC_CLIENT)
								setMapping(RCPT_ARRAY, sms_seq , i);						
								int cnt = PSTMT_SUB.executeUpdate(__LMS_SEND_CLINET_HASH__);
								log.debug("cnt:"+cnt+" SC_CLIENT Insert");
								if(cnt > 0){
									//250 2.0.0 Message accepted for delivery
									this.success_process(RCPT_ARRAY, __LMS_SEND_CLINET_HASH__.get("TR_NUM").toString());
								}else{
									this.error_process(RCPT_ARRAY, __LMS_SEND_CLINET_HASH__.get("TR_NUM").toString());
								}
								

							}catch(Exception e){
								log.error(e.getMessage());
								continue; 
							}
							
						}catch(Exception e){
							log.error(getName(), e);
							ERROR_MESSAGE = e.toString();
							this.error_process(RCPT_ARRAY);
							EMS_CONNECTION.rollback();					
							// e.printStackTrace();
							log("LMS Sender Exception is"+ e.getMessage());
							continue; 
						}finally{
							__LMS_SEND_HASH__.clear();
							__LMS_SEND_CLINET_HASH__.clear();
						}
						
					}//end while
					
					//master insert (SC_TRAN)
					if(!insertYn){		// 1번만 INSERT
						setMasterMapping(RCPT_ARRAY, sms_seq);
						insResult = PSTMT.executeUpdate(__LMS_SEND_HASH__);
						insertYn = true;
						log.debug("insResult:"+insResult+" MMS_MSG Insert:");
						if(insResult > 0){
							//250 2.0.0 Message accepted for delivery
							this.master_success_process(RCPT_ARRAY, __LMS_SEND_HASH__.get("TR_NUM").toString());
						}else{
							this.master_error_process(RCPT_ARRAY, __LMS_SEND_HASH__.get("TR_NUM").toString());
						}
						
						//master status update
						int upint = PSTMT_UPDATE.executeUpdate(__LMS_SEND_HASH__);
					}
					
					log.debug("LMS DONGBO - END : [th_cnt]"+th_cnt+"[size]"+this.PARSED_RCPT_INFO.size()+"[loop_time]:"+(System.currentTimeMillis() - time)+"ms");
				}catch(Exception e){
					EMS_CONNECTION.rollback();
					// e.printStackTrace();
					log.error("LMS DONGBO - ROLLBACK!!! LMS 등록 오류"+RCPT_ARRAY.toString(), e);
				}finally{
					if(EMS_CONNECTION != null){
						log.debug("LMS DONGBO - COMMIT TRUE : [th_cnt]"+th_cnt+"[size]"+this.PARSED_RCPT_INFO.size());
						EMS_CONNECTION.commit();
						EMS_CONNECTION.setAutoCommit(true);
					}
				}
			}//end of while (true)
			
		}finally{
			
			if(PSTMT != null){
				PSTMT.close();
			}
			if(PSTMT_SEQ != null){
				PSTMT_SEQ.close();
			}			
			if(PSTMT_SUB != null){
				PSTMT_SUB.close();
			}
			if(PSTMT_UPDATE != null){
				PSTMT_UPDATE.close();
			}
			//2017.03.07
			if(RS_SEQ != null){
				RS_SEQ.close();
			}
			if(EMS_CONNECTION != null){
				EMS_CONNECTION.recycle();
			}
		}
		
	}
	
	public Map setMasterMapping(String[] array, String seq) throws Exception {
		
		String post_id    	= "";
		String member_id  	= "";
		String from_number 	= "";
		String to_number   	= "";
		String content    	= "";
		
		try{
			post_id    = array[INDEX_OF_POST_ID];
			member_id  = array[INDEX_OF_MEMBER_ID];
			from_number= array[INDEX_OF_MAIL_FROM];
			to_number  = array[INDEX_OF_TOKEN_ID];
			
			__LMS_SEND_HASH__.put("TR_NUM", seq);
			__LMS_SEND_HASH__.put("MEMBER_ID", member_id);
			__LMS_SEND_HASH__.put("FROM_NUMBER", from_number);
			__LMS_SEND_HASH__.put("TO_NUMBER", to_number);
			__LMS_SEND_HASH__.put("POST_ID", post_id);
			
			
			ContentInfo sendContentInfo = ContentInfoManager.getContentInfo(post_id);
			
			Properties prop = sendContentInfo.getScheduleInfo();
			
			content = FileUtil.readLocal(prop.getProperty("CONTENT").substring(7)); //file:// 제거 
			
			content = content.replaceAll("\\$\\{FIELD1\\}", "\\%CHANGEWORD1\\%");
			content = content.replaceAll("\\$\\{FIELD2\\}", "\\%CHANGEWORD2\\%");
			content = content.replaceAll("\\$\\{FIELD3\\}", "\\%CHANGEWORD3\\%");
			content = content.replaceAll("\\$\\{FIELD4\\}", "\\%CHANGEWORD4\\%");
			content = content.replaceAll("\\$\\{FIELD5\\}", "\\%CHANGEWORD5\\%");
			
			
			__LMS_SEND_HASH__.put("CONTENT", content);		//동보일 경우는 매핑안된 컨텐츠 가져온다.
			
			__LMS_SEND_HASH__.put("USER_ID", prop.getProperty("USER_ID",""));
			
			__LMS_SEND_HASH__.put("SUBJECT", prop.get("SUBJECT"));
			
			__LMS_SEND_HASH__.put("USER_DEPT", prop.getProperty("USER_DEPT",""));
			
			__LMS_SEND_HASH__.put("FROM_NUMBER", prop.getProperty("FROM_NUMBER",""));
			
			return __LMS_SEND_HASH__;
			
		}catch(Exception e){
			
			return null;
		
		}finally{
			
		}
	}
	
	/**
	 * 한건에 대한 성공여부를 전송한다. 아마도 원투원 발송할때 RSET으로 초기화 하기 전에 호출이 되지 않을까... 생각된다.
	 * 
	 * @param RCPT_INFO
	 */
	protected void success_process(String[] _AGENT_ARRAY_, String msg) {
		this.resultLog(_AGENT_ARRAY_, "54", "10", "250 LMS Message accepted for send TR_NUM :"+msg, LOG_LEVEL_SUCCESS);
	}
	
	/**
	 */
	protected void error_process(String[] _AGENT_ARRAY_, String msg) {
		this.resultLog(_AGENT_ARRAY_, "55", this.sendState.getRETURN_CODE(), "LMS fail "+ERROR_MESSAGE+" TR_NUM :"+msg, this.sendState.getLogLevel());
	}
	
	/**
	 * 한건에 대한 성공여부를 전송한다. 아마도 원투원 발송할때 RSET으로 초기화 하기 전에 호출이 되지 않을까... 생각된다.
	 * 
	 * @param RCPT_INFO
	 */
	protected void master_success_process(String[] _AGENT_ARRAY_, String msg) {
		this.resultLog(_AGENT_ARRAY_, "54", "10", "250 LMS MMS_MSG Insert for send TR_NUM :"+msg, LOG_LEVEL_SUCCESS);
	}
	
	/**
	 */
	protected void master_error_process(String[] _AGENT_ARRAY_, String msg) {
		this.resultLog(_AGENT_ARRAY_, "55", this.sendState.getRETURN_CODE(), "LMS MMS_MSG Insert fail "+ERROR_MESSAGE+" TR_NUM :"+msg, this.sendState.getLogLevel());
	}
	
	public Map setMapping(String[] array , String seq , long cnt) throws Exception {
		String send_type	= "";
		String post_id    	= "";
		String member_id  	= "";
		String to_number   	= "";
		String spool    	= "";
		String list_table	= "";
		int spoolMaxLen		= 18;		
		
		try{
			send_type  = array[INDEX_OF_SEND_KIND];
			post_id    = array[INDEX_OF_POST_ID];
			member_id  = array[INDEX_OF_MEMBER_ID];
			to_number  = array[INDEX_OF_TOKEN_ID];
			spool 	   = array[INDEX_OF_SPOOL];
			list_table = array[INDEX_OF_LIST_TABLE];
			
			String[] arrMapping = StringUtil.split(spool, "|");
			
			__LMS_SEND_CLINET_HASH__.put("TR_NUM", seq);
			__LMS_SEND_CLINET_HASH__.put("TR_SEQ", cnt);
			__LMS_SEND_CLINET_HASH__.put("MEMBER_ID", member_id);
			__LMS_SEND_CLINET_HASH__.put("TO_NUMBER", to_number);
			__LMS_SEND_CLINET_HASH__.put("POST_ID", post_id);
			
			ContentInfo sendContentInfo = ContentInfoManager.getContentInfo(post_id);
			
			Properties prop = sendContentInfo.getScheduleInfo();
			
			if(prop.getProperty("SEND_STATE").equals("TEST"))
				__LMS_SEND_CLINET_HASH__.put("POST_ID", post_id+"^TT^"+member_id);		//LMS TEST
			else{
//				if(send_type.equals("AUTO"))			
//					__LMS_SEND_CLINET_HASH__.put("POST_ID", post_id+"_TA_"+member_id+"_"+list_table.substring(list_table.lastIndexOf("_")+1));				
//				else
					__LMS_SEND_CLINET_HASH__.put("POST_ID", post_id.substring(0, 13)+"^TC^"+member_id);		//LMS MASS
			}
			
			if(arrMapping.length >= spoolMaxLen){
				__LMS_SEND_CLINET_HASH__.put("CHANGE_WORD1", arrMapping[14]);
				__LMS_SEND_CLINET_HASH__.put("CHANGE_WORD2", arrMapping[15]);
				__LMS_SEND_CLINET_HASH__.put("CHANGE_WORD3", arrMapping[16]);
				__LMS_SEND_CLINET_HASH__.put("CHANGE_WORD4", arrMapping[17]);
				__LMS_SEND_CLINET_HASH__.put("CHANGE_WORD5", arrMapping[18]);
			}
			
			return __LMS_SEND_CLINET_HASH__;
			
		}catch(Exception e){
			
			return null;
		
		}finally{
			
		}
	}

	
	
	public static boolean isAuto(String table){
		if(table.startsWith("TMS_SMS_LIST")) return false;
		else return true;
	}
	
	
	/**
	 * 같은 도메인들이므로 걍 모두 에러처리를 한다.
	 */
	protected void all_error_process() {
		if( STEP_DEBUG )
			log("all error");
		//start_process( RCPT_ARRAY );
		error_process(RCPT_ARRAY);

		parsedListAllErrorProcess();
	}
}
