/*
 * @(#)LmsFixedDomainSingleRcptBufferedCommunicationActor.java            2004. 12. 6.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.mass.actor;

//import gems.esb.EsbSendUtil;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import com.humuson.tms.common.util.StringUtils;
import com.humuson.tms.constrants.ChannelType;

import lombok.extern.slf4j.Slf4j;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.lang.eMsLocale;
import pluto.mail.SendState;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;

/**
 * <br>
 * Innter Container에 있는 메일 발송 대상이 모두 같은 도메인의 경우 <br>
 * 1 to 1 메일 발송의 처리.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class KakaoFixedDomainSingleRcptBufferedCommunicationActor extends AbstractSingleRcptCommunicationActor {
	
	private static final String KAKAO_DELIM = "/**KAKAO_DELIM**/";
	private static final String KAKAO_BUTTON = "/**KAKAO_BUTTON**/";
	
	private static String QUERY_INSERT_KAKAO_SEND = null;
	private static ConnectInfo	TARGET_CONNECT_INFO = null;
	private static int th_cnt = 0;
	
	private eMsConnection TMS_CONNECTION = null;
	private eMsPreparedStatement PSTMT = null;
	
	private static final int SMS_LIMIT_BYTE = Integer.parseInt(eMsSystem.getProperty("sms.limit.byte","90"));
	
	static {
		
		QUERY_INSERT_KAKAO_SEND = SqlManager.getQuery("COMMON", "QUERY_INSERT_KAKAO_SEND");
				
		TARGET_CONNECT_INFO = new ConnectInfo();
		TARGET_CONNECT_INFO.setDRIVER(eMsSystem.getProperty("kakao.db.driver"));
		TARGET_CONNECT_INFO.setDB_URL(eMsSystem.getProperty("kakao.db.url"));
		TARGET_CONNECT_INFO.setDB_UID(eMsSystem.getProperty("kakao.db.id"));
		TARGET_CONNECT_INFO.setDB_PASS(eMsSystem.getProperty("kakao.db.pass"));
		TARGET_CONNECT_INFO.setDB_INIT_QUERY(eMsSystem.getProperty("kakao.db.init"));
		TARGET_CONNECT_INFO.setDB_BASE_CHARSET(eMsSystem.getProperty("kakao.db.base.charset"));
		TARGET_CONNECT_INFO.setDB_OUT_CHARSET(eMsSystem.getProperty("kakao.db.out.charset"));
		TARGET_CONNECT_INFO.setDB_IN_CHARSET(eMsSystem.getProperty("kakao.db.in.charset"));
	}

	/** Creates a new instance of KAKAOFixedDomainSingleRcptBufferedCommunicationActor */
	public KakaoFixedDomainSingleRcptBufferedCommunicationActor() throws Exception {
		super();
	}

	protected void work() throws Exception {
		try {
			log.info("QUERY_INSERT_KAKAO_SEND : {}", QUERY_INSERT_KAKAO_SEND);
			// get connection
			TMS_CONNECTION = ConnectionPool.getConnection(TARGET_CONNECT_INFO);
			PSTMT = TMS_CONNECTION.prepareStatement(QUERY_INSERT_KAKAO_SEND,"${","}");
			
			th_cnt ++;
			/**
			 * 자 시작 합니다.
			 */
			this.CURR_STEP = SendState.WAIT;
			
			while (true) {
				/**
				 * 없으면 다시 받아온다.
				 */
				if (this.RCPT_TO == null) {
					this.RCPT_TO = this.INNER_BUFFERED_BIN.popupNoWait();
				}
				
				if (this.RCPT_TO == null) {
					return;
				}
				
				if (log.isDebugEnabled()) {
					log("pop up:" + this.RCPT_TO.toString());
				}
				
				if (this.splitRcptInfo() == null) {
					if (log.isDebugEnabled()) {
						log("split fail continue");
					}
					continue;
				}
				
				log.debug("START : [th_cnt] => {} / [size] => {}", th_cnt, this.PARSED_RCPT_INFO.size());
				
				try {
					
					TMS_CONNECTION.setAutoCommit(false);
					
					long time = System.currentTimeMillis();
					Map<String,String> kakaoSendHash = null;
					
					// 여러개 뭉친 녀석들을 쪼갠거를 하나씩 처리를 한다.
					while (this.PARSED_RCPT_INFO.size() > 0) {
						Object NEXT_SPOOL = this.PARSED_RCPT_INFO.removeFirst();
						
						if (!this.parseRcptInfo(NEXT_SPOOL)) {
							if( log.isDebugEnabled() ) {
								log("parseRcptInfo fail continue");
							}
							continue;
						}
						
						// delay 시간이 있다면
						if (this.connection_delay > 0) {
							try {
								Thread.currentThread().sleep(this.connection_delay);
							} catch(Exception e) {}
						}
						
						// RCPT 보내기 전에 보낸다고 54-00 을 마킹해야한다.
						start_process(RCPT_ARRAY);
						
						try {
							
							// 매핑정보 설정
							kakaoSendHash = setMapping(RCPT_ARRAY);
//							log.info("kakaoSendHash : {}", kakaoSendHash);
							// KAKAO 알림톡 연동 테이블 insert.
							if (PSTMT.executeUpdate(kakaoSendHash) > 0) {
								this.success_process(RCPT_ARRAY);
							} else {
								this.error_process(RCPT_ARRAY, "KAKAO QUE INSERT CNT IS 0");
							}
						} catch(Exception e) {
							log.error("KAKAO Sender ERROR",  e);
							this.error_process(RCPT_ARRAY, e.getMessage());
							continue; 
						}
					}
					
					log.debug("END : [th_cnt] => {} / [size] => {} / [loop_time] => {} ms", th_cnt, this.PARSED_RCPT_INFO.size(), (System.currentTimeMillis() - time));
					
				} catch(Exception e) {
					TMS_CONNECTION.rollback();
					log.error("KAKAO ERROR.", e);
					log.error("KAKAO 1TO1 - ROLLBACK!!! KAKAO 등록 오류. {}", RCPT_ARRAY.toString());
				} finally {
					if (TMS_CONNECTION != null) {
						log.debug("COMMIT TRUE : [th_cnt] {} / [size] {}", th_cnt, this.PARSED_RCPT_INFO.size());
						TMS_CONNECTION.commit();
						TMS_CONNECTION.setAutoCommit(true);
					}	
				}
			}//end of while (true)
		} finally {
			if (TMS_CONNECTION != null) {
				TMS_CONNECTION.recycle();
			}
			if (PSTMT != null) {
				PSTMT.close();
			}
		}
	}
	
	/**
	 * 한건에 대한 성공여부를 전송한다. 아마도 원투원 발송할때 RSET으로 초기화 하기 전에 호출이 되지 않을까... 생각된다.
	 * 
	 * @param RCPT_INFO
	 */
	protected void success_process(String[] _AGENT_ARRAY_) {
		this.resultLog(_AGENT_ARRAY_, "54", "10", "250 KAKAO Message accepted for send", LOG_LEVEL_SUCCESS);
	}
	
	/**
	 */
	protected void error_process(String[] _AGENT_ARRAY_, String errorMessage) {
		this.resultLog(_AGENT_ARRAY_, "55", this.sendState.getRETURN_CODE(), "KAKAO fail " + errorMessage, this.sendState.getLogLevel());
	}
	
	public Map<String,String> setMapping(String[] array) throws Exception {
		
		Map<String,String> sendHash = new HashMap<String,String>();
		
		String send_type 	= "";
		String post_id    	= "";
		String member_id  	= "";
		String from_number 	= "";
		String to_number   	= "";
		String content    	= "";
		String list_table 	= "";
		String rowId 	= "";
		//알림톡 관련
		String smsType = "";
		
		
		try {
			
			send_type  = array[INDEX_OF_SEND_KIND];
			post_id    = array[INDEX_OF_POST_ID];
			member_id  = array[INDEX_OF_MEMBER_ID];
			from_number= array[INDEX_OF_MAIL_FROM];
			to_number  = array[INDEX_OF_TOKEN_ID];
			content    = array[INDEX_OF_CONTENT];
			list_table = array[INDEX_OF_LIST_TABLE];
			rowId = array[INDEX_OF_ROWID];
			sendHash.put("MEMBER_ID", member_id);
			//sendHash.put("FROM_NUMBER", from_number);
			sendHash.put("TO_NUMBER", to_number);
			sendHash.put("POST_ID", post_id);
			sendHash.put("CONTENT", content);
			
			/* 
			 * 자동 auto
			 * ETC1 : send_type ( AUTO/TEST )
			 * ETC2 : WORKDAY_SEQNO
			 * ETC3 : MEMBER_ID_MEMBER_ID_SEQ
			 * ETC4 : LIST_TABLE
			 * 
			 * 캠페인 camp
			 * ETC1	: send_type ( CAMP/TEST )
			 * ETC2	: POST_ID
			 * ETC3	: MEMBER_ID
			 * ETC4	: LIST_TABLE
			 * 
			 * ETC5	: 결과 업데이트 Y/N
			 * ETC6	: X
			 * 
			 */
//			AS-IS
			//sendHash.put("ETC1", post_id.substring(0, post_id.indexOf("_")));
			//sendHash.put("ETC2", post_id.substring(post_id.indexOf("_")+1));
			//sendHash.put("ETC3", member_id.substring(0, member_id.indexOf("_")));
			//sendHash.put("ETC4", member_id.substring(member_id.indexOf("_")+1));
			//sendHash.put("ETC5", list_table);
			//sendHash.put("ETC6", "N");
//			TO-BE
			sendHash.put("ETC1", send_type);
			sendHash.put("ETC2", post_id);
			sendHash.put("ETC3", member_id);
			sendHash.put("ETC4", list_table);
			sendHash.put("ETC5", "N");
			sendHash.put("ROW_ID", rowId); // etc6 oracle의 경우만
			
			ContentInfo sendContentInfo = ContentInfoManager.getContentInfo(post_id);
			Properties scheduleInfoProp = sendContentInfo.getScheduleInfo();
			
			StringBuffer buffer = new StringBuffer(512);
			//SCHD_INFO 에서 가져온 정보 중 매핑이 존재할 수 있다. 매핑 처리 하여 발송에 꼭 필요.!!  ex) push_img, from_number 
			for (Enumeration<?> eNum = scheduleInfoProp.propertyNames(); eNum.hasMoreElements();) {
				String key = eNum.nextElement().toString();
				String value = scheduleInfoProp.getProperty(key);
				
				buffer.setLength(0);
				StringConvertUtil.ConvertString(buffer, value, _MEMBER_HASH_, "${", "}", true, false);
				
				if (!key.equals("CONTENT") && !sendHash.containsKey(key))
					sendHash.put(key, StringUtil.trimNull(buffer));
			}
			
			sendHash.put("BILL_CODE", scheduleInfoProp.getProperty("BILL_CODE",""));
			sendHash.put("TEMPLATE_CODE", scheduleInfoProp.getProperty("TEMPLATE_CODE",""));
			
			String swichYn = scheduleInfoProp.getProperty("SWITCH_YN","N");
			smsType = scheduleInfoProp.getProperty("SMS_TYPE","NO");
			//버튼 관련 로직 추가
			String buttonInfos = "";
			if(content.lastIndexOf(KAKAO_BUTTON)>0){
				if (content.length() > 0 ) {
					int kakao_button_idx = content.lastIndexOf(KAKAO_BUTTON);
					int kakao_button_length = KAKAO_BUTTON.length();
					buttonInfos = content.substring((kakao_button_idx+kakao_button_length), content.length()).trim();
					content = content.substring(0,kakao_button_idx);
				}
			}
			sendHash.put("KAKAO_BUTTONS", buttonInfos);
			
			//SMS전환 발송 관련 로직 
			if ("Y".equals(swichYn) || content.indexOf(KAKAO_DELIM)>0) {
				String kakaoContent = "";
				String smsContent = "";
				
				if (content.length() > 0) {
					int idx1 = content.indexOf(KAKAO_DELIM);
					int idx2 = KAKAO_DELIM.length();
					
					kakaoContent = content.substring(0, idx1).trim();
					smsContent = content.substring((idx1 + idx2), content.length()).trim();
				}
				
				sendHash.put("RESEND_TYPE", getResendType(smsContent));
				sendHash.put("RESEND_CALLBACK", scheduleInfoProp.getProperty("FROM_NUMBER"));
				if("KA".equals(smsType)){
					sendHash.put("RESEND_MT_MESSAGE_REUSE", "Y");
				}else{
					sendHash.put("RESEND_MT_MESSAGE_REUSE", "N");
					sendHash.put("RESEND_TITLE", _MEMBER_HASH_.getAsString("SUBJECT"));
					sendHash.put("RESEND_MESSAGE", smsContent);
				}
				
				sendHash.put("KAKAO_CONTENT", kakaoContent);
			} else {
				sendHash.put("RESEND_TYPE", "NO");
				sendHash.put("RESEND_CALLBACK", "");
				sendHash.put("RESEND_TITLE", "");
				sendHash.put("RESEND_MESSAGE", "");
				sendHash.put("RESEND_MT_MESSAGE_REUSE", "N");
				
				sendHash.put("KAKAO_CONTENT", content);
			}
			
			sendHash.put("USER_ID", scheduleInfoProp.getProperty("USER_ID",""));
			sendHash.put("USER_DEPT", scheduleInfoProp.getProperty("USER_DEPT",""));
			
			log.debug("============================ SEND HASH START ============================");
			log.debug("{}", sendHash);
			log.debug("============================ SEND HASH END ============================");
			
			return sendHash;
			
		} catch(Exception e) {
			log.error("KAKAO __KAKAO_SEND_HASH__ put Exception", e);
			log("KAKAO __KAKAO_SEND_HASH__ put Exception is " + e.getMessage());
			throw e;
		}
	}
	
	/**
	 * 같은 도메인들이므로 걍 모두 에러처리를 한다.
	 */
	protected void all_error_process() {
		if (STEP_DEBUG)
			log("ALL ERROR");
		error_process(RCPT_ARRAY, "ALL ERROR");
		
		parsedListAllErrorProcess();
	}
	
	/*
	 * 알림톡 발송 실패시 발송할 문자 유형 확인
	 */
	private String getResendType(String smsContent) {
		if (StringUtils.isNull(smsContent)) return "NO";
		
		int bytes = getBytes(smsContent);
		
		if (bytes == 0 ) return "NO";
		
		if (bytes > SMS_LIMIT_BYTE) {
			return ChannelType.LMS.getCode();
		}
		return ChannelType.SMS.getCode();
	}
	
	/*
	 * 알림톡 발송 실패시 발송할 문자 내용 바이트 체크
	 */
	private int getBytes(String content) {
		try {
			return content.getBytes(eMsLocale.CHAR_SET).length;
		} catch(Exception e) {
			return 0;
		}
	}
	
	public static void main(String[] args) {
		String content = "testetestestsetaaaaaatestestsetsetsaaaae/**KAKAO_BUTTON**/{button:[{name=}]}";
		String buttonInfos = "";
		String kakaoContent = "";
		String smsContent = "";
		boolean buttonUseYn = false;
		boolean resendToSmsUseYn = false;
		int buttonIdx = 0;
		int buttonDelimSize = KAKAO_BUTTON.length();
		int smsContentIdx = 0;
		int smsContentDelimSize = KAKAO_DELIM.length();
		if (content.length() > 0) {
			if(content.indexOf(KAKAO_DELIM)>0){
				buttonUseYn = true;
				smsContentIdx = content.indexOf(KAKAO_DELIM);
			}
			if(content.indexOf(KAKAO_BUTTON)>0){
				resendToSmsUseYn = true;
				buttonIdx = content.indexOf(KAKAO_BUTTON);
			}
		}
		if(buttonUseYn){
			 
		}
		if(resendToSmsUseYn){
			
		}
			int idx1 = content.indexOf(KAKAO_DELIM);
			int idx2 = KAKAO_DELIM.length();
			
			kakaoContent = content.substring(0, idx1).trim();
			smsContent = content.substring((idx1 + idx2), content.length()).trim();
		
		System.out.println(kakaoContent);
		System.out.println(smsContent);
		
		if (content.length() > 0 ) {
			int idx3 = content.lastIndexOf(KAKAO_BUTTON);
			int idx4 = KAKAO_BUTTON.length();
			buttonInfos = content.substring((idx3+idx4), content.length()).trim();
			content = content.substring(0,idx3);
			System.out.println(idx3);
			System.out.println(idx4);
		}
		System.out.println(buttonInfos);
		System.out.println(content);
	}
}
