/*
 * @(#)LmsFixedDomainSingleRcptBufferedCommunicationActor.java            2004. 12. 6.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.mass.actor;

//import gems.esb.EsbSendUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.lang.Tracer;
import pluto.mail.SendState;
import pluto.secure.crypto.CryptoUtil;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;

/**
 * <br>
 * Innter Container에 있는 메일 발송 대상이 모두 같은 도메인의 경우 <br>
 * 1 to 1 메일 발송의 처리.
 * 
 * @version
 * @author dragon
 *  
 */

public class FriendsFixedDomainSingleRcptBufferedCommunicationActor extends AbstractSingleRcptCommunicationActor {
	
	private static final boolean	INNER_DEBUG	= false;
	
	private static String QUERY_INSERT_FRIENDS_SEND = null;
	
	public static String ERROR_MESSAGE = null;
	
	private eMsConnection TMS_CONNECTION = null;
	
	private eMsPreparedStatement PSTMT = null;
	
	private Map	__KAKAO_SEND_HASH__	= new Hashtable();
	
	private static int th_cnt = 0;
	
	private static ConnectInfo	TARGET_CONNECT_INFO					= null;
	
	private static final String KAKAO_BUTTON = "/**KAKAO_BUTTON**/";
	
	static {
		//MMS
		QUERY_INSERT_FRIENDS_SEND = SqlManager.getQuery("COMMON", "QUERY_INSERT_FRIENDS_SEND");
				
		TARGET_CONNECT_INFO = new ConnectInfo();
		TARGET_CONNECT_INFO.setDRIVER(eMsSystem.getProperty("kakao.db.driver"));
		TARGET_CONNECT_INFO.setDB_URL(eMsSystem.getProperty("kakao.db.url"));
		TARGET_CONNECT_INFO.setDB_UID(eMsSystem.getProperty("kakao.db.id"));
		TARGET_CONNECT_INFO.setDB_PASS(eMsSystem.getProperty("kakao.db.pass"));
		TARGET_CONNECT_INFO.setDB_INIT_QUERY(eMsSystem.getProperty("kakao.db.init"));
		TARGET_CONNECT_INFO.setDB_BASE_CHARSET(eMsSystem.getProperty("kakao.db.base.charset"));
		TARGET_CONNECT_INFO.setDB_OUT_CHARSET(eMsSystem.getProperty("kakao.db.out.charset"));
		TARGET_CONNECT_INFO.setDB_IN_CHARSET(eMsSystem.getProperty("kakao.db.in.charset"));
		
	}

	/** Creates a new instance of KAKAOFixedDomainSingleRcptBufferedCommunicationActor */
	public FriendsFixedDomainSingleRcptBufferedCommunicationActor() throws Exception {
		
		super();
		
	}

	protected void work() throws Exception {
		
		try{
			//get connection
			//log("1000 db connection start");
			TMS_CONNECTION = ConnectionPool.getConnection(TARGET_CONNECT_INFO);
			PSTMT = TMS_CONNECTION.prepareStatement(QUERY_INSERT_FRIENDS_SEND,"${","}"); //EMS_CONNECTION.eMsprepareStatement(QUERY_INSERT_MMS_SEND);
			//log("1000 db connection end");
			
		th_cnt ++;
		
		/**
		 * 자 시작 합니다.
		 */
		this.CURR_STEP = SendState.WAIT;

		while (true) {
			/**
			 * 없으면 다시 받아온다.
			 */
			if( this.RCPT_TO == null ) {
				this.RCPT_TO = this.INNER_BUFFERED_BIN.popupNoWait();
			}

			if( this.RCPT_TO == null ) {
				return;
			}
						
			if( INNER_DEBUG ) {
				log("pop up:" + this.RCPT_TO.toString());
			}

			if( this.splitRcptInfo() == null ) {
				if( INNER_DEBUG ) {
					log("split fail continue");
				}
				continue;
			}else{
 			
			
			}
			
			//Tracer.error("KAKAO 1TO1 - START : [th_cnt]"+th_cnt+"[size]"+this.PARSED_RCPT_INFO.size());
	
			try{
				TMS_CONNECTION.setAutoCommit(false);
				long time = System.currentTimeMillis();
				// 여러개 뭉친 녀석들을 쪼갠거를 하나씩 처리를 한다.
				while (this.PARSED_RCPT_INFO.size() > 0) {
					
					//Tracer.debug("[cnt]"+(i++));
					try {
						
					
					Object NEXT_SPOOL = this.PARSED_RCPT_INFO.removeFirst();
	
					if( !this.parseRcptInfo(NEXT_SPOOL) ) {
						if( INNER_DEBUG ) {
							log("parseRcptInfo fail continue");
						}
						continue; 
					}
					
					//delay 시간이 있다면
					if( this.connection_delay > 0 ) {
						try {
							Thread.currentThread().sleep(this.connection_delay);
						}catch(Exception e) {
							log("1001="+e.getMessage());
						}
					}
					
					} catch (Exception e) {
						log("1002="+e.getMessage());
					}
					try{
						// RCPT 보내기 전에 보낸다고 54-00 을 마킹해야한다.
						start_process(RCPT_ARRAY);				
						/*
						 * TMS MMS 업체 테이블로 인서트 하는 로직 
						 */				
						
						setMapping(RCPT_ARRAY);					
						
						Tracer.info("__KAKAO_SEND_HASH__ : "  +  __KAKAO_SEND_HASH__.toString());
						
						int cnt = PSTMT.executeUpdate(__KAKAO_SEND_HASH__);
						
						if(cnt > 0){
							//250 2.0.0 Message accepted for delivery
							this.success_process(RCPT_ARRAY);
						}else{
							this.error_process(RCPT_ARRAY);
						}
						
					}catch(Exception e){
						Tracer.error(getName(), e);
						ERROR_MESSAGE = e.toString();
						this.error_process(RCPT_ARRAY);
						TMS_CONNECTION.rollback();
						// e.printStackTrace();
						Tracer.info("KAKAO Sender Exception is"+ e.getMessage());					
						continue; 
					}finally{
						__KAKAO_SEND_HASH__.clear();
						
					}
					
				}
				//Tracer.debug("KAKAO 1TO1 - END : [th_cnt]"+th_cnt+"[size]"+this.PARSED_RCPT_INFO.size()+"[loop_time]:"+(System.currentTimeMillis() - time)+"ms");
			}catch(Exception e){
				TMS_CONNECTION.rollback();
				// e.printStackTrace();
				Tracer.error(e);
				Tracer.error("KAKAO 1TO1 - ROLLBACK!!! KAKAO 등록 오류"+RCPT_ARRAY.toString());
			}finally{
				if(TMS_CONNECTION != null){
					//Tracer.debug("KAKAO 1TO1 - COMMIT TRUE : [th_cnt]"+th_cnt+"[size]"+this.PARSED_RCPT_INFO.size());
					TMS_CONNECTION.commit();
					TMS_CONNECTION.setAutoCommit(true);
				}	
			}
			
				
			
		}//end of while (true)
		
		}finally{
			if(TMS_CONNECTION != null){
				TMS_CONNECTION.recycle();
			}
			if(PSTMT != null){
				PSTMT.close();
			}
		}
	}
	
	/**
	 * 한건에 대한 성공여부를 전송한다. 아마도 원투원 발송할때 RSET으로 초기화 하기 전에 호출이 되지 않을까... 생각된다.
	 * 
	 * @param RCPT_INFO
	 */
	protected void success_process(String[] _AGENT_ARRAY_) {
		this.resultLog(_AGENT_ARRAY_, "54", "10", "250 KAKAO Message accepted for send", LOG_LEVEL_SUCCESS);
	}
	
	/**
	 */
	protected void error_process(String[] _AGENT_ARRAY_) {
		this.resultLog(_AGENT_ARRAY_, "55", this.sendState.getRETURN_CODE(), "KAKAO fail "+ERROR_MESSAGE, this.sendState.getLogLevel());
	}
	
	public Map setMapping(String[] array) throws Exception {
		
		String send_type 	= "";
		String post_id    	= "";
		String member_id  	= "";
		String from_number 	= "";
		String to_number   	= "";
		String content    	= "";
		String list_table 	= "";
		String rowId 	= "";
		
		try{
			send_type  = array[INDEX_OF_SEND_KIND];
			post_id    = array[INDEX_OF_POST_ID];
			member_id  = array[INDEX_OF_MEMBER_ID];
			from_number= array[INDEX_OF_MAIL_FROM];
			to_number  = array[INDEX_OF_TOKEN_ID];
			content    = array[INDEX_OF_CONTENT];
			list_table = array[INDEX_OF_LIST_TABLE];
			rowId = array[INDEX_OF_ROWID];
			
			__KAKAO_SEND_HASH__.put("MEMBER_ID", member_id);
			__KAKAO_SEND_HASH__.put("POST_ID", post_id);
			
			
			String ENC_YN = eMsSystem.getProperty("member.info.encrypt.yn","N");
			if("Y".equals(ENC_YN)){
				to_number  = array[INDEX_OF_EMAIL_ENCRYPT];
				__KAKAO_SEND_HASH__.put("TO_NUMBER", CryptoUtil.deTelNum(to_number));
			}else{
				to_number  = array[INDEX_OF_TOKEN_ID];
				__KAKAO_SEND_HASH__.put("TO_NUMBER", to_number);
			}
						
			ContentInfo sendContentInfo = ContentInfoManager.getContentInfo(post_id);
			Properties prop = sendContentInfo.getScheduleInfo();
			
			/*if(prop.getProperty("SEND_STATE").equals("TEST") || prop.getProperty("SEND_STATE").equals("WFTEST")) {
				__KAKAO_SEND_HASH__.put("SENDTYPE", "TEST");	
				__KAKAO_SEND_HASH__.put("POST_ID", post_id+"^TT^"+member_id);		//KAKAO TEST
			} else {
				if(post_id.substring(0, 9).indexOf("_") > 0 || send_type.equals("AUTORESEND")){
					//__KAKAO_SEND_HASH__.put("POST_ID", post_id+"^TA^"+member_id+"^"+list_table.substring(list_table.lastIndexOf("_")+1));		//KAKAO AUTO	1_1
					__KAKAO_SEND_HASH__.put("POST_ID", post_id+"^TA_"+member_id);		//KAKAO AUTO	1_1
					__KAKAO_SEND_HASH__.put("SENDTYPE", "AUTO");	
				}else{
					__KAKAO_SEND_HASH__.put("POST_ID", post_id.substring(0, 13)+"^TC^"+member_id);		//KAKAO MASS
					__KAKAO_SEND_HASH__.put("SENDTYPE", "CAMP");
				}
			}*/
			
			/* 
			 * 자동 auto
			 * ETC1 : send_type ( AUTO/TEST )
			 * ETC2 : WORKDAY_SEQNO
			 * ETC3 : MEMBER_ID_MEMBER_ID_SEQ
			 * ETC4 : LIST_TABLE
			 * 
			 * 캠페인 camp
			 * ETC1	: send_type ( CAMP/TEST )
			 * ETC2	: POST_ID
			 * ETC3	: MEMBER_ID
			 * ETC4	: LIST_TABLE
			 * 
			 * ETC5	: 결과 업데이트 Y/N
			 * ETC6	: X
			 * 
			 */
			__KAKAO_SEND_HASH__.put("ETC1", send_type);
			__KAKAO_SEND_HASH__.put("ETC2", post_id);
			__KAKAO_SEND_HASH__.put("ETC3", member_id);
			__KAKAO_SEND_HASH__.put("ETC4", list_table);
			__KAKAO_SEND_HASH__.put("ETC5", "N");
			__KAKAO_SEND_HASH__.put("ROW_ID", rowId); // etc6 oracle의 경우만
			
			//친구톡 프로필키
			__KAKAO_SEND_HASH__.put("PROFILE_KEY", prop.getProperty("SENDER_KEY",""));			
			
			//친구톡 이미지 관련 로직 추가
			String attName = prop.getProperty("MMS_ATTACH_FILE_ID_1","");
			if(attName.equals("")) {
				__KAKAO_SEND_HASH__.put("FT_TYPE", "T");	
			}else {
				__KAKAO_SEND_HASH__.put("FT_TYPE", "I");			
			}
			__KAKAO_SEND_HASH__.put("IMG_PATH", attName);
			
			//친구톡 이미지 클릭 URL
			__KAKAO_SEND_HASH__.put("IMG_CLICK_URL", prop.getProperty("IMG_CLICK_URL",""));
			
			//친구톡 광고 문구 노출 여부 
			__KAKAO_SEND_HASH__.put("ADD_FLAG", prop.getProperty("AD_FLAG","Y"));
			
			//버튼 관련 로직 추가
			String buttonInfos = "";
			if(content.lastIndexOf(KAKAO_BUTTON)>0){
				if (content.length() > 0 ) {
					int kakao_button_idx = content.lastIndexOf(KAKAO_BUTTON);
					int kakao_button_length = KAKAO_BUTTON.length();
					buttonInfos = content.substring((kakao_button_idx+kakao_button_length), content.length()).trim();
					content = content.substring(0,kakao_button_idx);
				}
			}
			__KAKAO_SEND_HASH__.put("BUTTON_JSON", buttonInfos);			
			
			//부달 관련
//			String mkt_flag = _MEMBER_HASH_.getAsString("MKT_FLAG", "");
//
//			if(content.indexOf("/**KAKAO_DELIM**/")>-1){
//				String contentSplit[] = content.split("\\/\\*\\*KAKAO\\_DELIM\\*\\*\\/");
//				__KAKAO_SEND_HASH__.put("CONTENT", contentSplit[0]);
//				if(contentSplit[1] != null && !"".equals(contentSplit[1])){
//					
//					//수신동의여부가  Y일경우에만 부달 플래그 처리.
//					 if("N".equals(mkt_flag) || StringUtil.isNull(mkt_flag) ) {
//						__KAKAO_SEND_HASH__.put("FAILED_TYPE", "NO");
//					 } else {
//						 if (!StringUtil.isNull(prop.getProperty("SW_CONTENT_PATH",""))) {
//							__KAKAO_SEND_HASH__.put("FAILED_TYPE", "MMS");
//							__KAKAO_SEND_HASH__.put("FAILED_SUBJECT", prop.getProperty("SUBJECT",""));
//							__KAKAO_SEND_HASH__.put("FAILED_IMG", prop.getProperty("SW_CONTENT_PATH",""));
//						} else {
//							if(contentSplit[1].getBytes().length<=80){
//								__KAKAO_SEND_HASH__.put("FAILED_TYPE", "SMS");
//							}else{
//								__KAKAO_SEND_HASH__.put("FAILED_SUBJECT", prop.getProperty("SUBJECT",""));
//								__KAKAO_SEND_HASH__.put("FAILED_TYPE", "LMS");
//							}
//						}
//						__KAKAO_SEND_HASH__.put("FAILED_MSG", contentSplit[1]);
//					 }
//
//				}
//				
//			}else{
//				__KAKAO_SEND_HASH__.put("CONTENT", content);
//				__KAKAO_SEND_HASH__.put("FAILED_TYPE", "NO");
//			}
//			__KAKAO_SEND_HASH__.put("SMS_ID", prop.getProperty("SMS_ID",""));
			
			__KAKAO_SEND_HASH__.put("CONTENT", content);
			StringBuffer buffer = new StringBuffer(512);
			//SCHD_INFO 에서 가져온 정보 중 매핑이 존재할 수 있다. 매핑 처리 하여 발송에 꼭 필요.!!  ex) push_img, from_number 
			for( Enumeration<?> eNum = prop.propertyNames(); eNum.hasMoreElements(); ){
				String key = eNum.nextElement().toString();
				String value = prop.getProperty(key);
				
				buffer.setLength(0);
				

				StringConvertUtil.ConvertString(buffer, value, _MEMBER_HASH_, "${", "}", true, false);
				
				/*if(value.indexOf("${") > 0){
					
				}*/
				
				//System.out.println("PROP "+key+":"+buffer);
				if(!key.equals("CONTENT")&& !__KAKAO_SEND_HASH__.containsKey(key))
					__KAKAO_SEND_HASH__.put(key, StringUtil.trimNull(buffer));
				//System.out.println("PROP "+key+":"+__KAKAO_SEND_HASH__.get(key).toString());
				
				
			}
			
			__KAKAO_SEND_HASH__.put("USER_ID", prop.getProperty("USER_ID",""));
			__KAKAO_SEND_HASH__.put("USER_DEPT", prop.getProperty("USER_DEPT",""));
			
			return __KAKAO_SEND_HASH__;
			
		}catch(Exception e){
			// e.printStackTrace();
			Tracer.error(e);
			log("KAKAO __KAKAO_SEND_HASH__ put Exception is"+ e.getMessage());
			return null;
		
		}finally{
			
		}
	}
	
	public static boolean isAuto(String table){
		if(table.startsWith("TMS_SMS_LIST")) return false;
		else return true;
	}
	
	public static void main(String[] args) {
	}
	
	
	/**
	 * 같은 도메인들이므로 걍 모두 에러처리를 한다.
	 */
	protected void all_error_process() {
		if( STEP_DEBUG )
			log("all error");
		//start_process( RCPT_ARRAY );
		error_process(RCPT_ARRAY);

		parsedListAllErrorProcess();
	}
}
