/*
 * @(#)FixedDomainMutipleRcptBufferedCommunicationActor.java            2004. 12. 6.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.mass.actor;

import java.util.Iterator;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.mail.SendState;

/**
 * <br>
 * Innter Container에 있는 메일 발송 대상이 모두 같은 도메인의 경우 <br>
 * 동보 메일 발송의 처리.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class FixedDomainMultipleRcptBufferedCommunicationActor extends AbstractMultipleRcptCommunicationActor {

	/**
	 * Creates a new instance of
	 * FixedDomainMutipleRcptBufferedCommunicationActor
	 */
	public FixedDomainMultipleRcptBufferedCommunicationActor() throws Exception {
		super();
	}

	protected void work() throws Exception {
		// 자 시작 합니다.
		this.CURR_STEP = SendState.WAIT;

		boolean __RSET_SUCCESS_FLAG__ = true;
		boolean __RECONNECT_FLAG__ = false;

		int __RSET_SUCCESS_COUNT__ = 0;

		while (true) {
			// 없으면 다시 받아온다.
			if( this.RCPT_TO == null ) {
				this.RCPT_TO = this.INNER_BUFFERED_BIN.popupNoWait();
			}

			// 그래도 없으면 쉬러 돌아간다.
			if( this.RCPT_TO == null ) {
				return;
			}

			// 연결이 된 상태에서 딜레이 시간이 있으면 잠시 쉬어 간다.
			if( this.connection_delay > 0 && isConnect() ) {
				// 연결이 되어 있다면
				if (log.isDebugEnabled()) {
					log(" into connection delay sleep....");
				}

				super.closeConnection();

				try {
					Thread.currentThread().sleep(this.connection_delay);
				}
				catch(Exception e) {
				}
				if (log.isDebugEnabled()) {
					log(" out connection delay sleep....");
				}
			}

			// 상태값을 초기화한다.
			this.sendState.reset();

			// 하나를 끄집어 낸다.
			// splitRcptInfo 여기에서 start를 통합으로 찍으므로 여기에는 시작로그를 쓰는 부분이 없다.
			String __NOW_DOMAIN = super.splitRcptInfo();

			// 같은 도메인들 이므로 무조건 네트웍오류가 아니라면 RSET을 시도한다.
			if( (this.CURR_STEP > SendState.HELO) && (this.sendState.getLogLevel() != LOG_LEVEL_N_ERROR) && __RSET_SUCCESS_FLAG__ ) {
				// RSET 하러 갑니다.
				step(SendState.RSET, null, __NOW_DOMAIN, RCPT_ARRAY[INDEX_OF_STEP]);

				// RSET이 실패하면 연결부터 다시한다.
				if( this.sendState.isError() ) {
					__RSET_SUCCESS_FLAG__ = false;
				}
				else {
					__RSET_SUCCESS_FLAG__ = true;
					__RECONNECT_FLAG__ = false;
					__RSET_SUCCESS_COUNT__++;
				}
			}
			else {
				__RECONNECT_FLAG__ = true;
			}

			// 다시 연결을 해야한다면..
			if( __RECONNECT_FLAG__ || !__RSET_SUCCESS_FLAG__ ) {
				// 다시연결하면 재연결 카운트를 0으로 한다.
				__RSET_SUCCESS_COUNT__ = 0;

				// 연결 되어 있다면 일단 연결을 종료하고
				if( super.isConnect() ) {
					super.closeConnection();
				}

				// 한번 에러가 발생한 도메인은 RSET을 다시 시도하지 않는것이 좋다.
				// 추후 RSET에 대한 더욱 현명한 로직이 필요할거 같다.
				// 대상 도메인의 메일 서버로 연결을 시도 합니다.
				if (log.isDebugEnabled()) {
					log("step connect DOMAIN:" + __NOW_DOMAIN);
				}
				connect(__NOW_DOMAIN, RCPT_ARRAY[INDEX_OF_STEP]);

				if( this.sendState.isError() ) {
					all_error_process();
					continue;
				}

				// HELO 하러 갑니다.
				step(SendState.HELO, eMsLocale.SMTP_LOCAL_HOST[0], __NOW_DOMAIN, RCPT_ARRAY[INDEX_OF_STEP]);

				if( this.sendState.isError() ) {
					all_error_process();
					continue;
				}
			}
			else if( eMsLocale.RSET_HELO_RESEND_DOMAIN.indexOf(__NOW_DOMAIN) > 0 ) {
				super.resetConnectionTime();
				// RSET에 성공하였다면 HELO 다시 보내야 하는 도메인은 HELO를 다시 보낸다.
				// 다시 HELO 하러 갑니다.
				step(SendState.HELO, eMsLocale.SMTP_LOCAL_HOST[0], __NOW_DOMAIN, RCPT_ARRAY[INDEX_OF_STEP]);

				if( this.sendState.isError() ) {
					all_error_process();
					continue;
				}
			}
			else {
				super.resetConnectionTime();
			}

			if (eMsLocale.MGS_FLAG) {
				// MGS SEQ 하러 갑니다.
				step(SendState.SEQ, RCPT_ARRAY[INDEX_OF_MAIL_FROM], RCPT_ARRAY[INDEX_OF_DOMAIN], RCPT_ARRAY[INDEX_OF_STEP]);
			}
			
			// MAIL_FROM 하러 갑니다.
			step(SendState.MAIL_FROM, RCPT_ARRAY[INDEX_OF_MAIL_FROM], __NOW_DOMAIN, RCPT_ARRAY[INDEX_OF_STEP]);
			if( this.sendState.isError() ) {
				all_error_process();
				continue;
			}

			// 이제 중요한 RCPT 입니다. RCPT리스트 수만큼 RCPT를 보낸다.
			for (Iterator iter = this.PARSED_RCPT_INFO.iterator(); iter.hasNext();) {
				Object __NEXT_SPOOL__ = iter.next();

				if( !this.parseMemberInfoOnly(__NEXT_SPOOL__) ) {
					// 파싱해서 에러가 나면 제외시킨다.
					log("work.parseMemberInfoOnly fail spool:" + __NEXT_SPOOL__);
					iter.remove();
					continue;
				}

				step(SendState.RCPT_TO, RCPT_ARRAY[INDEX_OF_TOKEN_ID], RCPT_ARRAY[INDEX_OF_DOMAIN], RCPT_ARRAY[INDEX_OF_STEP]);

				if (log.isDebugEnabled()) {
					log("step rcpt done:" + RCPT_ARRAY[INDEX_OF_TOKEN_ID]);
				}

				switch (this.sendState.getLogLevel()) {
					case LOG_LEVEL_SUCCESS: {
						continue;
					}

					case LOG_LEVEL_N_ERROR:
					case LOG_LEVEL_DENY_ERROR: {
						// 네트웍 에러면 다음으로 진행을 할수 없으므로 전체 에러처리
						all_error_process();
						continue;
					}

					default: {
						// 기타 에러가 아니라면 그녀석만 에러처리하고 진행
						error_process(RCPT_ARRAY);
						iter.remove();
						continue;
					}
				}
			}

			// RCPT에서 모두 에러거나 네트웍 에러일 경우에는 그냥 돌아가야한다.
			if( this.PARSED_RCPT_INFO.size() == 0 ) {
				continue;
			}

			// DATA 를 전송합니다.
			step(SendState.DATA, null, RCPT_ARRAY[INDEX_OF_DOMAIN], RCPT_ARRAY[INDEX_OF_STEP]);
			if( this.sendState.isError() ) {
				all_error_process();
				continue;
			}

			// 실제 메일 바디를 전송합니다.
			step(SendState.DATA_BODY, RCPT_ARRAY[INDEX_OF_CONTENT], RCPT_ARRAY[INDEX_OF_DOMAIN], RCPT_ARRAY[INDEX_OF_STEP]);
			if( this.sendState.isError() ) {
				all_error_process();
				continue;
			}

			all_success_process();

			if (log.isDebugEnabled()) {
				log("step success done:" + __NOW_DOMAIN);
			}
		}
	}
}
