/*
 * @(#)AbstractSingleRcptCommunicationActor.java            2004. 12. 6.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.mass.actor;

import java.io.ByteArrayOutputStream;

import com.humuson.tms.constrants.ChannelType;

import freemarker20.ext.beans.StaticModels;
import freemarker20.template.SimpleHash;
import lombok.extern.slf4j.Slf4j;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import pluto.io.FileElement;
import pluto.lang.eMsLocale;
import pluto.log.ErrorSpoolLogger;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
import pluto.util.convert.SHA256;
import pluto.util.convert.TrackingInfoConvertor;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.handler.LongMappingSpoolReader;
import venus.spool.common.parser.SpoolHashParser;

/**
 * Class description :
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public abstract class AbstractSingleRcptCommunicationActor extends AbstractBufferedCommunicationActor {

	protected SpoolHashParser		SPOOL_TO_HASH_PARSER	= new SpoolHashParser("|");

//	protected SimpleHash			_MEMBER_HASH_			= new SimpleHash();

	protected SimpleHash			_DEFAULT_HASH_			= new SimpleHash();
	
	/** Creates a new instance of AbstractOneToOneCommunicationActor */
	public AbstractSingleRcptCommunicationActor() throws Exception {
		super();
	}

	protected boolean parseRcptInfo(Object target) {

		try {
			
			// RCPT ARRAY를 초기화 한다.
			RCPT_ARRAY[INDEX_OF_SEND_KIND] = null;
			RCPT_ARRAY[INDEX_OF_POST_ID] = null;
			RCPT_ARRAY[INDEX_OF_MEMBER_ID] = null;
			RCPT_ARRAY[INDEX_OF_TOKEN_ID] = null;
			RCPT_ARRAY[INDEX_OF_DOMAIN] = null;
			RCPT_ARRAY[INDEX_OF_MAIL_FROM] = null;
			RCPT_ARRAY[INDEX_OF_STEP] = null;
			RCPT_ARRAY[INDEX_OF_LIST_TABLE] = null;
			RCPT_ARRAY[INDEX_OF_SPOOL] = null;
			RCPT_ARRAY[INDEX_OF_CONTENT] = null;
			RCPT_ARRAY[INDEX_OF_ROWID] = null;
			RCPT_ARRAY[INDEX_OF_OS] = null;
			RCPT_ARRAY[INDEX_OF_NOTI_FLAG] = null;
			//PRIORITY
			RCPT_ARRAY[INDEX_OF_PRIORITY] = null;
			
			//samsunglife
			RCPT_ARRAY[INDEX_OF_EMAIL_ENCRYPT] = null;

			SPOOL_ANALYZER.parse(target.toString());

			if( STEP_DEBUG ) {
				log("parse=>".concat(SPOOL_ANALYZER.getMemberID()).concat(">").concat(SPOOL_ANALYZER.getTokenID()));
			}

			// 파싱을 했으면 기본정보를 세팅한다.
			RCPT_ARRAY[INDEX_OF_SEND_KIND]    = SPOOL_ANALYZER.getSendType();
			RCPT_ARRAY[INDEX_OF_POST_ID]      = SPOOL_ANALYZER.getPostID();
			RCPT_ARRAY[INDEX_OF_MEMBER_ID]    = SPOOL_ANALYZER.getMemberID();
			RCPT_ARRAY[INDEX_OF_TOKEN_ID]     = SPOOL_ANALYZER.getTokenID();
			RCPT_ARRAY[INDEX_OF_DOMAIN]       = SPOOL_ANALYZER.getDomain();
			RCPT_ARRAY[INDEX_OF_STEP]         = SPOOL_ANALYZER.getStep();
			RCPT_ARRAY[INDEX_OF_LIST_TABLE]   = SPOOL_ANALYZER.getListTable();
			RCPT_ARRAY[INDEX_OF_ROWID] 		  = SPOOL_ANALYZER.getRowid();
			RCPT_ARRAY[INDEX_OF_OS] 		  = SPOOL_ANALYZER.getOs();
			RCPT_ARRAY[INDEX_OF_NOTI_FLAG] 	  = SPOOL_ANALYZER.getNotiflag();
			//PRIORITY
			RCPT_ARRAY[INDEX_OF_PRIORITY] 	  = SPOOL_ANALYZER.getPriority();
			
			//samsunglife
			RCPT_ARRAY[INDEX_OF_EMAIL_ENCRYPT]= SPOOL_ANALYZER.getProperty(LOG_TOKEN_ENCRYPT);

			
			String _POST_ID_ = SPOOL_ANALYZER.getPostID();

			ContentInfo sendContentInfo = ContentInfoManager.getContentInfo(_POST_ID_);
			SpoolInfo sendSpoolInfo = SpoolInfoManager.getSpoolInfo(_POST_ID_);

			if( sendContentInfo == null ) {
				if( STEP_DEBUG ){
					log("content info is null=>".concat(_POST_ID_));
				}
				RCPT_ARRAY[INDEX_OF_MAIL_FROM] = PARSING_RESULT_CONTENT_INFO_FAIL;

				// 에러를 기록해야쥐
				ErrorSpoolLogger.put(target.toString().concat(" =>").concat(PARSING_RESULT_CONTENT_INFO_FAIL).concat(":").concat(_POST_ID_));
				this.sendState.set("900 CANNOT FIND CONTENT INFO", "99");
				start_process(RCPT_ARRAY);
				error_process(RCPT_ARRAY);
				return false;
			}

			RCPT_ARRAY[INDEX_OF_MAIL_FROM] = sendContentInfo.getReturnPath();

			String MEMBER_TOKEN = SPOOL_ANALYZER.getTokenID();
			String MEMBER_ID = SPOOL_ANALYZER.getMemberID();
			String MEMBER_NAME = SPOOL_ANALYZER.getMemberName();
			String MAPPING = SPOOL_ANALYZER.getMapping();
			String ROW_ID = SPOOL_ANALYZER.getRowid();
			String OS = SPOOL_ANALYZER.getOs();
			String NOTI_FLAG = SPOOL_ANALYZER.getNotiflag();
			
			int STEP = Integer.parseInt(SPOOL_ANALYZER.getStep());

			ByteArrayOutputStream	INNER_BYTE_ARRAY		= new ByteArrayOutputStream(18 * 1000);
			
			if( MAPPING != null && MAPPING.startsWith("isam://") ) {
				INNER_BYTE_ARRAY.reset();

				int idx_of_comma = MAPPING.indexOf(",", 7);
				int idx_of_at = MAPPING.indexOf("@", idx_of_comma);
				long start = Long.parseLong(MAPPING.substring(7, idx_of_comma));
				long end = Long.parseLong(MAPPING.substring(idx_of_comma + 1, idx_of_at));

				LongMappingSpoolReader reader = LongMappingSpoolReader.getInstance(MAPPING.substring(idx_of_at + 1).replace('\\', '/'));

				reader.inner_get(start, end, INNER_BYTE_ARRAY);

				MAPPING = INNER_BYTE_ARRAY.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
			}
			else if( MAPPING != null && MAPPING.startsWith("file://") ) {
				synchronized (INNER_BYTE_ARRAY) {
					INNER_BYTE_ARRAY.reset();

					FileElement.putFileBodyToStream(MAPPING.substring(7), INNER_BYTE_ARRAY);

					MAPPING = INNER_BYTE_ARRAY.toString(eMsLocale.FILE_SYSTEM_IN_CHAR_SET);
				}
			}

			// 파싱을 시작하기 전에 전에 있던 헤쉬 내용을 지워야한다. 2004.10.28
			// 안그러면 기존 내용이 투영 되기때문에 얘기치 못한 현상이 발생할 수도 있다.
			_MEMBER_HASH_.clear();

			if( MAPPING.startsWith("#P#:") ) {
				// 매핑이 key value 로 들어 왔을 때
				StringConvertUtil.ConvertStringToSimpleHash(_MEMBER_HASH_, MAPPING);
			}
			else {
				// 일반 헤더정보로 왔을때.
				SPOOL_TO_HASH_PARSER.setDelim(sendSpoolInfo.getSpoolDelimit());
				SPOOL_TO_HASH_PARSER.parse(_MEMBER_HASH_, MAPPING, sendSpoolInfo.getHEADER_KEY_MAP("|"), sendSpoolInfo.getDefaultSimpleHashMapping());
			}

			// 직렬 매핑 컬럼이 있다면 그거를 map_# 형태로 전환한다.
			if( _MEMBER_HASH_.containsKey("SERIAL_MAPPING") ) {
				SPOOL_TO_HASH_PARSER.parseSerialMapping(_MEMBER_HASH_, _MEMBER_HASH_.getAsString("SERIAL_MAPPING"), sendSpoolInfo.getSerialDelimit());
			}
			
			
			//JOO [TEST_ATTACH_HEADER] 테스트시 subject에 추가하는 string 
			//=========================================================
			// 원천적으로 보안을 설정할때 spool에 서있는 내용을 세팅한다.
			//[TODO] 헤더를 바꿀수 없기 때문에 제목에 추가되는 문자를 따로 지정할 수 없다.
			// 해서 임시적인 방법으로 (2005년도 부터 BC에서 사용) SECURE_FLAG 값에 "^"를 넣어 "^"후반의 값을 추가 값으로 사용했다.
			// 따로 해답이 없어 그대로 사용한다.
			String sAdditionalInfo = SPOOL_ANALYZER.getSecureFlag();
			if(!StringUtil.isNull(sAdditionalInfo) && !sAdditionalInfo.equalsIgnoreCase("null")){
				int idxAdditionalInfo = sAdditionalInfo.indexOf("^");
				//EMS_M_SECURE 정보가 스플에 있지만 재발송시 갱신한다.
				if( idxAdditionalInfo > 0 ) {
					_MEMBER_HASH_.put("EMS_M_SECURE", sAdditionalInfo.substring(0, idxAdditionalInfo));
					sendContentInfo.getScheduleInfo().setProperty("TEST_ATTACH_HEADER", sAdditionalInfo.substring(idxAdditionalInfo + 1));
				}
				else {
					_MEMBER_HASH_.put("EMS_M_SECURE", sAdditionalInfo);
				}
			}
			//=========================================================

			// 매핑에 추가되는 기본 값들을 설정한다.
			_MEMBER_HASH_.put("m_id", MEMBER_ID);
			_MEMBER_HASH_.put("m_email", MEMBER_TOKEN);
			_MEMBER_HASH_.put("m_name", MEMBER_NAME);
			_MEMBER_HASH_.put("p_id", _POST_ID_);

			_MEMBER_HASH_.put("TMS_M_ID", MEMBER_ID);
			_MEMBER_HASH_.put("EMS_M_ID", MEMBER_ID);
			
			_MEMBER_HASH_.put("TMS_M_TOKEN", MEMBER_TOKEN);
			_MEMBER_HASH_.put("TMS_M_EMAIL", MEMBER_TOKEN);
			
			_MEMBER_HASH_.put("EMS_M_TOKEN", MEMBER_TOKEN);
			_MEMBER_HASH_.put("EMS_M_EMAIL", MEMBER_TOKEN);
			_MEMBER_HASH_.put("EMS_M_PHONE", MEMBER_TOKEN);
			
			_MEMBER_HASH_.put("TMS_M_NAME", MEMBER_NAME);
			_MEMBER_HASH_.put("EMS_M_NAME", MEMBER_NAME);
			
			String channelType = sendContentInfo.getScheduleInfo().getProperty("CHANNEL_TYPE","");
			if (!ChannelType.PUSH.getCode().equals(channelType)) {
				_MEMBER_HASH_.put("TMS_M_PHONE", MEMBER_TOKEN);
			}
			
			int idx_member_sep = MEMBER_ID.lastIndexOf("_");

			// 자동메일에서 회원아이디는 두개로 분리가 될수 있기 때문에..
			if( idx_member_sep > 0 ) {
				_MEMBER_HASH_.put("TMS_M_ID", MEMBER_ID.substring(0, idx_member_sep));
				_MEMBER_HASH_.put("TMS_M_ID_SEQ", MEMBER_ID.substring(idx_member_sep + 1));
			}

			//트래킹 맴버아이디
			_MEMBER_HASH_.put("enc_p_id", TrackingInfoConvertor.enc_MAIL_ID(_POST_ID_));

			//트래킹 맴버아이디
			_MEMBER_HASH_.put("enc_mid", TrackingInfoConvertor.enc_MEMBER_ID(MEMBER_ID));
			
			//트래킹 이메일 - SHA256 암호화
			_MEMBER_HASH_.put("enc_email", SHA256.encode(MEMBER_TOKEN));

			//트래킹 발송 타입
			_MEMBER_HASH_.put("enc_s_type", TrackingInfoConvertor.enc_SEND_TYPE(SPOOL_ANALYZER.getSendType()));

			//트래킹 마감시간
			_MEMBER_HASH_.put("enc_t_close", TrackingInfoConvertor.enc_CLOSE(SPOOL_ANALYZER.getLimitDate()));

			//함수변환
			_MEMBER_HASH_.put("statics", StaticModels.INSTANCE);

			String s_type = SPOOL_ANALYZER.getSendType();
			
			if(s_type.equals("CAMP")){
				s_type = "MASS";
			}
			
			_MEMBER_HASH_.put("s_type", s_type);
			
			if( SPOOL_ANALYZER.isNextSpoolValid() ) {
				// 다음 스풀을 만들기 위해서 시도 횟수를 한차수 높여서 만든다.
				SPOOL_ANALYZER.setStep(STEP + 1);
				RCPT_ARRAY[INDEX_OF_SPOOL] = SPOOL_ANALYZER.compose();
			}
			else {
				RCPT_ARRAY[INDEX_OF_SPOOL] = null;
			}

			RCPT_ARRAY[INDEX_OF_CONTENT] = sendContentInfo.getResultMailBody(_MEMBER_HASH_, sendSpoolInfo.getDefaultMapping(), sendContentInfo.getScheduleInfo());
		}
		catch(Throwable thw) {
			//if (log.isDebugEnabled()) {
				log.error(getName(), thw);
			//}
			log("error=>".concat(StringConvertUtil.exToString(thw)));
			RCPT_ARRAY[INDEX_OF_MAIL_FROM] = thw.toString();

			// 에러를 기록해야쥐
			ErrorSpoolLogger.put(target.toString().concat(" =>").concat(thw.toString()));
			this.sendState.set("900 MAIL INFO MAKE ERROR=>" + thw.toString(), "99");
			start_process(RCPT_ARRAY);
			error_process(RCPT_ARRAY);
			return false;
		}

		return true;
	}

	/**
	 * 일단
	 */
	protected void all_success_process() {
		// 원투원에서는 있을수 없는 일이다.
	}

	/**
	 * 초기 연결에서 나오는 것임 그러니까 시작 마킹을 all_error_process에서 같이처리한다.
	 */
	protected void all_start_process() {
		// 원투원에서는 있을수 없는 일이다.
	}

	protected void _error_process() {
		// 수신거부 에러면 블럭 에러처리를 하고.
		switch (this.sendState.getLogLevel()) {
			case LOG_LEVEL_DENY_ERROR: {
				all_error_process();
				break;
			}
			default: {
				error_process(RCPT_ARRAY);
				break;
			}
		}
	}
	
	protected void parsedListAllErrorProcess() {
		// 여러개 뭉친 녀석들을 쪼갠거를 하나씩 처리를 한다.
		while (this.PARSED_RCPT_INFO.size() > 0) {
			Object NEXT_SPOOL = this.PARSED_RCPT_INFO.removeFirst();
			
			if( !this.parseMemberInfoOnly(NEXT_SPOOL) ) {
				continue;
			}

			start_process(RCPT_ARRAY);
			error_process(RCPT_ARRAY);
		}
	}

	protected abstract void work() throws Exception;

	protected void all_error_process() {
	}

}
