/*
 * @(#)AbstractMulipleRcptCommunicationActor.java            2004. 12. 6.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.mass.actor;

import java.util.Iterator;

import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import pluto.log.ErrorSpoolLogger;

/**
 * Class description :
 * 
 * @version
 * @author dragon
 *  
 */
public abstract class AbstractMultipleRcptCommunicationActor extends AbstractBufferedCommunicationActor {

	/** Creates a new instance of AbstractMulipleRcptCommunicationActor */
	public AbstractMultipleRcptCommunicationActor() throws Exception {
		super();
	}

	/**
	 * 기본적으로 현재 파싱된 RCPT에 대해서 에러 처리를 한다. 처리후에는 파싱된 버퍼를 clear 한다.
	 */
	protected void all_error_process() {
		if( STEP_DEBUG ) {
			log("all error");
		}

		for (Iterator iter = this.PARSED_RCPT_INFO.iterator(); iter.hasNext();) {
			Object __TMP_SPOOL__ = iter.next();

			if( this.parseMemberInfoOnly(__TMP_SPOOL__) ) {// 파싱에 성공하면 에러를 마킹한다.
				error_process(RCPT_ARRAY);
			}
			else {
				// 실패하면 제거하고
				log("all_error_process.parseMemberInfoOnly fail: " + __TMP_SPOOL__.toString());
			}
		}

		// 다 처리했으니까 비워준다.
		this.PARSED_RCPT_INFO.clear();
	}

	/**
	 * 기본적으로 현재 파싱된 RCPT에 대해서 시작 처리를 한다.
	 */
	protected void all_start_process() {
		for (Iterator iter = this.PARSED_RCPT_INFO.iterator(); iter.hasNext();) {
			Object __TMP_SPOOL__ = iter.next();

			if( this.parseMemberInfoOnly(__TMP_SPOOL__) ) {
				// 파싱에 성공하면 시작을 마킹한다.
				start_process(RCPT_ARRAY);
			}
			else {
				// 실패하면 제거하고
				log("all_start_process.parseMemberInfoOnly fail: " + __TMP_SPOOL__.toString());
				iter.remove();
			}
		}
	}

	/**
	 * 기본적으로 현재 파싱된 RCPT에 대해서 성공 처리를 한다. 처리후에는 파싱된 버퍼를 clear 한다.
	 */
	protected void all_success_process() {
		for (Iterator iter = this.PARSED_RCPT_INFO.iterator(); iter.hasNext();) {
			Object __TMP_SPOOL__ = iter.next();

			if( this.parseMemberInfoOnly(__TMP_SPOOL__) ) {
				// 파싱에 성공하면 시작을 마킹한다.
				success_process(RCPT_ARRAY);
			}
			else {
				// 실패하면 제거하고
				log("all_success_process.parseMemberInfoOnly parse fail: " + __TMP_SPOOL__.toString());
			}
		}

		// 다 처리했으니까 비워준다.
		this.PARSED_RCPT_INFO.clear();
	}

	protected String splitRcptInfo() {

		// 슈퍼 메소드를 호출하여 나누고 도메인을 결정한다.
		String DOMAIN = super.splitRcptInfo();

		if( DOMAIN == null ) {
			return null;
		}

		// 도메인을 알아냈으면 최초 한녀석을 뽑아서 파싱을 해가지고 메일아이디를 알아낸다.
		for (Iterator iter = this.PARSED_RCPT_INFO.iterator(); iter.hasNext();) {
			String __TMP_SPOOL__ = (String) iter.next();

			if( parseMemberInfoOnly(__TMP_SPOOL__) ) {
				//하나만 파싱되면 넘어간다.
				break;
			}

			// 회원 정보 추출이 안되서 바지는 녀석은 일단 agent_log에 남긴다.
			log("splitRcptInfo.parseMemberInfoOnly fail :" + __TMP_SPOOL__);

			// 실패하면 제거하고
			iter.remove();
		}

		// 전부 에러가 났다면 사이즈가 0이므로 실패를 반환한다.
		if( this.PARSED_RCPT_INFO.size() == 0 ){
			return null;
		}

		// 각 메일별로 묶여 있는 녀석이니가 해당 제작물을 생성한다.
		String _POST_ID_ = this.SPOOL_ANALYZER.getPostID();

		ContentInfo _SEND_CONTENT_INFO_ = null;

		try {
			_SEND_CONTENT_INFO_ = ContentInfoManager.getContentInfo(_POST_ID_);

			if( _SEND_CONTENT_INFO_ == null ) {
				throw new RuntimeException(PARSING_RESULT_CONTENT_INFO_FAIL);
			}

			// 기본세팅 정보는 넣어두고
			RCPT_ARRAY[INDEX_OF_CONTENT] = _SEND_CONTENT_INFO_.getResultMailBody(null, null, _SEND_CONTENT_INFO_.getScheduleInfo());
			RCPT_ARRAY[INDEX_OF_MAIL_FROM] = _SEND_CONTENT_INFO_.getReturnPath();
		}
		catch(Exception e) {
			RCPT_ARRAY[INDEX_OF_MAIL_FROM] = e.toString();
			// 에러를 기록해야쥐
			for (Iterator iter = this.PARSED_RCPT_INFO.iterator(); iter.hasNext();) {
				ErrorSpoolLogger.put(iter.next().toString().concat(" =>").concat(e.toString()));
			}
			return null;
		}

		// 파싱이 끝나면 시작을 마킹한다.
		this.all_start_process();

		return DOMAIN;
	}
}
