/*
 * @(#)AbstractBufferedCommunicationActor.java            2004. 12. 6.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.mass.actor;

import java.util.concurrent.atomic.AtomicInteger;

import jupiter.common.actor.BufferedCommunicationActor;
import jupiter.common.communicator.SmtpCommunicator;
import lombok.extern.slf4j.Slf4j;
import pluto.log.ErrorSpoolLogger;
import pluto.log.Log;
import pluto.util.PlutoLinkedList;
import pluto.util.StringConvertUtil;
import pluto.util.recycle.BufferBin;
import pluto.util.recycle.Bufferable;
import venus.spool.common.parser.MultiSpoolTokenizer;
import venus.spool.common.parser.SpoolAnalyzer;

/**
 * <br>
 * Actor의 recycling 작업을 지원하는 SmtpCommunicator다. <br>
 * Communicator의 execute() ( 시작 메소드 )도 이 곳에 정의되어 있다.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public abstract class AbstractBufferedCommunicationActor extends SmtpCommunicator implements BufferedCommunicationActor, Bufferable {
	

	public static final int			RCPT_CONTAIN_LIMIT					= 5;

	public static final String		PARSING_RESULT_OK					= "OK";

	public static final String		PARSING_RESULT_CONTENT_INFO_FAIL	= "UNREGIST CONTENT INFO";

	protected String[]				RCPT_ARRAY							= new String[16];

	protected BufferBin				INNER_BUFFERED_BIN					= null;

	/**
	 * 작업계속 유무를 체크하는 파라미터
	 */
	protected boolean				alive								= false;

	/**
	 * 내부 진행하는 Thread를 위한 변수들
	 */
	private Thread					inner_worker						= null;

	/**
	 * 작업 속도 조절을 위한 변수 0보다 크면 connection_delay 만큼 작업이 끝난 다음에 waiting한다.
	 */
	protected int					connection_delay					= 0;

	protected int					rset_count							= 10;

	/**
	 * 복수개의 RCPT_INFO를 저장하는
	 */
	protected PlutoLinkedList		PARSED_RCPT_INFO					= null;

	protected MultiSpoolTokenizer	RCPT_INFO_TOKEN						= null;

	protected SpoolAnalyzer			SPOOL_ANALYZER						= null;
	
	// 해당 Actor가 발송한 건수
	// Buffer에 발송할 데이터가 존재하지 않으면 0으로 초기화 됨
	protected static AtomicInteger totalSendCount = new AtomicInteger(0);
	
	// 푸시 발송시 사용
	// spareMinute을 넣어 Insert 시점에 Reserve_date 와 Expire_time 이 현재시간보다 과거로 가지 않도록 하기위함
	protected static Integer spareMinute = 0;

	/** Creates a new instance of AbstractBufferedCommunicationActor */
	public AbstractBufferedCommunicationActor() throws Exception {
		// false로 설정, 모니터링 할 필요가 없다.
		// SmtpCommunicator에서 강제로 끊는 것으로 수정을 했다. 
		// by keidao
		super(false);
		this.PARSED_RCPT_INFO = new PlutoLinkedList();
		this.RCPT_INFO_TOKEN = new MultiSpoolTokenizer(Log.DELIMINATOR_MUTI_RCPT_INFO);
		this.SPOOL_ANALYZER = SpoolAnalyzer.getSpoolAnalyzer();
	}

	/**
	 * 자신을 관리하는 쓰레기 통을 지정한다.
	 */
	public void setBufferBin(BufferBin bin) {
		this.INNER_BUFFERED_BIN = bin;
	}

	public void setParameter(BufferBin bin, ThreadGroup group, int name_idx, Integer inter_delay, int rset) {

		String name = bin.getName() + "_Worker_" + String.valueOf(name_idx);
		setBufferBin(bin);
		setName(name);
		this.connection_delay = inter_delay == null ? 0 : inter_delay.intValue();

		if(log.isDebugEnabled()){
			log.debug(name + "=>INIT ORG SLEEP VALUE:" + inter_delay);
			log.debug(name + "=>INIT CONVERT SLEEP VALUE:" + this.connection_delay);
		}
		
		this.rset_count = rset;

		this.AGENT_IDX = name_idx;

		inner_worker = new Thread(group, this, name);
	}

	/**
	 * 시작을 알리는 종소리
	 */
	public void execute() {
		inner_worker.start();
	}

	/**
	 * 재활용 되지 않고 삭제 될때 자원 정리
	 */
	public void destroy() {
		log.error(" Call destroy Method... from : " + Thread.currentThread().getName());
		this.clean();
		this.INNER_BUFFERED_BIN.destroy(this);
	}

	/**
	 * 더이상 안 쓴다고 명시한다.
	 */
	public void setEnd() {
		log.error(" Call setEnd Method... from : " + Thread.currentThread().getName());
		this.alive = false;
		synchronized (this) {
			this.notifyAll();
		}
	}

	/**
	 * 발송할 도메인을 지정
	 * 
	 * @param domain
	 *        발송할 도메인
	 */
	public void setDomain(String domain) {
		// 어떻게 바뀔지 모르는 것이기 때문에 일단은 그냥 넘어감
	}

	/**
	 * 재활용에 들어가기전에 사용한 자원을 반환
	 */
	public void clean() {
		this.sendState.reset();
		this.domain = null;
		this.RCPT_TO = null;
		super.close();
	}

	public void run() {
		this.alive = true;

		synchronized (this) {
			this.notifyAll();
		}

		while (this.alive) {
			//Object rcpt = null;
			if( STEP_DEBUG )
				log("add rcpt....[START]");
			
			int bufferSize = this.INNER_BUFFERED_BIN.getBufferSize();
			log.debug("getBufferSize()... bufferSize: {}", bufferSize);
			
			if (bufferSize < 1) {
				log.debug("Buffer is empty...");
				spareMinute = 0;
				totalSendCount = new AtomicInteger(0);
			}

			while (this.RCPT_TO == null && this.alive) {
				this.RCPT_TO = this.INNER_BUFFERED_BIN.popup();
			}
			
			if( this.RCPT_TO == null )
				continue;
			
			try {
				if( STEP_DEBUG )
					log(" CALL work....");
				this.work();
			}
			catch(Throwable error) {
				log.error(" is catch Throwable : " + error.toString());
				log( StringConvertUtil.exToString(getName(),error));
				this.sendState.set(error.toString(), "99");
				all_error_process();

				if( error instanceof ThreadDeath ) {
					this.alive = false;
				}
			}
			finally {
				closeConnection();
			}

			if( !this.alive ){
				break;
			}
		}

		log(getName() + " is die....");
		/**
		 * 영원히 사라진다.
		 */
		destroy();
	}

	public void log(String log) {
		this.INNER_BUFFERED_BIN.log(log);
	}

	/**
	 */
	protected abstract void all_success_process();

	/**
	 * 한건에 대한 성공여부를 전송한다. 아마도 원투원 발송할때 RSET으로 초기화 하기 전에 호출이 되지 않을까... 생각된다.
	 * 
	 * @param RCPT_INFO
	 */
	protected void success_process(String[] _AGENT_ARRAY_) {
		this.resultLog(_AGENT_ARRAY_, "54", "10", this.sendState.getMESSAGE(), LOG_LEVEL_SUCCESS, this.sendState.getMGS_SEQ());
	}

	/**
	 * 54-00 을 마킹한다. 즉 시작을 알린다.
	 */
	protected void start_process(String[] _AGENT_ARRAY_) {
		this.resultLog(_AGENT_ARRAY_, "54", "00", "250 Start", LOG_LEVEL_START, this.sendState.getMGS_SEQ());
	}

	/**
	 */
	protected void error_process(String[] _AGENT_ARRAY_) {
		this.resultLog(_AGENT_ARRAY_, "55", this.sendState.getRETURN_CODE(), this.sendState.getMESSAGE(), this.sendState.getLogLevel(), this.sendState.getMGS_SEQ());
	}

	protected boolean parseMemberInfoOnly(Object target) {

		try {
			SPOOL_ANALYZER.parse(target.toString());
			RCPT_ARRAY[INDEX_OF_SEND_KIND] = SPOOL_ANALYZER.getSendType();
			RCPT_ARRAY[INDEX_OF_POST_ID] = SPOOL_ANALYZER.getPostID();
			RCPT_ARRAY[INDEX_OF_MEMBER_ID] = SPOOL_ANALYZER.getMemberID();
			RCPT_ARRAY[INDEX_OF_STEP] = SPOOL_ANALYZER.getStep();
			RCPT_ARRAY[INDEX_OF_TOKEN_ID] = SPOOL_ANALYZER.getTokenID();
			RCPT_ARRAY[INDEX_OF_DOMAIN] = SPOOL_ANALYZER.getDomain();
			RCPT_ARRAY[INDEX_OF_LIST_TABLE] = SPOOL_ANALYZER.getListTable();
			
			//EMS7.0 EMAIL_ENCRYPT 
			RCPT_ARRAY[INDEX_OF_EMAIL_ENCRYPT] = SPOOL_ANALYZER.getProperty(LOG_TOKEN_ENCRYPT);

			// 스풀은 한차수 높여야 한다.
			SPOOL_ANALYZER.setStep(SPOOL_ANALYZER.getIntStep() + 1);

			if( SPOOL_ANALYZER.isNextSpoolValid() ) {
				RCPT_ARRAY[INDEX_OF_SPOOL] = SPOOL_ANALYZER.compose();
			}
			else {
				RCPT_ARRAY[INDEX_OF_SPOOL] = null;
			}
		}
		catch(Exception e) {
			if (log.isDebugEnabled()) 
				log.error(target.toString(), e);
			log("error=>".concat(StringConvertUtil.exToString(e)));
			RCPT_ARRAY[INDEX_OF_MAIL_FROM] = e.toString();
			// 에러를 기록해야쥐
			ErrorSpoolLogger.put(target.toString().concat(" =>").concat(e.toString()));

			return false;
		}

		return true;
	}

	protected String splitRcptInfo() {
		// 리스트 형태로의 전환이 필요하다.
		try {
			// 토큰으로 전환하고.
			this.RCPT_INFO_TOKEN.parse(this.RCPT_TO.toString());

			// RCPT LIST를 없애고 난다음
			this.PARSED_RCPT_INFO.clear();

			// 첫번 토큰으로 정보를 추출하고
			while (this.RCPT_INFO_TOKEN.hasMoreTokens()) {
				String NEXT = this.RCPT_INFO_TOKEN.nextToken();
				if( NEXT.trim().length() < 1 )
					continue;
				this.PARSED_RCPT_INFO.add(NEXT);
			}

			if( this.PARSED_RCPT_INFO.size() == 0 ){
				return null;
			}

			return this.RCPT_INFO_TOKEN.getDomain();
		}
		catch(Exception e) {
			if (log.isDebugEnabled()) 
				log.error(this.RCPT_TO.toString(), e);
			if( STEP_DEBUG )
				log("error=>".concat(e.toString()));

			/**
			 * 에러를 기록해야쥐
			 */
			ErrorSpoolLogger.put(this.RCPT_TO.toString().concat(" =>").concat(e.toString()));
			return null;
		}
		finally {
			this.RCPT_TO = null;
		}
	}

	/**
	 * @throws Exception
	 */
	protected abstract void work() throws Exception;

	/**
	 */
	protected abstract void all_start_process();

	/**
	 */
	protected abstract void all_error_process();
}
