/*
 * @(#)SingleScheduleCheckTask.java            2004. 12. 9.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package jupiter.common.task;

import java.sql.SQLException;
import java.util.List;
import java.util.Properties;

import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.lang.eMsTypes;
import pluto.mail.MailSendingInstanceFactory;
import pluto.reporter.Reporter;
import pluto.schedule.AlreadyRegistTaskException;
import pluto.schedule.Task;
import pluto.schedule.TaskManager;
import pluto.util.Cal;
/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class SingleScheduleCheckTask extends Task {
	
	
	/**대상이 되는 스케쥴을 선정하는 쿼리 */
	public static String QUERY_SELECT_TARGET_SCHEDULE = null;
	
	/**20테이블의 상태값을 업데이트 한다. */
	protected static List  QUERY_LIST_UPDATE_TARGET_SCHEDULE = null;
	
	protected String		MAIL_ID = "";
	
	/**구동에 필요한 기본 static 변수의 초기화 */
	static {
		try{
			QUERY_SELECT_TARGET_SCHEDULE = SqlManager.getQuery("MAIN_SCHEDULE_CHECK","QUERY_SELECT_TARGET_SCHEDULE");
			
			QUERY_LIST_UPDATE_TARGET_SCHEDULE = SqlManager.getMultiQuery("MAIN_SCHEDULE_CHECK","QUERY_UPDATE_TARGET_SCHEDULE");
		}
		catch( Exception e ) {
			log.error(e.getMessage());
			System.exit(1);
		}
	}
	
	protected eMsConnection EMS_CONNECTION = null;
	
	/** Creates a new instance of SingleScheduleCheckTask */
	public SingleScheduleCheckTask() {
		
		super( TYPE_INTERVAL );
		this.setName( "SingleScheduleCheckTask_at_".concat( Cal.getSerialDate() ) );
		this.setTaskID( "SingleScheduleCheckTask" );
	}
	
	/** 
	 * Task를 초기화하는 로직을 구현한다.
	 * Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록 되어있다.
	 */
	public void execute_initiate() throws Exception {
		
		this.setName( "ScheduleCheck_at_".concat( Cal.getSerialDate() ) );
		if (log.isDebugEnabled()) {
			log.debug(" Request Connection");
		}
		EMS_CONNECTION = ConnectionPool.getConnection();
		if (log.isDebugEnabled()) {
			log.debug(" Get Connetion " + EMS_CONNECTION.getName());
		}
	}
	
	/** 
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다.
	 * Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
		log.error(" Request Connection Error");
		//REPORT 데이터베이스 커넥션을 가져오는 과정에서 에러가 발생하였습니다.
		if( !( thw instanceof SQLException ) ){
			Reporter.report("common",getName(),"schedulechecktask.init.err",thw);
		}
	}
	
	/** 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다.
	 * 할당받은 자원을 free 시키는 로직을 구현한다.
	 * execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {
		if( EMS_CONNECTION != null ) {
			EMS_CONNECTION.recycle();
		}
	}
	
	/** execute() 가 false를 반환하였을때(실패) 실행하는 로직이 구현된다.
	 *여기서는 아무일도 하지 않으며 성공시 후속 조치가 필요한 Task는 이 method를 오버라이드 하면 된다.
	 */
	public void doErrorProcess( Throwable thw ){
		log.error( getName()  , thw );
		Reporter.report("common",getName(),"schedulechecktask.check.err",thw);
	}
	
	/** 실제적인 일을 처리하는 비지니스로직
	 * @return true : 성공적인 수행<br>
	 * false : 수행 실패
	 */
	public void execute() throws Exception {
		if (log.isDebugEnabled()) {
			log.debug(" is execute execute_createTask method...");
		}
		execute_createTask( QUERY_SELECT_TARGET_SCHEDULE , QUERY_LIST_UPDATE_TARGET_SCHEDULE );
		if (log.isDebugEnabled()) {
			log.debug(" is execute execute_createTask method...[OK]");
		}
	}
	
	/** 조건에 걸리는 녀석들을 집어 내어 MakeSendInfoTask 로 만들어 TaskManager에 등록을 한다.
	 * step : START 에서 실행 된다.
	 */
	private synchronized void execute_createTask( 
			String TARGET_QUERY , List UPDATE_QUERY ) throws Exception {
		
		eMsStatement __SELECT_STATEMENT__ = null;
		eMsStatement __EMS_EXEC_STATEMENT__ = null;
		
		eMsResultSet __RESULT_OF_SCHEDULE__ = null;
		
		try{
			__SELECT_STATEMENT__ = EMS_CONNECTION.createStatement();
			__EMS_EXEC_STATEMENT__ = EMS_CONNECTION.createStatement();
			
			// 기본 정보를 가져 온당...
			if (log.isDebugEnabled())  
					log.debug( EMS_CONNECTION.getName() + " BEFORE execute Query" );
					
			__RESULT_OF_SCHEDULE__ = 
					__SELECT_STATEMENT__.executeQuery( TARGET_QUERY );
			
			if (log.isDebugEnabled())  
					log.debug( EMS_CONNECTION.getName() + " AFTER execute Query" );
			
			/**각 스케쥴에 대해서 패치하여 스케쥴 생성하기
			 */
			while( __RESULT_OF_SCHEDULE__.next() ) {
				
				Properties SCHEDULE_INFO = new Properties();
				
				__RESULT_OF_SCHEDULE__.putToMap( SCHEDULE_INFO , false );
				
				MAIL_ID = SCHEDULE_INFO.getProperty("MAIL_ID","NO ID");
				
				SCHEDULE_INFO.setProperty( "UPDATE_JOB_STATUS" , "--" );
				
				if (log.isDebugEnabled())  
						log.debug( getName() + " is create new MakeSendInfoTask " + SCHEDULE_INFO.getProperty( "POST_ID") );
				
				try {
					Task make_info = ( Task )MailSendingInstanceFactory.getInstance( SCHEDULE_INFO , eMsTypes.SENDTASK_INSTANCE );
					
					if (log.isDebugEnabled())  log.debug( getName() + " is Popup MailSendTask => " + SCHEDULE_INFO.getProperty( "SEND_TYPE" ) + "_" + SCHEDULE_INFO.getProperty( "SEND_STATE" ) + " =>" + make_info.getClass().getName() );
					
					// 발송 스케쥴을 초기화 한다.
					make_info.setTaskProperty( SCHEDULE_INFO );
					
					// 등록한다.
					TaskManager.executeTask( make_info );
					
					// 반복 루틴 내부의 사용이 아니므로 그대로 사용한다. 2004.11.01
					EMS_CONNECTION.executeUpdateList( UPDATE_QUERY , SCHEDULE_INFO , "${" , "}" , false );
				}
				catch( Exception e ) {
					if( e instanceof AlreadyRegistTaskException ) {
						SCHEDULE_INFO.setProperty( "UPDATE_JOB_STATUS" , eMsLocale.REGIST_SEND_TASK_ERROR );
						// 반복 루틴 내부의 사용이 아니므로 그대로 사용한다. 2004.11.01
						EMS_CONNECTION.executeUpdateList( UPDATE_QUERY , SCHEDULE_INFO , "${" , "}" , false );
					}
					
					log.error( getName() , e );
					//Reporter.report(SCHEDULE_INFO.getProperty( "POST_ID") , getName(),"schedulechecktask.create.info.err",e);
					Reporter.report("["+this.MAIL_ID+"] "+SCHEDULE_INFO.getProperty( "POST_ID") , getName(),"schedulechecktask.create.info.err",e);
				}
			}
		}
		catch( Exception e ){
			throw e;
		}
		finally{
			try{ __RESULT_OF_SCHEDULE__.close(); }catch( Exception ignore ){}
			
			EMS_CONNECTION.recycleStatement( __SELECT_STATEMENT__ );
			EMS_CONNECTION.recycleStatement( __EMS_EXEC_STATEMENT__ );
		}
	}
}

