/*
 * @(#)SimpleQueRecycleMailSendTask.java            2004. 12. 9.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.common.task;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Properties;

import jupiter.common.pool.BufferedAgentPool;
import jupiter.mass.send.basic.SendStopException;
import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.FileElement;
import pluto.io.HeadTailFilenameFilter;
import pluto.lang.eMsLocale;
import pluto.log.ErrorSpoolLogger;
import pluto.mail.mx.LookupCacheManager;
import pluto.panopticon.filter.RejectFilter;
import pluto.panopticon.monitor.MailSendDomainFilter;
import pluto.secure.crypto.CryptoUtil;
import pluto.util.Cal;
import pluto.util.StringUtil;
import venus.spool.common.basic.SpoolingManager;
import venus.spool.common.popper.Popper;

/**
 * Class description :
 * 
 * @version
 * @author lena
 *  
 */
@Slf4j
public class SimpleQueRecycleMailSendTask extends AbstractNoDBMailSendTask {

	protected static String			STORE_BASE_DIR			= null;

	protected static String			STORE_WAIT_FILE_HEADER	= null;

	protected static String			STORE_WAIT_FILE_EXT		= null;

	protected static String			PROCESS_FILE_HEADER		= null;

	protected static String			PROCESS_FILE_EXT		= null;

	protected static String			END_BASE_DIR			= null;

	protected static String			END_FILE_HEADER			= null;

	protected static String			END_FILE_EXT			= null;

	protected FilenameFilter		WORK_FILE_NAME_FILTER	= null;

	protected String				TARGET_WORK_FILENAME	= null;

	protected String				TARGET_SENDING_FILENAME	= null;

	protected String				TARGET_DONE_FILENAME	= null;

	private static boolean			QUE_SEND_INTERRUPT_FLAG	= false;

	

	private	static	int			DATE_FROM_DB = 0;
	private	static	String		SELECT_GET_DATE_FROM_DB = SqlManager.getQuery( "SIMPLE_QUEUE_SEND_INFO", "QUERY_SELECT_SIMPLEQUEUE_GET_DATE" );
	//private	static	String		SELECT_GET_DATE_FROM_DB = SqlManager.getQuery("COMMON", "QUERY_SELECT_REALTIME_SCHEDULE_INFO");
	
	
	/** Creates a new instance of SimpleQueMailSendTask */
	public SimpleQueRecycleMailSendTask() throws Exception {
		super(TYPE_INTERVAL, 1);
		setName("SimpleQueRecycleMailSendTask");
		setTaskID("SimpleQueRecycleMailSendTask");
		this.WORK_FILE_NAME_FILTER = new HeadTailFilenameFilter(STORE_WAIT_FILE_HEADER, STORE_WAIT_FILE_EXT);
		this.instance_STOP_CHECK_RECYCLE = 2;
	}

	public static void init(Object tmp) throws Exception {
		Properties prop = (Properties) tmp;

		// 기본디렉토리 점검
		STORE_BASE_DIR = prop.getProperty("work.dir");

		if( STORE_BASE_DIR == null )
			throw new RuntimeException("work.dir param is not set... ");

		STORE_WAIT_FILE_HEADER = prop.getProperty("wait.file.header", "Resending");
		STORE_WAIT_FILE_EXT = prop.getProperty("wait.file.ext", ".work");

		// 작업중인 파일의 표식
		PROCESS_FILE_HEADER = prop.getProperty("send.file.header", "QueProcess");
		PROCESS_FILE_EXT = prop.getProperty("send.file.ext", ".sending");

		// 완료 디렉토리 점검
		END_BASE_DIR = prop.getProperty("end.dir");

		END_FILE_HEADER = prop.getProperty("end.file.header", "ResendDone");
		END_FILE_EXT = prop.getProperty("end.file.ext", ".done");

		if( END_BASE_DIR == null )
			throw new RuntimeException("end.dir param is not set... ");
	}

	public synchronized static void interruptQueSending() {
		QUE_SEND_INTERRUPT_FLAG = true;
	}

	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록 되어있다.
	 */
	public void execute_initiate() throws Exception {
		QUE_SEND_INTERRUPT_FLAG = false;
		
		eMsConnection EMS_CONNECTION = null;
		eMsStatement __EMS_EXEC_STMT__ = null;
		eMsResultSet __SELECT_RESULT__ = null;
		
		EMS_CONNECTION	= ConnectionPool.getConnection();
		__EMS_EXEC_STMT__ = EMS_CONNECTION.createStatement();
		boolean conn_check = false;
		try{
			__SELECT_RESULT__ = __EMS_EXEC_STMT__.executeQuery(SELECT_GET_DATE_FROM_DB);
			
			while(__SELECT_RESULT__.next()){
				DATE_FROM_DB = Integer.parseInt( __SELECT_RESULT__.getString("NOWDATE") );
			}
			
			conn_check = true;
		} catch(Exception e){
			log.error("error", e);
			conn_check = false;
		} finally{
			if(!conn_check){
				DATE_FROM_DB = 20000101;
			}
			if(__SELECT_RESULT__ != null){
				__SELECT_RESULT__.close();
			}
			if(__EMS_EXEC_STMT__ != null){
				EMS_CONNECTION.recycleStatement(__EMS_EXEC_STMT__);
			}
			if(EMS_CONNECTION != null){
				EMS_CONNECTION.recycle();
			}
		}
		
	}

	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
		// 에러 날 일이 없으므로 할 일이 없다.
	}

	/**
	 * 리스트 로드
	 */
	protected void execute_ListLoad() throws Exception {

		// 먼저 작업 디렉토리에서 파일을 하나 가져오기 위해서 파일 리스트를 추출한다.
		File _TARGET_DIRECTORY_ = new File(STORE_BASE_DIR);
		String _TARGET_FILES_[] = _TARGET_DIRECTORY_.list(this.WORK_FILE_NAME_FILTER);

		// 파일이 존재하지 않는다면 그냥 돌아간다.
		if( _TARGET_FILES_.length < 1 ) {
			this.SPOOL_POPPER = null;
			return;
		}

		LinkedList _FILE_LIST_ = new LinkedList();

		// 작업을 할 스풀 파일 중 제일 첨에 만들어 진녀석의 이름을 저장할 변수
		String _TARGET_WORK_FILE_ = null;

		for (int i = 0; i < _TARGET_FILES_.length; i++) {
			_FILE_LIST_.add(_TARGET_FILES_[i]);
		}

		Collections.sort(_FILE_LIST_);
		_TARGET_WORK_FILE_ = (String) _FILE_LIST_.getFirst();

		// 선택된 파일이름을 전체 경로로 바꾸고 작업 중 파일로 전환할 파일이름을 결정한다.
		// 작업중 파일로 전환할 파일이름
		this.TARGET_SENDING_FILENAME = STORE_BASE_DIR + File.separator + PROCESS_FILE_HEADER + Cal.getSerialDate() + PROCESS_FILE_EXT;

		if (log.isDebugEnabled()) 
			log.debug("TargetFile from=>" + this.TARGET_SENDING_FILENAME);

		// 작업중 파일로 전환할 원본파일 전체 경로
		this.TARGET_WORK_FILENAME = STORE_BASE_DIR + File.separator + _TARGET_WORK_FILE_;

		// 작업중 파일로 전환할 파일
		File _CHANGE_TARGET_FILE_ = new File(this.TARGET_SENDING_FILENAME);

		// 작업중 파일로 전환할 원본파일
		File _ORIGINAL_SOURCE_FILE_ = new File(this.TARGET_WORK_FILENAME);

		//원본 파일을 작업중 파일로 전환
		if( _ORIGINAL_SOURCE_FILE_.renameTo(_CHANGE_TARGET_FILE_) ) {
			log.debug( "Transfer Work->Sending Success from=>" + _ORIGINAL_SOURCE_FILE_.getPath() + " To=>" + _CHANGE_TARGET_FILE_.getPath());
		}
		else {
			log.error(getName(), "Transfer Work->Sending Fail from=>" + _ORIGINAL_SOURCE_FILE_.getPath() + " To=>" + _CHANGE_TARGET_FILE_.getPath());
		}

		//교체된 작업 중 파일로 Popper를 초기화 한다.
		this.SPOOL_POPPER = Popper.getInstance();

		//스풀 파일은 발송 엔진이 만드는 것이므로 무조건 발송 엔진과 동일한 서버에 있고, 따라서 base를 null로 셋팅한다.
		this.SPOOL_POPPER.init(null, this.TARGET_SENDING_FILENAME);
	}

	protected void execute_InnerSend() throws Exception {

		if( execute_StopCheck() ) {
			throw new SendStopException(getName() + " receive stop signal");
		}

		RejectFilter instanceRejectFilter = RejectFilter.getFilterInstance(this.TASK_PROPERTY);

		String nextSpool = null;
		String domain = null;
		int spoolPatchCount = 0;
		BufferedAgentPool pool = null;
		
		String email_str = null;
		String email_en  = null;
		String ori_Spool = null;
		
		StringBuffer strBuffer = new StringBuffer(1024);
		int email_en_len = 0;
		
		while ((nextSpool = (String) this.SPOOL_POPPER.next()) != null) {
			
			if( nextSpool == null || nextSpool.length() < 1 )
				continue;
			
			if( spoolPatchCount++ % instance_STOP_CHECK_RECYCLE == 0 ) {
				if( execute_StopCheck() ) {
					throw new SendStopException(getName() + " receive stop signal");
				}
			}

			try {
				int limitDate = 0;
				this.SPOOL_ANALYZER.parse(nextSpool);
				
				
				try{
					limitDate = Integer.parseInt( this.SPOOL_ANALYZER.getLimitDate() );
				} catch(Exception e){
					limitDate = 20000101; //set data(2000.01.01)
				}
				//오늘 일자가 큐발송마감일자보다 크면 Skip
				if(DATE_FROM_DB > limitDate) continue;
				
				//domain = this.SPOOL_ANALYZER.pickupDomain(nextSpool);
				//복호화한 email
				email_en  = getSecureEmail(nextSpool);
				email_str = getDecryptEmail(email_en);
				domain    = StringUtil.getDomain(email_str);
				
				//----- [1번] ---------------------
				//변환된 스풀
//				ori_Spool = nextSpool;
//				nextSpool = StringUtil.ConvertString(nextSpool, email_en, email_str);
				
				//----- [2번] ---------------------
				email_en_len = email_en.length();
				strBuffer.setLength(0);
				strBuffer.append(email_en).append(CryptoUtil.TMS_DECRYPT_TAG).append(email_str).append(nextSpool.substring(email_en_len));
				nextSpool = strBuffer.toString();
				
				if( domain == null ) {
					processSyntaxErrorSpool(nextSpool);
					continue;
				}

				// reject할 도메인 관리하려면 사용한다.
				if( MailSendDomainFilter.isFilterPresent() && MailSendDomainFilter.isTargetDomain(domain) ) {

					passRejectDomain(nextSpool);
					continue;
				}

				// Spool의 내용에서 필터링을 적용하여 보내지 않을 대상인지를 판별한다.
				if( instanceRejectFilter != null ) {

					//this.SPOOL_ANALYZER.parse(nextSpool);
					if( instanceRejectFilter.isFiltered(this.SPOOL_ANALYZER) ) {
						continue;
					}
					nextSpool = this.SPOOL_ANALYZER.composeSingleRcptSend();
				}

				//도메인을 Lookup 한다.
				DOMAIN_NOT_FOUND_EXCEPTION = LookupCacheManager.isInvalidDomain(domain);

				if( DOMAIN_NOT_FOUND_EXCEPTION == null ) {
					pool = this.getBufferedObjectPool(domain);
					pool.registSpool(domain, nextSpool);
				}
				else {
					passDomainNotFound(nextSpool, DOMAIN_NOT_FOUND_EXCEPTION);
				}
			}
			catch(OutOfMemoryError outError) {
				log.error("OOM error", outError);
				System.gc();

				try {
					Thread.currentThread().sleep(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
				}
				catch(Exception ignore) {
				}

				try {
					//뜻하지 않은 에러이므로 재발송 스풀 생성을 담당하는 SpoolingManager에 넣어준다.
					//SpoolingManager.registSpool(nextSpool);
					SpoolingManager.registSpool(ori_Spool);
				}
				catch(Exception ignore) {
				}

				continue;
			}
			catch(Throwable err) {
				log.error("error", err);
				ErrorSpoolLogger.put(nextSpool + " => send : " + err.toString());
				continue;
			}
		}

		if (log.isDebugEnabled()) 
			log.debug("EXEC BufferedAgentPool.flushAll()");

		BufferedAgentPool.flushAll();

		if (log.isDebugEnabled()) 
			log.debug("EXEC execute_ListSend [OK]");
	}

	/**
	 * 리스트 로드
	 */
	protected void execute_ListSend() throws Exception {
		if( this.SPOOL_POPPER == null )
			return;

		try {
			execute_InnerSend();
			//super.execute_ListSend();
		}
		catch(SendStopException se) {
			log.error("QUE SEND INTERRUPTED");

			/**
			 * 정지가 되었으므로 혹시나 work 파일들이 존재한다면 전부다 지워야 한다.
			 */
			File _TARGET_DIRECTORY_ = new File(STORE_BASE_DIR);
			String _TARGET_FILES_[] = _TARGET_DIRECTORY_.list(this.WORK_FILE_NAME_FILTER);

			for (int i = 0; i < _TARGET_FILES_.length; i++) {
				log.error("QUE SEND INTERRUPTED DELETE FILE", STORE_BASE_DIR + File.separator + _TARGET_FILES_[i]);
				if( (new File(STORE_BASE_DIR + File.separator + _TARGET_FILES_[i])).delete() ) {
					log.error("QUE SEND INTERRUPTED DELETE FILE", "SUCCESS");
				}
				else {
					log.error("QUE SEND INTERRUPTED DELETE FILE", "FAIL");
				}
			}
		}

		this.SPOOL_POPPER.close();
		this.SPOOL_POPPER = null;

		String TARGET_DONE_FILENAME = FileElement.CheckSubDirectory(END_BASE_DIR, Cal.getDayDate()) + File.separator + END_FILE_HEADER + Cal.getSerialDate() + END_FILE_EXT;

		// 작업 중 파일로 전환할 파일
		File _CHANGE_TARGET_FILE_ = new File(TARGET_DONE_FILENAME);

		// 작업 중 파일로 전환할 원본파일
		File _ORIGINAL_SOURCE_FILE_ = new File(this.TARGET_SENDING_FILENAME);

		// 원본 파일을 작업 중 파일로 전환
		if( _ORIGINAL_SOURCE_FILE_.renameTo(_CHANGE_TARGET_FILE_) ) {
			if (log.isDebugEnabled()) 
				log.debug("Transfer Sending -> Done Success from=>" + _ORIGINAL_SOURCE_FILE_.getPath() + " To=>" + _CHANGE_TARGET_FILE_.getPath());
		}
		else {
			log.error( "Transfer Sending -> Done Fail from=>" + _ORIGINAL_SOURCE_FILE_.getPath() + " To=>" + _CHANGE_TARGET_FILE_.getPath());
		}
	}

	protected void execute_ListMake() throws Exception {
		// do nothing
	}

	protected void execute_ContentLoad() throws Exception {
		// do nothing
	}

	protected void execute_Finish() throws Exception {
		// do nothing
	}

	/**
	 * 리스트를 뿌리러 들어갈때 실행
	 */
	protected void execute_Startup() throws Exception {
		// do nothing
	}

	/**
	 * 발송 정지 상태를 점검하고 정지되었다면 로그를 작성한다.
	 */
	protected boolean execute_StopCheck() {
		if( QUE_SEND_INTERRUPT_FLAG ) {
			QUE_SEND_INTERRUPT_FLAG = false;
			return true;
		}
		return false;
	}

	/**
	 * 지정된 도메인의 BufferedPool을 반환한다.
	 */
	protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
		BufferedAgentPool pool = BufferedAgentPool.getBufferedObjectPool("queue", domain);
		if( pool == null ) {
			pool = BufferedAgentPool.getBufferedObjectPool("single", domain);
		}
		return pool;
	}

	/**
	 * Syntax Error 스풀을 처리한다. 여기는 한번 필터링 된녀석들이 오기 때문에 있을수가 없다. 하지만 .. 만약 여기에 온다면 그건 앞에 프로그램이 잘못된것인다.
	 */
	protected void processSyntaxErrorSpool(String spool) throws Exception {
		log.error("que syntax error?", spool);
	}

	protected void passDomainNotFound(String spool, Throwable e) throws Exception {
		log.error("que dns error?", spool.concat("=>").concat(e.toString()));
	}

	protected void passRejectDomain(String spool) throws Exception {
		// do nothing...
		// 큐발송에서 제거되면 그냥 조용히 없어진다.
	}
}
