/*
 * @(#)ScheduleCheckTask.java            2004. 12. 9.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.common.task;

import java.util.List;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.FileElement;
import pluto.io.eMsFileWriter;
import pluto.lang.eMsTypes;
import pluto.mail.MailSendingInstanceFactory;
import pluto.reporter.Reporter;
import pluto.schedule.AlreadyRegistTaskException;
import pluto.schedule.Task;
import pluto.schedule.TaskManager;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;

/**
 * Class description :
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class ScheduleCheckTask extends pluto.schedule.Task {

	/**
	 * 대상이 되는 스케쥴을 선정하는 쿼리
	 */
	public static String		QUERY_SELECT_TARGET_SCHEDULE		= null;
	
	/**
	 * 대상이 되는 컨텐트를 가져오는 쿼리 LONG or BLOB 타입에 컨텐트가 몽땅 들어올때를 대비한
	 */
	public static String		QUERY_SELECT_TARGET_CONTENT			= null;

	/**
	 * 테스트 발송 타겟을 결정한다.
	 */
	public static String		QUERY_SELECT_TEST_SCHEDULE			= null;

	/**
	 * 대상이 되는 테스트 컨텐트를 가져오는 쿼리 LONG or BLOB 타입에 컨텐트가 몽땅 들어올때를 대비한
	 */
	public static String		QUERY_SELECT_TEST_CONTENT			= null;

	/**
	 * 테스트 발송 타겟을 결정한다.
	 */
	public static String		QUERY_SELECT_WF_TEST_SCHEDULE			= null;

	/**
	 * 대상이 되는 테스트 컨텐트를 가져오는 쿼리 LONG or BLOB 타입에 컨텐트가 몽땅 들어올때를 대비한
	 */
	public static String		QUERY_SELECT_WF_TEST_CONTENT			= null;
	
	/**
	 * 20테이블의 상태값을 업데이트 한다.
	 */
	protected static List		QUERY_LIST_UPDATE_TARGET_SCHEDULE	= null;

	/**
	 * 일단 가지고온 리스트를 마킹하기 위한 쿼리
	 */
	protected static List		QUERY_LIST_UPDATE_TEST_SCHEDULE		= null;
	
	/**
	 * 일단 가지고온 리스트를 마킹하기 위한 쿼리
	 */
	protected static List		QUERY_LIST_UPDATE_WF_TEST_SCHEDULE		= null;

	/**
	 * 컨텐트를 파싱한 결과를 저장하는 디렉토리
	 */
	public static String		CONTENTS_STORE_DIRECTORY			= null;
	
	public String				MAIL_ID = "";
	
	public static String		QUERY_SELECT_TARGET_AB_TIME_SCHEDULE = null;
	//public static String 		QUERY_SELECT_AB_TIME_CHECK = null;
	//public static String 		QUERY_UPDATE_SCHEDULE_REQDATE_INFO_TOMORROW = null;
	//public static String		QUERY_UPDATE_SCHEDULE_REQDATE_INFO_TODAY = null;
	public static String 		QUERY_UPDATE_AB_INFO = null;
	public static String		QUERY_SEND_TYPE_CHECK = null;

	/**
	 * 구동에 필요한 기본 static 변수의 초기화
	 */
	static {
		try {
			QUERY_SELECT_TARGET_SCHEDULE = SqlManager.getQuery("MAIN_SCHEDULE_CHECK", "QUERY_SELECT_TARGET_SCHEDULE");
			QUERY_SELECT_TARGET_CONTENT = SqlManager.getQuery("MAIN_SCHEDULE_CHECK", "QUERY_SELECT_TARGET_CONTENT");
			QUERY_LIST_UPDATE_TARGET_SCHEDULE = SqlManager.getMultiQuery("MAIN_SCHEDULE_CHECK", "QUERY_LIST_UPDATE_TARGET_SCHEDULE");

			QUERY_SELECT_TEST_SCHEDULE = SqlManager.getQuery("MAIN_SCHEDULE_CHECK", "QUERY_SELECT_TEST_SCHEDULE");
			QUERY_SELECT_TEST_CONTENT = SqlManager.getQuery("MAIN_SCHEDULE_CHECK", "QUERY_SELECT_TEST_CONTENT");
			QUERY_LIST_UPDATE_TEST_SCHEDULE = SqlManager.getMultiQuery("MAIN_SCHEDULE_CHECK", "QUERY_LIST_UPDATE_TEST_SCHEDULE");
			
			QUERY_SELECT_WF_TEST_SCHEDULE = SqlManager.getQuery("MAIN_SCHEDULE_CHECK", "QUERY_SELECT_WF_TEST_SCHEDULE");
			QUERY_SELECT_WF_TEST_CONTENT = SqlManager.getQuery("MAIN_SCHEDULE_CHECK", "QUERY_SELECT_WF_TEST_CONTENT");
			QUERY_LIST_UPDATE_WF_TEST_SCHEDULE = SqlManager.getMultiQuery("MAIN_SCHEDULE_CHECK", "QUERY_LIST_UPDATE_WF_TEST_SCHEDULE");
			
			QUERY_SELECT_TARGET_AB_TIME_SCHEDULE = SqlManager.getQuery("MAIN_SCHEDULE_CHECK","QUERY_SELECT_TARGET_AB_TIME_SCHEDULE");
			QUERY_UPDATE_AB_INFO = SqlManager.getQuery("MAIN_SCHEDULE_CHECK","QUERY_UPDATE_AB_INFO");
			QUERY_SEND_TYPE_CHECK = SqlManager.getQuery("MAIN_SCHEDULE_CHECK","QUERY_SEND_TYPE_CHECK");

			CONTENTS_STORE_DIRECTORY = eMsSystem.getProperty("content.store.directory");
		}
		catch(Exception e) {
			log.error(e.getMessage());
			System.exit(1);
		}
	}

	protected eMsConnection		EMS_CONNECTION						= null;

	protected eMsStatement		__SELECT_STATEMENT__				= null;

	protected eMsStatement		__EMS_EXEC_STATEMENT__				= null;
	
	protected eMsStatement		__SELECT_AB_TIME_CHK_STATEMENT__	= null;
	
	protected eMsStatement		__SEND_TYPE_CHECK__					= null;

	/** Creates a new instance of ScheduleCheckTask */
	public ScheduleCheckTask() {
		super(TYPE_INTERVAL);
		this.setName("ScheduleCheckTask_at_".concat(Cal.getSerialDate()));
		this.setTaskID("ScheduleCheckTask");
	}

	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록
	 * 되어있다.
	 */
	public void execute_initiate() throws Exception {
		this.setName("ScheduleCheckTask_at_".concat(Cal.getSerialDate()));
		if (log.isDebugEnabled()) {
			log.debug("execute_initiate");
		}

		EMS_CONNECTION = ConnectionPool.getConnection();
		try {
			__SELECT_STATEMENT__ = EMS_CONNECTION.createStatement();
		} catch (Exception e) {
			EMS_CONNECTION = ConnectionPool.getConnection();
			__SELECT_STATEMENT__ = EMS_CONNECTION.createStatement();
		}
		
		__EMS_EXEC_STATEMENT__ = EMS_CONNECTION.createStatement();
		__SELECT_AB_TIME_CHK_STATEMENT__ = EMS_CONNECTION.createStatement();
		__SEND_TYPE_CHECK__ = EMS_CONNECTION.createStatement();
	}

	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
		log.error(" Request Connection Error", thw);
	}

	/**
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. 할당받은 자원을 free 시키는 로직을 구현한다.
	 * execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {
		
		if( EMS_CONNECTION != null ) {
			EMS_CONNECTION.recycleStatement(__SELECT_STATEMENT__);
			EMS_CONNECTION.recycleStatement(__EMS_EXEC_STATEMENT__);
			EMS_CONNECTION.recycleStatement(__SELECT_AB_TIME_CHK_STATEMENT__);
			EMS_CONNECTION.recycleStatement(__SEND_TYPE_CHECK__);
			EMS_CONNECTION.recycle();
		}
	}

	/**
	 * 실제적인 일을 처리하는 비지니스로직
	 * 
	 * @return true : 성공적인 수행 <br>
	 *         false : 수행 실패
	 */
	@Override
	public void execute() throws Exception {
		
		execute_createTask(QUERY_SELECT_TARGET_SCHEDULE, QUERY_SELECT_TARGET_CONTENT, QUERY_LIST_UPDATE_TARGET_SCHEDULE);
		if (log.isDebugEnabled()) {
			log.debug("execute execute_createTestTask method...[OK]");
		}
		//테스트 스케쥴 쿼리가 없다면 그냥 돌아가야하지 않을까요?
		if( QUERY_SELECT_TEST_SCHEDULE == null || QUERY_LIST_UPDATE_TEST_SCHEDULE == null ) {
			return;
		}

		execute_createTask(QUERY_SELECT_TEST_SCHEDULE, QUERY_SELECT_TEST_CONTENT, QUERY_LIST_UPDATE_TEST_SCHEDULE);
		if (log.isDebugEnabled()) {
			log.debug("execute execute_createTestTask method...[OK]");
		}
		
		//테스트 스케쥴 쿼리가 없다면 그냥 돌아가야하지 않을까요?
		if( QUERY_SELECT_WF_TEST_SCHEDULE == null || QUERY_LIST_UPDATE_WF_TEST_SCHEDULE == null ) {
			return;
		}

		execute_createTask(QUERY_SELECT_WF_TEST_SCHEDULE, QUERY_SELECT_WF_TEST_CONTENT, QUERY_LIST_UPDATE_WF_TEST_SCHEDULE);
		if (log.isDebugEnabled()) {
			log.debug("execute execute_createTestTask method...[OK]");
		}
	}

	/**
	 * 조건에 걸리는 녀석들을 집어 내어 MakeSendInfoTask 로 만들어 TaskManager에 등록을 한다. step :
	 * START 에서 실행 된다.
	 */
	private synchronized void execute_createTask(String TARGET_QUERY, String CONTENT_QUERY, List UPDATE_QUERY) throws Exception {

		eMsResultSet __RESULT_OF_SCHEDULE__ = null;
		
		eMsResultSet __RESULT_AB_TIME = null;
		eMsResultSet __RESULT_TYPE_CHK = null;

		StringBuffer buffer = new StringBuffer(256);
		StringBuffer buffer_ab = new StringBuffer(256);
		StringBuffer buffer_date = new StringBuffer(256);
		try {
			//AB-TEST TIME CHECK START
			String s_Type_chk = "";
			if(QUERY_SEND_TYPE_CHECK != null){
				__RESULT_TYPE_CHK = __SEND_TYPE_CHECK__.executeQuery(QUERY_SEND_TYPE_CHECK);
				
				if(__RESULT_TYPE_CHK.next()){
					s_Type_chk = __RESULT_TYPE_CHK.getString("SEND_CHK");
				}
			}
			
			if(s_Type_chk.length() == 13){ // 자동과 같이 쓰는 관계로 대량메일이 스케쥴에 걸릴경우만 실행한다.
				//boolean b_Time_chk = false;
				boolean b_Time_chk = true;
				
				__RESULT_AB_TIME = __SELECT_AB_TIME_CHK_STATEMENT__.executeQuery(QUERY_SELECT_TARGET_AB_TIME_SCHEDULE);
				Properties AB_INFO = new Properties();
				while(__RESULT_AB_TIME.next()){
					__RESULT_AB_TIME.putToMap(AB_INFO, false);
					
					//판단 유형 업데이트 
					if(!AB_INFO.getProperty("AB_TYPE").equals("") && AB_INFO.getProperty("AB_ID").equals("RS") && b_Time_chk){
						eMsStatement __UPDATE_AB_STATEMENT__ = null;
						try{
							buffer_date.setLength(0);
							__UPDATE_AB_STATEMENT__ =  EMS_CONNECTION.createStatement();
							StringConvertUtil.ConvertString(buffer_date,QUERY_UPDATE_AB_INFO, AB_INFO,"${","}",true,false);
							__UPDATE_AB_STATEMENT__.executeUpdate(buffer_date.toString());
							buffer_ab.setLength(0);
							buffer_date.setLength(0);
							
						}catch(Exception e){
							log.error("UPDATE_AB_INFO error", e);
						}finally{
							if(__UPDATE_AB_STATEMENT__ != null){
								EMS_CONNECTION.recycleStatement(__UPDATE_AB_STATEMENT__);
							}
						}
					}
				
				}
			}
			
			//AB-TEST TIME CHECK END
			
			// 기본 정보를 가져 온다...
			if( log.isDebugEnabled() ){
				log.debug("exec=>" + TARGET_QUERY);
			}
			__RESULT_OF_SCHEDULE__ = __SELECT_STATEMENT__.executeQuery(TARGET_QUERY);
			if( log.isDebugEnabled() ){
				log.debug("exec=>[OK]");
			}

			/**
			 * 각 스케쥴에 대해서 패치하여 스케쥴 생성하기
			 */
			while (__RESULT_OF_SCHEDULE__.next()) {
				Properties SCHEDULE_INFO = new Properties();

				__RESULT_OF_SCHEDULE__.putToMap(SCHEDULE_INFO, false);
				
				MAIL_ID = SCHEDULE_INFO.getProperty("MAIL_ID", "NO ID");

				// CONTENT_ROOT가 데이터 베이스일 경우에는 데이터 베이스의 내용을 파일로 저장하고 그 경로를
				// CONTENT에 저장한다.
				if( SCHEDULE_INFO.getProperty("CONTENT_ROOT", "WEB").equalsIgnoreCase("DB") ) {
					eMsStatement __CONTENT_STATEMENT__ = null;
					eMsResultSet __RESULT_OF_CONTENT__ = null;
					String __REAL_CONTENTS__ = null;
					try {
						__CONTENT_STATEMENT__ = EMS_CONNECTION.createStatement();
						buffer.setLength(0);
						StringConvertUtil.ConvertString(buffer, CONTENT_QUERY, SCHEDULE_INFO, "${", "}", true, false);
						if( log.isDebugEnabled() ){
							log.debug("exec=>" + buffer.toString());
						}
						__RESULT_OF_CONTENT__ = __CONTENT_STATEMENT__.executeQuery(buffer.toString());
						if( log.isDebugEnabled() ){
							log.debug("exec=>[OK]");
						}
						if( __RESULT_OF_CONTENT__.next() ) {
							__REAL_CONTENTS__ = __RESULT_OF_CONTENT__.getCharStreamAsString(1);
							if (log.isDebugEnabled()) {
								log.debug("CONTENT=>", __REAL_CONTENTS__);
							}
						}
						else {
							//만일 컨텐트가 없다면? 에러마킹하고 돌아가야한다.
							log.error("DB CONTENT GET no content next");
							SCHEDULE_INFO.setProperty("UPDATE_JOB_STATUS", "41");
							// 반복 루틴 내부의 사용이 아니므로 그대로 사용한다. 2004.11.01
							EMS_CONNECTION.executeUpdateList(UPDATE_QUERY, SCHEDULE_INFO, "${", "}", false);
							continue;
						}
					}
					catch(Exception ex) {
						log.error("content update error", ex);
						// 만일 컨텐트가 없다면? 에러마킹하고 돌아가야한다.
						SCHEDULE_INFO.setProperty("UPDATE_JOB_STATUS", "41");
						// 반복 루틴 내부의 사용이 아니므로 그대로 사용한다. 2004.11.01
						EMS_CONNECTION.executeUpdateList(UPDATE_QUERY, SCHEDULE_INFO, "${", "}", false);
						continue;
					}
					finally {
						if( __CONTENT_STATEMENT__ != null ) {
							EMS_CONNECTION.recycleStatement(__CONTENT_STATEMENT__);
						}
						if(__RESULT_OF_CONTENT__ != null){
							__RESULT_OF_CONTENT__.close();
						}
					}

					String __CONTENT_SAVE_FILE_NAME__ = FileElement.CheckSubDirectory(CONTENTS_STORE_DIRECTORY, Cal.getDayDate()) + "/"
							+ SCHEDULE_INFO.getProperty("POST_ID", Cal.getSerialDate()) + ".db";
					eMsFileWriter wt = null;
					try {
						wt = new eMsFileWriter(__CONTENT_SAVE_FILE_NAME__);
						wt.write(__REAL_CONTENTS__);
						wt.flush();
						//파일을 적었으면 파일 이름을 CONTENT에 설정해야한다.
						SCHEDULE_INFO.setProperty("CONTENT", "file://" + __CONTENT_SAVE_FILE_NAME__);
					}
					catch(Exception e) {
						log.error("content file write error", e);
						//파일적다가 에러가 나도 그냥 돌아가야한다.
						SCHEDULE_INFO.setProperty("UPDATE_JOB_STATUS", "41");
						// 반복 루틴 내부의 사용이 아니므로 그대로 사용한다. 2004.11.01
						EMS_CONNECTION.executeUpdateList(UPDATE_QUERY, SCHEDULE_INFO, "${", "}", false);
						continue;
					}
					finally {
						try {
							if(wt != null){
								wt.close();
							}
						}
						catch(Exception e) {
						}
					}
				}

				SCHEDULE_INFO.setProperty("UPDATE_JOB_STATUS", "--");

				if (log.isDebugEnabled()) {
					log.debug(" is create new MakeSendInfoTask " + SCHEDULE_INFO.getProperty("POST_ID"));
				}
				
				try {
					
					log.debug( SCHEDULE_INFO.toString()); 
					
					Task make_info = (Task) MailSendingInstanceFactory.getInstance(SCHEDULE_INFO, eMsTypes.SENDTASK_INSTANCE);

					log.info(" is Popup MailSendTask => " + SCHEDULE_INFO.getProperty("SEND_TYPE") + "_" + SCHEDULE_INFO.getProperty("SEND_STATE") + " =>" + make_info.getClass().getName());
					
					/**
					 * 발송 스케쥴을 초기화 한다.
					 */
					make_info.setTaskProperty(SCHEDULE_INFO);

					/**
					 * 등록한다.
					 */
					TaskManager.executeTask(make_info);
					// 반복 루틴 내부의 사용이 아니므로 그대로 사용한다. 2004.11.01
					
					// task 등록 성공시 update를 실행한다.
					EMS_CONNECTION.executeUpdateList(UPDATE_QUERY, SCHEDULE_INFO, "${", "}", false);
					// 병렬 발송 update시, 중복 업데이트 방지.
					
					//하나 등록하고 조금 쉰다.
					//테스트 발송중복되어 안될수도 있는문제를 해결하기 위해..
					try {
						wait(500);
					}
					catch(Exception e) {
					}
				} catch(AlreadyRegistTaskException e) {
					log.info("AlreadyRegistTaskException is skip [msg:{}]", e.getMessage());
				} catch (Exception e) {
					log.error("["+this.MAIL_ID+"] " + SCHEDULE_INFO.getProperty("POST_ID")+" "+getName()+" schedulechecktask.create.info.err");
					log.error(getName(), e);
				}
			}
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			try {
				if(__RESULT_OF_SCHEDULE__ != null){
					__RESULT_OF_SCHEDULE__.close();
				}
				if(__RESULT_AB_TIME != null){
					__RESULT_AB_TIME.close();
				}
				if(__RESULT_TYPE_CHK != null){
					__RESULT_TYPE_CHK.close();
				}
			}
			catch(Exception ignore) {
			}
		}
	}
}
