/*
 * @(#)RealTimeCheckTask.java            2011. 04. 05.
 *
 * Copyright (c) 1998-2011 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.common.task;

import java.util.LinkedList;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.lang.eMsTypes;
import pluto.mail.MailSendingInstanceFactory;
import pluto.schedule.AlreadyRegistTaskException;
import pluto.schedule.Task;
import pluto.schedule.TaskManager;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;

/**
 * Class description :
 * 
 * @version
 * @author dragon
 * 
 */
@Slf4j
public class RealTimeCheckTask extends pluto.schedule.Task {

	/**
	 * 대상이 되는 스케쥴을 선정하는 쿼리
	 */
	public static String		QUERY_SELECT_REAL_SEARCH_TARGET_SCHEDULE		= null;
	
	public static String		QUERY_SELECT_REAL_INPUT_TARGET_SCHEDULE		= null;

	public	static	String 		QUERY_SELECT_INIT_REALTIME_THREAD_STATUS_INFO		= null;
	
	public	static	String	QUERY_UPDATE_INIT_REALTIME_THREAD_STATUS_EACH = null; //실시간 thread status 정보 update
	
	public	static	String	QUERY_UPDATE_INIT_REALTIME_THREAD_STATUS_ALL = null; //실시간 thread status 정보 update
	
	private	static	int	schedule_count = 0;
	
	private	static	String	mail_thread_size = "";
	
	/**
	 * 구동에 필요한 기본 static 변수의 초기화
	 */
	static {
		try {
			QUERY_SELECT_REAL_SEARCH_TARGET_SCHEDULE = SqlManager.getQuery("MAIN_SCHEDULE_CHECK", "QUERY_SELECT_REAL_SEARCH_TARGET_SCHEDULE");
			QUERY_SELECT_REAL_INPUT_TARGET_SCHEDULE = SqlManager.getQuery("MAIN_SCHEDULE_CHECK", "QUERY_SELECT_REAL_INPUT_TARGET_SCHEDULE");
			QUERY_SELECT_INIT_REALTIME_THREAD_STATUS_INFO = SqlManager.getQuery("COMMON", "QUERY_SELECT_INIT_REALTIME_THREAD_STATUS_INFO");
			QUERY_UPDATE_INIT_REALTIME_THREAD_STATUS_EACH = SqlManager.getQuery("COMMON", "QUERY_UPDATE_INIT_REALTIME_THREAD_STATUS_EACH"); //초기 엔진 구동시 THREAD_STATUS 초기화.
			QUERY_UPDATE_INIT_REALTIME_THREAD_STATUS_ALL =  SqlManager.getQuery("COMMON", "QUERY_UPDATE_INIT_REALTIME_THREAD_STATUS_ALL"); //초기 엔진 구동시 THREAD_STATUS 초기화.
			
		}
		catch(Exception e) {
			log.error(e.getMessage());
			System.exit(1);
		}
	}

	protected 	eMsConnection		EMS_CONNECTION						= null;

	protected 	eMsStatement		__SELECT_SEARCH_STATEMENT__				= null;

	protected 	eMsStatement		__SELECT_INPUT_STATEMENT__				= null;

	public 		String				MAIL_ID = "";
	
	public 		static	String 				LIST_MAKER_CLASS_NAME = "";
	
	/** Creates a new instance of RealTimeCheckTask */
	public RealTimeCheckTask() {
		super(TYPE_INTERVAL);
		this.setName("RealTimeCheckTask_at_"+(System.currentTimeMillis() % 100000));
		this.setTaskID("RealTimeCheckTask");
	}

	/*
	 * update_init_thread_status() 함수는 init 함수 호출시 단 한번만 발생 되어야 함.
	 * 다른 곳에서 함수 호출은 금지.
	 */
	private static void update_init_thread_status() throws Exception{
		
		eMsConnection 	conn = null;
		eMsStatement 	select_stmt = null;
		eMsStatement 	stmt = null;
		eMsResultSet	rs = null;
		
		int schedule_count = 0;
		
		int RESULT_UPDATE = 0;
		try{
			conn = ConnectionPool.getConnection();
			stmt = conn.createStatement();
			select_stmt = conn.createStatement();
			
			rs = select_stmt.executeQuery(QUERY_SELECT_INIT_REALTIME_THREAD_STATUS_INFO);
			
			
			StringBuffer sb = new StringBuffer();
			Properties BASE_SCHDULE = new Properties();
			while(rs.next()){
				BASE_SCHDULE.clear();
				rs.putToMap(BASE_SCHDULE, false);
				
				//ConvertString 작업 진행하기.
				sb.setLength(0);
				StringConvertUtil.ConvertString(sb, QUERY_UPDATE_INIT_REALTIME_THREAD_STATUS_EACH, BASE_SCHDULE, "${", "}", true, false);
				RESULT_UPDATE = stmt.executeUpdate( sb.toString() );
				if( RESULT_UPDATE > 0 ){
					schedule_count++;
				}
			}// 이전 데이터에 대한 thread status 초기화 진행.
			
			if( Integer.parseInt(mail_thread_size) > schedule_count ){
				BASE_SCHDULE.clear();
				sb.setLength(0);
				
				int target_count = Integer.parseInt(mail_thread_size) - schedule_count;
				BASE_SCHDULE.setProperty( "MAX_SIZE", String.valueOf(target_count) );
				StringConvertUtil.ConvertString(sb, QUERY_UPDATE_INIT_REALTIME_THREAD_STATUS_ALL, BASE_SCHDULE, "${", "}", true, false);
				stmt.executeUpdate( sb.toString() );
			}// execute update ( up to max size )  
			
		} catch(Exception e){
			log.error("error", e);
			System.exit(1);//초기 init 시 thread_status 값을 초기화 하지 못할 경우, main_thread를 종료한다.
		} finally{
			// 2017.03.07
			if(rs != null){
				rs.close();
			}
			if(conn != null){
				conn.recycleStatement(select_stmt);
				conn.recycleStatement(stmt);
				conn.recycle();
			}
		}
	}
	
	
	public static void init(Object tmp) throws Exception {
		Properties prop = (Properties) tmp;
		
		//mercury.contents.auto.producer.RealtimeContentPD
		LIST_MAKER_CLASS_NAME = prop.getProperty("make.class");
		
		mail_thread_size = eMsSystem.getProperty("mail.thread.size", "30");//default size 30.
	
		//read file.
		
		try{
			
			//최초 구동시, EMS_AUTO_BASE_INFO 테이블의 THREAD_STATUS 값을 00 으로 초기화 한다.
			update_init_thread_status();
			
		} catch(Exception e){
			log.error(e.getMessage());
			System.exit(1);
		}
		
	}
	
	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록
	 * 되어있다.
	 */
	public void execute_initiate() throws Exception {
		this.setName("RealTimeCheckTask_at_".concat(Cal.getSerialDate()));
		if (log.isDebugEnabled()) {
			log.debug("execute_initiate" );//for health check
		}
		EMS_CONNECTION = ConnectionPool.getConnection();
		
		try {
			__SELECT_SEARCH_STATEMENT__ = EMS_CONNECTION.createStatement();
			__SELECT_INPUT_STATEMENT__ = EMS_CONNECTION.createStatement();
		} catch (Exception e) {
			EMS_CONNECTION = ConnectionPool.getConnection();
			__SELECT_SEARCH_STATEMENT__ = EMS_CONNECTION.createStatement();
			__SELECT_INPUT_STATEMENT__ = EMS_CONNECTION.createStatement();
		}
		
	}

	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	@Override
	public void execute_initiateError(Throwable thw) {
		log.error("execute_initiateError", thw);

		//REPORT 데이터베이스 커넥션을 가져오는 과정에서 에러가 발생하였습니다.
	}

	/**
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. 할당받은 자원을 free 시키는 로직을 구현한다.
	 * execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {
		if (log.isDebugEnabled()) {
			log.debug("release_Resource" );//for health check
		}
		if( EMS_CONNECTION != null ) {
			EMS_CONNECTION.recycleStatement(__SELECT_SEARCH_STATEMENT__);
			EMS_CONNECTION.recycleStatement(__SELECT_INPUT_STATEMENT__);
			EMS_CONNECTION.recycle();
		}
	}

	
	/**
	 * 실제적인 일을 처리하는 비지니스로직
	 * 
	 * @return true : 성공적인 수행 <br>
	 *         false : 수행 실패
	 */
	@Override
	public void execute() throws Exception {
		execute_createTask( QUERY_SELECT_REAL_SEARCH_TARGET_SCHEDULE, QUERY_SELECT_REAL_INPUT_TARGET_SCHEDULE  );
		if (log.isDebugEnabled()) {
			log.debug("execute_createTask END");
		}
	}

	/**
	 * 조건에 걸리는 녀석들을 집어 내어 MakeSendInfoTask 로 만들어 TaskManager에 등록을 한다. step :
	 * START 에서 실행 된다.
	 */
	private synchronized void execute_createTask(String TARGET_SEARCH_QUERY, String TARGET_INPUT_QUERY) throws Exception {

		eMsResultSet __RESULT_OF_SEARCH_SCHEDULE__ = null;

		eMsResultSet __RESULT_OF_INPUT_SCHEDULE__ = null;

		try {
			__RESULT_OF_SEARCH_SCHEDULE__ = __SELECT_SEARCH_STATEMENT__.executeQuery(TARGET_SEARCH_QUERY);
			
			__RESULT_OF_INPUT_SCHEDULE__ = __SELECT_INPUT_STATEMENT__.executeQuery(TARGET_INPUT_QUERY);
			
			/**
			 * 실시간 검색
			 */
			
			/** 발송 리스트(실시간 검색) */			
			LinkedList			TARGET_SCHEDULE_SEARCH_LIST					=null;

			/** 발송 리스트(실시간 입력) */
			LinkedList			TARGET_SCHEDULE_INPUT_LIST					= null;

			String str = String.valueOf( System.nanoTime() );
			schedule_count = 0; //init thread count.
			
			while (__RESULT_OF_SEARCH_SCHEDULE__.next()) {
				schedule_count++;
				if( Integer.parseInt(mail_thread_size) >= schedule_count ){

					TARGET_SCHEDULE_SEARCH_LIST					= new LinkedList();
					
					Properties SCHEDULE_SEARCH_INFO = new Properties();
					
					SCHEDULE_SEARCH_INFO.setProperty("SEND_TYPE", "O");
					SCHEDULE_SEARCH_INFO.setProperty("SEND_STATE", "REAL");
					SCHEDULE_SEARCH_INFO.setProperty("LIST_MAKER", LIST_MAKER_CLASS_NAME );
					
					MAIL_ID = SCHEDULE_SEARCH_INFO.getProperty("MAIL_ID","NO ID");
					
					__RESULT_OF_SEARCH_SCHEDULE__.putToMap(SCHEDULE_SEARCH_INFO, false);
					TARGET_SCHEDULE_SEARCH_LIST.add(SCHEDULE_SEARCH_INFO);
					
					try {
						Task make_info = (Task) MailSendingInstanceFactory.getInstance(SCHEDULE_SEARCH_INFO, eMsTypes.SENDTASK_INSTANCE);

						/**
						 * 발송 스케쥴을 초기화 한다.
						 */
						make_info.setTaskProperty(SCHEDULE_SEARCH_INFO);
						/**
						 * 등록한다.
						 */
						
						TaskManager.executeTask(make_info);
						
						try {
							wait(500);
						} catch(Exception e) { }
					} catch(AlreadyRegistTaskException e) {
						log.info("AlreadyRegistTaskException is skip [msg:{}]", e.getMessage());
					} catch (Exception e) {
						log.error(getName(), e);
					}
				}
			}// REALTIME SEARCH
			
			
			/**
			 * 실시간 입력
			 */
			while (__RESULT_OF_INPUT_SCHEDULE__.next()) {

				schedule_count++;
				if( Integer.parseInt(mail_thread_size) >= schedule_count ){
					TARGET_SCHEDULE_INPUT_LIST					= new LinkedList();
					
					Properties SCHEDULE_INPUT_INFO = new Properties();
					
					SCHEDULE_INPUT_INFO.setProperty("SEND_TYPE", "O");
					SCHEDULE_INPUT_INFO.setProperty("SEND_STATE", "REAL");
					MAIL_ID = SCHEDULE_INPUT_INFO.getProperty("MAIL_ID","NO ID");
					SCHEDULE_INPUT_INFO.setProperty("LIST_MAKER", LIST_MAKER_CLASS_NAME );
					__RESULT_OF_INPUT_SCHEDULE__.putToMap(SCHEDULE_INPUT_INFO, false);
					TARGET_SCHEDULE_INPUT_LIST.add(SCHEDULE_INPUT_INFO);
					try {
						
						Task make_info = (Task) MailSendingInstanceFactory.getInstance(SCHEDULE_INPUT_INFO, eMsTypes.SENDTASK_INSTANCE);
						
						/**
						 * 발송 스케쥴을 초기화 한다.
						 */
						make_info.setTaskProperty(SCHEDULE_INPUT_INFO);
						
						/**
						 * 등록한다.
						 */
						TaskManager.executeTask(make_info);
						
						
						try {
							wait(500);
						}
						catch(Exception e) {
							
						}
					} catch(AlreadyRegistTaskException e) {
						log.error("AlreadyRegistTaskException is skip");
					} catch (Exception e) {
						log.error(getName(), e);
					}
				}// REALTIME INPUT
			}
		}
		catch(Exception e) {
			log.error("error", e);
			throw e;
		}
		finally {
			try {
				
				if(__RESULT_OF_SEARCH_SCHEDULE__ != null){
					__RESULT_OF_SEARCH_SCHEDULE__.close();
				}
				if(__RESULT_OF_INPUT_SCHEDULE__ != null){
					__RESULT_OF_INPUT_SCHEDULE__.close();
				}
				
			}
			catch(Exception ignore) {
			}
		}
	}
}
