/*
 * @(#)CommonStepMailSendTask.java            2004. 12. 3.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.common.task;

import java.util.Iterator;
import java.util.List;

import jupiter.common.actor.ListMaker;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsStatement;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsTypes;
import pluto.log.SmtpLogger;
import pluto.mail.MailSendingInstanceFactory;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;

/**
 * 메일 발송에서 단계별 로그 작성의 기본 방법을 정의한다.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public abstract class CommonStepMailSendTask extends AbstractDBMailSendTask {
	

	/**
	 * 스케쥴 테이블 상태값 업데이트 상속받은 녀석들은 이것을 알아서 세팅 해야한다.
	 */
	protected List					INSTANCE_QUERY_UPDATE_STATE_INFO	= null;

	/** Creates a new instance of CommonStepMailSendTask */
	public CommonStepMailSendTask() throws Exception {
		this(TYPE_TRANSACTION, DEFAULT_EXECUTE_INTERVAL);
		if (log.isDebugEnabled()) {
			// foo
		}
	}

	/** Creates a new instance of CommonStepMailSendTask */
	public CommonStepMailSendTask(short type) throws Exception {
		this(type, DEFAULT_EXECUTE_INTERVAL);
	}

	/** Creates a new instance of CommonStepMailSendTask */
	public CommonStepMailSendTask(short type, long interval) throws Exception {
		super(type, interval);
	}

	/**
	 * ListMaker Instance를 생성시켜 Call 해준다.
	 */
	protected void execute_ListMake() throws Exception {

		ListMaker targetMaker = (ListMaker) MailSendingInstanceFactory.getInstance(this.TASK_PROPERTY, eMsTypes.LISTMAKER_INSTANCE);
		targetMaker.process(this.TASK_PROPERTY);
	}

	/**
	 * 메일의 상태값을 바꾼다.
	 */
	protected void updateTaskState(String __TYPE__, String __STATE__) {
		updateTaskState(__TYPE__, __STATE__, "StateUpdate");
	}

	/**
	 * 메일의 상태값을 바꾸면서 특정 메세지를 같이 남길때 사용한다. add 2004.11.02
	 */
	protected void updateTaskState(String __TYPE__, String __STATE__, String __STATE_MSG__) {

		// 상태값 업데이트
		synchronized (this.composer.getLock()) {
			this.composer.setProperty(LOG_SEND_TYPE, "SYSTEM");
			this.composer.setProperty(LOG_T_TYPE, __TYPE__);
			this.composer.setProperty(LOG_T_CODE, __STATE__);
			this.composer.setProperty(LOG_MAIL_ID, this.POST_ID);
			this.composer.setProperty(LOG_MEMBER_ID, "noid");
			this.composer.setProperty(LOG_STEP, "0");
			this.composer.setProperty(LOG_T_DATE, Cal.getDate());
			this.composer.setProperty(LOG_MX_RECORD, "");
			this.composer.setProperty(LOG_DELAY, "");
			this.composer.setProperty(LOG_TOKEN_ID, "noemail");
			this.composer.setProperty(LOG_DOMAIN, "");
			this.composer.setProperty(LOG_WORKER, getName());
			this.composer.setProperty(LOG_ETC_LOG, __STATE_MSG__);
			this.composer.setProperty(LOG_LIST_TABLE, "n");

			SmtpLogger.put(this.composer);
		}

		this.TASK_PROPERTY.setProperty("UPDATE_JOB_STATUS", __STATE__);

		// 반복 루틴을 하나의 STMT로 처리하도록 전환 2004.11.02
		eMsConnection emsConnection = null; 
		eMsStatement stmt = null;

		// 2017.04.21
		synchronized (INSTANCE_QUERY_UPDATE_STATE_INFO) {
			try {
				emsConnection = ConnectionPool.getConnection();
				stmt = emsConnection.createStatement();
	
				// 반복 루틴 내부의 사용이 아니므로 그대로 사용하지만 쿼리를 만드는 것은 버퍼를 사용하도록 전환한다.
				// 2004.11.02
	
					for (Iterator iter = this.INSTANCE_QUERY_UPDATE_STATE_INFO.iterator(); iter.hasNext();) {
						String query = iter.next().toString();
	
						this.TMP_STRING_BUFFER.setLength(0);
						StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, query, this.TASK_PROPERTY, "${", "}", true, false);
						stmt.executeUpdate(this.TMP_STRING_BUFFER.toString());
					}
				}
			catch(Exception e) {
				log.error(getName(), e);
			}
			finally {
				if(emsConnection != null) {
					emsConnection.recycleStatement(stmt);
					emsConnection.recycle();	
				}
			}
		}
	}

	/**
	 * 메인 프로세스를 실행하다가 에러가 발생하면 실행되는루틴 41-95의 에러 처리를 해 준다.
	 */
	@Override
	public void doErrorProcess(Throwable thr) {

		updateTaskState("41", "41", StringUtil.nl2blank(thr.toString()));
		super.doErrorProcess(thr);
	}

	/**
	 * Syntax Error의 경우 54-00의 시작과 55-10의 에러 처리가 순차적으로 이루어진다.
	 */
	protected void processSyntaxErrorSpool(String spool) throws Exception {

		this.SPOOL_ANALYZER.parse(spool);

		if( this.SPOOL_ANALYZER.getIntStep() == 0 ) {
			synchronized (this.composer.getLock()) {
				this.composer.setProperty(LOG_SEND_TYPE, this.SPOOL_ANALYZER.getSendType());
				this.composer.setProperty(LOG_T_TYPE, "54");
				this.composer.setProperty(LOG_T_CODE, "00");
				this.composer.setProperty(LOG_MAIL_ID, this.SPOOL_ANALYZER.getPostID());
				this.composer.setProperty(LOG_MEMBER_ID, this.SPOOL_ANALYZER.getMemberID());
				this.composer.setProperty(LOG_STEP, this.SPOOL_ANALYZER.getStep());
				this.composer.setProperty(LOG_T_DATE, Cal.getDate());
				this.composer.setProperty(LOG_MX_RECORD, "");
				this.composer.setProperty(LOG_DELAY, "");
				//samsunglife
				//this.composer.setProperty(LOG_EMAIL_ID, this.SPOOL_ANALYZER.getEmailID());
				this.composer.setProperty(LOG_TOKEN_ID, this.SPOOL_ANALYZER.getProperty(LOG_TOKEN_ENCRYPT));
				this.composer.setProperty(LOG_DOMAIN, "");
				this.composer.setProperty(LOG_WORKER, getName());
				this.composer.setProperty(LOG_LIST_TABLE, this.SPOOL_ANALYZER.getListTable());
				this.composer.setProperty(LOG_ETC_LOG, "250 Strart");

				SmtpLogger.put(this.composer);
			}
		}

		synchronized (this.composer.getLock()) {
			this.composer.setProperty(LOG_SEND_TYPE, this.SPOOL_ANALYZER.getSendType());
			this.composer.setProperty(LOG_T_TYPE, "55");
			this.composer.setProperty(LOG_T_CODE, "10");
			this.composer.setProperty(LOG_MAIL_ID, this.SPOOL_ANALYZER.getPostID());
			this.composer.setProperty(LOG_MEMBER_ID, this.SPOOL_ANALYZER.getMemberID());
			this.composer.setProperty(LOG_STEP, this.SPOOL_ANALYZER.getStep());
			this.composer.setProperty(LOG_T_DATE, Cal.getDate());
			this.composer.setProperty(LOG_MX_RECORD, "SYNTAX_ERROR");
			this.composer.setProperty(LOG_DELAY, "0");
			//samsunglife
			//this.composer.setProperty(LOG_EMAIL_ID, this.SPOOL_ANALYZER.getEmailID());
			this.composer.setProperty(LOG_TOKEN_ID, this.SPOOL_ANALYZER.getProperty(LOG_TOKEN_ENCRYPT));
			this.composer.setProperty(LOG_DOMAIN, "SYNTAX_ERROR");
			this.composer.setProperty(LOG_WORKER, getName());
			this.composer.setProperty(LOG_ETC_LOG, "550 Syntax Error");
			this.composer.setProperty(LOG_LIST_TABLE, this.SPOOL_ANALYZER.getListTable());

			SmtpLogger.put(this.composer);
		}
	}

	/**
	 * Domain이 없는 경우 54-00의 시작과 55-20의 에러 처리가 순차적으로 이루어진다.
	 */
	protected void passDomainNotFound(String spool, Throwable e) throws Exception {
		this.SPOOL_ANALYZER.parse(spool);

		if( this.SPOOL_ANALYZER.getIntStep() == 0 ) {
			synchronized (this.composer.getLock()) {
				this.composer.setProperty(LOG_SEND_TYPE, this.SPOOL_ANALYZER.getSendType());
				this.composer.setProperty(LOG_T_TYPE, "54");
				this.composer.setProperty(LOG_T_CODE, "00");
				this.composer.setProperty(LOG_MAIL_ID, this.SPOOL_ANALYZER.getPostID());
				this.composer.setProperty(LOG_MEMBER_ID, this.SPOOL_ANALYZER.getMemberID());
				this.composer.setProperty(LOG_STEP, this.SPOOL_ANALYZER.getStep());
				this.composer.setProperty(LOG_T_DATE, Cal.getDate());
				this.composer.setProperty(LOG_MX_RECORD, "no mx recored");
				this.composer.setProperty(LOG_DELAY, "0");
				//samsunglife
				//this.composer.setProperty(LOG_EMAIL_ID, this.SPOOL_ANALYZER.getEmailID());
				this.composer.setProperty(LOG_TOKEN_ID, this.SPOOL_ANALYZER.getProperty(LOG_TOKEN_ENCRYPT));
				this.composer.setProperty(LOG_DOMAIN, "no domain");
				this.composer.setProperty(LOG_WORKER, getName());
				this.composer.setProperty(LOG_LIST_TABLE, this.SPOOL_ANALYZER.getListTable());
				//		this.composer.setProperty( Log.SPOOL_LOG ,"" );
				this.composer.setProperty(LOG_ETC_LOG, "250 Strart");

				SmtpLogger.put(this.composer);
			}
		}

		synchronized (this.composer.getLock()) {
			this.composer.setProperty(LOG_SEND_TYPE, this.SPOOL_ANALYZER.getSendType());
			this.composer.setProperty(LOG_T_TYPE, "55");
			this.composer.setProperty(LOG_T_CODE, "20");
			this.composer.setProperty(LOG_MAIL_ID, this.SPOOL_ANALYZER.getPostID());
			this.composer.setProperty(LOG_MEMBER_ID, this.SPOOL_ANALYZER.getMemberID());
			this.composer.setProperty(LOG_STEP, this.SPOOL_ANALYZER.getStep());
			this.composer.setProperty(LOG_T_DATE, Cal.getDate());
			this.composer.setProperty(LOG_MX_RECORD, "no mx record");
			this.composer.setProperty(LOG_DELAY, "0");
			//samsunglife
			//this.composer.setProperty(LOG_EMAIL_ID, this.SPOOL_ANALYZER.getEmailID());
			this.composer.setProperty(LOG_TOKEN_ID, this.SPOOL_ANALYZER.getProperty(LOG_TOKEN_ENCRYPT));
			this.composer.setProperty(LOG_DOMAIN, "no domain");
			this.composer.setProperty(LOG_WORKER, getName());
			//		this.composer.setProperty( Log.SPOOL_LOG ,"" );
			this.composer.setProperty(LOG_ETC_LOG, "550 ".concat(e.toString()));
			this.composer.setProperty(LOG_LIST_TABLE, this.SPOOL_ANALYZER.getListTable());

			SmtpLogger.put(this.composer);
		}
	}

	/**
	 * 접속 거부 당한 도메인의 경우 54-00의 시작과 55-30의 에러 처리가 순차적으로 이루어진다.
	 */
	protected void passRejectDomain(String spool) throws Exception {

		this.SPOOL_ANALYZER.parse(spool);

		if( this.SPOOL_ANALYZER.getIntStep() == 0 ) {
			synchronized (this.composer.getLock()) {
				this.composer.setProperty(LOG_SEND_TYPE, this.SPOOL_ANALYZER.getSendType());
				this.composer.setProperty(LOG_T_TYPE, "54");
				this.composer.setProperty(LOG_T_CODE, "00");
				this.composer.setProperty(LOG_MAIL_ID, this.SPOOL_ANALYZER.getPostID());
				this.composer.setProperty(LOG_MEMBER_ID, this.SPOOL_ANALYZER.getMemberID());
				this.composer.setProperty(LOG_STEP, this.SPOOL_ANALYZER.getStep());
				this.composer.setProperty(LOG_T_DATE, Cal.getDate());
				this.composer.setProperty(LOG_MX_RECORD, "NC");
				this.composer.setProperty(LOG_DELAY, "0");
				//samsunglife
				//this.composer.setProperty(LOG_EMAIL_ID, this.SPOOL_ANALYZER.getEmailID());
				this.composer.setProperty(LOG_TOKEN_ID, this.SPOOL_ANALYZER.getProperty(LOG_TOKEN_ENCRYPT));
				this.composer.setProperty(LOG_DOMAIN, this.SPOOL_ANALYZER.getDomain());
				this.composer.setProperty(LOG_WORKER, getName());
				this.composer.setProperty(LOG_LIST_TABLE, this.SPOOL_ANALYZER.getListTable());
				//		this.composer.setProperty( Log.SPOOL_LOG ,"" );
				this.composer.setProperty(LOG_ETC_LOG, "250 Strart");

				SmtpLogger.put(this.composer);
			}
		}

		synchronized (this.composer.getLock()) {
			this.composer.setProperty(LOG_SEND_TYPE, this.SPOOL_ANALYZER.getSendType());
			this.composer.setProperty(LOG_T_TYPE, "55");
			this.composer.setProperty(LOG_T_CODE, "30");
			this.composer.setProperty(LOG_MAIL_ID, this.SPOOL_ANALYZER.getPostID());
			this.composer.setProperty(LOG_MEMBER_ID, this.SPOOL_ANALYZER.getMemberID());
			this.composer.setProperty(LOG_STEP, this.SPOOL_ANALYZER.getStep());
			this.composer.setProperty(LOG_T_DATE, Cal.getDate());
			this.composer.setProperty(LOG_MX_RECORD, "NC");
			this.composer.setProperty(LOG_DELAY, "0");
			//samsunglife
			//this.composer.setProperty(LOG_EMAIL_ID, this.SPOOL_ANALYZER.getEmailID());
			this.composer.setProperty(LOG_TOKEN_ID, this.SPOOL_ANALYZER.getProperty(LOG_TOKEN_ENCRYPT));
			this.composer.setProperty(LOG_DOMAIN, this.SPOOL_ANALYZER.getDomain());
			this.composer.setProperty(LOG_WORKER, getName());
			//		this.composer.setProperty( Log.SPOOL_LOG ,"" );
			this.composer.setProperty(LOG_ETC_LOG, "550 TEMP REJECT DOMAIN");
			this.composer.setProperty(LOG_LIST_TABLE, this.SPOOL_ANALYZER.getListTable());

			SmtpLogger.put(this.composer);
		}
	}
}
