/*
 * @(#)AbstractMailSendTask.java            2004. 12. 3.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.common.task;

import jupiter.common.pool.BufferedAgentPool;
import jupiter.mass.send.basic.SendStopException;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import pluto.common.task.DenyFilterTask;
import pluto.common.task.HardBounceFilterTask;
import pluto.config.eMsSystem;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsStatement;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.log.ErrorSpoolLogger;
import pluto.mail.mx.LookupCacheManager;
import pluto.mail.mx.exception.NameNotKnownException;
import pluto.panopticon.filter.RejectFilter;
import pluto.panopticon.monitor.MailSendDomainFilter;
import pluto.schedule.Task;
import pluto.secure.crypto.CryptoUtil;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.basic.SpoolingManager;
import venus.spool.common.parser.SpoolAnalyzer;
import venus.spool.common.popper.Popper;

/**
 * <br>
 * 메일 발송을 위한 일련의 작업을 정의한다. <br>
 * 스풀을 읽어들여 유효성을 검사한 뒤 ( 도메인 등 )<br>
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public abstract class AbstractMailSendTask extends Task {

	/** 발송 정지 요청을 확인하는 주기 */
	public static int				STOP_CHECK_RECYCLE			= 1000;
	
	public static String			ERR_CHECK					= null;
	
	public static String			DENY_CHECK					= null;
	public static String 			ENC_PA						= null;
	public static String 			ENC_YN						= null;

	static {
		try {
			STOP_CHECK_RECYCLE = Integer.parseInt(eMsSystem.getProperty("stop.check.cycle", "1000"));
			ERR_CHECK = eMsSystem.getProperty("hardbounce.filter.check","N");
			DENY_CHECK = eMsSystem.getProperty("deny.filter.check","N");
			
			ENC_PA 	= eMsSystem.getProperty("member.info.encrypt.key"		   , "amail0722!@");
			ENC_YN 	= eMsSystem.getProperty("member.info.encrypt.yn"		   , "N");
		}
		catch(Exception e) {
			log.error(e.getMessage());
			System.exit(1);
		}
	}

	/** 현재 인스턴스의 발송 정지 요청을 확인하는 주기 */
	protected int					instance_STOP_CHECK_RECYCLE	= STOP_CHECK_RECYCLE;

	/** 작업중 생성되는 파일의 아이디 */
	protected String				WORK_FILE_ID				= null;

	/** 메일의 아이디 */
	protected String				POST_ID						= null;
	
	/** TMS3.0 채널유형(EM,SM,PU,TO) */
	protected String				CHANNEL_TYPE				= null;
	
	/**  TMS3.0 채널순번 : 동일 POST_ID 동일 채널 의경우 SEQ로 중복방지 */

	/** 스풀을 파싱하면서 에러가 발생한 도메인일 경우 Exception을 저장하는 변수 */
	protected Throwable				DOMAIN_NOT_FOUND_EXCEPTION	= null;

	/** 현재 작업 되는 메일의 스풀에 대한 정보 */
	protected SpoolInfo				mailSpoolInfo				= null;

	/** 발송 대상이 되는 ContentInfo */
	protected ContentInfo			SEND_CONTENT_INFO			= null;

	/** 스풀을 파싱해야할 녀석 */
	protected SpoolAnalyzer			SPOOL_ANALYZER				= null;

	/** 리스트 Popper */
	protected Popper				SPOOL_POPPER				= null;

	/** 스풀을 읽어와서 저장할 Local 디렉토리 */
	protected String				SPOOL_DIRECTORY				= null;
	

	protected	static	final String	REALTIME_SEARCH 	= "05";//실시간검색 CYCLE TYPE
	protected	static	final String	REALTIME_INPUT 		= "06";//실시간입력 CYCLE TYPE
	
	protected	static	String	QUERY_UPDATE_REALTIME_THREAD_STATUS_INFO = null; //실시간 thread status 정보 update
	
	
	/* define thread status info.
	 * REGISTER : 00 (DEFAULT CODE VALUE)
	 * execute_Startup(); A0 		
	 * execute_ContentLoad(); B0 	
	 * execute_ListMake(); C0 		
	 * execute_ListLoad(); D0 		
	 * execute_ListSend(); E0 		
	 * execute_Finish(); F0 		
	 * high level exception : 41
	 * 
	 * '00','F0','41' 경우 SCHEDULE QUERY EXECUTE. (실시간 입력 / 검색)
	 * THREAD STATUS 컬럼이 상관없는 배치성 메일은 HIGE LEVEL EXCEPTION 발생시 41로  반영이 되나, 무시하면 됨.
	 * 
	 */
	
	
	/** Creates a new instance of AbstractMailSendTask */
	public AbstractMailSendTask() throws Exception {
		this(TYPE_TRANSACTION, DEFAULT_EXECUTE_INTERVAL);
	}

	protected AbstractMailSendTask(short type) throws Exception {
		this(type, DEFAULT_EXECUTE_INTERVAL);
	}

	protected AbstractMailSendTask(short type, long interval) throws Exception {
		super(type, interval);
		this.instance_STOP_CHECK_RECYCLE = STOP_CHECK_RECYCLE;
		this.SPOOL_ANALYZER = SpoolAnalyzer.getSpoolAnalyzer();
		this.SPOOL_DIRECTORY = eMsSystem.getProperty("spool.temp.save.dir");
	}
	
	/**
	 * process 처리 가능 유무를 반환
	 * @return
	 */
	protected boolean isPossibleProcessing(){
		return true;
	}

	public void execute() throws Exception {

		try {
			
			if ( !isPossibleProcessing() ) {
				return;
			}
			
			if (log.isDebugEnabled()) 
				log.debug(" is execute execute_Startup Method...");
			execute_Startup();
			if (log.isDebugEnabled()) 
				log.debug(" is execute execute_Startup Method...[OK]");

			if (log.isDebugEnabled()) 
				log.debug(" is execute execute_ContentLoad Method...");
			execute_ContentLoad();
			if (log.isDebugEnabled()) 
				log.debug(" is execute execute_ContentLoad Method...[OK]");

			if (log.isDebugEnabled()) 
				log.debug(" is execute execute_ListMake Method...");
			execute_ListMake();
			if (log.isDebugEnabled()) 
				log.debug(" is execute execute_ListMake Method...[OK]");

			if (log.isDebugEnabled()) 
				log.debug(" is execute execute_ListLoad Method...");
			execute_ListLoad();
			if (log.isDebugEnabled()) 
				log.debug(" is execute execute_ListLoad Method...[OK]");

			if (log.isDebugEnabled()) 
				log.debug(" is execute execute_ListSend Method...");
			execute_ListSend();
			if (log.isDebugEnabled()) 
				log.debug(" is execute execute_ListSend Method...[OK]");

			if (log.isDebugEnabled()) 
				log.debug(" is execute execute_Finish Method...");
			execute_Finish();
			if (log.isDebugEnabled()) 
				log.debug(" is execute execute_Finish Method...[OK]");
		}
		catch(SendStopException e) {
//			update_thread_status("41");// high level exception.
			update_thread_status("32");
			log.error(getName(), e);
		}
	}


	protected void update_thread_status(String thread_code) throws Exception{
		
		this.TASK_PROPERTY.setProperty("THREAD_STATUS", thread_code); //먼저 세팅한다.
		
		eMsConnection 	conn = null;
		eMsStatement 	stmt = null;
		
		try{
			conn = ConnectionPool.getConnection();
			stmt = conn.createStatement();
			StringBuffer	buffer = new StringBuffer();
			StringConvertUtil.ConvertString(buffer, QUERY_UPDATE_REALTIME_THREAD_STATUS_INFO, this.TASK_PROPERTY , "${", "}", true, false);
			stmt.executeUpdate( buffer.toString() );
		} catch(Exception e){
			//EXCEPTION 발생은 무한으로 THREAD 가 생성될 우려가 있다. 물론 EXCEPTION 발생은 DB 접속이 안될때에 발생하겠지만.. '00' 에서 더이상 업데이트하지 못할때 고려하기. 
			//그래서 일단은 상위 클래스로 throw 를 넘긴다.
			log.error(getName(), e);
			throw e;
		} finally{
			if(conn != null){
				conn.recycleStatement(stmt);
				conn.recycle();
			}
		}
	}
	
	/**
	 * 
	 * @throws Exception
	 */
	protected synchronized void execute_ListSend() throws Exception {

		if (log.isDebugEnabled()) {
			log.debug("EXEC execute_ListSend");
		}

		// Popper의 Instance는 xml의 POPPER FACTORY에 정의되어 있다.
		// 보낼 대상이 등록되어 있으면 그것으로 SPOOL_POPPER를 초기화한다.
		if( this.mailSpoolInfo != null ) {
			SPOOL_POPPER = Popper.getInstance();

			/*
			 * 주기발송이나 수시발송의 경우 List쿼리의 결과가 없으면 41로 상태가 바뀐다. 여기서 Spool정보 XML파일의
			 * 정보를 미리가져와서 Vector가 비었는지 체크 필
			 */
			if( this.mailSpoolInfo.getSpoolFilesInfo().isEmpty() ) {
				//if (log.isDebugEnabled())
				log.debug( "No Real Data.... So Skip");

				return;
			}

			try{
				SPOOL_POPPER.setTaskProp(TASK_PROPERTY);
				SPOOL_POPPER.init(this.SPOOL_DIRECTORY, this.mailSpoolInfo.getSpoolFilesInfo());
			}catch(Exception ex){
				log.error("spool popper error", ex);
			}
		}
		else {
			log.debug( "MAIL SPOOL INFO IS NULL SO SKIP..");
			return;
		}

		if( this.SPOOL_POPPER == null ) {
			log.error(getName(), "No Real Data.... So Skip");
			return;
		}

		if( execute_StopCheck() ) {
			throw new SendStopException(getName() + " receive stop signal");
		}

		RejectFilter instanceRejectFilter = RejectFilter.getFilterInstance(this.TASK_PROPERTY);

		String nextSpool = null;
		String domain = null;
		int spoolPatchCount = 0;
		BufferedAgentPool pool = null;
		
		String email_str = null;
		String email_en  = null;
		String ori_Spool = null;
		
		StringBuffer strBuffer = new StringBuffer(1024);
		int email_en_len = 0;

		while ((nextSpool = (String) this.SPOOL_POPPER.next()) != null) {

			if( nextSpool == null || nextSpool.length() < 1 )
				continue;

			if( spoolPatchCount++ % instance_STOP_CHECK_RECYCLE == 0 ) {
				if( execute_StopCheck() ) {
					throw new SendStopException(getName() + " receive stop signal");
				}
			}

			try {
				if ("Y".equals(ENC_YN)) {
					//복호화한 email
					email_en  = getSecureEmail(nextSpool);//이메일 필드 추출
					email_str = getDecryptEmail(email_en);//이메일 복호화
					domain    = StringUtil.getDomain(email_str);//도매인추출
					
					//----- [2번] ---------------------
					email_en_len = email_en.length();
					strBuffer.setLength(0);
					strBuffer.append(email_en).append(CryptoUtil.TMS_DECRYPT_TAG).append(email_str).append(nextSpool.substring(email_en_len));
					ori_Spool = nextSpool;
					nextSpool = strBuffer.toString();
				} else {
					email_str  = getSecureEmail(nextSpool);//이메일 필드 추출
					domain    = StringUtil.getDomain(email_str);//도매인추출
				}
				
				if( domain == null ) {
					processSyntaxErrorSpool(nextSpool);
					continue;
				}

				// reject할 도메인 관리하려면 사용한다.
				if( MailSendDomainFilter.isFilterPresent() && MailSendDomainFilter.isTargetDomain(domain) ) {

					passRejectDomain(nextSpool);
					continue;
				}
				
				
				//hardbounce filter
				if(ERR_CHECK.equals("Y") && !email_str.equals("")){
					if(HardBounceFilterTask.checkErrEmail(email_str)){
						passRejectDomain(nextSpool);
						continue;
					}
				}
				
				//deny filter
				if(DENY_CHECK.equals("Y") && !email_str.equals("")){
					if(DenyFilterTask.checkDenyEmail(email_str)){
						passRejectDomain(nextSpool);
						continue;
					}
				}
				
				// Spool의 내용에서 필터링을 적용하여 보내지 않을 대상인지를 판별한다.
				if( instanceRejectFilter != null ) {

					this.SPOOL_ANALYZER.parse(nextSpool);

					if( instanceRejectFilter.isFiltered(this.SPOOL_ANALYZER) ) {
						continue;
					}

					nextSpool = this.SPOOL_ANALYZER.composeSingleRcptSend();
				}

				//도메인을 Lookup 한다.
				DOMAIN_NOT_FOUND_EXCEPTION = LookupCacheManager.isInvalidDomain(domain);
				
				if( DOMAIN_NOT_FOUND_EXCEPTION != null && DOMAIN_NOT_FOUND_EXCEPTION instanceof NameNotKnownException ) {
					passDomainNotFound(nextSpool, DOMAIN_NOT_FOUND_EXCEPTION);
				}
				else {
					pool = this.getBufferedObjectPool(domain);
					pool.registSpool(domain, nextSpool);
				}
			}
			catch(OutOfMemoryError outError) {
				log.error("OOM error", outError);
				System.gc();

				try {
					wait(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
				}
				catch(Exception ignore) {
				}

				try {
					//뜻하지 않은 에러이므로 재발송 스풀 생성을 담당하는 SpoolingManager에 넣어준다.
					//SpoolingManager.registSpool(nextSpool);
					SpoolingManager.registSpool(ori_Spool);
				}
				catch(Exception ignore) {
				}

				continue;
			}
			catch(Throwable err) {
				log.error("error", err);
				ErrorSpoolLogger.put(nextSpool + " => send : " + err.toString());
				continue;
			}
		}

		if (log.isDebugEnabled()) 
			log.debug("EXEC BufferedAgentPool.flushAll()");

		BufferedAgentPool.flushAll();

		if (log.isDebugEnabled()) 
			log.debug("EXEC execute_ListSend [OK]");
	}
	
	
	/**
	 * 암호화 되어있는 EMAIL을 가져온다.
	 * @param spool
	 * @return
	 */
	public String getSecureEmail(String spool){
		if( spool == null )
			return null;

		int idx1 = spool.indexOf("|");

		if( idx1 < 0 )
			return null;

		return spool.substring(0, idx1);
	}
	
	/**
	 * 암호화 되어있는 EMAIL을 가져온다.
	 * @param spool
	 * @return
	 */
	public String getSecureSms(String spool){
		if( spool == null )
			return null;

		int idx1 = spool.indexOf("|");

		if( idx1 < 0 )
			return null;

		return spool.substring(0, idx1);
	}
	
	/**
	 * 
	 * @param spool
	 * @return
	 * @throws Exception
	 */
	public String getDecryptEmail(String en_email) throws Exception {
		String email = "";
		try{
			if(en_email.indexOf("@") > 0){
				email = en_email;
			}else{
				//email decrypt
				email = CryptoUtil.deEmailAddr(en_email);
			}
			
		}catch(Exception e){
			log.error("Exception", e);
			return en_email;
		}
		if(StringUtil.isError(email)){
			return null;
		}else{
			return email.trim();
		}		
	}
	
	public String getDecryptSms(String en_sms) throws Exception {
		//SMS decrypt
		
		String sms = "";
		try{
			if(en_sms.length() < 15){
				sms = en_sms;
			}else{
				//en_sms decrypt
				sms = CryptoUtil.deEmailAddr(en_sms);
			}
			return sms.trim();
		}catch(Exception e){
			log.error("Exception", e);
			return en_sms;
		}
	}
	
	
	protected synchronized void execute_MassResend_ListSend() throws Exception {

		if (log.isDebugEnabled()) {
			log.debug("EXEC execute_ListSend");
		}

		// Popper의 Instance는 xml의 POPPER FACTORY에 정의되어 있다.
		// 보낼 대상이 등록되어 있으면 그것으로 SPOOL_POPPER를 초기화한다.
		if( this.mailSpoolInfo != null ) {
			SPOOL_POPPER = Popper.getInstance();

			/*
			 * 주기발송이나 수시발송의 경우 List쿼리의 결과가 없으면 41로 상태가 바뀐다. 여기서 Spool정보 XML파일의
			 * 정보를 미리가져와서 Vector가 비었는지 체크 필
			 */
			if( this.mailSpoolInfo.getSpoolFilesInfo().isEmpty() ) {
				//if (log.isDebugEnabled())
				log.debug( "No Real Data.... So Skip");

				return;
			}

			try{
				SPOOL_POPPER.init(null, this.mailSpoolInfo.getSpoolFilesInfo());
				
			}catch(Exception ex){
				log.error("Exception", ex);

			}
		}
		else {
			log.debug( "MAIL SPOOL INFO IS NULL SO SKIP..");
			return;
		}

		if( this.SPOOL_POPPER == null ) {
			log.error("No Real Data.... So Skip");
			return;
		}

		if( execute_StopCheck() ) {
			throw new SendStopException(getName() + " receive stop signal");
		}

		RejectFilter instanceRejectFilter = RejectFilter.getFilterInstance(this.TASK_PROPERTY);

		String nextSpool = null;
		String domain = null;
		int spoolPatchCount = 0;
		BufferedAgentPool pool = null;
		
		String email_str = null;
		String email_en  = null;
		String ori_Spool = null;
		
		StringBuffer strBuffer = new StringBuffer(1024);
		int email_en_len = 0;

		while ((nextSpool = (String) this.SPOOL_POPPER.next()) != null) {

			if( nextSpool == null || nextSpool.length() < 1 )
				continue;

			if( spoolPatchCount++ % instance_STOP_CHECK_RECYCLE == 0 ) {
				if( execute_StopCheck() ) {
					throw new SendStopException(getName() + " receive stop signal");
				}
			}

			try {
				//domain = this.SPOOL_ANALYZER.pickupDomain(nextSpool);
				//복호화한 email
				email_en  = getSecureEmail(nextSpool);
				email_str = getDecryptEmail(email_en);
				domain    = StringUtil.getDomain(email_str);
				
				//----- [1번] ---------------------
				//변환된 스풀
//				ori_Spool = nextSpool;
//				nextSpool = StringUtil.ConvertString(nextSpool, email_en, email_str);
				
				//----- [2번] ---------------------
				email_en_len = email_en.length();
				strBuffer.setLength(0);
				strBuffer.append(email_en).append(CryptoUtil.TMS_DECRYPT_TAG).append(email_str).append(nextSpool.substring(email_en_len));
				nextSpool = strBuffer.toString();
				
				if( domain == null ) {
					processSyntaxErrorSpool(nextSpool);
					continue;
				}

				// reject할 도메인 관리하려면 사용한다.
				if( MailSendDomainFilter.isFilterPresent() && MailSendDomainFilter.isTargetDomain(domain) ) {

					passRejectDomain(nextSpool);
					continue;
				}

				// Spool의 내용에서 필터링을 적용하여 보내지 않을 대상인지를 판별한다.
				if( instanceRejectFilter != null ) {

					this.SPOOL_ANALYZER.parse(nextSpool);

					if( instanceRejectFilter.isFiltered(this.SPOOL_ANALYZER) ) {
						continue;
					}

					nextSpool = this.SPOOL_ANALYZER.composeSingleRcptSend();
				}

				//도메인을 Lookup 한다.
				DOMAIN_NOT_FOUND_EXCEPTION = LookupCacheManager.isInvalidDomain(domain);

				if( DOMAIN_NOT_FOUND_EXCEPTION != null && DOMAIN_NOT_FOUND_EXCEPTION instanceof NameNotKnownException ) {
					passDomainNotFound(nextSpool, DOMAIN_NOT_FOUND_EXCEPTION);
				}
				else {
					pool = this.getBufferedObjectPool(domain);
					pool.registSpool(domain, nextSpool);
				}
			}
			catch(OutOfMemoryError outError) {
				log.error("OOM error", outError);
				System.gc();

				try {
					wait(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
				}
				catch(Exception ignore) {
				}

				try {
					//뜻하지 않은 에러이므로 재발송 스풀 생성을 담당하는 SpoolingManager에 넣어준다.
					//SpoolingManager.registSpool(nextSpool);
					SpoolingManager.registSpool(ori_Spool);
				}
				catch(Exception ignore) {
				}

				continue;
			}
			catch(Throwable err) {
				log.error("error", err);
				ErrorSpoolLogger.put(nextSpool + " => send : " + err.toString());
				continue;
			}
		}

		if (log.isDebugEnabled()) 
			log.debug("EXEC BufferedAgentPool.flushAll()");

		BufferedAgentPool.flushAll();

		if (log.isDebugEnabled()) 
			log.debug("EXEC execute_ListSend [OK]");
	}	

	/**
	 * 리스트를 외부에서 가져올 때
	 */
	protected abstract void execute_ListMake() throws Exception;

	/**
	 * SPOOL_CONF 위치를 읽어들이고 Xml을 SpoolInfo로 변환하여 Manager에 등록한다.
	 * setTaskProperty()가 호출된 이후에 실행되어야 된다.
	 */
	protected void execute_ListLoad() throws Exception {

		String spoolInfoConfig = TASK_PROPERTY.getProperty("SPOOL_CONF");
		this.mailSpoolInfo = SpoolInfo.XmlToSpoolInfo(spoolInfoConfig);
		SpoolInfoManager.putSpoolInfo(this.mailSpoolInfo, false);
	}

	/**
	 * CONTENTS_CONF 위치를 읽어들이고 Xml을 ContentInfo로 변환하여 Manager에 등록한다.
	 * setTaskProperty()가 호출된 이후에 실행되어야 된다.
	 */
	protected void execute_ContentLoad() throws Exception {

		String contentInfoConfig = TASK_PROPERTY.getProperty("CONTENT_CONF");
		String push_msg = TASK_PROPERTY.getProperty("PUSH_MSG","");
		String push_title = TASK_PROPERTY.getProperty("PUSH_TITLE","");
		
		this.SEND_CONTENT_INFO = ContentInfo.XmlToContentInfo(contentInfoConfig);

		if (!StringUtil.isNull(push_msg)) {
			SEND_CONTENT_INFO.getScheduleInfo().setProperty("PUSH_MSG", push_msg);	
		}
		if (!StringUtil.isNull(push_title)){ 
			SEND_CONTENT_INFO.getScheduleInfo().setProperty("PUSH_TITLE", push_title);	
		}
		
		ContentInfoManager.putContentInfo(this.SEND_CONTENT_INFO, false);
	}

	/**
	 * 메일발송 스케쥴이 최초 시작될때 호출
	 */
	protected abstract void execute_Startup() throws Exception;

	/**
	 * 리스트를 다 뿌리고 나올때 실행
	 */
	protected abstract void execute_Finish() throws Exception;

	/**
	 * 발송 정지 상태를 점검하고 정지되었다면 로그를 작성한다.
	 */
	protected abstract boolean execute_StopCheck();

	/**
	 * 지정된 도메인의 BufferedPool을 반환한다. BufferedAgentPool.getBufferedObjectPool(
	 * domain );
	 */
	protected abstract BufferedAgentPool getBufferedObjectPool(String domain) throws Exception;

	/**
	 * 도메인이 없을경우 에러처리하는 녀석
	 */
	protected abstract void passDomainNotFound(String spool, Throwable ex) throws Exception;

	/**
	 * 거절된 도메인을 Skip하는 녀석
	 */
	protected abstract void passRejectDomain(String spool) throws Exception;

	/**
	 * Syntax Error 스풀을 처리한다.
	 */
	protected abstract void processSyntaxErrorSpool(String spool) throws Exception;

}
