/*
 * @(#)AbstractDBMailSendTask.java            2004. 12. 3.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.common.task;

import java.sql.SQLException;

import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import lombok.extern.slf4j.Slf4j;
import pluto.log.Composer;
import pluto.log.Log;
import pluto.log.SmtpLogger;
import pluto.reporter.Reporter;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;

/**
 * Class description :
 * 
 * @version
 * @author dragon 
 *  
 */
@Slf4j
public abstract class AbstractDBMailSendTask extends AbstractMailSendTask implements Log {

	/** 메일의 리스트가 포함되어 있는 테이블 이름 */
	protected String				LIST_TABLE						= null;

	/** */
	protected String				INSTANCE_QUERY_CHECK_STOP_FLAG	= null;

	/** Task를 실행하면서 공용을 사용할 StringBuffer 대부분은 쿼리를 전환할때 사용된다. */
	protected StringBuffer		TMP_STRING_BUFFER				= null;

	/** 로그 조립할 Composer */
	protected Composer				composer						= null;

	/** Creates a new instance of AbstractDBMailSendTask */
	protected AbstractDBMailSendTask() throws Exception {
		this(TYPE_TRANSACTION, DEFAULT_EXECUTE_INTERVAL);
	}

	protected AbstractDBMailSendTask(short type) throws Exception {
		this(type, DEFAULT_EXECUTE_INTERVAL);
	}

	protected AbstractDBMailSendTask(short type, long interval) throws Exception {
		super(type, interval);
		this.composer = Composer.getComposerInstance();
	}

	/**
	 * <br>
	 * Task를 초기화하는 로직을 구현한다. <br>
	 * 발송 로직에서 최초로 구현된다. 하위에서 상속 받는 녀석들이 <br>
	 * override 할때는 super.execute_initiate() 를 반드시 호출해줘야한다. <br>
	 * throwable이 발생하게 되면 execute_initiateError() 를 호출하도록 되어있다.
	 * 
	 * @see pluto.schedule.Task.internal_execute()
	 */
	public void execute_initiate() throws Exception {

		super.execute_initiate();

		// 공용 StringBuffer 초기화 add 2004.11.02
		this.TMP_STRING_BUFFER = new StringBuffer(1024);
	}

	/**
	 * <br>
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. <br>
	 * Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ <br>
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {

		log.error(getName(), thw);

		//REPORT 데이터베이스 커넥션을 가져오는 과정에서 에러가 발생하였습니다.
		if( !(thw instanceof SQLException) ) {
			Reporter.report(this.POST_ID, getName(), "mailsendtask.init.err", thw);
		}
	}

	/**
	 * <br>
	 * execute() 가 false를 반환하였을때(실패) 실행하는 로직이 구현된다. <br>
	 * 여기서는 아무일도 하지 않으며 성공시 후속 조치가 필요한 Task는 이 <br>
	 * method를 오버라이드 하면 된다.
	 */
	public void doErrorProcess(Throwable thw) {

		log.error(getName(), thw);
		//REPORT 데이터베이스 커넥션을 가져오는 과정에서 에러가 발생하였습니다.
		Reporter.report(this.POST_ID, getName(), "mailsendtask.exec.err", thw);
	}

	/**
	 * <br>
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. <br>
	 * 할당받은 자원을 free 시키는 로직을 구현한다. <br>
	 * execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 <br>
	 * 처리로직을 전체 포함하여야 한다.
	 */
	public void release_Resource() {
		// 공용 StringBuffer 반환 add 2004.11.02
		this.TMP_STRING_BUFFER = null;
	}

	/* 발송 정지 상태를 점검하고 정지되었다면 로그를 작성한다. */
	protected boolean execute_StopCheck() {
		/* 정지 체크 쿼리가 없다면 그냥 false를 반환한다.( 체크할수 없으니까 ) */
		if( INSTANCE_QUERY_CHECK_STOP_FLAG == null ){
			return false;
		}

		eMsStatement __EMS_EXEC_STATEMENT__ = null;
		eMsResultSet rs = null;
		eMsConnection emsConnection = null;
		try {
			emsConnection = ConnectionPool.getConnection();
			__EMS_EXEC_STATEMENT__ = emsConnection.createStatement();
			this.TMP_STRING_BUFFER.setLength(0);
			StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, INSTANCE_QUERY_CHECK_STOP_FLAG, this.TASK_PROPERTY, "${", "}", true, false);
			rs = __EMS_EXEC_STATEMENT__.executeQuery(this.TMP_STRING_BUFFER.toString());

			if( rs.next() ) {
				if(log.isDebugEnabled()){
					log.debug("CHECK STOP SIGNAL--BINGO");
				}
				writeSystemLog("SYSTEM", "90", "32");
				return true;
			}
			if(log.isDebugEnabled()){
				log.debug("CHECK STOP SIGNAL--CONTINUE");
			}
			return false;
		}
		catch(Exception ignore) {
			log.error(getName(), ignore);
			return false;
		}
		finally {
			/* 점검을 다했으면 커넥션을 반환해야한다. */
			try {
				if( rs != null){
					rs.close();
				}
			}
			catch(Exception ignore) {
			}
			
			if(__EMS_EXEC_STATEMENT__ != null) {
				emsConnection.recycleStatement(__EMS_EXEC_STATEMENT__);
			}
			
			if(emsConnection != null) {
				emsConnection.recycle();
			}
		}
	}

	protected void writeSystemLog(String sTYPE, String sCODE_TYPE, String sCODE_CODE) {

		synchronized (this.composer.getLock()) {
			this.composer.setProperty(LOG_SEND_TYPE, sTYPE);
			this.composer.setProperty(LOG_T_TYPE, sCODE_TYPE);
			this.composer.setProperty(LOG_T_CODE, sCODE_CODE);
			this.composer.setProperty(LOG_MAIL_ID, this.POST_ID);
			this.composer.setProperty(LOG_MEMBER_ID, "noid");
			this.composer.setProperty(LOG_STEP, "0");
			this.composer.setProperty(LOG_T_DATE, Cal.getDate());
			this.composer.setProperty(LOG_MX_RECORD, "");
			this.composer.setProperty(LOG_DELAY, "");
			this.composer.setProperty(LOG_TOKEN_ID, "noemail");
			this.composer.setProperty(LOG_DOMAIN, "");
			this.composer.setProperty(LOG_WORKER, this.getName());
			this.composer.setProperty(LOG_ETC_LOG, "MailSendTaskEnd");
			this.composer.setProperty(LOG_LIST_TABLE, "n");

			SmtpLogger.put(this.composer);
		}
	}
}
