/*
 * Created on 2005. 7. 6.
 * 
 * 일본의 핸드폰 메일을 위해서 처음 디자인이 시작되었으며 
 * 핸드폰 메일이 아니더라도 특정 시간대에는 발송하지 않아야하는 도메인이 발생하였을 때 사용하면
 * 유용할거라 생각됨
 * 
 */
package jupiter.common.pool;

import org.w3c.dom.Element;

import lombok.extern.slf4j.Slf4j;
import pluto.log.Composer;
import pluto.log.SmtpLogger;
import pluto.util.Cal;
import pluto.log.Log;
import venus.spool.common.parser.SpoolAnalyzer;

/**
 * @author Owner
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
@Slf4j
public class TimeSectionLimitAgentPool extends FixedDomainBufferedAgentPool {

	public int						TIMELIMIT_START	= 2400;

	public int						TIMELIMIT_END	= 0700;

	public Composer					composer;

	public SpoolAnalyzer			SPOOL_ANALYZER	= null;

	protected void inner_init(Element TargetNode, String name) throws Exception {
		// 일단 super class와 동일하게 초기화 하고
		Element subNode;
		super.inner_init(TargetNode, name);

		// 시간 설정부분을 가져와서 나머지를 초기화 한다.
		subNode = (Element) TargetNode.getElementsByTagName("time-limit").item(0);
		this.TIMELIMIT_START = Integer.parseInt(subNode.getAttribute("start"));
		this.TIMELIMIT_END = Integer.parseInt(subNode.getAttribute("end"));

		if (log.isDebugEnabled()) {
			log.debug("start:{}", subNode.getAttribute("start"));
			log.debug("end:{}", subNode.getAttribute("end"));
		}
		try {
			this.SPOOL_ANALYZER = SpoolAnalyzer.getSpoolAnalyzer();
		}
		catch(Exception e) {
			log.error("spool analyzer error", e);
		}
	}

	public void registSpool(String domain, String spool) {
		// 로그를 작성하여 시간제한에 걸려서 발송이 안된 사항을 디비에 기록할 수 있도록 해야한다.

		if( check_TimeLimit(TIMELIMIT_START, TIMELIMIT_END) ) {
			if (log.isDebugEnabled()) {
				log.debug("ACCEPT");
			}
			super.registSpool(domain, spool);
		}
		else {
			if (log.isDebugEnabled()) {
				log.debug("REJECT");
			}
			this.composer = Composer.getComposerInstance();
			try {
				this.SPOOL_ANALYZER.parse(spool);
			}
			catch(Exception e) {
				log.error("spool parse error", e);
			}
			synchronized (this.composer.getLock()) {
				this.composer.setProperty(Log.LOG_SEND_TYPE, this.SPOOL_ANALYZER.getSendType());
				this.composer.setProperty(Log.LOG_T_TYPE, "54");
				this.composer.setProperty(Log.LOG_T_CODE, "00");
				this.composer.setProperty(Log.LOG_MAIL_ID, this.SPOOL_ANALYZER.getPostID());
				this.composer.setProperty(Log.LOG_MEMBER_ID, this.SPOOL_ANALYZER.getMemberID());
				this.composer.setProperty(Log.LOG_STEP, this.SPOOL_ANALYZER.getStep());
				this.composer.setProperty(Log.LOG_T_DATE, Cal.getDate());
				this.composer.setProperty(Log.LOG_MX_RECORD, "NC");
				this.composer.setProperty(Log.LOG_DELAY, "0");
				this.composer.setProperty(Log.LOG_TOKEN_ID, this.SPOOL_ANALYZER.getProperty(Log.LOG_TOKEN_ENCRYPT));
				this.composer.setProperty(Log.LOG_DOMAIN, this.SPOOL_ANALYZER.getDomain());
				this.composer.setProperty(Log.LOG_WORKER, getName());
				this.composer.setProperty(Log.LOG_ETC_LOG, "550 OUT OF TIME LIMIT");
				this.composer.setProperty(Log.LOG_LIST_TABLE, this.SPOOL_ANALYZER.getListTable());

				SmtpLogger.put(this.composer);

				this.composer.setProperty(Log.LOG_SEND_TYPE, this.SPOOL_ANALYZER.getSendType());
				this.composer.setProperty(Log.LOG_T_TYPE, "55");
				this.composer.setProperty(Log.LOG_T_CODE, "30");
				this.composer.setProperty(Log.LOG_MAIL_ID, this.SPOOL_ANALYZER.getPostID());
				this.composer.setProperty(Log.LOG_MEMBER_ID, this.SPOOL_ANALYZER.getMemberID());
				this.composer.setProperty(Log.LOG_STEP, this.SPOOL_ANALYZER.getStep());
				this.composer.setProperty(Log.LOG_T_DATE, Cal.getDate());
				this.composer.setProperty(Log.LOG_MX_RECORD, "NC");
				this.composer.setProperty(Log.LOG_DELAY, "0");
				//samsunglife
				this.composer.setProperty(Log.LOG_TOKEN_ID, this.SPOOL_ANALYZER.getProperty(Log.LOG_TOKEN_ENCRYPT));
				this.composer.setProperty(Log.LOG_DOMAIN, this.SPOOL_ANALYZER.getDomain());
				this.composer.setProperty(Log.LOG_WORKER, getName());
				this.composer.setProperty(Log.LOG_ETC_LOG, "550 OUT OF TIME LIMIT");
				this.composer.setProperty(Log.LOG_LIST_TABLE, this.SPOOL_ANALYZER.getListTable());

				SmtpLogger.put(this.composer);
			}
		}
	}

	/**
	 * 현재 시간이 Limit start time과 end time 사이에 있는지 체크
	 */
	public static boolean check_TimeLimit(int startTime, int endTime) {

		int cur_Time = Integer.parseInt(Cal.getHHmm());
		int limit_StartTime = startTime;
		int limit_EndTime = endTime;

		if (log.isDebugEnabled()) {
			log.debug("cur_Time:{}", cur_Time);
			log.debug("limit_StartTime:{}", limit_StartTime);
			log.debug("limit_EndTime:{}", limit_EndTime);
		}

		// CASE start time > end time 이면
		// 시작시간보다 크고 종료시간보다 작으면 발송이 되어야 한다.
		if( limit_StartTime > limit_EndTime ) {
			if( (cur_Time > limit_StartTime) && (cur_Time < limit_EndTime) ) {
				// 시작시간보다 작고 종료시간보다 크다면 나가야한다.
				return true;
			}
			// 발송안되게 막는다.
			return false;
		}
		// start time < end time 같은 경우...
		else if( limit_StartTime < limit_EndTime ) {
			if( cur_Time > limit_StartTime && cur_Time < limit_EndTime ) {
				return true;
			}
			return false;
		}
		else {
			// 그렇지 않으면 두 시간이 같기 때문에 무조건 나간다.
			return true;
		}

	}//check_TimeLimit

}// end class
