/*
 * MultiDomainBufferedAgentPool.java
 *
 * Created on 2004년 1월 27일 (화), 오후 11:47
 */

package jupiter.common.pool;

import java.util.Enumeration;

import pluto.mail.DomainFullException;
import pluto.mail.MultiRcptDomainGroupingManager;
import pluto.mail.MultiRcptInfo;

/**
 *
 */
public class MultipleDomainBufferedAgentPool extends BufferedAgentPool {
	
	protected MultiRcptDomainGroupingManager __INNER_GROUPING_MANAGER__ = null;
	
	/** Creates a new instance of FixedDomainBufferedAgentPool */
	public MultipleDomainBufferedAgentPool() {
		super();
		__INNER_GROUPING_MANAGER__ = new MultiRcptDomainGroupingManager();
	}
	
	
	/**
	 * ScheduleMonitor의 check()모듈에 abstract 형식으로 주기적으로 실행 함.
	 */
	protected void flush() throws Exception {
		if( FLUSH_LOCKING_FLAG ) {
			if( POOL_DEBUG ) log( "POOL FLUSH BUT FLAG IS TRUE" );
			return;
		}
		FLUSH_LOCKING_FLAG = true;
		
		if( POOL_DEBUG ) log( "POOL FLUSH START" );
		
		MultiRcptInfo _RCPT_TARGET_LIST_ = null;
		synchronized( __INNER_GROUPING_MANAGER__ ){
			for(  Enumeration myEnum = __INNER_GROUPING_MANAGER__.elements(); myEnum.hasMoreElements();  ) {
				_RCPT_TARGET_LIST_ = ( MultiRcptInfo )myEnum.nextElement();
				
				if( POOL_DEBUG ) log( "DOMAIN : " + _RCPT_TARGET_LIST_.getDomain() );
				
				String result = null;
				
				if( ( result =_RCPT_TARGET_LIST_.getResult() ) != null ){
					if( POOL_DEBUG ) log( _RCPT_TARGET_LIST_.getDomain() + " CONTAIN > 0 " );
					super.push( result );
				}
				else{
					if( POOL_DEBUG ) log( _RCPT_TARGET_LIST_.getDomain() + " CONTAIN < 1 " );
				}
			}
		}
		
		inner_flush();
		
		if( POOL_DEBUG ) log( "POOL FLUSH END" );
		
		FLUSH_LOCKING_FLAG = false;
	}
	
	public void registSpool( String domain , String spool ) {
		
		if( POOL_DEBUG ) log( "INTO registSpool() method " );
		
		// 버퍼가 변경 되었음을 마킹
		this.BUFFER_IS_MODIFIED = true;
		
		MultiRcptInfo _RCPT_TARGET_LIST_ = null;
		
		try {
			//_RCPT_TARGET_LIST_ = __INNER_GROUPING_MANAGER__.addSingleRcptElement( spool , domain );
			//resetsize
			_RCPT_TARGET_LIST_ = __INNER_GROUPING_MANAGER__.addSingleRcptElement( spool , domain, RESET_SIZE );
			String result = null;
			if( _RCPT_TARGET_LIST_ != null && ( result = _RCPT_TARGET_LIST_.getResult() ) != null ){
				super.push( result );
				if( POOL_DEBUG ) log( "return CASE RESULT REGIST" );
				return;
			}
			
			// Flush 할때를 잡아야 하니까..
			LAST_TOUCH_TIME = System.currentTimeMillis();
			if( POOL_DEBUG ) log( "return CASE NO RESULT REGIST" );
		}
		catch( DomainFullException e ){
			if( INOUT_DEBUG || POOL_DEBUG ) log( " catch DomainFullException " );
			synchronized( __INNER_GROUPING_MANAGER__ ){
				for(  Enumeration myEnum = __INNER_GROUPING_MANAGER__.elements(); myEnum.hasMoreElements();  ) {
					_RCPT_TARGET_LIST_ = ( MultiRcptInfo )myEnum.nextElement();
					String result = null;
					if( ( result = _RCPT_TARGET_LIST_.getResult() ) == null ){
						__INNER_GROUPING_MANAGER__.remove( _RCPT_TARGET_LIST_.getDomain() );
					}
					else{
						super.push( result );
					}
				}
			}
			if( INOUT_DEBUG || POOL_DEBUG ) log( " catch DomainFullException [END]" );
			
			//[JOO] spool을 이제 처리하도록 하자--------
			registSpool(  domain , spool );
			//---------------------------------------
			
		}
	}
}
