/*
 * FixedDomainBufferedAgentPool.java
 *
 * Created on 2004년 1월 27일 (화), 오후 11:52
 */

package jupiter.common.pool;

import pluto.mail.MultiRcptInfo;

/**
 * 
 * @author t??
 */
public class FixedDomainBufferedAgentPool extends BufferedAgentPool {

	protected MultiRcptInfo	_RCPT_TARGET_LIST_	= null;

	/** Creates a new instance of FixedDomainBufferedAgentPool */
	public FixedDomainBufferedAgentPool() {
		super();
	}
	//resetsize
	protected synchronized void setWorkerSize(int size) throws Exception {
		super.setWorkerSize(size);
		setInit(this.CAPACITY);
	}
	
	/**
	 * @date 2015.05.28
	 * @author pioneer
	 * @param size multi worker size
	 * @param resetSize unit size of one work
	 */
	 //resetsize
	protected synchronized void setWorkerSize(int size, int rsetSize) throws Exception {
		super.setWorkerSize(size, rsetSize);
		setInit(rsetSize);  
	}
	
	protected void setInit(int size){
		String domain = getName().substring(getName().indexOf(".") + 1);
		_RCPT_TARGET_LIST_ = new MultiRcptInfo(domain, size);
	}
	
	
	protected void flush() throws Exception {
		if( FLUSH_LOCKING_FLAG ) {
			if( POOL_DEBUG ) {
				log("POOL FLUSH BUT FLAG IS TRUE SO RETURN");
			}
			return;
		}
		
		FLUSH_LOCKING_FLAG = true;
		if( POOL_DEBUG ) {
			log("POOL FLUSH START");
		}

		if( this._RCPT_TARGET_LIST_ != null ) {
			String result = this._RCPT_TARGET_LIST_.getResult();
			if( result != null ) {
				super.push(result);
			}
		}

		inner_flush();

		if( POOL_DEBUG ) {
			log("POOL FLUSH END");
		}
		FLUSH_LOCKING_FLAG = false;
	}

	public void registSpool(String domain, String spool) {

		if( POOL_DEBUG ) {
			log("INTO registSpool() method ");
			//log("spool -->  "+spool);
			//log("domain -->  "+domain);
		}
		// 버퍼가 변경 되었음을 마킹
		this.BUFFER_IS_MODIFIED = true;
		//TODO 발송할 놈한테 넘겨주는것.
		if( _RCPT_TARGET_LIST_.addElement(spool) ) {
			if( INOUT_DEBUG ) {
				log("registSpool popup");
			}
			super.push(_RCPT_TARGET_LIST_.getResult());
			if( POOL_DEBUG ) {
				log("return CASE RESULT REGIST");
			}
			return;
		}

		if( INOUT_DEBUG ) {
			log("registSpool skip ".concat(spool));
		}
		if( POOL_DEBUG ) {
			log("return CASE NO RESULT REGIST");
		}
	}
}
