/*
 * AgentPool.java
 *
 * Created on 2003년 11월 19일 (수), 오후 3:22
 */

package jupiter.common.pool;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;

import jupiter.common.actor.BufferedCommunicationActor;
import jupiter.common.communicator.SmtpCommunicator;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.log.LogChannelContainer;
import pluto.util.recycle.Bufferable;
import pluto.util.recycle.BufferedObjectPool;
import pluto.util.xml.XMLUtil;

/**
 * @author 이상근
 * @version 3.5
 */
@Slf4j
public abstract class BufferedAgentPool extends BufferedObjectPool {

	private static Hashtable		pool_list				= new Hashtable();

	/**
	 * 초기화 파라미터
	 * 
	 * <PRE>
	 * 
	 * &lt;TARGET name="SMTP AGENT POOL" type="xml"&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;class name="Lib2002.net.smtp.agent.SMTPPoolManager"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&lt;zone name="[POOL NAME]"
	 * domain="default"&gt; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;class name="[POOL CLASS]"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;subclass value="[AGENT CLASS]"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;size value="[동시접속 AGENT COUNT]"/&gt; &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&lt;delay value="[delay time]"/&gt;
	 * &nbsp;&nbsp;&nbsp;&nbsp;&lt;/zone&gt; &lt;/TARGET&gt;
	 * 
	 * </PRE>
	 * 
	 * zone Element는 복수개로 지정할수 있으며 기본적으로는 [main,que,attach] 세개가 있다.
	 * 
	 * @param prop
	 *        초기화 파라미터
	 * @throws Exception
	 *         초기화 에러
	 */
	public synchronized static void init(Object prop) throws Exception {

		Element TargetNode = (Element) prop;
		Element SubNode = null;

		String ClassName = null;
		String ZoneName = null;
		String ZoneDomain = null;

		NodeList TargetNodeList = TargetNode.getElementsByTagName("zone");
		int TargetNodeCount = TargetNodeList.getLength();

		for (int i = 0; i < TargetNodeCount; i++) {
			TargetNode = (Element) TargetNodeList.item(i);

			ZoneName = TargetNode.getAttribute("name");
			ZoneDomain = TargetNode.getAttribute("domain");

			SubNode = (Element) TargetNode.getElementsByTagName("class").item(0);
			ClassName = SubNode.getAttribute("name");

			BufferedAgentPool returnValue = (BufferedAgentPool) (Class.forName(ClassName).newInstance());
			returnValue.start();
			returnValue.inner_init(TargetNode, ZoneName.concat(".").concat(ZoneDomain));
			pool_list.put(ZoneName.concat(".").concat(ZoneDomain), returnValue);

			if (log.isDebugEnabled()) {
				log.debug("AgentPool Regist: {}", ZoneName.concat(".").concat(ZoneDomain));
			}
		}
	}

	public static BufferedAgentPool getBufferedObjectPool(String zone, String domain) throws Exception {

		BufferedAgentPool returnValue = null;
		if( pool_list.containsKey(zone.concat(".").concat(domain.toLowerCase())) ) {
			returnValue = (BufferedAgentPool) pool_list.get(zone.concat(".").concat(domain.toLowerCase()));
		}
		else {
			returnValue = (BufferedAgentPool) pool_list.get(zone.concat(".default"));
		}
		if (log.isDebugEnabled()) {
			returnValue.log("CALL");
		}
		return returnValue;
	}

	public static void resetPoolSize(String zone, String domain, int size) throws Exception {
		if( pool_list.containsKey(zone.concat(".").concat(domain)) ) {
			((BufferedObjectPool) pool_list.get(zone.concat(".").concat(domain))).resetWorkerSize(size);
		}
		else {
			((BufferedObjectPool) pool_list.get(zone.concat(".default"))).resetWorkerSize(size);
		}
	}

	public synchronized static void flushAll() {
		BufferedObjectPool _POOL_ = null;
		for (Enumeration myEnum = pool_list.elements(); myEnum.hasMoreElements();) {
			_POOL_ = (BufferedObjectPool) myEnum.nextElement();
			try {
				_POOL_.registFlush();
			}
			catch(Exception e) {
				log.error("POOL FLUSH EXCEPTION", e);
			}
		}
	}

	protected ThreadGroup	group;

	protected Integer		AGENT_WORK_DELAY			= null;

	protected String		AGENT_CLASS_NAME			= null;

	protected Class			AGENT_CLASS					= null;

	protected Constructor	AGENT_CLASS_CONSTRUCTOR		= null;

	protected boolean		WAIT_EMPTY					= false;

	/**
	 * 한번에 리셋할수 있는 카운트를 지정한다.
	 */
	public int				SMTP_REST_LIMIT		= eMsLocale.SMTP_REST_LIMIT;

	public int				INSTANCE_TIMEOUT_CONNECT		= eMsLocale.TIMEOUT_CONNECT;
	
	public int				INSTANCE_TIMEOUT_INIT		= eMsLocale.TIMEOUT_INIT;

	public int				INSTANCE_TIMEOUT_HELO		= eMsLocale.TIMEOUT_HELO;

	public int				INSTANCE_TIMEOUT_MAILFROM	= eMsLocale.TIMEOUT_MAILFROM;

	public int				INSTANCE_TIMEOUT_RCPT		= eMsLocale.TIMEOUT_RCPT;

	public int				INSTANCE_TIMEOUT_DATAINIT	= eMsLocale.TIMEOUT_DATAINIT;

	public int				INSTANCE_TIMEOUT_DATABLOCK	= eMsLocale.TIMEOUT_DATABLOCK;

	public int				INSTANCE_TIMEOUT_RSET		= eMsLocale.TIMEOUT_RSET;

	/** Creates a new instance of AgentPool */
	public BufferedAgentPool() {
		super(60 * 1000L, "AgentPoolInnerMonitor");
	}

	protected void inner_init(Element TargetNode, String name) throws Exception {
		setName(name);

		// 내부 로깅 인스턴스 있으면 초기화
		String LOGCHANNEL_ID = XMLUtil.getSubElementAttribute(TargetNode, "LOGGER", "ID");

		if( LOGCHANNEL_ID == null ) {
			log.error("LOGCHANNEL IS NOT SET.......");
		}
		else {
			if (log.isDebugEnabled()) 
				log.debug("LOGGER=>" + LOGCHANNEL_ID);
			this.LOG_CHANNEL_INSTANCE = LogChannelContainer.get(LOGCHANNEL_ID);
		}

		Element SubNode = null;

		// 타임아웃을 지정한다.
		Element TimeOutNode = (Element) TargetNode.getElementsByTagName("timeout").item(0);

		if( TimeOutNode != null ) {
			SubNode = (Element) TimeOutNode.getElementsByTagName("TIMEOUT_CONNECT").item(0);
			this.INSTANCE_TIMEOUT_CONNECT = Integer.parseInt(SubNode.getAttribute("value"));

			SubNode = (Element) TimeOutNode.getElementsByTagName("TIMEOUT_INIT").item(0);
			this.INSTANCE_TIMEOUT_INIT = Integer.parseInt(SubNode.getAttribute("value"));

			if (log.isDebugEnabled()) 
				log.debug("INSTANCE_TIMEOUT_INIT=>" + String.valueOf(INSTANCE_TIMEOUT_INIT));

			SubNode = (Element) TimeOutNode.getElementsByTagName("TIMEOUT_HELO").item(0);
			this.INSTANCE_TIMEOUT_HELO = Integer.parseInt(SubNode.getAttribute("value"));

			if (log.isDebugEnabled()) 
				log.debug("INSTANCE_TIMEOUT_HELO=>" + String.valueOf(INSTANCE_TIMEOUT_HELO));

			SubNode = (Element) TimeOutNode.getElementsByTagName("TIMEOUT_MAILFROM").item(0);
			this.INSTANCE_TIMEOUT_MAILFROM = Integer.parseInt(SubNode.getAttribute("value"));

			if (log.isDebugEnabled()) 
				log.debug("INSTANCE_TIMEOUT_MAILFROM=>" + String.valueOf(INSTANCE_TIMEOUT_MAILFROM));

			SubNode = (Element) TimeOutNode.getElementsByTagName("TIMEOUT_RCPT").item(0);
			this.INSTANCE_TIMEOUT_RCPT = Integer.parseInt(SubNode.getAttribute("value"));

			if (log.isDebugEnabled()) 
				log.debug("INSTANCE_TIMEOUT_RCPT=>" + String.valueOf(INSTANCE_TIMEOUT_RCPT));

			SubNode = (Element) TimeOutNode.getElementsByTagName("TIMEOUT_DATAINIT").item(0);
			this.INSTANCE_TIMEOUT_DATAINIT = Integer.parseInt(SubNode.getAttribute("value"));

			if (log.isDebugEnabled()) 
				log.debug("INSTANCE_TIMEOUT_DATAINIT=>" + String.valueOf(INSTANCE_TIMEOUT_DATAINIT));

			SubNode = (Element) TimeOutNode.getElementsByTagName("TIMEOUT_DATABLOCK").item(0);
			this.INSTANCE_TIMEOUT_DATABLOCK = Integer.parseInt(SubNode.getAttribute("value"));

			if (log.isDebugEnabled()) 
				log.debug("INSTANCE_TIMEOUT_DATABLOCK=>" + String.valueOf(INSTANCE_TIMEOUT_DATABLOCK));

			SubNode = (Element) TimeOutNode.getElementsByTagName("TIMEOUT_RSET").item(0);
			this.INSTANCE_TIMEOUT_RSET = Integer.parseInt(SubNode.getAttribute("value"));

			if (log.isDebugEnabled()) 
				log.debug("INSTANCE_TIMEOUT_RSET=>" + String.valueOf(INSTANCE_TIMEOUT_RSET));
		}

		// reset 크기 지정
		SubNode = (Element) TargetNode.getElementsByTagName("rset").item(0);
		if( SubNode != null ) {
			this.SMTP_REST_LIMIT = Integer.parseInt(SubNode.getAttribute("value"));
		}

		// 발송 쓰레드를 결정
		SubNode = (Element) TargetNode.getElementsByTagName("subclass").item(0);
		AGENT_CLASS_NAME = SubNode.getAttribute("value");
		AGENT_CLASS = Class.forName(AGENT_CLASS_NAME);

		// 용량 지정
		SubNode = (Element) TargetNode.getElementsByTagName("size").item(0);
		int iWorkerSize = Integer.parseInt(SubNode.getAttribute("value"));
		
		SubNode = (Element) TargetNode.getElementsByTagName("resetsize").item(0);
		int iResetSize = Integer.parseInt(SubNode.getAttribute("value"));

		// 버퍼 사이즈 조정
		SubNode = (Element) TargetNode.getElementsByTagName("buffersize").item(0);
		int iBufferSize = Integer.parseInt(SubNode.getAttribute("value"));

		/**
		 * 노는 녀석이 없을때 기다릴지 아니면 넘어갈지 결정한다.
		 */
		SubNode = (Element) TargetNode.getElementsByTagName("wait").item(0);
		this.WAIT_EMPTY = "true".equals(SubNode.getAttribute("value")) ? true : false;

		SubNode = (Element) TargetNode.getElementsByTagName("delay").item(0);
		String sDelayValue = SubNode.getAttribute("value");
		if (log.isDebugEnabled()) {
			log.debug("{} AgentPool Delay: {}", name, sDelayValue);
		}
		this.AGENT_WORK_DELAY = Integer.decode(sDelayValue);
		if (log.isDebugEnabled()) {
			log.debug("{} AgentPool DelayConvert: {}", name, this.AGENT_WORK_DELAY.toString());
		}

		/**
		 * 쓰레드 그룹을 지정한다.
		 */
		this.group = new ThreadGroup(eMsLocale.EMS_ROOT_THREAD_GROUP, "AgentPool=>" + getName());

// 여기서 worker size를 셋팅하면 Actor들을 WORKER_LIST에 값 만큼 채워넣어서 start 시킨다.
		//resetsize
		if(iResetSize==0) setWorkerSize(iWorkerSize);
		else              setWorkerSize(iWorkerSize, iResetSize); //일하는 놈들 갯수랑 작업량(단일)갯수랑 분리
		
//		setWorkerSize(iWorkerSize);

		// 버퍼 사이즈를 지정한다.
		resetBufferSize(iBufferSize);
	}

	/**
	 * 아랫것들이 플러쉬를 할때 상위 버퍼를 비워주는 로직
	 */
	protected void inner_flush() throws Exception {
		if( this.STACK_OF_BUFFERED_OBJECT.size() == 0 ) {
			if( POOL_DEBUG ) {
				log("CALL INNER FLUSH BUT NO BUFFER CONTENTS REMAIN.. SO DO NOTHING");
			}
			return;
		}

		log("FLUSH REMAIN IN BUFFER");

		while (this.BUFFER_IS_MODIFIED && (this.STACK_OF_BUFFERED_OBJECT.size() > 0 ||this.STACK_PRIORITY_OF_BUFFERED_OBJECT.size() > 0 )) {
			if( POOL_DEBUG ) {
				log("remain size:" + String.valueOf(this.STACK_OF_BUFFERED_OBJECT.size()));
				log("call notifyAll");
			}

			synchronized (this.LOCK_OF_OUTPUT) {
				try {
					this.LOCK_OF_OUTPUT.notifyAll();
				}
				catch(Exception e) {
				}
			}
			synchronized (this.LOCK_OF_NORMAL_INPUT) {
				try {
					this.LOCK_OF_NORMAL_INPUT.notifyAll();
				}
				catch(Exception e) {
				}
			}
			synchronized (this.LOCK_OF_PRIORITY_INPUT) {
				try {
					this.LOCK_OF_PRIORITY_INPUT.notifyAll();
				}
				catch(Exception e) {
				}
			}
			if( POOL_DEBUG ) {
				log("call notifyAll[OK]");
			}
			// 버퍼가 변경 되었음을 마킹
			this.BUFFER_IS_MODIFIED = false;

			try {
				Thread.currentThread().sleep(3000);
			}
			catch(Exception e) {
			}
			if( POOL_DEBUG ) {
				log("out wait");
			}
		}
		log("FLUSH REMAIN IN BUFFER END");
	}

	public abstract void registSpool(String domain, String spool);

	protected Bufferable create(int seq, int level) throws Exception {
		if (log.isDebugEnabled()) {
			log("INTO CREATE METHOD");
		}
		// AGENT_CLASS=QueRecycleCommunicationActor
		// AGENT_CLASS=StandardSingleRcptBufferedCommunicationActor
		SmtpCommunicator worker = (SmtpCommunicator) AGENT_CLASS.newInstance();  

		worker.setTIMEOUT_CONNECT(this.INSTANCE_TIMEOUT_CONNECT);
		worker.setTIMEOUT_INIT(this.INSTANCE_TIMEOUT_INIT);
		worker.setTIMEOUT_HELO(this.INSTANCE_TIMEOUT_HELO);
		worker.setTIMEOUT_MAILFROM(this.INSTANCE_TIMEOUT_MAILFROM);
		worker.setTIMEOUT_RCPT(this.INSTANCE_TIMEOUT_RCPT);
		worker.setTIMEOUT_DATAINIT(this.INSTANCE_TIMEOUT_DATAINIT);
		worker.setTIMEOUT_DATABLOCK(this.INSTANCE_TIMEOUT_DATABLOCK);
		worker.setTIMEOUT_RSET(this.INSTANCE_TIMEOUT_RSET);

		if (log.isDebugEnabled()) {
			log("CREATE INSTANCE");
		}
		// worker = AbstractBufferedCommunicationActor  
		((BufferedCommunicationActor) worker).setParameter(this, this.group, seq, this.AGENT_WORK_DELAY, this.SMTP_REST_LIMIT);
		if (log.isDebugEnabled()) {
			log("CREATE SUCCESS AND RETURN");
		}
		return (Bufferable) worker;
	}
}
