/*
 * StandAloneSmtpCommunicator.java
 *
 * Created on 2003년 3월 7일 금, 오전 1:51
 */

package jupiter.common.communicator;

import java.util.Vector;

import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.mail.SendState;

/**
 *
 * @author  Administrator
 * @version
 */
@Slf4j
public class StandAloneSmtpCommunicator extends SmtpCommunicator {
	
	
	protected long time_interval = 0;
	
	protected Vector<Object> resultVector = new Vector<Object>();
	
	protected String MAIL_FROM = null;
	
	protected String MAIL_DATA = null;
	
	protected Vector<Object> rcptVector = null;
	
	/** Creates new StandAloneSmtpCommunicator */
	public StandAloneSmtpCommunicator() throws Exception {
		this("StandAloneSmtpCommunicator");
	}
	
	public StandAloneSmtpCommunicator(String n) throws Exception {
		super();
		setName( n );
		this.rcptVector = new Vector<Object>();
	}
	
	public void setDomain( String domain ){
		this.domain = domain;
	}
	
	public void setMailFrom( String mail ){
		this.MAIL_FROM = mail;
	}
	
	public void setData( String data ){
		this.MAIL_DATA = data;
		
	}
	
	public void setRcptTo( String email ){
		this.rcptVector.addElement( email );
	}
	
	/**메일 발송을 하고 난다음에 결과를 String Array로 반환한다.<br>
	 *1 : 코드 <br>
	 *2 : 메세지
	 */
	public Vector<Object> execute() {
		resultVector.clear();
		
		if( this.rcptVector == null
				|| this.rcptVector.isEmpty()) {
			return resultVector;
		}
		
		String[] returnValue = new String[3];
		
		/**시작 시간을 마킹하고
		 */
		this.time_interval = System.currentTimeMillis();
		
		if (log.isDebugEnabled()) {
			log.debug( "into connect");
		}
		
		try {
			/*실제 통신을 실행한다.
			 *통신은 INIT -> BODY 까지만 진행을 한다.
			 */
			inner_work();
		}
		catch (Exception e ) {
			log.error( getName() , e );
			returnValue[0] = "FATAL ERROR";
			returnValue[1] = "99";
			returnValue[2] = e.toString();
			resultVector.addElement( returnValue );
		}
		
		/** BODY까지 진행이 된건지 아니면 중간에 Exception이 발생한건지 판단하여 뒷처리를 한다.
		 */
		// HELO 단계를 지났다면 QUIT를 실행한다.
		if( this.CURR_STEP > SendState.HELO ) {
			if (log.isDebugEnabled()) {
				log.debug( "step QUIT");
			}
			step( SendState.QUIT , null , this.domain , 0 );
		}
		
		// 이제 모든 통신을 종료한다.
		if (log.isDebugEnabled()) {
			log.debug( "step CLOSE");
		}
		this.close();
		
		this.rcptVector.clear();
		
		return resultVector;
	}
	
	private void inner_work() throws Exception {
		/**자 시작 합니다.
		 */
		this.CURR_STEP = SendState.START;
		
		// 대상 도메인의 메일 서버로 연결을 시도 합니다.
		if (log.isDebugEnabled()) {
			log.debug( "step connect DOMAIN");
		}
		connect( this.domain , "0" );
		
		if( this.sendState.isError() ) {
			allErrorProcess();
			return;
		}
			
		// HELO 하러 갑니다.
		step( SendState.HELO , eMsLocale.SMTP_LOCAL_HOST[0] , this.domain , 0 );
		if( this.sendState.isError() ) {
			allErrorProcess();
			return;
		}
		
		// MAIL_FROM 하러 갑니다.
		if (log.isDebugEnabled()) {
			log.debug( "step MAIL_FROM");
		}
		step( SendState.MAIL_FROM , this.MAIL_FROM , this.domain , 0 );
		if( this.sendState.isError() ) {
			allErrorProcess();
			return;
		}
		
		// HELO를정상적으로 받았습니다.
		this.CURR_STEP = SendState.MAIL_FROM;
		
		/**이제 중요한 RCPT 입니다.
		 */
		if (log.isDebugEnabled()) {
			log.debug( "step RCPT_TO");
		}
		
		String tmp = null;
		for( int i = 0 ; i < this.rcptVector.size() ; i++ ) {
			tmp = (String)this.rcptVector.get( i );
			
			step( SendState.RCPT_TO , tmp , this.domain , 0 );
			
			if( this.sendState.isError() ) {
				errorProcess( tmp );
				//에러처리를 하고 처리한 RCPT는 제외하고 인덱스도 하나 줄인다.
				this.rcptVector.remove(i);
				i--;
			}
		}
		
		if( this.rcptVector.isEmpty()) return;
		
		// 무사히 RCPT가 끝났습니다.
		this.CURR_STEP = SendState.RCPT_TO;
		
		// DATA 를 전송합니다.
		if (log.isDebugEnabled()) {
			log.debug( "step DATA");
		}
		step( SendState.DATA , null , this.domain , 0 );
		if( this.sendState.isError() ) {
			allErrorProcess();
			return;
		}
		// 무사히 RCPT가 끝났습니다.
		this.CURR_STEP = SendState.DATA;
		
		// 실제 메일 바디를 전송합니다.
		if (log.isDebugEnabled()) {
			log.debug( "step DATA_BODY");
		}
		step( SendState.DATA_BODY , this.MAIL_DATA , this.domain , 0 );
		if( this.sendState.isError() ) {
			allErrorProcess();
			return;
		}
		
		successProcess();
		return;
	}
	
	private void allErrorProcess() {
		String tmp = null;
		while( !this.rcptVector.isEmpty() ) {
			tmp = (String)rcptVector.remove( 0 );
			errorProcess(tmp);
		}
	}
	
	private void successProcess() {
		String tmp = null;
		String[] returnValue = new String[3];
		while( !this.rcptVector.isEmpty()) {
			tmp = (String)rcptVector.remove( 0 );
			returnValue[0] = tmp;
			returnValue[1] = this.sendState.getRETURN_CODE();
			returnValue[2] = this.sendState.getMESSAGE();
			resultVector.addElement( returnValue );
		}
	}
	
	/**
	 */
	private void errorProcess(String mId) {
		String[] returnValue = new String[3];
		returnValue[0] = mId;
		returnValue[1] = this.sendState.getRETURN_CODE();
		returnValue[2] = this.sendState.getMESSAGE();
		resultVector.addElement( returnValue );
	}
	
	public void log(String log) {
	}
}
