/*
 * SingleContentSmtpCommunicator.java
 *
 * Created on 2003년 3월 7일 금, 오전 1:51
 */

package jupiter.common.communicator;

import java.util.Properties;

import mercury.contents.common.body.MailBody;
import mercury.contents.common.message.Message;
import mercury.contents.common.parser.BodyParser;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.lang.eMsTypes;
import pluto.mail.SendState;
import pluto.util.StringUtil;
/**
 *
 * @author  Administrator
 * @version
 */
@Slf4j
public class SingleContentSmtpCommunicator extends SmtpCommunicator {
	
	
	public static final String MAIL_BODY_CLASS_NAME = "mercury.contents.common.body.SingleTonMailBody";
	public static final String BODY_PARSER_CLASS_NAME = "mercury.contents.common.parser.StringBodyParser";
	public static final String MESSAGE_CLASS_NAME = "mercury.contents.common.message.SimpleMessage";
	
	public static final int CONSTANT_CONNECTION_TIME_OUT = 30000;
	
	protected long timeInterval = 0;
	
	protected String returnPath = null;
	
	protected String tokenData = null;
	
	protected String toToken = null;
	
	protected MailBody mailBody = null;
	protected BodyParser bodyParser = null;
	protected Message message = null;
	
	/** Creates new StandAloneSmtpCommunicator */
	public SingleContentSmtpCommunicator() throws Exception {
		this("StandAloneSmtpCommunicator");
	}
	
	/**
	 * 
	 * @param name
	 * @throws Exception
	 */
	public SingleContentSmtpCommunicator(String name) throws Exception {
		super( true );
		setName(name);
		mailBody = ( MailBody )( Class.forName( MAIL_BODY_CLASS_NAME ).newInstance() );
		bodyParser = ( BodyParser )( Class.forName( BODY_PARSER_CLASS_NAME ).newInstance() );
		message = ( Message )( Class.forName( MESSAGE_CLASS_NAME ).newInstance() );
		
		message.setContentType( new Short( eMsTypes.TEXT_HTML ) );
		message.setCharSet( eMsLocale.MAIL_MIME_CHAR_SET );
		message.setContentEncoding( new Short( eMsLocale.MAIL_ENC_TYPE ) );
		message.setMessageID( "SingleContentSmtpCommunicator's message" );
		
		message.setContent( bodyParser );
		
		mailBody.setMessage( message );
		
		mailBody.setEtcHeader( eMsLocale.DEFAULT_HEADER );
		
		this.INSTANCE_TIMEOUT_INIT = CONSTANT_CONNECTION_TIME_OUT;
	}
	
	public void setProperty( Properties prop ) throws Exception {
		this.returnPath = prop.getProperty( "RETURN_PATH" );
		this.toToken = prop.getProperty( "TMS_M_TOKEN" );
		this.domain = StringUtil.getDomain( this.toToken );
		
		mailBody.setSubject( prop.getProperty( "SUBJECT" ) );
		mailBody.setFromName( prop.getProperty( "FROM_NAME" ) );
		mailBody.setFromEmail( prop.getProperty( "FROM_EMAIL" ) );
		mailBody.setToName( prop.getProperty( "TMS_M_NAME" ) );
		mailBody.setToEmail( prop.getProperty( "TMS_M_TOKEN" ) );
		
		bodyParser.setContents( prop.getProperty("CONTENT") );
		
		
		this.tokenData = mailBody.getMailBody( prop , null , null );
	}
	
	/**메일 발송을 하고 난다음에 결과를 String Array로 반환한다.<br>
	 *1 : 코드 <br>
	 *2 : 메세지
	 *
	 */
	public String execute() {
		String resultString = null;
		/**시작 시간을 마킹하고
		 */
		this.timeInterval = System.currentTimeMillis();
		
		if (log.isDebugEnabled()) {
			log.debug("into connect");
		}
		
		try {
			/*실제 통신을 실행한다.
			 *통신은 INIT -> BODY 까지만 진행을 한다.
			 */
			resultString = innerWork();
		}
		catch( Exception e ) {
			log.error( getName() , e );
			resultString = "FATAL ERROR:".concat( e.toString() );
		}
		
		/** BODY까지 진행이 된건지 아니면 중간에 Exception이 발생한건지 판단하여 뒷처리를 한다.
		 */
		// HELO 단계를 지났다면 QUIT를 실행한다.
		if( this.CURR_STEP > SendState.HELO ) {
			if (log.isDebugEnabled()) {
				log.debug( "step QUIT");
			}
			step( SendState.QUIT , null , this.domain , 0 );
		}
		
		// 이제 모든 통신을 종료한다.
		if (log.isDebugEnabled()) {
			log.debug( "step CLOSE");
		}
		this.close();
		
		return resultString;
	}
	
	private String innerWork() throws Exception {
		/**자 시작 합니다.
		 */
		this.CURR_STEP = SendState.START;
		
		// 대상 도메인의 메일 서버로 연결을 시도 합니다.
		if (log.isDebugEnabled()) {
			log.debug("step connect DOMAIN");
		}
		connect( this.domain , "0" );
		
		if( this.sendState.isError() ) {
			return this.sendState.getMESSAGE();
		}
		
		// HELO 하러 갑니다.
		step( SendState.HELO , eMsLocale.SMTP_LOCAL_HOST[0] , this.domain , 0 );
		if( this.sendState.isError() ) {
			return this.sendState.getMESSAGE();
		}
		
		// MAIL_FROM 하러 갑니다.
		step( SendState.MAIL_FROM , this.returnPath , this.domain , 0 );
		if( this.sendState.isError() ) {
			return this.sendState.getMESSAGE();
		}
		
		// HELO를정상적으로 받았습니다.
		this.CURR_STEP = SendState.MAIL_FROM;
		
		/**이제 중요한 RCPT 입니다.
		 */
		step( SendState.RCPT_TO , toToken , this.domain , 0 );
		
		if( this.sendState.isError() ) {
			return this.sendState.getMESSAGE();
		}
		
		// 무사히 RCPT가 끝났습니다.
		this.CURR_STEP = SendState.RCPT_TO;
		
		// DATA 를 전송합니다.
		step( SendState.DATA , null , this.domain , 0 );
		if( this.sendState.isError() ) {
			return this.sendState.getMESSAGE();
		}
		// 무사히 RCPT가 끝났습니다.
		this.CURR_STEP = SendState.DATA;
		
		// 실제 메일 바디를 전송합니다.
		step( SendState.DATA_BODY , this.tokenData , this.domain , 0 );
		if( this.sendState.isError() ) {
			return this.sendState.getMESSAGE();
		}
		
		return this.sendState.getMESSAGE();
	}
	
	@Override
	public void log(String log) {
		// 
	}
}
