/*
 * @(#)ListMaker.java            2004. 11. 24.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package jupiter.common.actor;

import java.util.Properties;
/**
 * 리스트를 생성하는 로직을 정의한다.
 * 
 * @version		
 * @author 		dragon
 *
 */
public interface ListMaker extends pluto.log.Log {
	
	
	public static final String KEY_HEADER_STRING = "MAPPINGHEADER";
	
	public static final String KEY_OF_MAIN_QUERY_STRING = "MAIN_QUERY_STRING";
	public static final String KEY_OF_TEST_SEND_QUERY_STRING="TEST SEND QUERY STRING";
	public static final String KEY_OF_ADDDB_QUERY_STRING = "ADDDB_QUERY_STRING";
	public static final String KEY_OF_BASIC_MAPPING_FILE = "BASIC MAPPING FILE";
	public static final String KEY_OF_ADD_MAPPING_FILE = "ADD MAPPING FILE";

	public static final String KEY_MAIN_LIST_QUERY = "A";
	public static final String KEY_SUB_LIST_QUERY = "B";
	
	public static final String KEY_MAIN_LIST_FILENAME = "C";
	public static final String KEY_SUB_LIST_ADDED_FILENAME = "D";
	
	public static final String KEY_FINAL_LIST_FILENAME = "__LIST_FILE_NAME__";
	
	/** 실제적인 리스트 생성 로직을 구현한다.
	 * @param prop 발송 정보
	 * @throws Exception 에러
	 */	
	public void process( Properties prop ) throws Exception;
	
	/** 데이터 베이스에 리스트를 생성하는 ListMaker는 구현하지 않아도 되지만<br>
	 * 생성된 정보를 바로 사용할 경우에는 이 Method를 통해서 생성된 정보를 반환한다.
	 * @return 생성된 리스트 정보
	 */	
	public Object getTargetList();

	/** 리스트 생성중에 임시로 만든 파일등을 정리하는 로직
	 */	
	public void destroy();
	
	/** 
	 * 
	 * @return
	 */
	public String getID();
	
	/**
	 * 
	 * @return
	 */
	public String getMAPPING_HEADER();
}
