/*
 * BufferedCommunicationActor.java
 *
 * Created on 2003년 11월 19일 (수), 오전 3:23
 */

package jupiter.common.actor;

import pluto.util.recycle.BufferBin;
/** 메일 발송에 필요한 기본 패턴을 정의한다.
 * @author 이상근
 * @version 3.0
 */
public interface BufferedCommunicationActor extends Runnable{

	/**개인화 메일 방식
	 */
	public static final short ONE_TO_ONE_TYPE = 1;
	
	/**벌크메일 방식
	 */
	public static final short BULK_TYPE = 2;
	
	/** 발송할 도메인을 지정
	 * @param domain 발송할 도메인
	 */
	public void setDomain( String domain );

	/**발송하고난 결과를 반환할수 있는..
	 */
	public short getErrorType();
	
	/**시작을 알리는 종소리
	 */
	public void execute();
	
	/**이녀석이 돌아갈 때 필요한 것들을 세팅한다.
	 */
	public void setParameter(BufferBin bin, ThreadGroup group, int name_idx, Integer inter_delay, int rset_count );
}

