/*
 * @(#)TestSendTask.java            2004. 12. 7.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.auto.send.task;

import java.util.Properties;

import jupiter.common.actor.ListMaker;
import jupiter.common.pool.BufferedAgentPool;
import jupiter.common.task.AbstractNoDBMailSendTask;
import jupiter.mass.send.basic.SendStopException;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import mercury.contents.common.producer.ContentPD;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsStatement;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.lang.eMsTypes;
import pluto.log.ErrorSpoolLogger;
import pluto.mail.MailSendingInstanceFactory;
import pluto.mail.mx.LookupCacheManager;
import pluto.mail.mx.exception.NameNotKnownException;
import pluto.panopticon.filter.RejectFilter;
import pluto.panopticon.monitor.MailSendDomainFilter;
import pluto.reporter.Reporter;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import venus.spool.common.basic.InstanceFactory;
import venus.spool.common.basic.SpoolingManager;
import venus.spool.common.popper.Popper;
import venus.spool.common.task.SpoolControlTask;

/**
 * Class description :
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class TestSendTask extends AbstractNoDBMailSendTask {

	/** 리스트 메이커 인스턴스 */
	protected ListMaker				INNER_LIST_MAKER	= null;

	/** 매핑 헤더 정보 */
	protected Properties			MAPPING_HEADER_INFO	= null;
	
	public int  send_cnt = 0;

	protected String				MAIL_ID = "";
	
	/*
	UPDATE EMS_AUTO_SCHEDULE_INFO
	   SET TEST_STATUS = '${TEST_STATUS}'
	      ,TEST_DATE   = GETDATE()
	      ,TEST_CNT    = '${TEST_CNT}'
	 WHERE WORKDAY     = '${WORKDAY}'
	   AND SEQNO       = '${SEQNO}'
	   AND SERVER_ID   = '##SERVER_ID##'
	 */
	private static String QUERY_UPDATE_TEST_STATUS = null;
	
	private static String QUERY_UPDATE_PLAN_TEST_FLAG = null;
	
	static {
		try {
			QUERY_UPDATE_TEST_STATUS = SqlManager.getQuery("TMS_EMAIL_TEST", "QUERY_UPDATE_TEST_STATUS");
			
			//QUERY_UPDATE_PLAN_TEST_FLAG = SqlManager.getQuery("TMS_EMAIL_TEST", "QUERY_UPDATE_PLAN_TEST_FLAG");
		}catch(Exception e) {
			log.error(e.getMessage());
			System.exit(1);
		}
	}

	/** Creates a new instance of TestSendTask */
	public TestSendTask() throws Exception {
		super();
	}

	public void setTaskProperty(Properties prop) {

		this.TASK_PROPERTY = prop;
		this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		//this.CHANNEL_SEQ = this.TASK_PROPERTY.getProperty( "CHANNEL_SEQ" );
		
		this.setTaskID(this.POST_ID+"_TEST");	
		this.MAIL_ID = this.TASK_PROPERTY.getProperty("MAIL_ID","NO ID");
		this.setName("["+this.MAIL_ID+"] "+this.POST_ID + "_TestSendTask");
		
		this.WORK_FILE_ID = this.POST_ID.concat("_test_").concat(Cal.getSerialDate());
	}

	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록
	 * 되어있다.
	 */
	public void execute_initiate() throws Exception {
	}

	/**
	 * Contents 를 생성하고 Xml을 ContentInfo로 변환하여 Manager에 등록한다. setTaskProperty()가
	 * 호출된 이후에 실행되어야 된다.
	 */
	protected void execute_ContentLoad() throws Exception {

		ContentPD INNER_CONTENT_PD = (ContentPD) MailSendingInstanceFactory.getInstance(this.TASK_PROPERTY, eMsTypes.CONTENTPD_INSTANCE);
		INNER_CONTENT_PD.process(this.TASK_PROPERTY);

		ContentInfo __CONTENT_INFO__ = INNER_CONTENT_PD.getContentInfo();
		ContentInfoManager.putContentInfo(__CONTENT_INFO__, false);
		ContentInfoManager.registContentInfo(__CONTENT_INFO__);		//시험발송 실첨부가 정상적으로 되지 않아 추가
	}

	/**
	 * ListMaker Instance를 생성시켜 Call 해준다.
	 */
	protected void execute_ListMake() throws Exception {

		this.INNER_LIST_MAKER = (ListMaker) MailSendingInstanceFactory.getInstance(this.TASK_PROPERTY, eMsTypes.LISTMAKER_INSTANCE);
		INNER_LIST_MAKER.process(this.TASK_PROPERTY);

		if( this.MAPPING_HEADER_INFO == null )
			this.MAPPING_HEADER_INFO = new Properties();
		
		this.MAPPING_HEADER_INFO.setProperty(this.INNER_LIST_MAKER.getID(), this.INNER_LIST_MAKER.getMAPPING_HEADER());
	}

	protected void execute_ListLoad() throws Exception {

		SpoolControlTask targetTask = (SpoolControlTask) InstanceFactory.getInstance(this.TASK_PROPERTY, eMsTypes.SPOOLTASK_INSTANCE);

		// 테스트 발송은 list make 후 db에 넣지 않고 파일 그 자체로 spool을 만든다.
		this.TASK_PROPERTY.setProperty("TARGET_LIST_FILE", (String) INNER_LIST_MAKER.getTargetList());

		targetTask.setTaskProperty(this.TASK_PROPERTY);

		// 매핑 헤더 정보를 셋팅한다. ( List Make에서 만든 매핑 헤더 정보가 닮겨있다. )
		targetTask.setMAPPING_HEADER_INFO(this.MAPPING_HEADER_INFO);

		// 부자연스러운 호출이지만 일단 Go. [ 추후에 변경 요망 ]
		targetTask.internal_execute();

		// Spool에 대한 정보를 빼내자.
		this.mailSpoolInfo = targetTask.getSpoolInfo();

	}


	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
	}

	/**
	 * 리스트를 뿌리러 들어갈때 실행
	 */
	protected void execute_Startup() throws Exception {
//		update_test_status("30");
		update_test_status("30","--");
	}

	/**
	 * 리스트를 뿌리러 들어갈때 실행
	 */
	protected void execute_SendStartUpdate() throws Exception {
	}

	/**
	 * 리스트를 다 뿌리고 나올때 실행
	 */
	protected void execute_Finish() throws Exception {
//		update_test_status("40");
		update_test_status("40","30");
	}
	
	/**
	 * 상태업데이트
	 * @param status
	 * @param cnt
	 * @throws Exception
	 */
	protected void update_test_status(String status, String now_status) throws Exception{
		
		this.TASK_PROPERTY.setProperty("JOB_STATUS", status);
//		this.TASK_PROPERTY.setProperty("TEST_CNT", ""+this.send_cnt);
		this.TASK_PROPERTY.setProperty("JOB_STATUS_NOW", now_status);
		
		eMsConnection 	conn = null;
		eMsStatement 	stmt = null;
		try{
			conn = ConnectionPool.getConnection();
			stmt = conn.createStatement();
			StringBuffer	buffer = new StringBuffer();
			StringConvertUtil.ConvertString(buffer, QUERY_UPDATE_TEST_STATUS, this.TASK_PROPERTY , "${", "}", true, false);
			stmt.executeUpdate( buffer.toString() );
			
		} catch(Exception e){
			log.error(this.getName(), e);
			throw e;
		} finally{
			if(conn != null){
				conn.recycleStatement(stmt);
				conn.recycle();
			}
		}
	}
	
	protected synchronized void execute_ListSend() throws Exception {
		execute_test_ListSend();
	}
	
	protected synchronized void execute_test_ListSend() throws Exception {

		if (log.isDebugEnabled()) {
			log.debug("EXEC execute_test_ListSend");
		}

		// Popper의 Instance는 xml의 POPPER FACTORY에 정의되어 있다.
		// 보낼 대상이 등록되어 있으면 그것으로 SPOOL_POPPER를 초기화한다.
		if( this.mailSpoolInfo != null ) {
			SPOOL_POPPER = Popper.getInstance();

			/*
			 * 주기발송이나 수시발송의 경우 List쿼리의 결과가 없으면 41로 상태가 바뀐다. 여기서 Spool정보 XML파일의
			 * 정보를 미리가져와서 Vector가 비었는지 체크 필
			 */
			if( this.mailSpoolInfo.getSpoolFilesInfo().isEmpty() ) {
				//if (log.isDebugEnabled())
				log.debug( "No Real Data.... So Skip");

				return;
			}

			try{
				SPOOL_POPPER.setTaskProp(TASK_PROPERTY);	//수신거부재필터링으로 인해 추가
				SPOOL_POPPER.init(this.SPOOL_DIRECTORY, this.mailSpoolInfo.getSpoolFilesInfo());
			}catch(Exception ex){
				log.error(this.getName(), ex);
			}
		}
		else {
			log.debug( "MAIL SPOOL INFO IS NULL SO SKIP..");
			return;
		}

		if( this.SPOOL_POPPER == null ) {
			log.error("No Real Data.... So Skip");
			return;
		}

		if( execute_StopCheck() ) {
			throw new SendStopException(getName() + " receive stop signal");
		}

		RejectFilter instanceRejectFilter = RejectFilter.getFilterInstance(this.TASK_PROPERTY);

		String nextSpool = null;
		String domain = null;
		int spoolPatchCount = 0;
		BufferedAgentPool pool = null;

		while ((nextSpool = (String) this.SPOOL_POPPER.next()) != null) {

			//발송 건수 확인
			this.send_cnt++;
			
			if( nextSpool == null || nextSpool.length() < 1 )
				continue;

			if( spoolPatchCount++ % instance_STOP_CHECK_RECYCLE == 0 ) {
				if( execute_StopCheck() ) {
					throw new SendStopException(getName() + " receive stop signal");
				}
			}

			try {
				
				if("SMS".equalsIgnoreCase(this.TASK_PROPERTY.getProperty("SMS_TYPE")) || "LMS".equalsIgnoreCase(this.TASK_PROPERTY.getProperty("SMS_TYPE")) || "PUSH".equalsIgnoreCase(this.TASK_PROPERTY.getProperty("SMS_TYPE"))){
					domain = this.TASK_PROPERTY.getProperty("SMS_TYPE").toLowerCase();
				}else{
					domain = this.SPOOL_ANALYZER.pickupDomain(nextSpool);
				}

				if( domain == null ) {
					processSyntaxErrorSpool(nextSpool);
					continue;
				}

				// reject할 도메인 관리하려면 사용한다.
				if( MailSendDomainFilter.isFilterPresent() && MailSendDomainFilter.isTargetDomain(domain) ) {

					passRejectDomain(nextSpool);
					continue;
				}

				// Spool의 내용에서 필터링을 적용하여 보내지 않을 대상인지를 판별한다.
				if( instanceRejectFilter != null ) {

					this.SPOOL_ANALYZER.parse(nextSpool);

					if( instanceRejectFilter.isFiltered(this.SPOOL_ANALYZER) ) {
						continue;
					}

					nextSpool = this.SPOOL_ANALYZER.composeSingleRcptSend();
				}

				//도메인을 Lookup 한다.
				DOMAIN_NOT_FOUND_EXCEPTION = LookupCacheManager.isInvalidDomain(domain);

				if( DOMAIN_NOT_FOUND_EXCEPTION != null && DOMAIN_NOT_FOUND_EXCEPTION instanceof NameNotKnownException ) {
					passDomainNotFound(nextSpool, DOMAIN_NOT_FOUND_EXCEPTION);
				}
				else {
					pool = this.getBufferedObjectPool(domain);
					pool.registSpool(domain, nextSpool);
				}
			}
			catch(OutOfMemoryError outError) {
				log.error("OOM error", outError);
				System.gc();

				try {
					wait(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
				}
				catch(Exception ignore) {
				}

				try {
					//뜻하지 않은 에러이므로 재발송 스풀 생성을 담당하는 SpoolingManager에 넣어준다.
					SpoolingManager.registSpool(nextSpool);
				}
				catch(Exception ignore) {
				}

				continue;
			}
			catch(Throwable err) {
				log.error("error", err);
				ErrorSpoolLogger.put(nextSpool + " => send : " + err.toString());
				continue;
			}
		}

		if (log.isDebugEnabled()) 
			log.debug("EXEC BufferedAgentPool.flushAll()");

		BufferedAgentPool.flushAll();

		if (log.isDebugEnabled()) 
			log.debug("EXEC execute_ListSend [OK]");
	}
	
	

	/**
	 * 발송 정지 상태를 점검하고 정지되었다면 로그를 작성한다.
	 */
	protected boolean execute_StopCheck() {
		return false;
	}

	/**
	 * 지정된 도메인의 BufferedPool을 반환한다. BufferedAgentPool.getBufferedObjectPool(
	 * domain );
	 */
	protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
		return BufferedAgentPool.getBufferedObjectPool("single", domain);
	}

	/**
	 * 메인 프로세스를 실행하다가 에러가 발생하면 실행되는루틴
	 */
	public void doErrorProcess(Throwable thw) {
		log.error(getName(), thw);
		//REPORT 데이터베이스 커넥션을 가져오는 과정에서 에러가 발생하였습니다.
		try {
			update_test_status("41","30");
		} catch (Exception e) {
			log.error(this.getName(), e);
		}
		
		Reporter.report(getName(), getName(), "mailsendtask.exec.err", thw);
	}

	public void release_Resource() {
	}

	/**
	 * 도메인이 없을경우 에러처리하는 녀석
	 */
	protected void passDomainNotFound(String spool, Throwable ex) throws Exception {
		log.error("TEST SPOOL DOMAIN INVALID", spool.concat("=>").concat(ex.toString()));
	}

	protected void processSyntaxErrorSpool(String spool) throws Exception {
		log.error("TEST SPOOL SYNTAX ERROR", spool);
	}

	protected void passRejectDomain(String spool) throws Exception {
		log.error("TEST SPOOL DOMAIN REJECTED", spool);
	}
}
