/*
 * @(#)SmsQueRetrySendTask.java            2004. 12. 7.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package jupiter.auto.send.task;

import java.util.List;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.lang.eMsTypes;
import pluto.util.Cal;
import venus.spool.common.basic.InstanceFactory;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.task.SpoolControlTask;
/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class SmsQueRetrySendTask extends SmsAutoBaseSendTask {
	

	private static List QUERY_UPDATE_STATE_INFO = null;

	static {
		try {
			// INSTANCE_QUERY_UPDATE_STATE_INFO 멤버 변수에 지정되어 스테이트를 업데이트 해준다.
			QUERY_UPDATE_STATE_INFO = SqlManager.getMultiQuery("COMMON","QUERY_UPDATE_STATE_INFO");
		}
		catch( Exception ignore ) {
			log.error(ignore.getMessage());
		}
	}
	
	/** Creates a new instance of SmsQueRetrySendTask */
	public SmsQueRetrySendTask() throws Exception {
		super();
	}
	
	public void setTaskProperty(Properties prop){
		
		this.TASK_PROPERTY = prop;
		
		this.POST_ID = this.TASK_PROPERTY.getProperty( "POST_ID" );
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		//this.CHANNEL_SEQ = this.TASK_PROPERTY.getProperty( "CHANNEL_SEQ" );
		
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty( "LIST_TABLE" );
		this.WORK_FILE_ID = this.POST_ID.concat("_real_one_").concat( Cal.getSerialDate() );
		
		this.setTaskID( this.POST_ID );
		this.setName( this.POST_ID + "_SmsQueRetrySendTask" );

		/**상위 클래스에서 이거 가지고 업데이트를 해 준다.
		 */
		this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;
	}
	
	/**
	 * Spool Instance를 생성시켜 Call 해준다. 
	 */
	protected void execute_ListLoad() throws Exception {
		
		SpoolControlTask targetTask = ( SpoolControlTask )InstanceFactory.getInstance( this.TASK_PROPERTY , eMsTypes.SPOOLTASK_INSTANCE  );

		// 매핑 헤더 정보를 가져오는 부분을 변경
		this.TASK_PROPERTY.setProperty("MAPPINGHEADER", SpoolInfoManager.getSpoolInfo(this.POST_ID).getMappingHeader());
		
		targetTask.setTaskProperty( this.TASK_PROPERTY );
		
		
		// 매핑 헤더 정보를 셋팅한다. ( List Make에서 만든 매핑 헤더 정보가 닮겨있다. )
		// 이 세팅은 필요 없는 거 같은데...		
		targetTask.setMAPPING_HEADER_INFO( this.MAPPING_HEADER_INFO ); 
		
		// 부자연스러운 호출이지만 일단 Go. [ 추후에 변경 요망 ]
		targetTask.internal_execute();
		
		// Spool에 대한 정보를 빼내자. 
		this.mailSpoolInfo = targetTask.getSpoolInfo();
	}
	
	/**컨텐츠를 등록할지 말지... 기본은 등록한다.
	 */
	protected void execute_RegistContents() throws Exception {
		if( this.SEND_CONTENT_INFO == null ) 
				throw new RuntimeException( "CONTENT INFO NOT FOUND" );
	}
	
	/** 리스트를 뿌리러 들어갈때 실행
	 */
	protected void execute_Startup() throws Exception {
		updateTaskState( "90" , "46" );
	}
	
	/** 리스트를 다 뿌리고 나올때 실행
	 */
	protected void execute_Finish() throws Exception {
		updateTaskState( "90" , "40" );
	}
	
	/**무조건 false 멈추면 안되니깐.. ^^
	 */
	protected boolean execute_StopCheck() {
		return false;
	}


}
