/*
 * @(#)ScheduleCreateTask.java            2004. 12. 7.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.auto.send.task;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import lombok.extern.slf4j.Slf4j;
import pluto.reporter.Reporter;
import pluto.schedule.Task;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;

/**
 * Class description :
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class ScheduleCreateTask extends Task {
	
	
	protected static List				QUERY_SELECT_TARGET_MAIL			= null;

	public static String			QUERY_CHECK_CURRENT_SCHEDULE		= null;

	protected static List				QUERY_SELECT_INSERT_SCHEDULE_INFO	= null;

	protected static List				QUERY_INSERT_SCHEDULE_INFO			= null;

	protected static Properties		DATE_INFORMATION					= null;

	static {
		try {
			QUERY_SELECT_TARGET_MAIL = SqlManager.getMultiQuery("COMMON", "QUERY_SELECT_TARGET_MAIL");

			QUERY_CHECK_CURRENT_SCHEDULE = SqlManager.getQuery("COMMON", "QUERY_CHECK_CURRENT_SCHEDULE");

			QUERY_SELECT_INSERT_SCHEDULE_INFO = SqlManager.getMultiQuery("COMMON", "QUERY_SELECT_INSERT_SCHEDULE_INFO");

			QUERY_INSERT_SCHEDULE_INFO = SqlManager.getMultiQuery("COMMON", "QUERY_INSERT_SCHEDULE_INFO");
		}
		catch(Exception e) {
			log.error(e.getMessage());
			System.exit(1);
		}
		DATE_INFORMATION = new Properties();
	}

	protected eMsConnection			EMS_CONNECTION						= null;

	protected eMsStatement			SELECT_STATEMENT					= null;

	protected eMsStatement			UPDATE_STATEMENT					= null;
	
	protected String				MAIL_ID = "";

	/** Creates a new instance of ScheduleCreateTask */
	public ScheduleCreateTask() {
		super(TYPE_INTERVAL, 1);
		this.setName("ScheduleCreateTask");
		this.setTaskID("ScheduleCreateTask");
	}

	@Override
	public void execute_initiate() throws Exception {
		if (log.isDebugEnabled()) {
			log.debug( getName() +" START" );//for health check
		}
		EMS_CONNECTION = ConnectionPool.getConnection();
		SELECT_STATEMENT = EMS_CONNECTION.createStatement();
		UPDATE_STATEMENT = EMS_CONNECTION.createStatement();
	}

	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	@Override
	public void execute_initiateError(Throwable thw) {
		log.error(getName(), thw);
		//REPORT 데이터베이스 커넥션을 가져오는 과정에서 에러가 발생하였습니다.
		if( !(thw instanceof SQLException) ) {
			Reporter.report("["+(this.MAIL_ID.equals("")? "NO ID" : this.MAIL_ID)+"]", getName(), "mailsendtask.init.err", thw);
		}
	}

	/**
	 * execute() 가 false를 반환하였을때(실패) 실행하는 로직이 구현된다. 여기서는 아무일도 하지 않으며 성공시 후속 조치가 필요한 Task는 이 method를 오버라이드 하면 된다.
	 */
	@Override
	public void doErrorProcess(Throwable thw) {
		log.error(getName(), thw);
		//REPORT 데이터베이스 커넥션을 가져오는 과정에서 에러가 발생하였습니다.
		Reporter.report("["+(this.MAIL_ID.equals("")? "NO ID" : this.MAIL_ID)+"]", getName(), "mailsendtask.init.err", thw);
	
	}

	/**
	 * 에러가 발생하거나 정상적으로 끝나거나 언제나 실행이된다. 할당받은 자원을 free 시키는 로직을 구현한다. execute_initiateError()와 마찬가지로 Exception을 반환하면 안되고 처리로직을 전체 포함하여야 한다.
	 */
	@Override
	public void release_Resource() {
		if (log.isDebugEnabled()) {
			log.debug( getName() +" END" );//for health check
		}
		if( EMS_CONNECTION != null ) {
			EMS_CONNECTION.recycleStatement(UPDATE_STATEMENT);
			EMS_CONNECTION.recycleStatement(SELECT_STATEMENT);
			EMS_CONNECTION.recycle();
		}
	}

	/**
	 * 실제적인 일을 처리하는 비지니스로직
	 * 
	 * @return true : 성공적인 수행 <br>
	 *         false : 수행 실패
	 */
	@Override
	public synchronized void execute() throws Exception {
		if (log.isDebugEnabled()) {
			log.debug("{} is execute execute_CheckWork Method...", getName());
		}
		eMsResultSet RS_SELECTED_SCHEDULE_INFO = null;
		
		DATE_INFORMATION.setProperty("YEAR", Cal.getYear());
		DATE_INFORMATION.setProperty("YYYY", Cal.getYear());
		DATE_INFORMATION.setProperty("MONTH", Cal.getMonth());
		DATE_INFORMATION.setProperty("MM", Cal.getMonth());
		DATE_INFORMATION.setProperty("DAY", Cal.getDay());
		DATE_INFORMATION.setProperty("DD", Cal.getDay());
		DATE_INFORMATION.setProperty("HOUR", Cal.getHour());
		DATE_INFORMATION.setProperty("HH", Cal.getHour());
		DATE_INFORMATION.setProperty("MIN", Cal.getMin());
		DATE_INFORMATION.setProperty("MI", Cal.getMin());
		DATE_INFORMATION.setProperty("WEEK", Cal.getWeekDay());
		DATE_INFORMATION.setProperty("YYYYMMDD", Cal.getDayDate());

		/**
		 * 기본 시간을 Property에 넣는다.
		 */
		Properties TMP_INFORMATION = new Properties(DATE_INFORMATION);

		StringBuffer buffer = new StringBuffer(256);
		
		for (Iterator iter = QUERY_SELECT_TARGET_MAIL.iterator(); iter.hasNext();) {
			String __EXEC_QUERY__ = (String) iter.next();

			if( __EXEC_QUERY__.trim().length() < 7 )
				continue;

			try {
				buffer.setLength(0);
				StringConvertUtil.ConvertString(buffer, __EXEC_QUERY__.trim(), TMP_INFORMATION, "${", "}", false, false);
				if (log.isDebugEnabled()) 
					log.debug("exec=>" + buffer.toString());
				RS_SELECTED_SCHEDULE_INFO = SELECT_STATEMENT.executeQuery(buffer.toString());

				while (RS_SELECTED_SCHEDULE_INFO.next()) {
					RS_SELECTED_SCHEDULE_INFO.putToMap(TMP_INFORMATION, false);
					MAIL_ID = TMP_INFORMATION.getProperty("MAIL_ID","NO ID");
					insert_work(UPDATE_STATEMENT, TMP_INFORMATION);
				}
			}
			catch(Exception e) {
				log.error(getName(), e);
				Reporter.report("["+this.MAIL_ID+"] ", getName(), "mailsendtask.init.err", e);
				continue;
			}
			finally {
				try {
					if(RS_SELECTED_SCHEDULE_INFO != null)
						RS_SELECTED_SCHEDULE_INFO.close();
				}
				catch(Exception ex) {
				}
			}
		}

		log.debug( " is execute execute_CheckWork Method...[OK]");
	}

	protected synchronized void insert_work(eMsStatement __EMS_EXEC_STATEMENT__, Properties __INSERT_INFO__) throws Exception {
		eMsResultSet CHECK_RS = null;
		StringBuffer buffer = new StringBuffer(256);
		try {
			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer, QUERY_CHECK_CURRENT_SCHEDULE, __INSERT_INFO__, "${", "}", false, false);
			if (log.isDebugEnabled()) 
				log.debug("check=>" + buffer.toString());
			CHECK_RS = __EMS_EXEC_STATEMENT__.executeQuery(buffer.toString());

			if( CHECK_RS.next() )
				return;
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			try {
				CHECK_RS.close();
			}
			catch(Exception ignore) {
			}
		}

		eMsResultSet __TMP_RESULT__ = null;

		try {
			/**
			 * 인서트할 정보를 모아온다.
			 */
			for (Iterator iter = QUERY_SELECT_INSERT_SCHEDULE_INFO.iterator(); iter.hasNext();) {
				String __EXEC_QUERY__ = (String) iter.next();
				buffer.setLength(0);
				StringConvertUtil.ConvertString(buffer, __EXEC_QUERY__, __INSERT_INFO__, "${", "}", false, false);
				__TMP_RESULT__ = __EMS_EXEC_STATEMENT__.executeQuery(buffer.toString());
				if( __TMP_RESULT__.next() ) {
					__TMP_RESULT__.putToMap(__INSERT_INFO__, false);
				}
				else {
					log.error(getName(), "POOR SCHEDULE CREATE INFO");
					return;
				}

				try {
					__TMP_RESULT__.close();
				}
				catch(Exception ignore) {
				}
			}
			if (log.isDebugEnabled()) 
				log.debug("prop", __INSERT_INFO__.toString());

			if( StringUtil.isNull(__INSERT_INFO__.getProperty("V_SEQNO")) ) {
				__INSERT_INFO__.setProperty("V_SEQNO", "1");
			}

			/**
			 * 정보를 가지고 쭉! 인서트를 해 나간다.
			 */
			for (Iterator iter = QUERY_INSERT_SCHEDULE_INFO.iterator(); iter.hasNext();) {
				String __EXEC_QUERY__ = (String) iter.next();
				buffer.setLength(0);
				StringConvertUtil.ConvertString(buffer, __EXEC_QUERY__, __INSERT_INFO__, "${", "}", false, false);
				__EMS_EXEC_STATEMENT__.executeUpdate(buffer.toString());
			}
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			try {
				if(__TMP_RESULT__ != null)
					__TMP_RESULT__.close();
			}
			catch(Exception e) {
			}
		}
	}
}
