package jupiter.auto.send.task;

import java.util.Properties;

import mercury.contents.auto.producer.BasicContentPD;

import pluto.config.SqlManager;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class SMSRealtimeContentPD extends BasicContentPD {

	protected static String QUERY_SELECT_SMS_SCHEDULE_INFO = null;
	
	static {
		try{
			QUERY_SELECT_SMS_SCHEDULE_INFO = SqlManager.getQuery("SMS","QUERY_SELECT_SMS_SCHEDULE_INFO");
		
		}
		catch( Exception e ){
			log.error(e.getMessage());
			System.exit( 1 );
		}
	}
	
	protected String INSTANCE_QUERY_SELECT_SCHEDULE_INFO = null;
	
	/** Creates a new instance of RealtimeContentPD */
	public SMSRealtimeContentPD() {
		super();
		INSTANCE_QUERY_SELECT_SCHEDULE_INFO = QUERY_SELECT_SMS_SCHEDULE_INFO;
	}
	
	protected void initProperty( Properties prop  ) throws Exception {
		this.init_property( prop );
		
		super.initProperty( prop );
		
		setName( this.POST_ID + " 's RealtimeContentPD" );
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	final void init_property( Properties prop ) throws Exception {
		this.refreshDBConnection();
		
		eMsStatement __EMS_EXEC_STATEMENT__ = null;
		eMsResultSet RS_SELECTED_SCHEDULE_INFO = null;
		
		try{
			__EMS_EXEC_STATEMENT__ = this.EMS_CONNECTION.createStatement();
			
			this.TMP_BUFFER.setLength( 0 );
			StringConvertUtil.ConvertString( this.TMP_BUFFER , INSTANCE_QUERY_SELECT_SCHEDULE_INFO , prop , "${" , "}" , true , false );
			
			//log.debug("QUERY : " + this.TMP_BUFFER.toString());
			
			//RS_SELECTED_SCHEDULE_INFO = __EMS_EXEC_STATEMENT__.executeQuery( INSTANCE_QUERY_SELECT_SCHEDULE_INFO , prop , "${" , "}" );
			RS_SELECTED_SCHEDULE_INFO = __EMS_EXEC_STATEMENT__.executeQuery( this.TMP_BUFFER.toString() );
			
			if( RS_SELECTED_SCHEDULE_INFO.next() ){
				RS_SELECTED_SCHEDULE_INFO.putToMap( prop , false );
			}
			else{
				throw new RuntimeException( "NO SCHEDULE INFO=>".concat( prop.toString() ) );
			}
		}
		catch( Throwable e ){
			throw new Exception( e.toString() );
		}
		finally{
			if(RS_SELECTED_SCHEDULE_INFO != null){
				RS_SELECTED_SCHEDULE_INFO.close();
			}
			this.EMS_CONNECTION.recycleStatement( __EMS_EXEC_STATEMENT__ );
		}
	}
	
	protected void process_main() throws Exception {		

		String __CONTENT__ = null;
		try {
			__CONTENT__ = this.SCHEDULE_INFO.getProperty("CONTENT");
		}
		catch(Exception e) {
			log.error(__CONTENT__, e);
			throw e;
		}

		if (log.isDebugEnabled()) {
			log.debug("CONTENT", __CONTENT__);
		}

		
		if( this.SCHEDULE_INFO.getProperty("CONTENT_MAPPING_SERIALIZE_FLAG", "N").equalsIgnoreCase("Y") ) {
			__CONTENT__ = StringUtil.GeneralizeContents(__CONTENT__, "${", "}", "map_");
		}

		log.debug( " pass get contents ");

		
		__CONTENT__ = execute_ContentProcess(eMsLocale.CONTENT_DEFAULT_HEADER + __CONTENT__ + eMsLocale.CONTENT_DEFAULT_TAIL);

		
		execute_ContentSave(__CONTENT__);

		
		log.debug( " pass result contents ");
		execute_createContentInfo();
		log.debug( " pass regist contensts infomation ");
	}
}

