/*
 * @(#)RealTimeSendTask.java            2011. 04. 08.
 *
 * Copyright (c) 1998-2011 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.auto.send.task;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

import jupiter.common.actor.ListMaker;
import jupiter.common.pool.BufferedAgentPool;
import jupiter.common.task.CommonStepMailSendTask;
import lombok.extern.slf4j.Slf4j;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import mercury.contents.common.producer.ContentPD;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.lang.eMsTypes;
import pluto.mail.MailSendingInstanceFactory;
import pluto.reporter.Reporter;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
import venus.spool.common.basic.InstanceFactory;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.task.SpoolControlTask;

/**
 * 실시간 성 자동 메일 발송을 담당하는 Task
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class RealTimeSendTask extends CommonStepMailSendTask {
	

	//실시간 검색 대상 메일의 리스트를 가져온다. ( AUTO001 )
	public static String			QUERY_SELECT_REALTIME_SCHEDULE_INFO			= null;

	//	실시간 검색 대상 메일의 리스트를 가져온다. ( AUTO100 )
	public static String			QUERY_SELECT_REALTIME_WORK_INFO				= null;

	//실시간 검색/입력 대상 메일발송 대상 리스트를 업데이트 한다. 그래야 다시 안가져온다.
	public static String			QUERY_UPDATE_LIST_STATE_QUERY				= null;

	//실시간 검색/입력 대상 리스트 테이블의 리스트를 가져온다. 그래야 그 테이블들을 검색할수 있으니까.
	protected static String			QUERY_SELECT_REALTIME_TABLE_INFO			= null;

	//실시간 입력으로 생성된 100번 테이블을 검색하여 컨텐트가 만들어져 있지 않으면 만드는데 사용하는 쿼리
	protected static String			QUERY_SELECT_REALTIME_INPUT_SCHEDULE_INFO	= null;

	//컨텐츠 정보 파일 업데이트
	protected static String			QUERY_UPDATE_CONTENT_CONF					= null;

	//스풀 정보 파일 업데이트
	protected static String			QUERY_UPDATE_SPOOL_CONF						= null;

	//발송 flag 변경
	protected static String			QUERY_UPDATE_STATE_INFO						= null;
	
	protected String				MAIL_ID = "";

	
	
	static {
		try {
			QUERY_SELECT_REALTIME_SCHEDULE_INFO = SqlManager.getQuery("COMMON", "QUERY_SELECT_REALTIME_SCHEDULE_INFO");

			QUERY_SELECT_REALTIME_WORK_INFO = SqlManager.getQuery("COMMON", "QUERY_SELECT_REALTIME_WORK_INFO");

			QUERY_UPDATE_LIST_STATE_QUERY = SqlManager.getQuery("COMMON", "QUERY_UPDATE_LIST_STATE_QUERY");

			QUERY_SELECT_REALTIME_TABLE_INFO = SqlManager.getQuery("COMMON", "QUERY_SELECT_REALTIME_TABLE_INFO");

			QUERY_SELECT_REALTIME_INPUT_SCHEDULE_INFO = SqlManager.getQuery("COMMON", "QUERY_SELECT_REALTIME_INPUT_SCHEDULE_INFO");

			QUERY_UPDATE_CONTENT_CONF = SqlManager.getQuery("COMMON", "QUERY_UPDATE_CONTENT_CONF");

			QUERY_UPDATE_SPOOL_CONF = SqlManager.getQuery("COMMON", "QUERY_UPDATE_SPOOL_CONF");

			QUERY_UPDATE_STATE_INFO = SqlManager.getQuery("COMMON", "QUERY_UPDATE_STATE_INFO");
			
			QUERY_UPDATE_REALTIME_THREAD_STATUS_INFO = SqlManager.getQuery("COMMON", "QUERY_UPDATE_REALTIME_THREAD_STATUS_INFO");
		}
		catch(Exception e) {
			log.error("query init error", e);
			System.exit(1);
		}
	}

	// 복수 개의 스풀 정보를 저장
	public ArrayList				spoolInfoList								= new ArrayList();

	/** 대상자 쿼리 */
	public String					SELECT_TARGET_LIST_QUERY					= null;

	/** 타겟 리스트 업데이트 쿼리 */
	public String					UPDATE_TARGET_LIST_QUERY					= null;

	/** 리스트 메이커 클래스 이름 */
	public static String			LIST_MAKER_CLASS_NAME						= null; 

	/** 리스트 메이커 인스턴스 */
	protected ListMaker				INNER_LIST_MAKER							= null;

	/** 대상 테이블을 검색하는 쿼리 */
	protected String				instance_QUERY_TARGET_TABLE_INFO			= null;

	/** 매핑 헤더 정보 */
	protected Properties			MAPPING_HEADER_INFO							= null;

	
	/** Creates a new instance of RealTimeSendTask */
	public RealTimeSendTask() throws Exception {
		
		super();
		
		// 리스트에 대한 업데이트는 하지 않으므로 널이다.
		this.UPDATE_TARGET_LIST_QUERY = QUERY_UPDATE_LIST_STATE_QUERY;

		// 대상이 되는 테이블 정보를 읽어오는 쿼리
		this.instance_QUERY_TARGET_TABLE_INFO = QUERY_SELECT_REALTIME_TABLE_INFO;

		if (log.isDebugEnabled()) {
			log.debug("REAL TIME Instance Create...");
		}
		
	}
	
	@Override
	public void setTaskProperty(Properties send_info) {
		this.TASK_PROPERTY = send_info;
		LIST_MAKER_CLASS_NAME = this.TASK_PROPERTY.getProperty("LIST_MAKER", "");
		
		
		String task_seq = String.valueOf( System.nanoTime() );
		String msg_type     = this.TASK_PROPERTY.getProperty("MSG_TYPE");
		String msg_type_seq = this.TASK_PROPERTY.getProperty("MSG_TYPE_SEQ");
		this.setName("RealTimeSendTask_" +  msg_type + "_" + msg_type_seq+"_"+task_seq);
		this.setTaskID("RealTimeSendTask_" +  msg_type + "_" + msg_type_seq);
	}

	/**
	 * 본격적인 실행 프로세스 전에 실행
	 */
	@Override
	public void execute_initiate() throws Exception {

		super.execute_initiate();
		this.WORK_FILE_ID = "realtime_".concat(Cal.getSerialDate());
		this.SPOOL_ANALYZER.setLimitDate(Cal.getDayDate());
		this.SPOOL_ANALYZER.setStep(0);
		if (log.isDebugEnabled()) {
			log.debug("REAL TIME Instance Initiate...");
		}
		
		// 매번 객체생성한다.
		INNER_LIST_MAKER = (ListMaker) (Class.forName(LIST_MAKER_CLASS_NAME).newInstance());
		
	}

	/**
	 * 시작할 때 실행
	 */
	@Override
	protected void execute_Startup() throws Exception {
		//donithing ~
		update_thread_status("A0");
	}


	/**
	 * 컨텐트 가지고 오는 부분이 상위의 방법과 완전히 다르므로 override 한다.
	 */
	@Override
	protected void execute_ContentLoad() throws Exception {
		update_thread_status("B0");
		
		//실시간 검색의 경우에는 execute_ListMake에서 컨텐츠 정보를 가져온다.

		//실시간 입력의 경우에는 리스트를 만들면서 컨텐트 정보를생성하지 않았기 때문에
		//여기서 일괄적으로 만들어 줘야 한다.
		eMsStatement __EMS_EXEC_STATEMENT__ = null;
		eMsConnection emsConnection = null;
		try {
			emsConnection = ConnectionPool.getConnection();
			__EMS_EXEC_STATEMENT__ = emsConnection.createStatement();
			if( REALTIME_INPUT.equals(this.TASK_PROPERTY.getProperty("CYCLE_TYPE")) ){ //실시간 입력일 경우 content 생성.
				Properties REALTIME_INSERT_SCHEDULE_INFO = this.TASK_PROPERTY;
				if( !ContentInfoManager.checkContentInfo( REALTIME_INSERT_SCHEDULE_INFO.getProperty("POST_ID")) ) {
					// 정보가 생성되었으면 컨텐트를만들자
					if (log.isDebugEnabled()) {
						log.debug("CONTENT INFO MAKE PROPERTIES=>" + REALTIME_INSERT_SCHEDULE_INFO.toString());
					}

					ContentPD INNER_CONTENT_PD = (ContentPD) MailSendingInstanceFactory.getInstance(REALTIME_INSERT_SCHEDULE_INFO, eMsTypes.CONTENTPD_INSTANCE);
					INNER_CONTENT_PD.process(REALTIME_INSERT_SCHEDULE_INFO);

					ContentInfo __CONTENT_INFO__ = INNER_CONTENT_PD.getContentInfo();
					ContentInfoManager.registContentInfo(__CONTENT_INFO__);

					// Content Conf 정보를 넣어준다.
					REALTIME_INSERT_SCHEDULE_INFO.setProperty("CONTENT_CONF", ContentInfoManager.getContentInfo(REALTIME_INSERT_SCHEDULE_INFO.getProperty("POST_ID")).getContentInfoPath());
					this.TMP_STRING_BUFFER.setLength(0);
					StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, QUERY_UPDATE_CONTENT_CONF, REALTIME_INSERT_SCHEDULE_INFO, "${", "}", true, false);
					try {
						//에러가 나도 다른 메일이 발송이 될 수 있게
						__EMS_EXEC_STATEMENT__.executeUpdate(this.TMP_STRING_BUFFER.toString());
					}
					catch(Exception e) {
						log.error(getName(), e.toString());
					}
				}
			}
		}
		catch(Exception e) {
			log.error(getName(), e);
		}
		finally {
			if(emsConnection != null) {
				emsConnection.recycleStatement(__EMS_EXEC_STATEMENT__);
				emsConnection.recycle();	
			}
		}
	}

	@Override
	protected void execute_ListMake() throws Exception {
		
		update_thread_status("C0");
		
		String postId = "";
		
		// 실시간 검색 메일에 대해서.. 대상 정보를 가지고 리스트를 생성한다.
		if( REALTIME_SEARCH.equals(this.TASK_PROPERTY.getProperty("CYCLE_TYPE")) ){
			Properties __TARGET_INFO__ = this.TASK_PROPERTY;

			if (log.isDebugEnabled()) {
				log.debug("CALL LIST MAKER=>".concat(__TARGET_INFO__.toString()));
			}
			try {
				this.MAIL_ID = (__TARGET_INFO__).getProperty("MAIL_ID","NO ID");
				postId = (__TARGET_INFO__).getProperty("POST_ID","NO ID");

				this.INNER_LIST_MAKER.process( __TARGET_INFO__);

				// INNER_LIST_MAKER.getID()가 null이 아닌경우에만 헤더정보 세팅으로 변경
				if( this.MAPPING_HEADER_INFO == null ) {
					this.MAPPING_HEADER_INFO = new Properties();
				}
				if( this.INNER_LIST_MAKER.getID() != null ) {
					this.MAPPING_HEADER_INFO.setProperty(this.INNER_LIST_MAKER.getID(), this.INNER_LIST_MAKER.getMAPPING_HEADER());
				}
			}
			catch(Exception e) {
				if (log.isDebugEnabled()) {
					log.debug("CALL LIST MAKER ERROR ".concat(e.toString()));
				}
				log.error(getName(), e);
				Reporter.report("["+this.MAIL_ID+"] "+postId, getName(), "list.make.err", e);
			}
		}
	}

	/**
	 * 스풀을 생성하고 스풀 정보 파일을 만든다.
	 */
	protected void execute_ListLoad() throws Exception {
		
		update_thread_status("D0");
		
		// 기존 리스트가 있으면 초기화 하여준다.
		this.spoolInfoList.clear();

		SpoolInfo sInfo = null;

		// 실시간 검색 메일에 대해서 스풀과 스풀 정보 파일 생성합니다.
		eMsStatement __EMS_EXEC_STATEMENT__ = null;
		eMsResultSet rsSelectedWorkInfo = null;
		eMsConnection emsConnection = null;
		try {
			emsConnection = ConnectionPool.getConnection();
			__EMS_EXEC_STATEMENT__ = emsConnection.createStatement();
			
			rsSelectedWorkInfo = __EMS_EXEC_STATEMENT__.executeQuery(QUERY_SELECT_REALTIME_WORK_INFO,this.TASK_PROPERTY,"${","}" );
			
			Properties REALTIME_INSERT_SCHEDULE_INFO = new Properties();

			while (rsSelectedWorkInfo.next()) {
				REALTIME_INSERT_SCHEDULE_INFO.clear();
				rsSelectedWorkInfo.putToMap(REALTIME_INSERT_SCHEDULE_INFO, false);
				
				this.MAIL_ID = REALTIME_INSERT_SCHEDULE_INFO.getProperty("MAIL_ID","NO ID");

				// 정보가 생성되었으면 스풀을 만들자
				SpoolControlTask targetTask = (SpoolControlTask) InstanceFactory.getInstance(REALTIME_INSERT_SCHEDULE_INFO, eMsTypes.SPOOLTASK_INSTANCE);

				// 메일 정보를 셋팅한다. 실행해야만 쿼리도 초기화된다.
				targetTask.setTaskProperty(REALTIME_INSERT_SCHEDULE_INFO);
				
				
				///////////////////////////////////////////////////////////////////
				/*
				 * [jjg2000]
				 * 최초에 실시간 검색 메일이 들어오는 부분에서 header 정보가 null일 수가 없다.
				 * 두번째 이후에 들어오는 부분에서 null(map_)일경우 기존 header를 재사용하는 로직을 구성했다.
				 */
				String header_str = this.MAPPING_HEADER_INFO.getProperty(REALTIME_INSERT_SCHEDULE_INFO.getProperty("POST_ID"));
				if(StringUtil.isNull(header_str)){
				
					boolean spoolInfoYn = SpoolInfoManager.checkSpoolInfo(REALTIME_INSERT_SCHEDULE_INFO.getProperty("POST_ID"));
					
					if(spoolInfoYn){
						// 매핑 헤더 정보를 셋팅한다. ( Spool Info에 저장 되어 있는 매핑 헤더 정보를 가져온다.. )
						sInfo = SpoolInfoManager.getSpoolInfo(REALTIME_INSERT_SCHEDULE_INFO.getProperty("POST_ID"));
						
						if( this.MAPPING_HEADER_INFO == null ) {
							this.MAPPING_HEADER_INFO = new Properties();
						}
						
						this.MAPPING_HEADER_INFO.setProperty(sInfo.getID(),sInfo.getMappingHeader());
					}
				}
				///////////////////////////////////////////////////////////////
				
				// 매핑 헤더 정보를 셋팅한다. ( List Make에서 만든 매핑 헤더 정보가 닮겨있다. )
				targetTask.setMAPPING_HEADER_INFO(this.MAPPING_HEADER_INFO);

				// 부자연스러운 호출이지만 일단 Go. [ 추후에 변경 요망 ]
				targetTask.internal_execute();

				// Spool에 대한 정보를 빼내자.
				sInfo = targetTask.getSpoolInfo();
				
				//by joo -  SpoolInfoManager에 등록하고 가져와도 된다. 그리고 부자연스럽다. spoolTask로 보낸다.
				//SpoolInfoManager.registSpoolInfo(sInfo);

				// SpoolInfo List에 셋팅한다.
				if( sInfo.getSpoolFilesInfo() != null && sInfo.getSpoolFilesInfo().size() > 0 ) {
					this.spoolInfoList.add(sInfo);
				}

				try {
					// 이렇게 해서 2개 이상의 실시간 검색 메일의
					// spool 파일이 동일하게 생성되는 것을 방지한다.
					Thread.sleep(1000);
				}
				catch(Exception ex) {
				}
			}
		}
		catch(Exception e) {
			log.error(getName(), e);
		}
		finally {
			//2017.03.07
			if(rsSelectedWorkInfo != null){
				rsSelectedWorkInfo.close();
			}
			emsConnection.recycleStatement(__EMS_EXEC_STATEMENT__);
		}

		try {
			__EMS_EXEC_STATEMENT__ = emsConnection.createStatement();

			// 실시간 입력 메일에 대해서 스풀과 스풀 정보 파일 생성합니다.
			Properties REALTIME_INSERT_SCHEDULE_INFO = null;
			if( REALTIME_INPUT.equals(this.TASK_PROPERTY.getProperty("CYCLE_TYPE")) ){
				REALTIME_INSERT_SCHEDULE_INFO = this.TASK_PROPERTY;

				this.MAIL_ID = REALTIME_INSERT_SCHEDULE_INFO.getProperty("MAIL_ID","NO ID");
				
				// 정보가 생성되었으면 스풀을 만들자
				SpoolControlTask targetTask = (SpoolControlTask) InstanceFactory.getInstance(REALTIME_INSERT_SCHEDULE_INFO, eMsTypes.SPOOLTASK_INSTANCE);

				
				
				// 메일 정보를 셋팅한다. 실행해야만 쿼리도 초기화된다.
				targetTask.setTaskProperty( REALTIME_INSERT_SCHEDULE_INFO );

				// 매핑 헤더 정보를 셋팅한다.

				// 부자연스러운 호출이지만 일단 Go. [ 추후에 변경 요망 ]
				targetTask.internal_execute();

				// Spool에 대한 정보를 빼내자.
				sInfo = targetTask.getSpoolInfo();
				SpoolInfoManager.registSpoolInfo(sInfo);

				// SpoolInfo List에 셋팅한다.
				if( sInfo.getSpoolFilesInfo() != null && sInfo.getSpoolFilesInfo().size() > 0 ) {
					this.spoolInfoList.add(sInfo);
				}

				try {
					// 이렇게 해서 2개 이상의 실시간 입력 메일의
					// spool 파일이 동일하게 생성되는 것을 방지한다.
					Thread.sleep(1000);
				}
				catch(Exception ex) {
				}

				// Spool Conf 정보를 넣어준다.
				REALTIME_INSERT_SCHEDULE_INFO.setProperty("SPOOL_CONF", SpoolInfoManager.getSpoolInfo(REALTIME_INSERT_SCHEDULE_INFO.getProperty("POST_ID")).getSpoolInfoPath());

				this.TMP_STRING_BUFFER.setLength(0);
				StringConvertUtil.ConvertString(this.TMP_STRING_BUFFER, QUERY_UPDATE_SPOOL_CONF, REALTIME_INSERT_SCHEDULE_INFO, "${", "}", true, false);

				try {
					//에러가 나도 다른 메일이 발송이 될 수 있게
					__EMS_EXEC_STATEMENT__.executeUpdate(this.TMP_STRING_BUFFER.toString());
				}
				catch(Exception e) {
					log.error(getName(), e.toString());
				}
			}
		}
		catch(Exception e) {
			log.error(getName(), e);
		}
		finally {
			emsConnection.recycleStatement(__EMS_EXEC_STATEMENT__);
			emsConnection.recycle();
		}
	}

	@Override
	protected synchronized void execute_ListSend() throws Exception {

		update_thread_status("E0");
		// 실시간 검색 메일에 대해서만 발송한다.
		if( this.spoolInfoList == null ) {
			log.debug( " No Real Data.... So Skip ");
		}
		else {
			for (Iterator it = this.spoolInfoList.iterator(); it.hasNext();) {
				this.mailSpoolInfo = (SpoolInfo) it.next();
				super.execute_ListSend();

				try {
					wait(100);
				}
				catch(Exception ex_sub) {
				}
			}	
		}

		BufferedAgentPool.flushAll();

	}

	/*
	 * (non-Javadoc)
	 * @see jupiter.common.task.AbstractMailSendTask#execute_Finish()
	 */
	@Override
	protected void execute_Finish() throws Exception {
		// Do Nothing
		update_thread_status("F0");
	}

	/**
	 * 발송 정지 상태를 점검하고 정지되었다면 로그를 작성한다.
	 */
	protected boolean execute_StopCheck() {
		return false;
	}

	/**
	 * 지정된 도메인의 BufferedPool을 반환한다. BufferedAgentPool.getBufferedObjectPool( domain );
	 */
	@Override
	protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
		return BufferedAgentPool.getBufferedObjectPool("single", domain);
	}

	/**
	 * Syntax Error 스풀을 처리한다.
	 */
	/* Syntax Error 처리를 안하고 있음 2011.06.07 CS
	protected void processSyntaxErrorSpool(String spool) throws Exception {
	}
	 */

	/**
	 * 메인 프로세스를 실행하다가 에러가 발생하면 실행되는루틴
	 */
	@Override
	public void doErrorProcess(Throwable thr) {
		log.error(getName(), thr);
		Reporter.report("[" + this.MAIL_ID + "] " + this.POST_ID, getName(), "mailsendtask.exec.err", thr);
	}
}
