/*
 * @(#)SmsRetrySendTask.java            2004. 12. 7.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package jupiter.auto.send.task;

import java.util.Properties;

import pluto.lang.eMsTypes;
import pluto.util.Cal;
import venus.spool.common.basic.InstanceFactory;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.task.SpoolControlTask;
/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
public class PushRetrySendTask extends SmsAutoBaseSendTask {
	
	
	/** Creates a new instance of SmsRetrySendTask */
	public PushRetrySendTask() throws Exception{
		super();
	}
	
	public void setTaskProperty(Properties prop){
		
		this.TASK_PROPERTY = prop;

		this.POST_ID = this.TASK_PROPERTY.getProperty( "POST_ID" );
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty( "LIST_TABLE" );
		this.WORK_FILE_ID = this.POST_ID.concat("_real_retry_").concat( Cal.getSerialDate() );
		
		this.setTaskID( this.POST_ID );
		this.setName( this.POST_ID + "_AutoSmsRetrySendTask" );
		
		/**상위 클래스에서 이거 가지고 업데이트를 해 준다.
		 */
		this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;
	}

	
	/**
	 * Spool Instance를 생성시켜 Call 해준다. 
	 */
	protected void execute_ListLoad() throws Exception {
		
		SpoolControlTask targetTask = ( SpoolControlTask )InstanceFactory.getInstance( this.TASK_PROPERTY , eMsTypes.SPOOLTASK_INSTANCE  );

		// 매핑 헤더 정보를 가져오는 부분을 변경
		this.TASK_PROPERTY.setProperty("MAPPINGHEADER", SpoolInfoManager.getSpoolInfo(this.POST_ID).getMappingHeader());
		
		targetTask.setTaskProperty( this.TASK_PROPERTY );
		
		
		// 매핑 헤더 정보를 셋팅한다. ( List Make에서 만든 매핑 헤더 정보가 닮겨있다. )
		// 이 세팅은 필요 없는 거 같은데...		
		targetTask.setMAPPING_HEADER_INFO( this.MAPPING_HEADER_INFO ); 
		
		// 부자연스러운 호출이지만 일단 Go. [ 추후에 변경 요망 ]
		targetTask.internal_execute();
		
		// Spool에 대한 정보를 빼내자. 
		this.mailSpoolInfo = targetTask.getSpoolInfo();
	}
	
	/** 리스트를 뿌리러 들어갈때 실행
	 */
	protected void execute_Startup() throws Exception {
		updateTaskState( "90" , "36" );
	}
}

