/*
 * @(#)PushRealTimeSendTask.java            2011. 04. 08.
 *
 * Copyright (c) 1998-2011 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.auto.send.task;

import java.util.Iterator;
import java.util.Properties;

import jupiter.auto.log.updator.MMSAutoReceiver;
import jupiter.common.pool.BufferedAgentPool;
import jupiter.mass.send.basic.SendStopException;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.log.ErrorSpoolLogger;
import pluto.panopticon.filter.RejectFilter;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolingManager;
import venus.spool.common.popper.Popper;

/**
 * 실시간 성 자동 메일 발송을 담당하는 Task
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class PushRealTimeSendTask extends RealTimeSendTask {
	

	/** Creates a new instance of RealTimeSendTask */
	public PushRealTimeSendTask() throws Exception {
		
		super();
	}
	
	@Override
	public void setTaskProperty(Properties sendInfo) {
		this.TASK_PROPERTY = sendInfo;
		LIST_MAKER_CLASS_NAME = this.TASK_PROPERTY.getProperty("LIST_MAKER", "");
		
		
		String task_seq = String.valueOf( System.nanoTime() );
		String msg_type     = this.TASK_PROPERTY.getProperty("MSG_TYPE");
		String msg_type_seq = this.TASK_PROPERTY.getProperty("MSG_TYPE_SEQ");
		this.setName("PushRealTimeSendTask_" +  msg_type + "_" + msg_type_seq+"_"+task_seq);
		this.setTaskID("PushRealTimeSendTask_" +  msg_type + "_" + msg_type_seq);
		
	}
	
	@Override
	protected synchronized void execute_ListSend() throws Exception {

		update_thread_status("E0");
		// 실시간 검색 메일에 대해서만 발송한다.
		if( this.spoolInfoList == null ) {
			log.debug( " No Real Data.... So Skip ");
		}
		
		if (log.isDebugEnabled()) {
			log.debug("EXEC execute_ListSend");
		}
		
		log.info("PushRealTimeSendTask Loading get spoolInfoList is "+ spoolInfoList.toString() );
		
		for (Iterator<Object> it = this.spoolInfoList.iterator(); it.hasNext();) {
			this.mailSpoolInfo = (SpoolInfo) it.next();
			
			// Popper의 Instance는 xml의 POPPER FACTORY에 정의되어 있다.
			// 보낼 대상이 등록되어 있으면 그것으로 SPOOL_POPPER를 초기화한다.
			if( this.mailSpoolInfo != null ) {
				SPOOL_POPPER = Popper.getInstance();

				/*
				 * 주기발송이나 수시발송의 경우 List쿼리의 결과가 없으면 41로 상태가 바뀐다. 여기서 Spool정보 XML파일의
				 * 정보를 미리가져와서 Vector가 비었는지 체크 필
				 */
				if( this.mailSpoolInfo.getSpoolFilesInfo().isEmpty() ) {
					log.debug( "No Real Data.... So Skip");

					return;
				}

				try{
					SPOOL_POPPER.init(this.SPOOL_DIRECTORY, this.mailSpoolInfo.getSpoolFilesInfo());
				}catch(Exception ex){
					log.error(getName(), ex);
				}
			}
			else {
				log.debug( "PUSH SPOOL INFO IS NULL SO SKIP..");
				return;
			}

			if( this.SPOOL_POPPER == null ) {
				log.error("No Real Data.... So Skip");
				return;
			}

			if( execute_StopCheck() ) {
				throw new SendStopException(getName() + " receive stop signal");
			}

			RejectFilter instanceRejectFilter = RejectFilter.getFilterInstance(this.TASK_PROPERTY);

			String nextSpool = null;
			int spoolPatchCount = 0;
			BufferedAgentPool pool = null;
			
			String domain = this.TASK_PROPERTY.getProperty("SMS_TYPE").toLowerCase();
			
			while ((nextSpool = (String) this.SPOOL_POPPER.next()) != null) {

				if( nextSpool == null || nextSpool.length() < 1 )
					continue;

				if( spoolPatchCount++ % instance_STOP_CHECK_RECYCLE == 0 ) {
					if( execute_StopCheck() ) {
						throw new SendStopException(getName() + " receive stop signal");
					}
				}
				try {
					
					if( domain == null ) {
						processSyntaxErrorSpool(nextSpool);
						continue;
					}


					// Spool의 내용에서 필터링을 적용하여 보내지 않을 대상인지를 판별한다.
					if( instanceRejectFilter != null ) {

						this.SPOOL_ANALYZER.parse(nextSpool);

						if( instanceRejectFilter.isFiltered(this.SPOOL_ANALYZER) ) {
							continue;
						}

						nextSpool = this.SPOOL_ANALYZER.composeSingleRcptSend();
					}

					pool = this.getBufferedObjectPool(domain);
					pool.registSpool(domain, nextSpool);
				}
				catch(OutOfMemoryError outError) {
					log.error("OOM error", outError);
					System.gc();

					try {
						wait(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
					} catch(Exception ignore) {
					}

					try {
						//뜻하지 않은 에러이므로 재발송 스풀 생성을 담당하는 SpoolingManager에 넣어준다.
						SpoolingManager.registSpool(nextSpool);
					}
					catch(Exception ignore) {
					}

					continue;
				}
				catch(Throwable err) {
					log.error(getName(), err);
					ErrorSpoolLogger.put(nextSpool + " => send : " + err.toString());
					continue;
				}
			}//end of while

			if (log.isDebugEnabled()) 
				log.debug("EXEC BufferedAgentPool.flushAll()");

			BufferedAgentPool.flushAll();

			if (log.isDebugEnabled()) 
				log.debug("EXEC execute_ListSend [OK]");

			try {
				wait(100);
			}
			catch(Exception ex_sub) {
			}
			
		}//end for

		BufferedAgentPool.flushAll();

	}
}
