/*
 * @(#)SmsCampListMakeTask.java            2004. 12. 7.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package jupiter.auto.send.task;

import java.util.Properties;

import jupiter.common.pool.BufferedAgentPool;
import lombok.extern.slf4j.Slf4j;
import mercury.contents.common.basic.ContentInfoManager;
import mercury.contents.common.producer.ContentPD;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsStatement;
import pluto.lang.eMsTypes;
import pluto.mail.MailSendingInstanceFactory;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import venus.spool.common.basic.InstanceFactory;
import venus.spool.common.task.SpoolControlTask;
/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class PushCampListMakeTask extends AutoBaseSendTask {


	public static String QUERY_UPDATE_CONTENT_CONF = null;

	static {
		try {
			QUERY_UPDATE_CONTENT_CONF = SqlManager.getQuery("COMMON","QUERY_UPDATE_CONTENT_CONF");
		}
		catch( Exception e ){
			log.error(e.getMessage());
			System.exit( 1 );
		}
	}
	
	/** Creates a new instance of SmsCampListMakeTask */
	public PushCampListMakeTask() throws Exception{
		super();
	}
	
	@Override
	public void setTaskProperty(Properties prop) {
		this.TASK_PROPERTY = prop;

		this.POST_ID = this.TASK_PROPERTY.getProperty( "POST_ID" );
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty( "LIST_TABLE" );
		this.WORK_FILE_ID = this.POST_ID.concat("_real_one_").concat( Cal.getSerialDate() );
		
		this.setTaskID( this.POST_ID);
		this.setName( this.POST_ID + "_PushCampListMakeTask" );
		
		/**상위 클래스에서 이거 가지고 업데이트를 해 준다.
		 */
		this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;
	}

	/** 
	 * <br> 자동 메일의 경우에는 컨텐츠 로드하는 방법이 기존의 방식을 그대로 사용한다.
	 * <br> 따라서 기존의 CommonStepMailSendTask의 방법으로 정의한다.
	 */
	protected void execute_ContentLoad() throws Exception {
		
		ContentPD targetContentPD = ( ContentPD )MailSendingInstanceFactory.getInstance( this.TASK_PROPERTY , eMsTypes.CONTENTPD_INSTANCE );
		targetContentPD.process( this.TASK_PROPERTY );
		this.SEND_CONTENT_INFO = targetContentPD.getContentInfo();
		ContentInfoManager.registContentInfo( this.SEND_CONTENT_INFO );
		
		String content_conf = ContentInfoManager.getContentInfo(this.POST_ID).getContentInfoPath();
		
		// CONTENT_CONF 등록
		eMsStatement stmt = null;
		eMsConnection emsConnection = null;
		try {
			emsConnection = ConnectionPool.getConnection();
			stmt = emsConnection.createStatement();
			
			Properties prop = new Properties();
			
			prop.setProperty("CONTENT_CONF",content_conf);
			prop.setProperty("POST_ID",this.TASK_PROPERTY.getProperty("POST_ID"));
			prop.setProperty("MSG_TYPE",this.TASK_PROPERTY.getProperty("MSG_TYPE"));
			
			this.TMP_STRING_BUFFER.setLength( 0 );
			StringConvertUtil.ConvertString( this.TMP_STRING_BUFFER , QUERY_UPDATE_CONTENT_CONF  , prop, "${" , "}" , true , false );
			stmt.executeUpdate( this.TMP_STRING_BUFFER.toString() );
		}
		catch( Exception e ){
			log.error( getName() , e );
		}
		finally {
			if(emsConnection != null) {
				emsConnection.recycleStatement( stmt );
				emsConnection.recycle();	
			}
		}	
	}
	
	/**
	 * Spool Instance를 생성시켜 Call 해준다. 
	 */
	protected void execute_ListLoad() throws Exception {
		
		SpoolControlTask targetTask = ( SpoolControlTask )InstanceFactory.getInstance( this.TASK_PROPERTY , eMsTypes.SPOOLTASK_INSTANCE  );

		targetTask.setTaskProperty( this.TASK_PROPERTY );
		
		// 매핑 헤더 정보를 셋팅한다. ( List Make에서 만든 매핑 헤더 정보가 닮겨있다. )
		targetTask.setMAPPING_HEADER_INFO( this.MAPPING_HEADER_INFO ); 
		
		// 부자연스러운 호출이지만 일단 Go. [ 추후에 변경 요망 ]
		targetTask.internal_execute();
		
		// Spool에 대한 정보를 빼내자. 
		this.mailSpoolInfo = targetTask.getSpoolInfo();
	}
	
	/** 최초 시작할때 호출. 
	 * 시작을 마킹하는 코드로 업데이트를 해야한다.
	 */
	protected void execute_Startup() throws Exception {
		updateTaskState( "41" , "10" );
	}
	
	/** 리스트를 뿌리러 들어갈때 실행
	 *아무것도 하지 않는다.
	 */
	protected void execute_SendStartUpdate() throws Exception {
	}
	
	/** 종료가 됨을 마킹
	 */
	protected void execute_Finish() throws Exception {
		updateTaskState( "41" , "20" );
	}
	
	/** 발송 정지 상태를 점검하고 정지되었다면 로그를 작성한다.
	 *체크 자체를 하지 않기 때문에 
	 */
	protected boolean execute_StopCheck() {
		throw new RuntimeException( "NOT IMPLEMENT METHOD" );
	}
	
	/** 지정된 도메인의 BufferedPool을 반환한다.
	 * BufferedAgentPool.getBufferedObjectPool( domain );
	 */
	protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
		throw new RuntimeException( "NOT IMPLEMENT METHOD" );
	}
	
	/**발송은 하지 않는다.
	 */
	protected synchronized void execute_ListSend() throws Exception {
		// do nothing
	}
}
