package jupiter.auto.send.task;

import java.util.Properties;

import jupiter.common.actor.ListMaker;
import jupiter.common.pool.BufferedAgentPool;
import jupiter.common.task.SmsAbstractNoDBMailSendTask;
import lombok.extern.slf4j.Slf4j;
import mercury.contents.common.basic.ContentInfo;
import mercury.contents.common.basic.ContentInfoManager;
import mercury.contents.common.producer.ContentPD;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsStatement;
import pluto.lang.eMsTypes;
import pluto.mail.MailSendingInstanceFactory;
import pluto.reporter.Reporter;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import venus.spool.common.basic.InstanceFactory;
import venus.spool.common.task.SpoolControlTask;

@Slf4j
public class PushAutoTestSendTask extends SmsAbstractNoDBMailSendTask {

	/** 리스트 메이커 인스턴스 */
	protected ListMaker				INNER_LIST_MAKER	= null;

	/** 매핑 헤더 정보 */
	protected Properties			MAPPING_HEADER_INFO	= null;
	
	public int  send_cnt = 0;

	protected String				MAIL_ID = "";
	
	/*
UPDATE TMS_AUTO_CHN_INFO
   SET PLAN_TEST_FLAG = '${JOB_STATUS}'
      ,PLAN_TEST_DATE = NOW()
 WHERE MSG_TYPE = '${MSG_TYPE}'             
   AND MSG_TYPE_SEQ ='${MSG_TYPE_SEQ}'
   AND CHANNEL_TYPE = 'EM'
	 */
	private static String QUERY_LIST_UPDATE_TEST_SCHEDULE = null;              
	
	static {
		try {
			QUERY_LIST_UPDATE_TEST_SCHEDULE = SqlManager.getQuery("MAIN_SCHEDULE_CHECK", "QUERY_LIST_UPDATE_WF_TEST_SCHEDULE");
		}catch(Exception e) {
			log.error(e.getMessage());
			System.exit(1);
		}
	}

	/** Creates a new instance of TestSendTask */
	public PushAutoTestSendTask() throws Exception {
		super();
	}

	public void setTaskProperty(Properties prop) {

		this.TASK_PROPERTY = prop;
		this.POST_ID = this.TASK_PROPERTY.getProperty("POST_ID");
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		//this.CHANNEL_SEQ = this.TASK_PROPERTY.getProperty( "CHANNEL_SEQ" );
		
		this.setTaskID(this.POST_ID);	
		this.MAIL_ID = this.TASK_PROPERTY.getProperty("MAIL_ID","NO ID");
		this.setName("["+this.MAIL_ID+"] "+this.POST_ID + "_TestSendTask");
		
		this.WORK_FILE_ID = this.POST_ID.concat("_test_").concat(Cal.getSerialDate());
	}

	/**
	 * Task를 초기화하는 로직을 구현한다. Throwable이 발생하게 되면 execute_initiateError() 를 호출하도록
	 * 되어있다.
	 */
	public void execute_initiate() throws Exception {
	}

	/**
	 * Contents 를 생성하고 Xml을 ContentInfo로 변환하여 Manager에 등록한다. setTaskProperty()가
	 * 호출된 이후에 실행되어야 된다.
	 */
	protected void execute_ContentLoad() throws Exception {

		ContentPD contentPd = (ContentPD) MailSendingInstanceFactory.getInstance(this.TASK_PROPERTY, eMsTypes.CONTENTPD_INSTANCE);
		contentPd.process(this.TASK_PROPERTY);

		ContentInfo contentInfo = contentPd.getContentInfo();
		ContentInfoManager.putContentInfo(contentInfo, false);
		ContentInfoManager.registContentInfo(contentInfo);		//시험발송 실첨부가 정상적으로 되지 않아 추가
	}

	/**
	 * ListMaker Instance를 생성시켜 Call 해준다.
	 */
	protected void execute_ListMake() throws Exception {

		this.INNER_LIST_MAKER = (ListMaker) MailSendingInstanceFactory.getInstance(this.TASK_PROPERTY, eMsTypes.LISTMAKER_INSTANCE);
		INNER_LIST_MAKER.process(this.TASK_PROPERTY);

		if( this.MAPPING_HEADER_INFO == null )
			this.MAPPING_HEADER_INFO = new Properties();
		
		this.MAPPING_HEADER_INFO.setProperty(this.INNER_LIST_MAKER.getID(), this.INNER_LIST_MAKER.getMAPPING_HEADER());
	}

	protected void execute_ListLoad() throws Exception {

		SpoolControlTask targetTask = (SpoolControlTask) InstanceFactory.getInstance(this.TASK_PROPERTY, eMsTypes.SPOOLTASK_INSTANCE);

		// 테스트 발송은 list make 후 db에 넣지 않고 파일 그 자체로 spool을 만든다.
		this.TASK_PROPERTY.setProperty("TARGET_LIST_FILE", (String) INNER_LIST_MAKER.getTargetList());

		targetTask.setTaskProperty(this.TASK_PROPERTY);

		// 매핑 헤더 정보를 셋팅한다. ( List Make에서 만든 매핑 헤더 정보가 닮겨있다. )
		targetTask.setMAPPING_HEADER_INFO(this.MAPPING_HEADER_INFO);

		// 부자연스러운 호출이지만 일단 Go. [ 추후에 변경 요망 ]
		targetTask.internal_execute();

		// Spool에 대한 정보를 빼내자.
		this.mailSpoolInfo = targetTask.getSpoolInfo();

	}


	/**
	 * 초기화할때 Throwable이 뛰쳐나왔을때 처리하는 로직을 구현한다. Exception을 절대로 반환하면 안된다. 그러면 ㅠㅠ
	 * 에러처리는 구현안에 모두 포함하여 하는 것을 권장한다.
	 */
	public void execute_initiateError(Throwable thw) {
	}

	/**
	 * 리스트를 뿌리러 들어갈때 실행
	 */
	protected void execute_Startup() throws Exception {
		update_test_status("30","--");
	}

	/**
	 * 리스트를 뿌리러 들어갈때 실행
	 */
	protected void execute_SendStartUpdate() throws Exception {
	}

	/**
	 * 리스트를 다 뿌리고 나올때 실행
	 */
	protected void execute_Finish() throws Exception {
		update_test_status("40","30");
	}
	
	/**
	 * 상태업데이트
	 * @param status
	 * @param cnt
	 * @throws Exception
	 */
	protected void update_test_status(String status, String now_status) throws Exception{
		this.TASK_PROPERTY.setProperty("JOB_STATUS", status);
		this.TASK_PROPERTY.setProperty("UPDATE_JOB_STATUS", status);
		this.TASK_PROPERTY.setProperty("JOB_STATUS_NOW", now_status);
		
		eMsConnection conn = null;
		eMsStatement  stmt = null;
		try{
			conn = ConnectionPool.getConnection();
			stmt = conn.createStatement();
			StringBuffer buffer = new StringBuffer();
			StringConvertUtil.ConvertString(buffer, QUERY_LIST_UPDATE_TEST_SCHEDULE, this.TASK_PROPERTY , "${", "}", true, false);
			stmt.executeUpdate( buffer.toString() );
		} catch(Exception e){
			log.error("update test status error", e);
			throw e;
		} finally{
			if(conn != null){
				conn.recycleStatement(stmt);
				conn.recycle();
			}
		}
	}

	
	/**
	 * 발송 정지 상태를 점검하고 정지되었다면 로그를 작성한다.
	 */
	protected boolean execute_StopCheck() {
		return false;
	}
	
	/**
	 * 오버라이드
	 * 테스트는 평문을 입력하기 때문에 암호화부분을 skip 했다
	 */
	public String getDecryptMsgTo(String enMsgTo) throws Exception {
		
		// crypt skip
		
		return enMsgTo;
	}

	/**
	 * 지정된 도메인의 BufferedPool을 반환한다. BufferedAgentPool.getBufferedObjectPool(
	 * domain );
	 */
	protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
		return BufferedAgentPool.getBufferedObjectPool("single", domain);
	}

	/**
	 * 메인 프로세스를 실행하다가 에러가 발생하면 실행되는루틴
	 */
	public void doErrorProcess(Throwable thw) {
		log.error(getName(), thw);
		//REPORT 데이터베이스 커넥션을 가져오는 과정에서 에러가 발생하였습니다.
		//Reporter.report(this.POST_ID, getName(), "mailsendtask.exec.err", thw);
		
		try {
			update_test_status("41","30");
		} catch (Exception e) {
			log.error("update_test_status error", e);
		}
		
		Reporter.report(getName(), getName(), "mailsendtask.exec.err", thw);
	}

	public void release_Resource() {
	}

	/**
	 * 도메인이 없을경우 에러처리하는 녀석
	 */
	protected void passDomainNotFound(String spool, Throwable ex) throws Exception {
		log.error("TEST SPOOL DOMAIN INVALID", spool.concat("=>").concat(ex.toString()));
	}

	protected void processSyntaxErrorSpool(String spool) throws Exception {
		log.error("TEST SPOOL SYNTAX ERROR", spool);
	}

	protected void passRejectDomain(String spool) throws Exception {
		log.error("TEST SPOOL DOMAIN REJECTED", spool);
	}
}
