/*
 * @(#)PushAutoBaseSendTask.java            2004. 12. 7.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package jupiter.auto.send.task;

import java.util.Properties;

import jupiter.auto.log.updator.MMSAutoReceiver;
import jupiter.common.pool.BufferedAgentPool;
import jupiter.mass.send.basic.SendStopException;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import lombok.extern.slf4j.Slf4j;
import pluto.lang.eMsLocale;
import pluto.log.ErrorSpoolLogger;
import pluto.panopticon.filter.RejectFilter;
import pluto.util.convert.StringConvert;
import venus.spool.common.basic.SpoolingManager;
import venus.spool.common.popper.Popper;

/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class PushAutoBaseSendTask extends AutoBaseSendTask {
	
	private static String QUERY_CHECK_SMS_TYPE = null;
	
	static {
		try {
			QUERY_CHECK_SMS_TYPE    = SqlManager.getQuery("COMMON","QUERY_CHECK_SMS_TYPE");
		}
		catch( Exception e ){
			log.error(e.getMessage());
			System.exit( 1 );
		}
	}
	
	/** 매핑 헤더 정보 */
	protected Properties MAPPING_HEADER_INFO = null;
	
	
	
	/**
	 * 
	 * @throws Exception
	 */
	public PushAutoBaseSendTask() throws Exception {
		super();
	}
	
	/*
	 * (non-Javadoc)
	 * @see jupiter.common.task.AbstractMailSendTask#execute_ListSend()
	 */
	@Override
	protected synchronized void execute_ListSend() throws Exception {

		if (log.isDebugEnabled()) {
			log.debug("EXEC execute_ListSend");
		}

		// Popper의 Instance는 xml의 POPPER FACTORY에 정의되어 있다.
		// 보낼 대상이 등록되어 있으면 그것으로 SPOOL_POPPER를 초기화한다.
		if( this.mailSpoolInfo != null ) {
			SPOOL_POPPER = Popper.getInstance();

			/*
			 * 주기발송이나 수시발송의 경우 List쿼리의 결과가 없으면 41로 상태가 바뀐다. 여기서 Spool정보 XML파일의
			 * 정보를 미리가져와서 Vector가 비었는지 체크 필
			 */
			if( this.mailSpoolInfo.getSpoolFilesInfo().isEmpty() ) {
				log.debug( "No Real Data.... So Skip");

				return;
			}

			try{
				SPOOL_POPPER.setTaskProp(TASK_PROPERTY);
				SPOOL_POPPER.init(this.SPOOL_DIRECTORY, this.mailSpoolInfo.getSpoolFilesInfo());
			}catch(Exception ex){
				log.error("spool popper error", ex);
			}
		}
		else {
			log.debug( "SMS SPOOL INFO IS NULL SO SKIP..");
			return;
		}

		if( this.SPOOL_POPPER == null ) {
			log.error("No Real Data.... So Skip");
			return;
		}

		if( execute_StopCheck() ) {
			throw new SendStopException(getName() + " receive stop signal");
		}

		RejectFilter instanceRejectFilter = RejectFilter.getFilterInstance(this.TASK_PROPERTY);

		String nextSpool = null;
		String domain = null;
		int spoolPatchCount = 0;
		BufferedAgentPool pool = null;
		
		domain = this.TASK_PROPERTY.getProperty("SMS_TYPE").toLowerCase();
		if("".equals(domain)){
			domain = getSmstype();
		}
		
		//동보일 경우 SMS는 SMSD 로 LMS는 LMSD로 SMS_TYPE 변경 
		if("SMS".equalsIgnoreCase(this.TASK_PROPERTY.getProperty("SMS_TYPE")) 
				|| "LMS".equalsIgnoreCase(this.TASK_PROPERTY.getProperty("SMS_TYPE"))){
			if(this.TASK_PROPERTY.getProperty("DONGBO_YN","N").equals("Y")){			
				domain = domain+"d";					
			}
		}
		
		while ((nextSpool = (String) this.SPOOL_POPPER.next()) != null) {

			if( nextSpool == null || nextSpool.length() < 1 )
				continue;

			
			if( spoolPatchCount++ % instance_STOP_CHECK_RECYCLE == 0 ) {
				if( execute_StopCheck() ) {
					throw new SendStopException(getName() + " receive stop signal");
				}
			}
			
			try {
				if( domain == null ) {
					processSyntaxErrorSpool(nextSpool);
					continue;
				}

				// Spool의 내용에서 필터링을 적용하여 보내지 않을 대상인지를 판별한다.
				if( instanceRejectFilter != null ) {

					this.SPOOL_ANALYZER.parse(nextSpool);

					if( instanceRejectFilter.isFiltered(this.SPOOL_ANALYZER) ) {
						continue;
					}

					nextSpool = this.SPOOL_ANALYZER.composeSingleRcptSend();
				}
				
				pool = this.getBufferedObjectPool(domain);
				pool.registSpool(domain, nextSpool);
			}
			catch(OutOfMemoryError outError) {
				log.error(getName(), outError);
				System.gc();

				try {
					wait(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
				}
				catch(Exception ignore) {
				}

				try {
					//뜻하지 않은 에러이므로 재발송 스풀 생성을 담당하는 SpoolingManager에 넣어준다.
					SpoolingManager.registSpool(nextSpool);
				}
				catch(Exception ignore) {
				}

				continue;
			}
			catch(Throwable err) {
				log.error(getName(), err);
				ErrorSpoolLogger.put(nextSpool + " => send : " + err.toString());
				continue;
			}
		}//end of while

		if (log.isDebugEnabled()) 
			log.debug("EXEC BufferedAgentPool.flushAll()");

		BufferedAgentPool.flushAll();

		if (log.isDebugEnabled()) 
			log.debug("EXEC execute_ListSend [OK]");
	}
	
	/** 
	 * domain에 SMS_TYPE이 잡히지 않을때
	 */
	private String getSmstype() throws Exception {
		
		eMsConnection emsConnection 		= null;
		try{
			emsConnection 			= ConnectionPool.getConnection();
			StringBuffer buffer = new StringBuffer(256);
			StringConvert.ConvertStringUseMap(buffer, QUERY_CHECK_SMS_TYPE, this.TASK_PROPERTY, "${", "}", false, true);					    
			Properties m = new Properties();
			emsConnection.putSingleResultToMap(buffer.toString(), m);
			return m.getProperty("SMS_TYPE");
		}
		catch( Exception e ){
			log.error( getName() , e );
			throw new Exception(e);
		}finally{
			if(emsConnection != null)
				emsConnection.recycle();
		}
	}
	
	
}	


