package jupiter.auto.send.task;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import jupiter.common.pool.BufferedAgentPool;
import jupiter.common.task.CommonStepMailSendTask;
import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.lang.eMsTypes;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import venus.spool.common.basic.InstanceFactory;
import venus.spool.common.basic.SpoolInfo;
import venus.spool.common.basic.SpoolInfoManager;
import venus.spool.common.task.SpoolControlTask;

/**
 * 
 * @author hyogun
 *
 */
@Slf4j
public class PersonalResendTask extends CommonStepMailSendTask {

	

	
	/*
	 * 복수 개의 스풀 정보를 저장
	 */ 
	public List<Object>				spoolInfoList = new ArrayList<Object>();

	
	/*
	 * Query 
	 */
	protected static String QUERY_SELECT_PERSONAL_RESEND_WORK_INFO = null;
	protected static String QUERY_UPDATE_LIST_STATE_QUERY = null;
	protected static String QUERY_SELECT_LIST_LOAD_QUERY = null;	
	protected static String instance_QUERY_TARGET_TABLE_INFO = null;
	protected static String QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO = null;
	
	static {
		try {
			QUERY_SELECT_PERSONAL_RESEND_WORK_INFO = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_SELECT_PERSONAL_RESEND_WORK_INFO" );
			QUERY_UPDATE_LIST_STATE_QUERY = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_UPDATE_LIST_STATE_QUERY" );
			QUERY_SELECT_LIST_LOAD_QUERY = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_SELECT_LIST_LOAD_QUERY" );
			QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO = SqlManager.getQuery("PERSONAL_RESEND", "QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO" );

		}
		catch( Exception e ){
			log.error(e.getMessage());
			System.exit( 1 );
		}
	}
	
	
	public PersonalResendTask() throws Exception {

		super(TYPE_INTERVAL, 1);
		this.setName("PersonalResendTask");
		this.setTaskID("PersonalResendTask");

		if (log.isDebugEnabled()) {
			log.debug("PERSONAL RESEND Instance Create...");
		}
	}

	public static void init(Object tmp) throws Exception {

		Properties prop = (Properties) tmp;

		if (log.isDebugEnabled()) {
			log.debug("PERSONAL RESEND INIT..."+prop.toString());
		}
	}
	
	@Override
	public void setTaskProperty(Properties prop) {
	}

	
	@Override
	public void doErrorProcess(Throwable thr) {

	}

	@Override
	protected void execute_ListMake() throws Exception {
	}
	
	@Override
	protected void execute_ContentLoad() throws Exception {

	}

	@Override
	public void execute_initiate() throws Exception {
		if (log.isDebugEnabled()) {
			log.info("execute_initiate");
		}
		super.execute_initiate();
		this.WORK_FILE_ID = "personal_resend_".concat(Cal.getSerialDate());
		this.SPOOL_ANALYZER.setLimitDate(Cal.getDayDate());
		this.SPOOL_ANALYZER.setStep(0);
	}

	@Override
	public void release_Resource() {
		if (log.isDebugEnabled()) {
			log.info("release_Resource");
		}
		super.release_Resource();
		
	}

	@Override
	protected void updateTaskState(String __TYPE__, String __STATE__, String __STATE_MSG__) {
	}
	
	@Override
	protected void execute_ListLoad() throws Exception {

		// 기존 리스트가 있으면 초기화 하여준다.
		this.spoolInfoList.clear();

		SpoolInfo spInfo = null;

		// 실시간 검색 메일에 대해서 스풀과 스풀 정보 파일 생성합니다.
		eMsConnection emsConnection = null;
		eMsStatement __EMS_EXEC_STATEMENT__ = null;
		eMsResultSet rs = null;

		Properties prop = null;

		try {
			emsConnection = ConnectionPool.getConnection();
			__EMS_EXEC_STATEMENT__ = emsConnection.createStatement();
			rs = __EMS_EXEC_STATEMENT__.executeQuery(QUERY_SELECT_PERSONAL_RESEND_WORK_INFO);
			prop = new Properties();

			while (rs.next()) {
				prop.clear();
				rs.putToMap(prop, false);

				prop.setProperty("MAPPINGHEADER", SpoolInfoManager.getSpoolInfo(prop.getProperty("POST_ID") ).getMappingHeader());
				
				// 정보가 생성되었으면 스풀을 만들자
				SpoolControlTask targetTask = (SpoolControlTask) InstanceFactory.getInstance(prop, eMsTypes.SPOOLTASK_INSTANCE);

				// 메일 정보를 셋팅한다. 실행해야만 쿼리도 초기화된다.
				targetTask.setTaskProperty(prop);

				// 부자연스러운 호출이지만 일단 Go. [ 추후에 변경 요망 ]
				targetTask.internal_execute();

				// Spool에 대한 정보를 빼내자.
				spInfo = targetTask.getSpoolInfo();
				SpoolInfoManager.registSpoolInfo(spInfo,  spInfo.getID() + "_" + spInfo.getSendState() + Cal.getSerialDate() );

				// SpoolInfo List에 셋팅한다.
				if( spInfo.getSpoolFilesInfo()!= null && !spInfo.getSpoolFilesInfo().isEmpty() ) {
					this.spoolInfoList.add(spInfo);
				}

				try {
					// 이렇게 해서 2개 이상의 실시간 검색 메일의
					// spool 파일이 동일하게 생성되는 것을 방지한다.
					//this.wait(1000);
					wait_thread(1000);
				}
				catch(Exception ex) {
				}
			}
		}
		catch(Exception e) {
			log.error(getName(), e);
			try {
				if (__EMS_EXEC_STATEMENT__ != null) {
					__EMS_EXEC_STATEMENT__.executeUpdate(StringConvertUtil.ConvertString(QUERY_UPDATE_PERSONAL_RESEND_WORK_INFO, prop, "${", "}", false, false));
				} else {
					log.error("__EMS_EXEC_STATEMENT__ is null");
				}
			} catch(Exception e2) {
				log.error(getName(), e2);
			}
			
		}
		finally {
			
			if( rs != null ) {
				try {
					rs.close();
				} catch(Exception e) {}
			}
			
			if(__EMS_EXEC_STATEMENT__ != null){
				__EMS_EXEC_STATEMENT__.close();
			}
			
			if (emsConnection != null) {
				emsConnection.recycle();
			}
		}

	}

	@Override
	protected void execute_Startup() throws Exception {

	}

	@Override
	protected void execute_Finish() throws Exception {

	}

	@Override
	protected synchronized void execute_ListSend() throws Exception {

		// 실시간 검색 메일에 대해서만 발송한다.
		if( this.spoolInfoList == null ) {
			log.info(" No Real Data.... So Skip ");
		}
		else {
			for (Iterator<Object> it = this.spoolInfoList.iterator(); it.hasNext();) {
				this.mailSpoolInfo = (SpoolInfo) it.next();
				super.execute_ListSend();

				//TODO 'Refactor the synchronisation mechanism to not use a Thread instance as a monitor'
				this.wait(100);
//				try {
//					Thread.currentThread().sleep(100);
//				}
//				catch(Exception ex_sub) {
//				}
			}	
		}

		BufferedAgentPool.flushAll();
	}


	/**
	 * 지정된 도메인의 BufferedPool을 반환한다. BufferedAgentPool.getBufferedObjectPool( domain );
	 */
	@Override
	protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
		return BufferedAgentPool.getBufferedObjectPool("single", domain);
	}
	
	//TODO 'Refactor the synchronisation mechanism to not use a Thread instance as a monitor'
	private synchronized void wait_thread(long time) throws InterruptedException {
		try {
			wait(time);	
		} catch (Exception e) {
			// TODO: handle exception
		}
	}
}
