/*
 * @(#)SmsAutoBaseSendTask.java            2004. 12. 7.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package jupiter.auto.send.task;

import java.util.Properties;

import jupiter.common.pool.BufferedAgentPool;
import jupiter.mass.send.basic.SendStopException;
import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.lang.eMsLocale;
import pluto.log.ErrorSpoolLogger;
import pluto.panopticon.filter.RejectFilter;
import pluto.secure.crypto.CryptoUtil;
import pluto.util.Cal;
import pluto.util.convert.StringConvert;
import venus.spool.common.basic.SpoolingManager;
import venus.spool.common.popper.Popper;
/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class KakaoBaseSendTask extends AutoBaseSendTask {
	
	private static String QUERY_CHECK_SMS_TYPE = null;
	
	/** 매핑 헤더 정보 */
	protected Properties MAPPING_HEADER_INFO = null;
	
	static {
		try {
			QUERY_CHECK_SMS_TYPE    = SqlManager.getQuery("COMMON","QUERY_CHECK_SMS_TYPE");
		}
		catch( Exception e ){
			//e.printStackTrace();
			log.error("query init error", e);
			System.exit( 1 );
		}
	}
		
	
	/** Creates a new instance of SmsAutoBaseSendTask */
	public KakaoBaseSendTask() throws Exception{
		super();
	}

	@Override
	public void setTaskProperty( Properties prop ) {
		this.TASK_PROPERTY = prop;
		this.POST_ID = this.TASK_PROPERTY.getProperty( "POST_ID" );
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty("CHANNEL_TYPE");
		//this.CHANNEL_SEQ = this.TASK_PROPERTY.getProperty( "CHANNEL_SEQ" );
		
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty( "LIST_TABLE" );
		this.WORK_FILE_ID = this.POST_ID.concat("_real_one_").concat( Cal.getSerialDate() );
		
		this.setTaskID( this.POST_ID );
		this.setName( this.POST_ID + "_SmsAutoBaseSendTask" );
		
		/**상위 클래스에서 이거 가지고 업데이트를 해 준다.
		 */
		this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;
		
		/**정지를 체크해야할 쿼리를 지정( AbstractDBMailSendTask에서 사용 )
		 */
		this.INSTANCE_QUERY_CHECK_STOP_FLAG = QUERY_CHECK_STOP_FLAG;
	}

	protected synchronized void execute_ListSend() throws Exception {

		// Popper의 Instance는 xml의 POPPER FACTORY에 정의되어 있다.
		// 보낼 대상이 등록되어 있으면 그것으로 SPOOL_POPPER를 초기화한다.
		if( this.mailSpoolInfo != null ) {
			SPOOL_POPPER = Popper.getInstance();

			/*
			 * 주기발송이나 수시발송의 경우 List쿼리의 결과가 없으면 41로 상태가 바뀐다. 여기서 Spool정보 XML파일의
			 * 정보를 미리가져와서 Vector가 비었는지 체크 필
			 */
			if (this.mailSpoolInfo.getSpoolFilesInfo().isEmpty()) {
				log.info(getName(), "No Real Data.... So Skip");
				return;
			}

			try{
				SPOOL_POPPER.setTaskProp(TASK_PROPERTY);
				SPOOL_POPPER.init(this.SPOOL_DIRECTORY, this.mailSpoolInfo.getSpoolFilesInfo());
			}catch(Exception ex){
				log.error("spool poper error", ex);
			}
		}
		else {
			log.debug( "KAKAO SPOOL INFO IS NULL SO SKIP..");
			return;
		}

		if( this.SPOOL_POPPER == null ) {
			log.error(getName(), "No Real Data.... So Skip");
			return;
		}

		if( execute_StopCheck() ) {
			throw new SendStopException(getName() + " receive stop signal");
		}

		RejectFilter instanceRejectFilter = RejectFilter.getFilterInstance(this.TASK_PROPERTY);

		String nextSpool = null;
		String domain = null;
		int spoolPatchCount = 0;
		BufferedAgentPool pool = null;
		
		String phoneStr = null;
		String phoneEn  = null;
		String ori_Spool = null;
		
		StringBuffer strBuffer = new StringBuffer(1024);
		/* 
		 * kakao 관련 타입 설정
		 * domain 관련 부분에 삽입 / buffer agent 단에 등록시 필요 
		 */
// kakao 관련 buffer 관리 및 domain 별 발송 현황에서의 표시를 위한
		domain = this.TASK_PROPERTY.getProperty("KAKAO_TYPE","AT").toLowerCase();
		if ("".equals(domain)) {
			domain = "AT";
		}
		
		
		//통합 캠페인으로 발송 시 SMS 발송 건수 제한 기능
		int budget = Integer.parseInt(this.TASK_PROPERTY.getProperty("BUDGET","0"));
		boolean flagBudget = (budget > 0);
		
		while ((nextSpool = (String) this.SPOOL_POPPER.next()) != null) {
			
			if( nextSpool == null || nextSpool.length() < 1 )
				continue;
			
			if ((spoolPatchCount++ % instance_STOP_CHECK_RECYCLE) == 0) {
				if( execute_StopCheck() ) {
					throw new SendStopException(getName() + " receive stop signal");
				}
			}
			
			/*
			 * [jjg] 
			 */
			if (flagBudget) {
				if (spoolPatchCount > budget) {
					log.error("POST_ID : " + this.TASK_PROPERTY.getProperty("POST_ID") + " / TOTAL CAMPAIGN SMS budget : " + budget + " / spoolPatchCount : " + spoolPatchCount);
					break;
				}
			}
			
			try {
				
				ori_Spool = nextSpool;
				
				if ("Y".equals(ENC_YN)) {
					//복호화한 email
					phoneEn  = getSecureSms(nextSpool);//전화번호 필드 추출
					
					if (!"PU".equals(this.TASK_PROPERTY.getProperty("CHANNEL_TYPE"))) {
						phoneStr = getDecryptSms(phoneEn);//이메일 복호화
					} else{
						phoneStr = phoneEn;
					}
					
					strBuffer.setLength(0);
					strBuffer.append(phoneEn)
						.append(CryptoUtil.TMS_DECRYPT_TAG)
						.append(phoneStr)
						.append(nextSpool.substring(phoneEn.length())).toString();
					
					nextSpool = strBuffer.toString();
				}
				
				if (domain == null) {
					processSyntaxErrorSpool(nextSpool);
					continue;
				}

				// Spool의 내용에서 필터링을 적용하여 보내지 않을 대상인지를 판별한다.
				if (instanceRejectFilter != null) {
					this.SPOOL_ANALYZER.parse(nextSpool);

					if (instanceRejectFilter.isFiltered(this.SPOOL_ANALYZER)) {
						continue;
					}

					nextSpool = this.SPOOL_ANALYZER.composeSingleRcptSend();
				}
				
				pool = this.getBufferedObjectPool(domain);
				
				log.debug("registSpool... domain: {} spool: {}", domain, nextSpool);
				
				pool.registSpool(domain, nextSpool);
				
			} catch(OutOfMemoryError outError) {
				log.error(getName(), outError);
				System.gc();

				try {
					wait(eMsLocale.OUT_OF_MEMORY_ERROR_INTERVAL);
				} catch(Exception ignore) {}

				try {
					//뜻하지 않은 에러이므로 재발송 스풀 생성을 담당하는 SpoolingManager에 넣어준다.
					SpoolingManager.registSpool(ori_Spool);
					
				} catch(Exception ignore) {}
				
				continue;
				
			} catch(Throwable err) {
				log.error(getName(), err);
				ErrorSpoolLogger.put(nextSpool + " => send : " + err.toString());
				continue;
			}
		}//end of while

		if (log.isDebugEnabled()) 
			log.debug("EXEC BufferedAgentPool.flushAll()");

		BufferedAgentPool.flushAll();

		if (log.isDebugEnabled()) 
			log.debug("EXEC execute_ListSend [OK]");
	}
	
}


