/*
 * @(#)SmsCampListMakeTask.java            2004. 12. 7.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package jupiter.auto.send.task;

import java.util.Properties;

import com.humuson.tms.common.util.FatigueListTableNameUtil;
import com.humuson.tms.constrants.StatusType;

import jupiter.auto.log.updator.MMSAutoReceiver;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.lang.eMsLocale;
import lombok.extern.slf4j.Slf4j;
import pluto.util.StringConvertUtil;
/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class FatigueFilterSmsCampListMakeTask extends SmsCampListMakeTask {

	/**필터사용여부 확인 */
	protected static String QUERY_SELECT_FILTER_USEYN = null;
	/**발송횟수 업데이트 사용 여부 확인 쿼리 */
	protected static String QUERY_CHECK_SEND_CNT_UPDATE_AVAILABLE = null;
	/**발송횟수 업데이트 쿼리(피로도 카운트 테이블 사용) */
	protected static String QUERY_SEND_CNT_UPDATE = null;
	
//	protected eMsConnection EMS_CONNECTION = null;
	
	private static String ORACLE = "ORACLE";  	
	
	private static String ORACLE_REPLACE_HINT = "##ORACLE_REPLACE_HINT##";
	
	static {
		try {
			QUERY_SELECT_FILTER_USEYN	= SqlManager.getQuery("FILTER_INFO","QUERY_SELECT_FILTER_USEYN");
			QUERY_CHECK_SEND_CNT_UPDATE_AVAILABLE	= SqlManager.getQuery("FILTER_INFO","QUERY_CHECK_SEND_CNT_UPDATE_AVAILABLE");
			QUERY_SEND_CNT_UPDATE					= SqlManager.getQuery("FILTER_INFO","QUERY_SEND_CNT_UPDATE");
		}
		catch( Exception ignore ) {
			log.error(ignore.getMessage());
		}
	}
	
	public FatigueFilterSmsCampListMakeTask() throws Exception {
		super();
	}
	
	@Override
	public void execute_initiate() throws Exception {

		super.execute_initiate();

//		EMS_CONNECTION = ConnectionPool.getConnection();
	}
	
	@Override
	protected boolean isPossibleProcessing() {
		
		updateTaskState( "41" , "10" );
		
		try {
			/**
			 * 피로도 카운트 테이블 업데이트 
			 * 피로도 필터링을 사용하지 않을때만 피로도리스트 업데이트를 한다.
			 * (피로도 사용시에는 필터 카운트 업데이트를 batch에서 한다.) 
			 */
			/*
			if(TASK_PROPERTY.getProperty("DIVIDE_SCHD_SEQ", "0").equals("0")){
				log.info("FATIGUE LIST INSERT / UPDATE START...");
				insertFatigueListSentCnt(TASK_PROPERTY);
				log.info("FATIGUE LIST INSERT / UPDATE END...");
			}*/
			
		} catch (Exception e) {
			log.error("Exception", e);
			return false;
		}
		return super.isPossibleProcessing();
	}
	

	@Override
	protected void execute_Startup() throws Exception {
		// isPossibleProcessing() 에서 state를 미리 바꾸기 때문에 여기서는 아무것도 안함
	}
	
	protected boolean isUseFatigueFilter( Properties TARGET_PROPERTIES ) throws Exception {
		
		boolean useFilter = false;
		
		eMsStatement __SELECT_STATEMENT__ = null;
		eMsConnection emsConnection = null;
		
		eMsResultSet rs = null;
		Exception ex = null;
		try {
			emsConnection = ConnectionPool.getConnection();
			__SELECT_STATEMENT__ = emsConnection.createStatement();
			this.TMP_STRING_BUFFER.setLength( 0 );
			StringConvertUtil.ConvertString( this.TMP_STRING_BUFFER , this.QUERY_SELECT_FILTER_USEYN , TARGET_PROPERTIES , "${" , "}" , true , false );
			rs = __SELECT_STATEMENT__.executeQuery( this.TMP_STRING_BUFFER.toString() );
			if ( rs.next() ) {
				useFilter = rs.getString( "FATIGUE_USE_YN" ).equals("Y") ? true:false;
			}
		}catch( Exception e ) {
			log.error(e.toString());
			throw e;
		}finally {
			try{ if(rs != null) rs.close(); }catch( Exception e ){}
			if(emsConnection != null) {
				emsConnection.recycleStatement( __SELECT_STATEMENT__ );
				emsConnection.recycle();	
			}
		}
		return useFilter;
	}
		
	/**
	 * 발송 횟수를 업데이트 한다. (피로도 카운트 테이블)
	 * 
	 * @param TARGET_PROPERTIES
	 * @return
	 * @throws Exception
	 */
	protected int 	insertFatigueListSentCnt(Properties TARGET_PROPERTIES) throws Exception {
		int successCnt = 0;
		
		eMsStatement	__UPDATE_STATEMENT__ = null;
		eMsConnection emsConnection = null;
		Exception ex = null;
		boolean isFail = false;
		try {
			emsConnection = ConnectionPool.getConnection();
			__UPDATE_STATEMENT__ = emsConnection.createStatement();
			
			// Fatigue_list Table Name 세팅.
			TARGET_PROPERTIES.setProperty("FATIGUE_TABLE",FatigueListTableNameUtil.getFatigueListTableName(CHANNEL_TYPE));
			
			this.TMP_STRING_BUFFER.setLength( 0 );
			StringConvertUtil.ConvertString( this.TMP_STRING_BUFFER , 	this.QUERY_SEND_CNT_UPDATE , TARGET_PROPERTIES , "${" , "}" , true , false );
			String query = this.TMP_STRING_BUFFER.toString();
			if(ORACLE.equalsIgnoreCase(eMsLocale.DB_TYPE)){
				String pkHint = TARGET_PROPERTIES.getProperty("LIST_TABLE").replace("TMS", "PK");
				query = query.replace(ORACLE_REPLACE_HINT, pkHint);
			}
			successCnt = __UPDATE_STATEMENT__.executeUpdate( query );
		} catch( Exception e ) {
			isFail = true;
			log.error(e.toString());
			throw e;
		}
		finally {
			if(isFail){
				updateTaskState( "41", StatusType.ERROR.getCode());
			}
			if(emsConnection != null) {
				emsConnection.recycleStatement( __UPDATE_STATEMENT__ );
				//2017.03.07
				emsConnection.recycle();	
			}
		}
		return successCnt;
	}	
}
