package jupiter.auto.send.task;

import java.util.Properties;

import com.humuson.tms.common.util.FatigueListTableNameUtil;
import com.humuson.tms.constrants.StatusType;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.lang.eMsLocale;
import pluto.util.StringConvertUtil;

@Slf4j
public class FatigueFilterCampListMakeTask extends CampListMakeTask{

	/**필터사용여부 확인 */
	protected static String QUERY_SELECT_FILTER_USEYN = null;
	/**발송횟수 업데이트 사용 여부 확인 쿼리 */
	protected static String QUERY_CHECK_SEND_CNT_UPDATE_AVAILABLE = null;
	/**발송횟수 업데이트 쿼리(피로도 카운트 테이블 사용) */
	protected static String QUERY_SEND_CNT_UPDATE = null;
	
//	protected eMsConnection EMS_CONNECTION = null;
	
	private static String ORACLE = "ORACLE";  	
	
	private static String ORACLE_REPLACE_HINT = "##ORACLE_REPLACE_HINT##";
	
	static {
		try {
			QUERY_SELECT_FILTER_USEYN				= SqlManager.getQuery("FILTER_INFO","QUERY_SELECT_FILTER_USEYN");
			QUERY_CHECK_SEND_CNT_UPDATE_AVAILABLE	= SqlManager.getQuery("FILTER_INFO","QUERY_CHECK_SEND_CNT_UPDATE_AVAILABLE");
			QUERY_SEND_CNT_UPDATE					= SqlManager.getQuery("FILTER_INFO","QUERY_SEND_CNT_UPDATE");
		}
		catch( Exception ignore ) {
			log.error(ignore.getMessage());
		}
	}
	
	public FatigueFilterCampListMakeTask() throws Exception {
		super();
	}
	
	@Override
	public void execute_initiate() throws Exception {

		super.execute_initiate();
		
//		EMS_CONNECTION = ConnectionPool.getConnection();
	}
	
	@Override
	protected boolean isPossibleProcessing() {
		
		updateTaskState( "41" , "10" );
		try {
			/**
			 * 피로도 카운트 테이블 업데이트 
			 * 피로도 필터링을 사용하지 않을때만 피로도리스트 업데이트를 한다.
			 * (피로도 사용시에는 필터 카운트 업데이트를 batch에서 한다.) 
			 */
//			if(TASK_PROPERTY.getProperty("DIVIDE_SCHD_SEQ", "0").equals("0")){
//				log.info("FATIGUE LIST INSERT / UPDATE START...");
//				
//				insertFatigueListSentCnt(TASK_PROPERTY,"DAY");
//				log.info("FATIGUE LIST INSERT / UPDATE DAY...");
//				insertFatigueListSentCnt(TASK_PROPERTY,"MONTH");
//				log.info("FATIGUE LIST INSERT / UPDATE MONTH...");
//				
//				log.info("FATIGUE LIST INSERT / UPDATE END...");
//			}
			
			
		} catch (Exception e) {
			log.error("Exeption", e);
			return false;
		}
		
		return super.isPossibleProcessing();
	}
	

	@Override
	protected void execute_Startup() throws Exception {
		// isPossibleProcessing() 에서 state를 미리 바꾸기 때문에 여기서는 아무것도 안함
	}
	
	protected Properties isUseFatigueFilter( Properties TARGET_PROPERTIES ) throws Exception {
		
		eMsStatement __SELECT_STATEMENT__ = null;
		eMsConnection	emsConnection	=	null;
		eMsResultSet rs = null;
		Exception ex = null;
		try {
			emsConnection = ConnectionPool.getConnection();
			__SELECT_STATEMENT__ = emsConnection.createStatement();
			this.TMP_STRING_BUFFER.setLength( 0 );
			StringConvertUtil.ConvertString( this.TMP_STRING_BUFFER , this.QUERY_SELECT_FILTER_USEYN , TARGET_PROPERTIES , "${" , "}" , true , false );
			rs = __SELECT_STATEMENT__.executeQuery( this.TMP_STRING_BUFFER.toString() );
			if ( rs.next() ) {
				TARGET_PROPERTIES.setProperty("FATIGUE_DAY_LIMIT",rs.getString("FATIGUE_DAY_LIMIT"));
				TARGET_PROPERTIES.setProperty("FATIGUE_MONTH_LIMIT",rs.getString("FATIGUE_MONTH_LIMIT"));
			}
		}catch( Exception e ) {
			log.error(e.toString());
			throw e;
		}finally {
			try{ if(rs != null) rs.close(); }catch( Exception e ){}
			if(emsConnection != null) {
				emsConnection.recycleStatement( __SELECT_STATEMENT__ );
				emsConnection.recycle();	
			}
		}
		return TARGET_PROPERTIES;
	}

	/**
	 * 발송 횟수를 업데이트 한다. (피로도 카운트 테이블)
	 * 
	 * @param TARGET_PROPERTIES
	 * @return
	 * @throws Exception
	 */
	protected int insertFatigueListSentCnt(Properties TARGET_PROPERTIES,String dateType) throws Exception {
		int successCnt = 0;
		
		eMsStatement	__UPDATE_STATEMENT__ = null;
		eMsConnection	emsConnection	=	null;
		Exception ex = null;
		String fatigueDate = "";
		boolean isFail = false;
		try {
			emsConnection = ConnectionPool.getConnection();
			__UPDATE_STATEMENT__ = emsConnection.createStatement();
			
			// Fatigue_list Table Name 세팅.
			TARGET_PROPERTIES.setProperty("FATIGUE_TABLE",getFatigueListTableName(CHANNEL_TYPE,dateType));
			fatigueDate = "";
			if(dateType.equals("DAY")){
				fatigueDate = TARGET_PROPERTIES.getProperty("POST_ID").substring(0,8);
				log.info("WORKDAY : {} DATETYPE : {}",fatigueDate ,dateType);
			}else if(dateType.equals("MONTH")){
				fatigueDate = TARGET_PROPERTIES.getProperty("POST_ID").substring(0,6);
				log.info("WORKDAY : {} DATETYPE : {}",fatigueDate ,dateType);
			}
			TARGET_PROPERTIES.setProperty("FATIGUE_DATE", fatigueDate);
			
			this.TMP_STRING_BUFFER.setLength( 0 );
			StringConvertUtil.ConvertString( this.TMP_STRING_BUFFER , 	this.QUERY_SEND_CNT_UPDATE , TARGET_PROPERTIES , "${" , "}" , true , false );
			String query = this.TMP_STRING_BUFFER.toString();
			if(ORACLE.equalsIgnoreCase(eMsLocale.DB_TYPE)){
				String pkHint = TARGET_PROPERTIES.getProperty("LIST_TABLE").replace("TMS", "PK");
				query = query.replace(ORACLE_REPLACE_HINT, pkHint);
			}
			successCnt = __UPDATE_STATEMENT__.executeUpdate( query );
		} catch( Exception e ) {
			isFail = true;
			log.error(e.toString());
			throw e;
		}
		finally {
			if(isFail){
				updateTaskState( "41", StatusType.ERROR.getCode());
			}
			if(emsConnection != null) {
				emsConnection.recycleStatement( __UPDATE_STATEMENT__ );
				//2017.03.07
				emsConnection.recycle();	
			}
		}
		return successCnt;
	}
	
	/**TMS-COMMON 에 동일한 함수가 있으나, DAY / MONTH 체크가 없어 추가로 만듬 / tms-common 에도 추가로 작업하여 만듬
	 * ChannelType 을 설정하지 않을 경우 기존 버전에서 정상 동작
	 * @param ChannelType
	 * @param dateType
	 * @return
	 */
	protected String getFatigueListTableName(String ChannelType , String dateType){
		String targetFatigueListTable = "";
		switch (ChannelType) {
		case "EM":
			if(dateType.equals("DAY")){
				targetFatigueListTable = "TMS_FATIGUE_EMAIL_DAY_LIST";
			}else if(dateType.equals("MONTH")){
				targetFatigueListTable = "TMS_FATIGUE_EMAIL_MONTH_LIST";
			}
			break;
		case "SM":
			if(dateType.equals("DAY")){
				targetFatigueListTable = "TMS_FATIGUE_SMS_DAY_LIST";
			}else if(dateType.equals("MONTH")){
				targetFatigueListTable = "TMS_FATIGUE_SMS_MONTH_LIST";
			}
			break;
		case "KA":
			if(dateType.equals("DAY")){
				targetFatigueListTable = "TMS_FATIGUE_KAKAO_DAY_LIST";
			}else if(dateType.equals("MONTH")){
				targetFatigueListTable = "TMS_FATIGUE_KAKAO_MONTH_LIST";
			}	
			break;
		case "PU":
			if(dateType.equals("DAY")){
				targetFatigueListTable = "TMS_FATIGUE_PUSH_DAY_LIST";
			}else if(dateType.equals("MONTH")){
				targetFatigueListTable = "TMS_FATIGUE_PUSH_MONTH_LIST";
			}
			break;

		default:
			if(dateType.equals("DAY")){
				targetFatigueListTable = "TMS_FATIGUE_DAY_LIST";
			}else if(dateType.equals("MONTH")){
				targetFatigueListTable = "TMS_FATIGUE_MONTH_LIST";
			}
			break;
		}
		return targetFatigueListTable;
	}
	public static void main(String[] args) {
		System.out.println("2017032800001".substring(0, 6));
	}

}
