/*
 * @(#)AutoBaseSendTask.java            2004. 12. 7.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */
 
 
package jupiter.auto.send.task;

import java.util.List;
import java.util.Properties;

import jupiter.common.pool.BufferedAgentPool;
import jupiter.common.task.CommonStepMailSendTask;
import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.util.Cal;
/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class AutoBaseSendTask extends CommonStepMailSendTask {
	
	
	protected static List QUERY_UPDATE_STATE_START = null;
	
	protected static List QUERY_UPDATE_STATE_END = null;
	
	protected static List QUERY_UPDATE_STATE_INFO = null;
	
	public static String QUERY_CHECK_STOP_FLAG = null;
	
	public static String QUERY_UPDATE_STATE_STOP = null;

	static {
		try {
			/**멤버지정하지 않고 시작를 업데이트 한다.
			 */
			QUERY_UPDATE_STATE_START = SqlManager.getMultiQuery("COMMON","QUERY_UPDATE_STATE_START");
			
			/**멤버지정하지 않고 종료를 업데이트 한다.
			 */
			QUERY_UPDATE_STATE_END = SqlManager.getMultiQuery("COMMON","QUERY_UPDATE_STATE_END");
			
			/** 멤버변수에 지정이 되는 것이 아닌 그냥 사용된다.
			 */
			QUERY_CHECK_STOP_FLAG = SqlManager.getQuery("COMMON","QUERY_CHECK_STOP_FLAG");
			
			/** INSTANCE_QUERY_UPDATE_STATE_INFO 멤버 변수에 지정되어 스테이트를 업데이트 해준다.
			 */
			QUERY_UPDATE_STATE_INFO = SqlManager.getMultiQuery("COMMON","QUERY_UPDATE_STATE_INFO");
			
			/**
			 * 발송중지완료를 업데이트한다.
			 */
			QUERY_UPDATE_STATE_STOP    = SqlManager.getQuery("COMMON","QUERY_UPDATE_STATE_STOP");
		}
		catch( Exception e ){
			log.error(e.getMessage());
			System.exit( 1 );
		}
	}
	
	/** 매핑 헤더 정보 */
	protected Properties MAPPING_HEADER_INFO = null;
	
	
	
	/** Creates a new instance of AutoBaseSendTask */
	public AutoBaseSendTask() throws Exception{
		super();
	}
	
	@Override
	public void setTaskProperty( Properties prop ) {
		this.TASK_PROPERTY = prop;

		this.POST_ID = this.TASK_PROPERTY.getProperty( "POST_ID" );
		// TMS3.0 채널 조건 추가
		this.CHANNEL_TYPE = this.TASK_PROPERTY.getProperty( "CHANNEL_TYPE" );
		
		this.LIST_TABLE = this.TASK_PROPERTY.getProperty( "LIST_TABLE" );
		this.WORK_FILE_ID = this.POST_ID.concat("_real_one_").concat( Cal.getSerialDate() );
		
		this.setTaskID( this.POST_ID );
		this.setName( this.POST_ID + "_AutoBaseSendTask" );
		
		/**상위 클래스에서 이거 가지고 업데이트를 해 준다.
		 */
		this.INSTANCE_QUERY_UPDATE_STATE_INFO = QUERY_UPDATE_STATE_INFO;
		
		/**정지를 체크해야할 쿼리를 지정( AbstractDBMailSendTask에서 사용 )
		 */
		this.INSTANCE_QUERY_CHECK_STOP_FLAG = QUERY_CHECK_STOP_FLAG;
	}

	/** 최초 시작할때 호출. 일단 아무것도 하지 않는다.
	 */
	@Override
	protected void execute_Startup() throws Exception {
		//START_DATE를 업데이트 하지 않아서 추가..
		
		execute_SendStartUpdate();
	
	
	}
	
	/** 리스트를 뿌리러 들어갈때 실행
	 */
	protected void execute_SendStartUpdate() throws Exception {
		
		updateTaskState( "90" , "30" );
		
		eMsConnection emsConnection = null;
		
		try{
			emsConnection = ConnectionPool.getConnection();
			// 반복 루틴이 아니므로 그냥 사용한다. 2004.11.01
			emsConnection.executeUpdateList( QUERY_UPDATE_STATE_START , this.TASK_PROPERTY , "${" , "}" , false );
			
		}
		catch( Exception e ){
			log.error( getName() , e );
			
			// 더이상 작업을 진행하지 못하도록 상위에 Exception 을 넘긴다.
			throw new Exception(e);
		}finally{
			if(emsConnection != null)
				emsConnection.recycle();
		}
	}
	
	/** 리스트를 다 뿌리고 나올때 실행
	 */
	@Override
	protected void execute_Finish() throws Exception {
		
		updateTaskState( "90" , "40" );
		eMsConnection emsConnection = null;
		try{
			emsConnection = ConnectionPool.getConnection();
			// 반복 루틴이 아니므로 그냥 사용한다. 2004.11.01
		
			String jobStatus = "40";
			if ("Y".equals(TASK_PROPERTY.getProperty("DIVIDE_SEND_USE_YN", "N"))) {
				
				int prevSpoolReadCount =  Integer.parseInt(this.TASK_PROPERTY.getProperty("SPOOL_READ_COUNT", "0"));
				int filterCount =  Integer.parseInt(this.TASK_PROPERTY.getProperty("FILTER_CNT", "0"));
				log.info("divide Info  prevSpoolReadCount : {} / filterCount : {} / Target Cnt : {} ",prevSpoolReadCount,filterCount,TASK_PROPERTY.getProperty("TARGET_CNT", "0"));
				prevSpoolReadCount += mailSpoolInfo.getSpoolSize() + filterCount;
				
				if (mailSpoolInfo.getSpoolSize() > 0 && prevSpoolReadCount < Integer.parseInt(TASK_PROPERTY.getProperty("TARGET_CNT", "0"))) {
					log.info("Next Schedule Reserve after "+TASK_PROPERTY.getProperty("DIVIDE_MINUTE", "0")+"minute [postId:"+TASK_PROPERTY.getProperty("POST_ID")+"] ");
					jobStatus = "00";
				}
				this.TASK_PROPERTY.put("NEXT_REQ_MINUTE", TASK_PROPERTY.getProperty("DIVIDE_MINUTE", "0"));
				this.TASK_PROPERTY.put("NEXT_DIVIDE_SCHD_SEQ", String.valueOf(mailSpoolInfo.getNextSpoolDivideScheduleSeq()));
			} else {
				this.TASK_PROPERTY.put("NEXT_REQ_MINUTE", "0");
				this.TASK_PROPERTY.put("NEXT_DIVIDE_SCHD_SEQ", String.valueOf(mailSpoolInfo.getSpoolDivideScheduleSeq()));
			}
			this.TASK_PROPERTY.put("UPDATE_JOB_STATUS", jobStatus);
			this.TASK_PROPERTY.put("LAST_SPOOL_MEMBER_ID", mailSpoolInfo.getLastMemberId());
			this.TASK_PROPERTY.put("CURRENT_SPOOL_READ_COUNT", String.valueOf(mailSpoolInfo.getSpoolSize()));
			
			emsConnection.executeUpdateList( QUERY_UPDATE_STATE_END , this.TASK_PROPERTY , "${" , "}" , false );
			
		}
		catch( Exception e ){
			log.error( getName() , e );
		}finally{
			if(emsConnection != null)
				emsConnection.recycle();
		}
	}

	/** 
	 * 지정된 도메인의 BufferedPool을 반환한다.
	 * BufferedAgentPool.getBufferedObjectPool( domain );
	 */
	@Override
	protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
		/*if(domain.equals("hanmail.net")){
			domain ="daum.net";
		}*/
		return BufferedAgentPool.getBufferedObjectPool( "single" , domain );
	}
}	


