/*
 * @(#)AdditionalSendTask.java            2004. 12. 7.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.auto.send.task;

import java.util.ArrayList;
import java.util.Properties;

import jupiter.common.pool.BufferedAgentPool;
import jupiter.common.task.CommonStepMailSendTask;
import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.reporter.Reporter;
import pluto.util.Cal;

/**
 * Class description :
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class AdditionalSendTask extends CommonStepMailSendTask {
	

	//실시간 검색/입력 대상 리스트 테이블의 리스트를 가져온다. 그래야 그 테이블들을 검색할수 있으니까.
	protected static String			QUERY_SELECT_RESEND_TABLE_INFO	= null;

	//실시간 검색/입력 대상 메일발송 대상 리스트를 가져온다.
	protected static String			QUERY_SELECT_LIST_LOAD_QUERY	= null;

	//실시간 검색/입력 대상 메일발송 대상 리스트를 업데이트 한다. 그래야 다시 안가져온다.
	protected static String			QUERY_UPDATE_LIST_STATE_QUERY	= null;
	
	protected String				MAIL_ID = "";

	static {
		try {
			QUERY_SELECT_RESEND_TABLE_INFO = SqlManager.getQuery("ADDITIONAL_SEND", "QUERY_SELECT_RESEND_TABLE_INFO");
			QUERY_SELECT_LIST_LOAD_QUERY = SqlManager.getQuery("ADDITIONAL_SEND", "QUERY_SELECT_LIST_LOAD_QUERY");
			QUERY_UPDATE_LIST_STATE_QUERY = SqlManager.getQuery("ADDITIONAL_SEND", "QUERY_UPDATE_LIST_STATE_QUERY");
		}
		catch(Exception e) {
			log.error(e.getMessage());
			System.exit(1);
		}
	}

	protected ArrayList				TARGET_TABLE_LIST				= null;

	/** Creates a new instance of AdditionalSendTask */
	public AdditionalSendTask() throws Exception {
		super();
		this.setName("AdditionalSendTask");
		this.setTaskID("AdditionalSendTask");

		this.TARGET_TABLE_LIST = new ArrayList();

		/**
		 * 스풀에 적을 기본적인 사항을 세팅한다.
		 */
		this.SPOOL_ANALYZER.setSendType("AUTORESEND");// one to one
		this.SPOOL_ANALYZER.setNextSpoolGenerate("N");// spool attach
		this.SPOOL_ANALYZER.setLimitDate("19000000");
		this.SPOOL_ANALYZER.setStep(0);
		if (log.isDebugEnabled()) {
			// foo
		}
	}

	public void setTaskProperty(Properties send_info) {
	}

	/**
	 * 본격적인 실행프로세스전에 실행
	 */
	public void execute_initiate() throws Exception {
		super.execute_initiate();
		this.WORK_FILE_ID = "RESEND_".concat(Cal.getSerialDate());
		this.SPOOL_ANALYZER.setStep(0);
	}

	/**
	 * 시작할 때 실행 - 실시간 검색을 해야하는 테이블 리스트를 가져온다.
	 */
	protected void execute_Startup() throws Exception {
		eMsStatement __EMS_EXEC_STATEMENT__ = null;
		eMsResultSet rsSelectedScheduleInfo = null;

		this.TARGET_TABLE_LIST.clear();
		eMsConnection emsConnection = null;
		try {
			emsConnection = ConnectionPool.getConnection();
			__EMS_EXEC_STATEMENT__ = emsConnection.createStatement();

			// 실시간 검색 대상 메일의 리스트를 가져온다. => 이정보를 가지고 리스트 메이커를 실행한다.
			rsSelectedScheduleInfo = __EMS_EXEC_STATEMENT__.executeQuery(QUERY_SELECT_RESEND_TABLE_INFO);

			while (rsSelectedScheduleInfo.next()) {
				Properties prop = new Properties();
				rsSelectedScheduleInfo.putToMap(prop, false);
				this.MAIL_ID = prop.getProperty("MAIL_ID","NO ID");
				TARGET_TABLE_LIST.add(prop);
			}
		}
		catch(Exception e) {
			log.error(getName(), e);
			Reporter.report("[" + this.MAIL_ID + "]", getName(), "mailsendtask.init.err", e);
			throw e;
		}
		finally {
			if(rsSelectedScheduleInfo != null){
				rsSelectedScheduleInfo.close();
			}

			if(emsConnection != null) {
				emsConnection.recycleStatement(__EMS_EXEC_STATEMENT__);
				emsConnection.recycle();				
			}
		}
	}

	protected void execute_ContentLoad() throws Exception {
		// 기존 발송된 리스트를 재발송하는 것이므로 컨텐트는 안만들어도 된다.
	}

	protected void execute_ListMake() throws Exception {
		// 이미 리스트는 생성되어 있으므로 물론 안넣어도 된다.
	}

	/**
	 * 스풀을 생성하고 스풀 정보 파일을 만든다.
	 */
	protected void execute_ListLoad() throws Exception {
	}
	
	protected synchronized void execute_ListSend() throws Exception {
		
	}

	/**
	 * 발송 정지 상태를 점검하고 정지되었다면 로그를 작성한다.
	 */
	protected boolean execute_StopCheck() {
		return false;
	}

	/**
	 * Syntax Error 스풀을 처리한다.
	 */
	protected void processSyntaxErrorSpool(String spool) throws Exception {
	}

	/**
	 * 메인 프로세스를 실행하다가 에러가 발생하면 실행되는루틴
	 */
	public void doErrorProcess(Throwable thr) {

		log.error(getName(), thr);
		//REPORT 데이터베이스 커넥션을 가져오는 과정에서 에러가 발생하였습니다.
		Reporter.report("[" + this.MAIL_ID + "] " + this.POST_ID, getName(), "mailsendtask.exec.err", thr);
	}

	/**
	 * 지정된 도메인의 BufferedPool을 반환한다. BufferedAgentPool.getBufferedObjectPool(
	 * domain );
	 */
	protected BufferedAgentPool getBufferedObjectPool(String domain) throws Exception {
		return BufferedAgentPool.getBufferedObjectPool("single", domain);
	}

	/**
	 * 끝날 때 실행
	 */
	protected void execute_Finish() throws Exception {
		// Do Nothing
	}
}
