/*
 * @(#)StateLogUpdator.java            2004. 12. 7.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.auto.log.updator;

import java.util.Properties;

import pluto.common.log.LogUpdatorImpl;
import pluto.config.SqlManager;
import lombok.extern.slf4j.Slf4j;
/**
 * Class description :
 * 
 * @version		
 * @author 		dragon
 *
 */
@Slf4j
public class StateLogUpdator extends LogUpdatorImpl  {
	//protected static String QUERY_UPDATE_20_STATE = null;
	protected static String QUERY_UPDATE_20_START = null;
	protected static String QUERY_RETRY_UPDATE_20_START = null;
	protected static String QUERY_QUE_RETRY_UPDATE_20_START = null;
	protected static String QUERY_UPDATE_20_END = null;
	
	static{
		try{
			//QUERY_UPDATE_20_STATE = SqlManager.getQuery("RARE_S_LOG_UPDATE","QUERY_UPDATE_20_STATE");
			QUERY_UPDATE_20_START = SqlManager.getQuery("RARE_S_LOG_UPDATE","QUERY_UPDATE_20_START");
			QUERY_RETRY_UPDATE_20_START = SqlManager.getQuery("RARE_S_LOG_UPDATE","QUERY_RETRY_UPDATE_20_START");
			QUERY_QUE_RETRY_UPDATE_20_START = SqlManager.getQuery("RARE_S_LOG_UPDATE","QUERY_QUE_RETRY_UPDATE_20_START");
			QUERY_UPDATE_20_END = SqlManager.getQuery("RARE_S_LOG_UPDATE","QUERY_UPDATE_20_END");
		}
		catch( Exception e ){
			log.error(e.getMessage());
			System.exit( 1 );
		}
	}
	
	
	
	/** Creates a new instance of StateLogUpdator */
	public StateLogUpdator() {
		setName( "StateLogUpdator" );
		if(log.isDebugEnabled()){
			// foo
		}
	}
	
	/** 업데이트 하는 로직이 들어간다.
	 */
	public String update(Object obj) throws Exception {
		Properties __LOG_DATA__ = ( Properties )obj;
		String __T_TYPE__ = __LOG_DATA__.getProperty( LOG_T_TYPE );
		String __T_CODE__ = __LOG_DATA__.getProperty( LOG_T_CODE );
		
		/**41 발송 상태 업데이트 일경우 20/70 테이블에 업데이트를 한다.
		 */
		//if(__T_TYPE__.equals("41") ) {
		//	executeUpdate( QUERY_UPDATE_20_STATE , __LOG_DATA__ );
		//	return "OK";
		//}
		
		/** 90-00 발송 정지 에 대한 업데이트
		 */
		if(__T_TYPE__.equals("90") && __T_CODE__.equals("00")){
			// 정지는 나중에 넣고 삽입하지뭐..쩝...
			return "OK";
		}
		
		/** 90-30 발송 시작에 대한 업데이트
		 */
		if(__T_TYPE__.equals("90") && __T_CODE__.equals("30")) {
			executeUpdate( QUERY_UPDATE_20_START , __LOG_DATA__ );
			return "OK";
		}
		
		/** 90-35 실패메일 재발송 시작에 대한 업데이트
		 */
		if(__T_TYPE__.equals("90") && __T_CODE__.equals("36")) {
			executeUpdate( QUERY_RETRY_UPDATE_20_START , __LOG_DATA__ );
			return "OK";
		}
		
		/** 90-46 에러메일 재발송 시작에 대한 업데이트
		 */
		if(__T_TYPE__.equals("90") && __T_CODE__.equals("46")) {
			executeUpdate( QUERY_QUE_RETRY_UPDATE_20_START , __LOG_DATA__ );
			return "OK";
		}
		
		/** 90-40 발송 종료에 대한 업데이트
		 */
		if(__T_TYPE__.equals("90") && __T_CODE__.equals("40")) {
			executeUpdate( QUERY_UPDATE_20_END , __LOG_DATA__ );
			return "OK";
		}
		
		return "NO";
	}
}
