/*
 * Created on 2008. 7. 16.
 */
package jupiter.auto.log.updator;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;

/**
 * @author ���̸���
 */
@Slf4j
public class MMSAutoReceiver extends  pluto.schedule.Task {
	

	/**
	 * MMS ��� ����(SOURCE)
	 */
	protected eMsConnection			SOURCE_CONNECTION					= null;

	/**
	 * MMS ��� ���� (TARGET ---> MMS_SEND)
	 */
	protected eMsConnection			TARGET_CONNECTION					= null;

	/**
	 * ���� �������⿡ ���
	 */
	protected eMsStatement			TARGET_SELECT_STMT					= null;
	
	/**
	 * ���� ������Ʈ�� ���
	 */
	protected eMsStatement			TARGET_UPDATE_STMT					= null;

	/**
	 * EMS ��� UPDATE
	 */
	protected eMsStatement			EMS_UPDATE_STMT						= null;

	/**
	 * EMS ����� SELECT
	 */
	protected eMsStatement			EMS_SELECT_STMT						= null;

	/**
	 * ��� ���̺� ����� �������� ����
	 */
	protected String				QUERY_SELECT_TARGET_MMS_LIST_TABLE		= null;

	/**
	 * ������ �������� ����
	 */
	protected String				QUERY_TARGET_MMS_RESULT_QUERY			= null;
									
	/**
	 * �ڵ��߼� ������Ʈ ����
	 */
	protected String				QUERY_UPDATE_AUTO_RESULT_QUERY		= null;

	/**
	 * �ڵ��߼� �ش� POST_ID ���Ӹ� UPDATE����..
	 */
	protected String				QUERY_UPDATE_AUTO_SUMMARY_QUERY		= null;
	
	/**
	 * SMS(MMS) LOG TABLE FLAG UPDATE ����
	 */
	protected String				QUERY_UPDATE_LOG_RESULT_QUERY		= null;
	
	/*LIST TABLE ���� ������Ʈ ���� */
	
	protected String				QUERY_UPDATE_AUTO_RESULT_QUERY_SUCCESS		= null;
	

	/**
	 * ������Ʈ�� ���Ӹ��� �����ؾ��� WORKDAY & SEQNO ����Ʈ�� ���� �׸�.
	 */
	protected LinkedList			LIST_SUMMARY_TARGET_AUTO_IDS		= null;
	
	
	public MMSAutoReceiver() {
		super(TYPE_INTERVAL,1);
		this.setName("MMSAutoRecevier"+System.currentTimeMillis());
		this.setTaskID("MMSAutoRecevier");
		
		this.QUERY_SELECT_TARGET_MMS_LIST_TABLE = SqlManager.getQuery("AUTO_UPDATE", "QUERY_SELECT_TARGET_MMS_LIST_TABLE");
		this.QUERY_TARGET_MMS_RESULT_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_TARGET_MMS_RESULT_QUERY");
		this.QUERY_UPDATE_AUTO_RESULT_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_AUTO_RESULT_QUERY");
//		this.QUERY_UPDATE_MAIL_AUTO_RESULT_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_MAIL_AUTO_RESULT_QUERY");		
		this.QUERY_UPDATE_AUTO_SUMMARY_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_AUTO_SUMMARY_QUERY");
		this.QUERY_UPDATE_LOG_RESULT_QUERY = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_LOG_RESULT_QUERY");
		this.QUERY_UPDATE_AUTO_RESULT_QUERY_SUCCESS = SqlManager.getQuery("AUTO_UPDATE", "QUERY_UPDATE_AUTO_RESULT_QUERY_SUCCESS");
		this.LIST_SUMMARY_TARGET_AUTO_IDS = new LinkedList();

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see pluto.sms.module.SMSCall#execute()
	 */
	public void execute() {		
		if (log.isDebugEnabled()) {
			log.debug("CALL MAIN METHOD");
		}
		try {
			this.execute_init();

			this.execute_main();
		}
		catch(Throwable thw) {
			log.error("SMSAUTOReceiver", "CALL MAIN METHOD ERROR" , thw);
		}
		finally {
			// �ڿ��ȯ.
			this.releaseResource();
		}
	}

	/**
	 * �ʱ�ȭ�ϸ鼭 ����� �ڿ��� �Ҵ��Ѵ�.
	 * 
	 * @throws Throwable
	 *             �ʱ�ȭ ����.
	 */
	protected void execute_init() throws Throwable {
		if (log.isDebugEnabled()) {
			log.debug("CALL MAIN execute_init");
		}
		//eMs DB ���� Connection
		this.SOURCE_CONNECTION = ConnectionPool.getConnection();
		// ��� �������� ������ STMT ��
		this.EMS_SELECT_STMT = this.SOURCE_CONNECTION.createStatement();
		// ��� ������Ʈ ����
		this.EMS_UPDATE_STMT = this.SOURCE_CONNECTION.createStatement();
		this.setName("LMSAutoReceiver");
		
	}

	/**
	 * ����� ������ �Ҵ���� �ڿ��� ���Ѵ�.
	 */
	protected void releaseResource() {
		if (log.isDebugEnabled()) {
			log.debug("CALL MAIN releaseResource");
		}
		// EMS ��� ������ ��ȯ�Ѵ�.
		if( this.SOURCE_CONNECTION != null ) {
			this.SOURCE_CONNECTION.recycleStatement(this.EMS_SELECT_STMT);
			this.SOURCE_CONNECTION.recycleStatement(this.EMS_UPDATE_STMT);
			this.SOURCE_CONNECTION.recycle();
		}

		// LMS 
		if( this.TARGET_SELECT_STMT != null ) {
			this.TARGET_SELECT_STMT.close();
			
			this.TARGET_SELECT_STMT = null;
		}
		if( this.TARGET_UPDATE_STMT != null ) {
			this.TARGET_UPDATE_STMT.close();
		
			this.TARGET_UPDATE_STMT = null;
		}
		

		if( this.TARGET_CONNECTION != null ) {
			this.TARGET_CONNECTION.destroy();
			// null�� ������ ������ �ٽ� ���� �Ѵ�.
			this.TARGET_CONNECTION = null;
		}
	}

	protected void execute_main() throws Throwable {
		if (log.isDebugEnabled()) {
			log.debug("CALL MAIN execute_main");
		}
		//schedule �� �����ϴ� resultset
		eMsResultSet rsResult = null;

		//this.TARGET_CONNECTION = ConnectionPool.getConnection(SMSExecutor.TARGET_CONNECT_INFO);	//LMS DB
		this.TARGET_SELECT_STMT = this.TARGET_CONNECTION.createStatement();	//LMS DB
		this.TARGET_UPDATE_STMT = this.TARGET_CONNECTION.createStatement();	//LMS DB

		LinkedList listSMSLogTables = new LinkedList();

		try {
			// ��� ���̺��� SELECT�ϴ� ������ �����Ѵ�.
			if (log.isDebugEnabled()) {
				log.debug("SELECT TARGET LOG TABLE", this.QUERY_SELECT_TARGET_MMS_LIST_TABLE);
			}
			rsResult = this.TARGET_SELECT_STMT.executeQuery(this.QUERY_SELECT_TARGET_MMS_LIST_TABLE);
			Properties tValue = new Properties();			
			if( rsResult.next() ) {
				// [kckim 2005May31 5.0���� �´� �Լ��� ����...]				
				if(rsResult.getString("LIST_TABLE1").equals(rsResult.getString("LIST_TABLE2"))){
					tValue.setProperty("LIST_TABLE",rsResult.getString("LIST_TABLE1").toString());
				}else{
					rsResult.putToMap(tValue, false);					
				}
			}
			else {
				if (log.isDebugEnabled()) {
					log.debug("TARGET TABLE SELECT FAIL..", this.QUERY_SELECT_TARGET_MMS_LIST_TABLE);
				}
				return;
			}

			// �� �÷��� ���� ��������Ƿ� ���� ITERATING�ؼ� ����Ʈ�� ��´�.
			for (Iterator iter = tValue.values().iterator(); iter.hasNext();) {
				String sTableName = iter.next().toString();
				if( listSMSLogTables.indexOf(sTableName) < 0 ) {
					if (log.isDebugEnabled()) {
						log.debug("SELECT TARGET LOG TABLE", sTableName);
					}
					listSMSLogTables.addLast(sTableName);
				}
				else {
					if (log.isDebugEnabled()) {
						log.debug("SKIP TARGET LOG TABLE", sTableName);
					}
				}
			}
		}
		finally {
			if( rsResult != null ) {
				rsResult.close();
			}
		}
		Properties tableProp = new Properties();

		// �ϴ� ���Ӹ� ��� ���̵� ���� �ʱ�ȭ�Ѵ�.
		this.LIST_SUMMARY_TARGET_AUTO_IDS.clear();

		// ���� �α� ���̺?�� �����͸� ������ ���� ���̺? ������Ʈ�� �Ѵ�.
		for (Iterator iter = listSMSLogTables.iterator(); iter.hasNext();) {
			String sTableName = iter.next().toString();
			if (log.isDebugEnabled()) {
				log.debug("TARGET LOG TABLE", sTableName);
			}
			tableProp.setProperty("LIST_TABLE", sTableName);

			try {
				this.process_table(tableProp);
			}
			catch(Throwable thw) {
				log.error("LMSAutoReceiver", "TABLE PROCESS ERROR", thw);
			}
		}
	}

	/**
	 * ���̺��� ó���Ѵ�.
	 * 
	 * @param prop
	 *            ���̺� �̸��� ���� Map
	 * @throws Throwable
	 *             ���࿡��
	 */
	protected void process_table(Properties prop) throws Throwable {
		//schedule �� �����ϴ� resultset
		eMsResultSet rsResult = null;
		try {
			if (log.isDebugEnabled()) {
				log.debug("SELECT LOG TABLE>" + prop.toString(), this.QUERY_TARGET_MMS_RESULT_QUERY);
			}
			rsResult = this.TARGET_SELECT_STMT.executeQuery(this.QUERY_TARGET_MMS_RESULT_QUERY, prop, "${", "}");
			
			Properties tValue = new Properties();

			
			while (rsResult.next()) {
			
				rsResult.putToMap(tValue, false);
				tValue.setProperty("TARGET_TABLE",prop.getProperty("LIST_TABLE"));		
				
				
				try {					
					this.process_record(tValue);
				}
				catch(Throwable thw1) {
					log.error("LMSAutoReceiver", "RECORD UPDATE ERROR", thw1);
				}
				try {					
					this.process_summary(tValue);
				}catch(Throwable thw2) {
					log.error("LMSAutoReceiver", "SUMMARY ERROR", thw2);
				}
				
				
				//LMS LOG ��FLAG UPDATE 
				try{
					this.process_update(tValue);
				}catch(Throwable thw3){
					log.error("LMSAutoReceiver", "TARGET_SMS_TABLE UPDATE ERROR", thw3);
				}
			}
		}
		finally {
			if( rsResult != null ) {
				rsResult.close();
			}
		}
	}
	
	protected void process_summary(Properties record) throws Throwable {

		StringBuffer buffer = new StringBuffer(256);
		
		if(record.getProperty("ERROR_CODE").equals("00")){
			if(log.isDebugEnabled()){
				log.debug("ERROR_CODE 00");	
			}
		}else{
			
			StringConvertUtil.ConvertString(buffer,QUERY_UPDATE_AUTO_SUMMARY_QUERY,record,"${", "}", true,false);
			if(this.EMS_UPDATE_STMT.executeUpdate(buffer.toString())>0){
				if(log.isDebugEnabled()){
					log.debug("Summary update success");	
				}				
			}else{
				if(log.isDebugEnabled()){
					log.debug("Summary update fail");
				}				
			}
		}		
	}
	/*
	 LMS UPDATE_FLAG�� ������Ʈ�� �����ش�.
	*/
	protected void process_update(Properties record) throws Throwable {

		StringBuffer buffer = new StringBuffer(512);
		
		StringConvertUtil.ConvertString(buffer,QUERY_UPDATE_LOG_RESULT_QUERY,record,"${", "}", true,false);
		if(this.TARGET_UPDATE_STMT.executeUpdate(buffer.toString())>0){//LMS UPDATE
			if(log.isDebugEnabled()){
				log.debug("update_flag success");
			}			
		}else{
			if(log.isDebugEnabled()){
				log.debug("update_flag fail");
			}
			
		}
	}
	

	/**
	 * �α� ���ڵ忡 ���� �б⸦ �����Ѵ�.
	 * 
	 * @param record
	 * @throws Throwable
	 */
	protected void process_record(Properties record) throws Throwable {		
		
		String sTRAN_ETC7 = record.getProperty("TRAN_ETC7");//"ems_26364734"
		String sTRAN_ETC6 = record.getProperty("TRAN_ETC6");//"SMSAUTO_LIST_01"
		String sTRAN_ETC1 = record.getProperty("TRAN_ETC1");//"20060227_5"
		
		record.setProperty("MEMBER_ID_SEQ",sTRAN_ETC7.substring(sTRAN_ETC7.lastIndexOf("_")+1));
		record.setProperty("MEMBER_ID",sTRAN_ETC7.substring(0,sTRAN_ETC7.lastIndexOf("_")));
		record.setProperty("WORKDAY",sTRAN_ETC1.substring(0,sTRAN_ETC1.lastIndexOf("_")));
		record.setProperty("SEQNO",sTRAN_ETC1.substring(sTRAN_ETC1.lastIndexOf("_")+1));
		record.setProperty("LIST_TABLE",sTRAN_ETC6);
		
		this.LIST_SUMMARY_TARGET_AUTO_IDS.addLast(record);
		
		StringBuffer buffer = new StringBuffer(512);
		
		if (log.isDebugEnabled()) {
			log.debug("EXEC TYPE ONE>" + record, this.QUERY_UPDATE_AUTO_RESULT_QUERY);
		}
		
		if(record.getProperty("ERROR_CODE").equals("00")){
			StringConvertUtil.ConvertString(buffer,this.QUERY_UPDATE_AUTO_RESULT_QUERY_SUCCESS,record,"${", "}", true,false);
		}else{
			StringConvertUtil.ConvertString(buffer,this.QUERY_UPDATE_AUTO_RESULT_QUERY,record,"${", "}", true,false);
		}		
		
		if(this.EMS_UPDATE_STMT.executeUpdate(buffer.toString())>0){
			if (log.isDebugEnabled()) {
				log.debug("Error_code update success");
			}			
		}else{
			if (log.isDebugEnabled()) {
				log.debug("Error_code update fail");
			}			
		}		
	}	
	/**
	 * ������ �߻��ϰų� ���������� �����ų� ������ �����̵ȴ�. �Ҵ���� �ڿ��� free ��Ű�� ������ �����Ѵ�.
	 * execute_initiateError()�� �������� Exception�� ��ȯ�ϸ� �ȵǰ� ó�������� ��ü �����Ͽ��� �Ѵ�.
	 */
	public void release_Resource() {
		// ��ȯ�� �ڿ��� ���.
	}
	/**
	 * Task�� �ʱ�ȭ�ϴ� ������ �����Ѵ�. Throwable�� �߻��ϰ� �Ǹ� execute_initiateError() �� ȣ���ϵ���
	 * �Ǿ��ִ�.
	 */
	public void execute_initiate() throws Exception {
		this.setName("MMSAutoReceiver_at_".concat(Cal.getSerialDate()));
	}
	/**
	 * �ʱ�ȭ�Ҷ� Throwable�� ���ĳ������� ó���ϴ� ������ �����Ѵ�. Exception�� ���� ��ȯ�ϸ� �ȵȴ�. �׷��� �Ф�
	 * ����ó���� �����ȿ� ��� �����Ͽ� �ϴ� ���� �����Ѵ�.
	 */
	public void execute_initiateError(Throwable thw) {
		log.error("MMSExecutor", "init error", thw);
	}
	
}