/*
 * @(#)BaseSepCodeSendLogUpdator.java            2004. 12. 8.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.auto.log.updator;

import java.util.Properties;

import pluto.common.log.LogUpdatorImpl;
import pluto.config.SqlManager;
import pluto.db.eMsResultSet;
import lombok.extern.slf4j.Slf4j;
import lombok.extern.slf4j.XSlf4j;
import pluto.util.StringUtil;

/**
 * Class description :
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class BaseSepCodeSendLogUpdator extends LogUpdatorImpl {

	

	protected static String			QUERY_UPDATE_ONE_LIST_SEND_DATE	= null;

	protected static String			QUERY_PLUS_SEND_CNT				= null;

	protected static String			QUERY_QUE_SUCCESS_UPDATE		= null;

	protected static String			QUERY_LIST_SUCCESS_UPDATE		= null;

	protected static String			QUERY_LIST_ERROR_UPDATE			= null;

	protected static String			QUERY_QUE_ERROR_UPDATE			= null;

	protected static String			QUERY_BASIC_ERROR_UPDATE		= null;

	protected static String			QUERY_SELECT_CURRENT_ERROR_CODE	= null;

	protected static String			QUERY_UPDATE_SEND_SUMMARY		= null;

	protected static String			QUERY_INSERT_SEND_SUMMARY		= null;
	
	protected static String			QUERY_INSERT_SEND_OPTIMIZ		= null;

	static {
		try {
			QUERY_UPDATE_ONE_LIST_SEND_DATE = SqlManager.getQuery("SEND_LOG_UPDATE", "QUERY_UPDATE_ONE_LIST_SEND_DATE");

			QUERY_PLUS_SEND_CNT = SqlManager.getQuery("SEND_LOG_UPDATE", "QUERY_PLUS_SEND_CNT");

			QUERY_QUE_SUCCESS_UPDATE = SqlManager.getQuery("SEND_LOG_UPDATE", "QUERY_QUE_SUCCESS_UPDATE");

			QUERY_LIST_SUCCESS_UPDATE = SqlManager.getQuery("SEND_LOG_UPDATE", "QUERY_LIST_SUCCESS_UPDATE");

			QUERY_LIST_ERROR_UPDATE = SqlManager.getQuery("SEND_LOG_UPDATE", "QUERY_LIST_ERROR_UPDATE");

			QUERY_QUE_ERROR_UPDATE = SqlManager.getQuery("SEND_LOG_UPDATE", "QUERY_QUE_ERROR_UPDATE");

			QUERY_BASIC_ERROR_UPDATE = SqlManager.getQuery("SEND_LOG_UPDATE", "QUERY_BASIC_ERROR_UPDATE");

			QUERY_SELECT_CURRENT_ERROR_CODE = SqlManager.getQuery("SEND_LOG_UPDATE", "QUERY_SELECT_CURRENT_ERROR_CODE");

			QUERY_UPDATE_SEND_SUMMARY = SqlManager.getQuery("SEND_LOG_UPDATE", "QUERY_UPDATE_SEND_SUMMARY");

			QUERY_INSERT_SEND_SUMMARY = SqlManager.getQuery("SEND_LOG_UPDATE", "QUERY_INSERT_SEND_SUMMARY");
			
			QUERY_INSERT_SEND_OPTIMIZ = SqlManager.getQuery("SEND_LOG_UPDATE", "QUERY_INSERT_SEND_OPTIMIZ");
		}
		catch(Exception e) {
			log.error(e.getMessage());
			System.exit(1);
		}
	}

	/** Creates a new instance of BaseSepCodeSendLogUpdator */
	public BaseSepCodeSendLogUpdator() {
		setName("BaseSepCodeSendLogUpdator");
		if (log.isDebugEnabled()) {
			// foo
		}
	}

	/**
	 * 업데이트 하는 로직이 들어간다.
	 */
	public String update(Object log) throws Exception {
		Properties __LOG_DATA__ = (Properties) log;

		String __T_TYPE__ = __LOG_DATA__.getProperty(LOG_T_TYPE);
		String __T_CODE__ = __LOG_DATA__.getProperty(LOG_T_CODE);

		//if( !__T_CODE__.equals("--") ) {
		/*
		 * 도메인 값이 없는 경우 DOMAIN_SEND_SUMMARY에 UPDATE할때 DELAY값이 없어서 오류가 난다.
		 * 또한, DOMAIN값 또한 없어서 오류가 난다.
		 * 따라서, 아래와 값이 해당값의 null유무를 확인 후 돌린다.
		 */
		if( !__T_CODE__.equals("--") && !StringUtil.isNull(__LOG_DATA__.getProperty(LOG_DOMAIN))) {
			/**
			 * 시작로그가 아니라면 결과서머리에 업데이트를 한다.
			 */
			int count = executeUpdate(QUERY_UPDATE_SEND_SUMMARY, __LOG_DATA__);

			/**
			 * 업데이트가 되지 않으면 인서트 하고 업데이트 한다.
			 */
			if( count < 1 ) {
				// 인서트하고
				executeUpdate(QUERY_INSERT_SEND_SUMMARY, __LOG_DATA__);

				// 다시 업데이트 하고
				executeUpdate(QUERY_UPDATE_SEND_SUMMARY, __LOG_DATA__);
			}
		}

		int __QUE_STEP__ = 0;

		try {
			__QUE_STEP__ = Integer.parseInt(__LOG_DATA__.getProperty(LOG_STEP));
		}
		catch(Exception _ex) {
		}

		/**
		 * 54-00 메일발송시작 업데이트
		 */
		if( __T_TYPE__.equals("54") && __T_CODE__.equals("--") ) {
			/* 큐발송일 경우에는 카운트를 올리지 않는다 */
			if( __QUE_STEP__ != 0 ) {
				return "QUE OR EXT SEND";
			}

			/* 원투원 발송시간 마킹 */
			executeUpdate(QUERY_UPDATE_ONE_LIST_SEND_DATE, __LOG_DATA__);

			/* 발송 수 올리기 */
			executeUpdate(QUERY_PLUS_SEND_CNT, __LOG_DATA__);

			return "START";
		}

		/**
		 * 54-10 발송성공에 대한 업데이트
		 */
		if( __T_TYPE__.equals("54") && __T_CODE__.equals("00") ) {
			/* 큐발송에서 성공할 경우 */
			if( __QUE_STEP__ > 0 ) {
				/**
				 * 큐는 기타오류에서 성공한것 이기 때문에 20 테이블의 카운트를조절해야한당....
				 */
				//예전에 어떤 에러였는지를알아와야한다.
				eMsResultSet RS = null;
				try {
					RS = this.executeQuery(QUERY_SELECT_CURRENT_ERROR_CODE, __LOG_DATA__);
					if( RS.next() ) {
						RS.putToMap(__LOG_DATA__, false);
					}
					else {
						return "NO CURRENT DATA OR CURRENT SUCCESS";
					}
				}
				catch(Exception e) {
					throw e;
				}
				finally {
					if(RS != null)
						RS.close();
				}
			}

			/* 리스트 테이블의 플래그를 업데이트 한다. */
			executeUpdate(QUERY_LIST_SUCCESS_UPDATE, __LOG_DATA__);
			/* 옵티마이징통계테이블에 INSERT */
//			executeUpdate(QUERY_INSERT_SEND_OPTIMIZ, __LOG_DATA__);			

			if( __QUE_STEP__ > 0 ) {
				executeUpdate(QUERY_QUE_SUCCESS_UPDATE, __LOG_DATA__);
				return "QUE SUCCESS OK";
			}

			return "1ST OK";
		}

		/**
		 * 55-00스풀링 단계가 다 끝났다고 하는 거가 오면
		 */
		if( __T_TYPE__.equals("55") && __T_CODE__.equals("00") ) {
			/* 큐처리가 종료된다는 것을 마킹하는 것이 필요하다. 현재는 그런 로직이 없으므로 .. 일단은 skip */
			return "OK";
		}

		/**
		 * 자 ... 에러가 발생을 했습니다.
		 */
		if( __T_TYPE__.equals("55") ) {
			if( __QUE_STEP__ > 0 ) {
				//예전에 어떤 에러였는지를알아와야한다.
				eMsResultSet RS = null;
				try {
					RS = this.executeQuery(QUERY_SELECT_CURRENT_ERROR_CODE, __LOG_DATA__);
					if( RS.next() ) {
						RS.putToMap(__LOG_DATA__, false);
					}
					else {
						return "NO CURRENT DATA";
					}
				}
				catch(Exception e) {
					throw e;
				}
				finally {
					if(RS != null)
						RS.close();
				}

				String CURRENT_ERROR_CODE = __LOG_DATA__.getProperty("CURRENT_CODE");

				// 기존 에러코드와 동일하다면 업데이트 필요가 없다.
				if( __T_CODE__.equals(CURRENT_ERROR_CODE) ) {
					return "QUE SAME ERROR SKIP";
				}
			}

			/**
			 * 일단 제일먼저 60테이블에 에러코드를 업데이트 한다.
			 */
			executeUpdate(QUERY_LIST_ERROR_UPDATE, __LOG_DATA__);
			/* 옵티마이징통계테이블에 INSERT */
//			executeUpdate(QUERY_INSERT_SEND_OPTIMIZ, __LOG_DATA__);

			if( __QUE_STEP__ > 0 ) {
				executeUpdate(QUERY_QUE_ERROR_UPDATE, __LOG_DATA__);
				return "QUE DEF ERROR OK";
			}

			executeUpdate(QUERY_BASIC_ERROR_UPDATE, __LOG_DATA__);
			return "FIRST ERROR OK";
		}
		return "NO";
	}
}
