
package jupiter.auto.log.updator;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import moon.logprocess.db.AutoPreparedStatementGroup;
import moon.logprocess.task.AutoAnalyzerMainTask;
import moon.logprocess.updator.DomainUpdateBean;
import moon.logprocess.updator.ScheduleTblBean;
import pluto.common.log.LogUpdatorImpl;
import pluto.config.SqlManager;
import pluto.config.eMsSystem;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.log.LogUpdator;
import pluto.util.StringUtil;

/**
 * <br>
 * 대량 메일 에러 로그 업데이트에 대한 규칙을 제공한다. <br>
 * 여러번 재발송 하는 경우 이전 에러 값을 참조하여 업데이트 한다. <br>
 * 써머리 테이블에 업데이트 한다.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class AutoSendSepCodeLogUpdatorPps extends LogUpdatorImpl {
	
	
	protected static Hashtable AUTO_PPS_GRP_PPT = new Hashtable();
	
	// preparestatement query
	public static String 	QUERY_UPDATE_START_60			= null;
	public static String	QUERY_UPDATE_SUCCESS_60			= null;
	public static String	QUERY_UPDATE_ERROR_60			= null;
	public static String	QUERY_SELECT_CURRENT_ERROR_CODE	= null;
	//upstream
	public static String	QUERY_UPDATE_DELIVER_60			= null;
	
	//2015.03.09 bhkim hardbounce
	public static String	QUERY_INSERT_HARDBOUNCE_SUMMARY 	= null;
	public static String	QUERY_UPDATE_HARDBOUNCE_SUMMARY 	= null;
	
	//2017.04.24 FATIGUE
	public static String	QUERY_DAY_FATIGUE_SUMMARY 	= null;
	public static String	QUERY_MONTH_FATIGUE_SUMMARY 	= null;
	
	static {
		try {			
			// prepareStatement
			QUERY_UPDATE_START_60 			= SqlManager.getQuery("AUTO_LOG_UPDATE_PPS", "QUERY_UPDATE_START_60");
			QUERY_UPDATE_SUCCESS_60 		= SqlManager.getQuery("AUTO_LOG_UPDATE_PPS", "QUERY_UPDATE_SUCCESS_60");
			QUERY_UPDATE_ERROR_60 			= SqlManager.getQuery("AUTO_LOG_UPDATE_PPS", "QUERY_UPDATE_ERROR_60");
			QUERY_SELECT_CURRENT_ERROR_CODE = SqlManager.getQuery("AUTO_LOG_UPDATE_PPS", "QUERY_SELECT_CURRENT_ERROR_CODE");
			
			//2015.03.09 bhkim hardbounce
			QUERY_INSERT_HARDBOUNCE_SUMMARY = SqlManager.getQuery("ERROR_LIST_INFO", "QUERY_INSERT_HARDBOUNCE_SUMMARY");
			QUERY_UPDATE_HARDBOUNCE_SUMMARY = SqlManager.getQuery("ERROR_LIST_INFO", "QUERY_UPDATE_HARDBOUNCE_SUMMARY");
			
			//2017.04.24 fatigue
			QUERY_DAY_FATIGUE_SUMMARY = SqlManager.getQuery("FATIGUE", "QUERY_DAY_FATIGUE_SUMMARY");
			QUERY_MONTH_FATIGUE_SUMMARY = SqlManager.getQuery("FATIGUE", "QUERY_MONTH_FATIGUE_SUMMARY");
			
			//upstream
			QUERY_UPDATE_DELIVER_60 		= SqlManager.getQuery("AUTO_LOG_UPDATE_PPS", "QUERY_UPDATE_DELIVER_60");
		}
		catch(Exception e) {
			log.error(e.getMessage());
			System.exit(1);
		}
	}

	public AutoSendSepCodeLogUpdatorPps() {
	}	
	
	
	
	// CONNECTION CONTROL /////////////////////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * 데이터 베이스에 관련한 자원 생성
	 */
	public void init_connection(eMsConnection conn) throws Exception {
		// summary 데이터가 들어있는 properties는 clear 해준다.
		AutoAnalyzerMainTask.AUTO_DOMAIN_PPT.clear();
		AutoAnalyzerMainTask.AUTO_SCHEDULE_PPT.clear();
		
		this.EMS_CONNECTION = conn;
		
		if( this.EMS_CONNECTION == null ) throw new NullPointerException( getName() +  "CONNECTION IS NULL");

		if (log.isDebugEnabled()) log.debug("[AutoSendSepCodeLogUpdatorPps] <init_connection>");
		
		if( ADDITIONAL_MODULES != null ) {
			log.debug("[ADDITIONAL_MODULES]:"+ADDITIONAL_MODULES.size());
			for( Iterator iterator = ADDITIONAL_MODULES.iterator() ; iterator.hasNext() ; ) {
				( ( LogUpdator )iterator.next() ).init_connection( conn );
			}
		}
	}
	
	/** 
	 * 데이터 베이스 관련하여 내부적으로 생성한 자원들을 반환한다.
	 */
	public void clear_connection() {
		if (log.isDebugEnabled()) log.debug("\t\t\t[AutoSendSepCodeLogUpdatorPps] <clear_connection>");
		
		if( ADDITIONAL_MODULES != null ) {
			for( Iterator iterator = ADDITIONAL_MODULES.iterator() ; iterator.hasNext() ; ) {
				( ( LogUpdator )iterator.next() ).clear_connection();
			}
		}
		
		Enumeration e = AUTO_PPS_GRP_PPT.elements();	
		AutoPreparedStatementGroup PPS_GRP = null;
		
		while(e.hasMoreElements())	{
			PPS_GRP = (AutoPreparedStatementGroup)e.nextElement();
			
			if(log.isDebugEnabled()){
				log.debug("[PPS_GRP:close]"+PPS_GRP.TABLE_LIST);
			}
			
			if(PPS_GRP !=null){PPS_GRP.close(); PPS_GRP=null;}
		}
		AUTO_PPS_GRP_PPT.clear();
	}	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	
	
	/**
	 * 업데이트 하는 로직이 들어간다.
	 */
	public String update(Object obj) throws Exception {
		Properties __LOG_DATA__ = (Properties) obj;

		String __T_TYPE__ = __LOG_DATA__.getProperty(LOG_T_TYPE);
		String __T_CODE__ = __LOG_DATA__.getProperty(LOG_T_CODE);
		
		DomainUpdateBean domainBean = null;
		// post id 로 해당 bean을 찾아 온다.
		ScheduleTblBean stBean = (ScheduleTblBean)AutoAnalyzerMainTask.AUTO_SCHEDULE_PPT.get(__LOG_DATA__.getProperty(LOG_MAIL_ID));
		
		// 일치하는 bean 이 없다면 생성한다.
		if(stBean==null){
			stBean = new ScheduleTblBean(__LOG_DATA__.getProperty(LOG_MAIL_ID));//workday_seqno
			// hash table에 추가한다.
			AutoAnalyzerMainTask.AUTO_SCHEDULE_PPT.put(__LOG_DATA__.getProperty(LOG_MAIL_ID), stBean);
		}
		
		String domain_key = "";
		boolean lock= false;
		
		// 해당 pps 그룹을 가져온다. 없다면(null) 생성해서 가져온다.
		AutoPreparedStatementGroup PPS_GRP = getPpsGroup(this.EMS_CONNECTION, __LOG_DATA__.getProperty(LOG_LIST_TABLE));

		
		try {
			/*
			 * 도메인 값이 없는 경우 DOMAIN_SEND_SUMMARY에 UPDATE할때 DELAY값이 없어서 오류가 난다.
			 * 또한, DOMAIN값 또한 없어서 오류가 난다.
			 * 따라서, 아래와 값이 해당값의 null유무를 확인 후 돌린다.
			 */
			if( !__T_CODE__.equals("--") && !StringUtil.isNull(__LOG_DATA__.getProperty(LOG_DOMAIN))) {
				/**
				 * 시작로그가 아니라면 결과서머리에 업데이트를 한다.
				 */
				domain_key=__LOG_DATA__.getProperty(LOG_DOMAIN)+"_"+__LOG_DATA__.getProperty(LOG_T_DATE_YYYYMMDD);
				domainBean = (DomainUpdateBean)AutoAnalyzerMainTask.AUTO_DOMAIN_PPT.get(domain_key);
				
				// 일치하는 도메인 정보 bean 이 없다면 생성한다.
				if(domainBean==null){
					lock = true;
					domainBean = new DomainUpdateBean(__LOG_DATA__.getProperty(LOG_DOMAIN),__LOG_DATA__.getProperty(LOG_T_DATE_YYYYMMDD));	
					AutoAnalyzerMainTask.AUTO_DOMAIN_PPT.put(domain_key, domainBean);
				}	
				
				//count 증가
				domainBean.addCodeCnt("AUTO", __T_CODE__);
				domainBean.addDur("AUTO", __T_CODE__, __LOG_DATA__.getProperty(LOG_DELAY));
			}
		}
		catch(Exception e) {
			log.error("error", e);
		}

		int __QUE_STEP__ = 0;

		try {
			__QUE_STEP__ = Integer.parseInt(__LOG_DATA__.getProperty(LOG_STEP));
		}
		catch(Exception _ex) {
		}
		
		/**
		 * 54-00 메일발송시작 업데이트
		 */
		if( __T_TYPE__.equals("54") && __T_CODE__.equals("--") ) {
			/* 큐발송일 경우에는 카운트를 올리지 않는다 */
			if( __QUE_STEP__ != 0 ) {
				return "QUE OR EXT SEND";
			}
			// start update
			PPS_GRP.PPS_UPDATE_START_60.executeUpdate(__LOG_DATA__);
			
			//push count 를 증가시킨다.
			stBean.addPush();
			
			return "START";
		}
		
		
		/**
		 * 54-10 발송성공에 대한 업데이트
		 */
		if( __T_TYPE__.equals("54") && __T_CODE__.equals("00") ) {
			
			/* 큐발송에서 성공할 경우 */
			if( __QUE_STEP__ > 0 ) {
				/**
				 * 큐는 기타오류에서 성공한것 이기 때문에 20 테이블의 카운트를조절해야한당....
				 */
				/**
				 * 예전에 어떤 에러였는지를알아와야한다.
				 */
				eMsResultSet RS = null;
				try {
					RS = PPS_GRP.PPS_SELECT_CURRENT_ERROR_CODE.executeQuery(__LOG_DATA__);
					
					if( RS.next() ) {
						RS.putToMap(__LOG_DATA__, false);
						String curr = __LOG_DATA__.getProperty("CURRENT_CODE");
						if( curr.equals("00") )
							return "BEFORE SUCCESS AND NOW SUCCESS?";
					}
					else {
						return "NO CURRENT DATA";
					}
				}
				catch(Exception e) {
					throw e;
				}
				finally {
					if(RS != null)
						RS.close();
				}
			}
			/* 일단 리스트 테이블의 플래그를 업데이트 한다. */
			PPS_GRP.PPS_UPDATE_SUCCESS_60.executeUpdate(__LOG_DATA__);

			if( __QUE_STEP__ > 0 ) {
				//stBean 에 해당 오류의 count를 하나 줄인다.
				stBean.minusErrorCnt(__LOG_DATA__.getProperty("CURRENT_CODE"));
				//fail cnt 를 줄인다.
				stBean.minusFailCnt();
				return "QUE SUCCESS OK";
			}

			return "1ST OK";
		}

		/**
		 * 55-00스풀링 단계가 다 끝났다고 하는 거가 오면
		 */
		if( __T_TYPE__.equals("55") && __T_CODE__.equals("00") ) {
			/* 큐처리가 종료된다는 것을 마킹하는 것이 필요하다. 현재는 그런 로직이 없으므로 .. 일단은 skip */
			return "OK";
		}

		/**
		 * 자 ... 에러가 발생을 했습니다.
		 */
		if( __T_TYPE__.equals("55") ) {
			if( __QUE_STEP__ > 0 ) {
				/**
				 * 예전에 어떤 에러였는지를알아와야한다.
				 */
				eMsResultSet RS = null;
				try {
					RS = PPS_GRP.PPS_SELECT_CURRENT_ERROR_CODE.executeQuery(__LOG_DATA__);
					
					if( RS.next() ) {
						RS.putToMap(__LOG_DATA__, false);
					}
					else {
						return "NO CURRENT DATA";
					}
				}
				catch(Exception e) {
					throw e;
				}
				finally {
					if(RS != null)
						RS.close();
				}
				
				// 기존 에러코드와 동일하다면 업데이트 필요가 없다.
				if( __T_CODE__.equals(__LOG_DATA__.getProperty("CURRENT_CODE")) ) {
					return "QUE SAME ERROR SKIP";
				}
			}

			/**
			 * 일단 제일먼저 60테이블에 에러코드를 업데이트 한다.
			 */
			PPS_GRP.PPS_UPDATE_ERROR_60.executeUpdate(__LOG_DATA__);

			
			/**
			 * hardbounce update
			 */
			if(Integer.parseInt(__LOG_DATA__.getProperty("T_CODE")) <= 20){
				try {
					
					if(PPS_GRP.PPS_UPDATE_HARDBOUNCE_SUMMARY.executeUpdate(__LOG_DATA__) == 0){
						PPS_GRP.PPS_INSERT_HARDBOUNCE_SUMMARY.executeUpdate(__LOG_DATA__);
					}
				}catch(Exception e) {
					throw e;
				}
				finally {
					
				}
			}
			
			/**
			 * 피로도 관련 업데이트 로직 추가
			 */
			String FATIGUE_USE_YN = eMsSystem.getProperty("fatigue.yn","N");
			if ("Y".equals(FATIGUE_USE_YN)) {
				try {
					if(PPS_GRP.PPS_UPDATE_FATIGUE_DAY_SUMMARY.executeUpdate(__LOG_DATA__) > 0){
						PPS_GRP.PPS_UPDATE_FATIGUE_MONTH_SUMMARY.executeUpdate(__LOG_DATA__);
					}
				}catch(Exception e) {
					throw e;
				}
			}
			
			if( __QUE_STEP__ > 0 ) {
				// 기존 오류는 감소시킨다.
				stBean.minusErrorCnt(__LOG_DATA__.getProperty("CURRENT_CODE"));
				// 현재 오류는 증가시킨다.
				stBean.addErrorCnt(__T_CODE__);	
				return "QUE DEF ERROR OK";
			}

			// 해당 오류 count를 증가시킨다.
			stBean.addErrorCnt(__T_CODE__);
			// 전체 fail count를 증가시킨다.
			stBean.addFailCnt();
			
			return "FIRST ERROR OK";
		}
		return "NO UPDATE";
	}
	
	
	
	
	// 필요한 properties group을 가져오기 위한 메소드
	private AutoPreparedStatementGroup getPpsGroup(eMsConnection conn, String list_table) throws Exception{
		
		AutoPreparedStatementGroup PPS_GRP = (AutoPreparedStatementGroup)AUTO_PPS_GRP_PPT.get(list_table);
		
		if(PPS_GRP==null){ 
			PPS_GRP = setPpsConn(conn, list_table);
			AUTO_PPS_GRP_PPT.put(list_table, PPS_GRP);
		}
		
		return PPS_GRP;
	}
	
	
	private AutoPreparedStatementGroup setPpsConn(eMsConnection conn, String list_table) throws Exception{
		log.debug("["+list_table+"] Properties group Create !!");
		AutoPreparedStatementGroup pps_grp = new AutoPreparedStatementGroup(list_table);
		pps_grp.create(conn);
		return pps_grp;
	}



	public LogUpdator getLogUpdator(String __SEND_TYPE__) {
		return null; 
	}
}
