
package jupiter.auto.log.updator;

import java.util.Properties;

import com.humuson.tms.constrants.PushResponseCodeConstants;

import lombok.extern.slf4j.Slf4j;
import moon.logprocess.db.AutoPushPreparedStatementGroup;
import moon.logprocess.task.AutoAnalyzerMainTask;
import moon.logprocess.updator.ScheduleTblBean;
import pluto.db.eMsConnection;

/**
 * <br>
 * 대량 메일 에러 로그 업데이트에 대한 규칙을 제공한다. <br>
 * 여러번 재발송 하는 경우 이전 에러 값을 참조하여 업데이트 한다. <br>
 * 써머리 테이블에 업데이트 한다.
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class AutoSendPushLogUpdatorPps extends AutoSendSepCodeLogUpdatorPps {
	
	public AutoSendPushLogUpdatorPps() {
	}	
	
	
	/**
	 * 업데이트 하는 로직이 들어간다.
	 */
	public String update(Object obj) throws Exception {
		Properties __LOG_DATA__ = (Properties) obj;

		String __T_TYPE__ = __LOG_DATA__.getProperty(LOG_T_TYPE);
		String __T_CODE__ = __LOG_DATA__.getProperty(LOG_T_CODE);
		String serverId = __LOG_DATA__.getProperty(LOG_SERVER_ID);
		
		// post id 로 해당 bean을 찾아 온다.
		// MQ로부터 어떤 서버아이디에 해당되는 발송건을 받을지 모르므로 업데이트 엔진에서 요청된 서버아이디마다 스케쥴빈을 생성 및 관리한다.
		ScheduleTblBean stBean = (ScheduleTblBean)AutoAnalyzerMainTask.AUTO_SCHEDULE_PPT.get(__LOG_DATA__.getProperty(LOG_MAIL_ID)+":"+serverId);
		
		// 일치하는 bean 이 없다면 생성한다.
		if(stBean==null){
			stBean = new ScheduleTblBean(__LOG_DATA__.getProperty(LOG_MAIL_ID));//workday_seqno
			stBean.setServerId(serverId);
			// hash table에 추가한다.
			AutoAnalyzerMainTask.AUTO_SCHEDULE_PPT.put(__LOG_DATA__.getProperty(LOG_MAIL_ID)+":"+serverId, stBean);
		}
		
		
		// 해당 pps 그룹을 가져온다. 없다면(null) 생성해서 가져온다.
		AutoPushPreparedStatementGroup PPS_GRP = getPpsGroup(this.EMS_CONNECTION, __LOG_DATA__.getProperty(LOG_LIST_TABLE));

		
		/**
		 * 54-00 푸시발송시작 업데이트는 PushFixedDomainSingleRcptBufferedCommunicationActor 업데이트 처리
		 * 발송 카운트도 PushFixedDomainSingleRcptBufferedCommunicationActor 에서 처
		 */
		
		if( __T_TYPE__.equals("54") &&
					( 
						__T_CODE__.equals(PushResponseCodeConstants.SENDING) ||
						__T_CODE__.equals(PushResponseCodeConstants.SENDING_CCS) || 
						__T_CODE__.equals(PushResponseCodeConstants.MQ_SENDING) 
					)
			) {

			// PUSH 일때는 SEND_STATE 00유지  ERROR_CODE 만 변경한다.
			log.debug("__LOG_DATA__: {}", __LOG_DATA__);
			PPS_GRP.PPS_UPDATE_START_60.executeUpdate(__LOG_DATA__);
			
			
			return "START";
		}
		
		
		
		/**
		 * 54-10 발송성공에 대한 업데이트
		 */
		if( __T_TYPE__.equals("54")) {
			
			/* 일단 리스트 테이블의 플래그를 업데이트 한다. */
			PPS_GRP.PPS_UPDATE_SUCCESS_60.executeUpdate(__LOG_DATA__);


			return "1ST OK";
		}

		/**
		 * 55-00스풀링 단계가 다 끝났다고 하는 거가 오면
		 */
		if( __T_TYPE__.equals("55") && __T_CODE__.equals("00") ) {
			/* 큐처리가 종료된다는 것을 마킹하는 것이 필요하다. 현재는 그런 로직이 없으므로 .. 일단은 skip */
			return "OK";
		}

		/**
		 * 자 ... 에러가 발생을 했습니다.
		 */
		if( __T_TYPE__.equals("55") ) {

			/**
			 * 일단 제일먼저 60테이블에 에러코드를 업데이트 한다.
			 */
			PPS_GRP.PPS_UPDATE_ERROR_60.executeUpdate(__LOG_DATA__);
			

			// 해당 오류 count를 증가시킨다.
			stBean.addErrorCnt(__T_CODE__);
			// 전체 fail count를 증가시킨다.
			stBean.addFailCnt();
			
			return "FIRST ERROR OK";
		}
		/**
		 * upstream 반영
		 */
		if( __T_TYPE__.equals("56") ) {
			log.info("__LOG_DATA__: {}", __LOG_DATA__);
			PPS_GRP.PPS_UPDATE_DELIVER_60.executeUpdate(__LOG_DATA__);
			return "DELIVER UPDATE OK";
		}
		
		return "NO UPDATE";
	}
	
	
	
	
	// 필요한 properties group을 가져오기 위한 메소드
	private AutoPushPreparedStatementGroup getPpsGroup(eMsConnection conn, String list_table) throws Exception{
		
		AutoPushPreparedStatementGroup PPS_GRP = (AutoPushPreparedStatementGroup)AUTO_PPS_GRP_PPT.get(list_table);
		
		if(PPS_GRP==null){ 
			PPS_GRP = setPpsConn(conn, list_table);
			AUTO_PPS_GRP_PPT.put(list_table, PPS_GRP);
		}
		
		return PPS_GRP;
	}
	
	
	private AutoPushPreparedStatementGroup setPpsConn(eMsConnection conn, String list_table) throws Exception{
		log.debug("["+list_table+"] Properties group Create !!");
		AutoPushPreparedStatementGroup pps_grp = new AutoPushPreparedStatementGroup(list_table);
		pps_grp.create(conn);
		return pps_grp;
	}

}
