/*
 * @(#)TestListMaker.java            2004. 12. 23.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.auto.actor;

import java.io.IOException;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

import lombok.extern.slf4j.Slf4j;
import pluto.config.SqlManager;
import pluto.db.ConnectInfo;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsResultSet;
import pluto.db.eMsStatement;
import pluto.io.FileElement;
import pluto.lang.eMsLocale;
import pluto.log.Composer;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import pluto.util.StringUtil;
import pluto.util.convert.DelimConvertor;
import venus.spool.common.basic.NoTargetListException;
import venus.spool.common.parser.SpoolAnalyzer;
import venus.spool.common.parser.SpoolHashParser;
import venus.spool.common.parser.SpoolHeaderParser;

/**
 * Class description :
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class TestListMaker extends BasicListMaker {

	

	protected String				LIST_TABLE	= null;
	
	//삼성생명 전용으로 추가한 부분임.
	protected String PWD     = "PWD";
	protected String PWD_STR = "RmG0RhNBwJVlG5klf5pRuA==";
	
	/*
	SELECT EMAIL AS TEST_EMAIL
	  FROM EMS_AUTO_TEST_LIST
	 WHERE MAIL_ID = '${MAIL_ID}'
	 */
	private static String QUERY_SELECT_TEST_EMAIL_LIST = null;
	
	/*
	SELECT TOP 2 
	 */
	private static String QUERY_SELECT_TEST_CNT_MYSQL = null;
	private static String QUERY_SELECT_TEST_CNT_MSSQL = null;
	private static String QUERY_SELECT_TEST_CNT_ORACLE = null;
	
	static {
		try {
			QUERY_SELECT_TEST_EMAIL_LIST = SqlManager.getQuery("TMS_EMAIL_TEST", "QUERY_SELECT_TEST_EMAIL_LIST");
			QUERY_SELECT_TEST_CNT_MYSQL = SqlManager.getQuery("TMS_EMAIL_TEST", "QUERY_SELECT_TEST_CNT_MYSQL");
			QUERY_SELECT_TEST_CNT_MSSQL = SqlManager.getQuery("TMS_EMAIL_TEST", "QUERY_SELECT_TEST_CNT_MSSQL");
			QUERY_SELECT_TEST_CNT_ORACLE = SqlManager.getQuery("TMS_EMAIL_TEST", "QUERY_SELECT_TEST_CNT_ORACLE");
		}catch(Exception e) {
			log.error("query init error", e);
			System.exit(1);
		}
	}
	
	protected List	TEST_EMAIL_LIST	= new LinkedList();
	

	/** Creates a new instance of TestListMaker */
	public TestListMaker() {
		super();
	}

	protected void inner_init(Properties prop) throws Exception {
		this.SCHEDULE_INFO = prop;

		// 로그 조립 인스턴스 초기화
		this.composer = Composer.getComposerInstance();

		// 스풀 헤쉬파서 초기화
		this.AUTO_KEY_VALUE_PARSER = new SpoolHashParser("|");

		//Prop에 이미 POST_ID가 들어 있다...
		this.POST_ID = prop.getProperty("POST_ID");
		this.LIST_TABLE = prop.getProperty("LIST_TABLE");

		setName(this.POST_ID + "'s TestListMaker");

		this.WORK_FILE_ID = this.POST_ID + "_test_" + System.currentTimeMillis();

		this.WORKDAY = null;
		this.SEQNO = null;
	}

	//kdy0831 start!!!
	//CLOB DATA 를 가져오기 위한 함수
	public static String readClobData(Reader reader) throws IOException {
        StringBuffer data = new StringBuffer();
        char[] buf = new char[1024];
        int cnt = 0;
        if (null != reader) {
            while ( (cnt = reader.read(buf)) != -1) {
                data.append(buf, 0, cnt);
                
            }
        }
        return data.toString();
    }
	
	protected String getSpoolData(){

		
		//여기서 EMS_AUTO_SAMPLING 테이블에서 SPOOL_FLAG = N 이라면, SPOOL 파일 받은 것을 그대로 써주게 하고, 그렇지 않다면 기존 로직 그대로 INFO 파일을 
		//생성하게 한다.
		
		String spool_data = "";
		String lobGetQuery = "";
		String sample_id = "";
		sample_id = this.SCHEDULE_INFO.getProperty("ID");
			
		lobGetQuery = "SELECT SPOOL_DATA FROM EMS_AUTO_SAMPLING WHERE ID='"+ sample_id +"'";
		
		eMsConnection con = null;
		PreparedStatement psmt = null;
		ResultSet rs = null;
		try {
			con = ConnectionPool.getConnection();
			psmt = con.prepareStatement(lobGetQuery);
			rs = psmt.executeQuery();
		} catch (Exception e) {
			log.error("lobGetQuery error", e);
		}

		try {
			if(rs != null && rs.next()){
				String clobData = readClobData(rs.getCharacterStream("SPOOL_DATA"));
				spool_data = new String(clobData.getBytes( eMsLocale.FILE_SYSTEM_IN_CHAR_SET ), eMsLocale.FILE_SYSTEM_OUT_CHAR_SET );
			}
		} catch (Exception e) {
			log.error("clob error", e);
		} finally{
			if(rs != null){
				try {
					rs.close();
				} catch (SQLException e) {
				}
			}
			if( psmt != null){
				try {
					psmt.close();
				} catch (SQLException e) {
				}
			}
			if( con!= null ){
				con.recycle();
			}
			
			
		}
		return spool_data;
	}
	//kdy0831 end
	
	
	protected synchronized void execute_BasicInfoProcess() throws Exception {
		////////////////////////////////////////////////
		// SAMSUNGLIFE개발 
		////////////////////////////////////////////////
		StringBuffer  buffer           = new StringBuffer(512);
		eMsConnection EMS_CONNECTION   = null;
		eMsStatement  SELECT_STATEMENT = null;
		eMsResultSet  rs               = null;
		String        test_email       = "";
		
		try {
			EMS_CONNECTION = ConnectionPool.getConnection();
			SELECT_STATEMENT = EMS_CONNECTION.createStatement();

			StringConvertUtil.ConvertString(buffer,QUERY_SELECT_TEST_EMAIL_LIST, this.SCHEDULE_INFO, "${","}", true, false);
			rs = SELECT_STATEMENT.executeQuery(buffer.toString());

			while (rs.next()) {
				test_email = rs.getString("TEST_EMAIL");
//				this.TEST_EMAIL_LIST.add(test_email);
				String[] testList = test_email.split("::");
				
				for(int i=0; i<testList.length; i++){
					this.TEST_EMAIL_LIST.add(testList[i]);
				}
			}
		} catch (Exception e) {
			throw e;
		} finally {
			try { if (rs != null) { rs.close(); } } catch (Exception ignore) { }
			if(EMS_CONNECTION != null) {
				EMS_CONNECTION.recycleStatement(SELECT_STATEMENT);
				SELECT_STATEMENT = null;
				EMS_CONNECTION.recycle();	
			}
		}
		
		if( TEST_EMAIL_LIST.size() < 1 ) {
			throw new NoTargetListException("NO TARGET LIST => " + this.SCHEDULE_INFO.getProperty("SEND_LIST"));
		}
		
		execute_BasicInfoProcess_basic();
	}
	
	protected synchronized void execute_BasicInfoProcess_basic() throws Exception {
		String this_day = Cal.getDayDate();		
		
		// 기본리스트 파일 저장 파일이름 결정
		this.LIST_STORE_FILE_NAME = FileElement.CheckSubDirectory(TMP_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + ".base";
		
		/**
		 * 저장파일을 초기화 한다.
		 */
		openWriter(this.LIST_STORE_FILE_NAME);
		
		this.NEXT_BASE_INFO_FILE_NAME = this.LIST_STORE_FILE_NAME;
		
		String __EXEC_TARGET_QUERY__ = null;
		
		eMsConnection __TARGET_CONNECTION__ = null;
		eMsStatement stmt = null;
		eMsResultSet rs = null;

		/* 시작 전에 헤더 스트링을 초기화하고 시작한다. */
		this.SCHEDULE_INFO.setProperty("MAPPINGHEADER", "");
		
		ConnectInfo __TMP_CONNECTION_INFO__ = (ConnectInfo) this.VECTOR_QUERY_LIST_INFO.get(0);

		StringBuffer buffer = new StringBuffer(1024);

		boolean __APPEND_CHECK__ = false;
		try {
			__TARGET_CONNECTION__ = ConnectionPool.getConnection(__TMP_CONNECTION_INFO__);
			
			log.debug(".execute_BasicInfoProcess() db url :"+ __TMP_CONNECTION_INFO__.getDB_URL());
			log.debug(".execute_BasicInfoProcess() db id :"+ __TMP_CONNECTION_INFO__.getDB_UID());
			log.debug(".execute_BasicInfoProcess() db pwd :"+ __TMP_CONNECTION_INFO__.getDB_PASS());

			stmt = __TARGET_CONNECTION__.createStatement();
			
			buffer.setLength(0);
			//StringConvertUtil.ConvertString(buffer, this.SCHEDULE_INFO.getProperty("SAMPLING_SYNTAX"), this.SCHEDULE_INFO, "${","}", true, false);
			StringConvertUtil.ConvertString(buffer, __TMP_CONNECTION_INFO__.getQUERY(), this.SCHEDULE_INFO, "${", "}", true, false);
			//__EXEC_TARGET_QUERY__ = buffer.toString();
			
			/**
			 * test row 입력
			 */
			if(__TMP_CONNECTION_INFO__.getDB_URL().indexOf("oracle")>0){		//oracle
				// sample count 적용 : rownum<= 5 를 추가
				__EXEC_TARGET_QUERY__ = setQuerySample_oracle(buffer.toString());
			}else if(__TMP_CONNECTION_INFO__.getDB_URL().indexOf("mysql")>0){	//mysql
				// sample count 적용 : top 2를 추가
				__EXEC_TARGET_QUERY__ = setQuerySample_mysql(buffer.toString());
			}else{																//mssql
				// sample count 적용 : top 2를 추가
				__EXEC_TARGET_QUERY__ = setQuerySample_mssql(buffer.toString());
			}
			
			log.debug(".execute_BasicInfoProcess() exe test_query:"+ __EXEC_TARGET_QUERY__);
			
			rs = stmt.executeQuery(__TARGET_CONNECTION__.encode(__EXEC_TARGET_QUERY__));
			log.debug(".execute_BasicInfoProcess() exe query:[OK]");
			
			
			
			
			//////////////////////////////////////////////////////////////////////////////////////
			String [] header_list = StringUtil.split(rs.getHeaderString(), "|");
			buffer.setLength(0);
			
			//액션 인덱스
			int pwd_index = 0;
			String temp_header = "";
			
			for(int i=1; i<=header_list.length; i++) {
				temp_header = header_list[i-1];
				
				//테스트 발송은 1111111 로 페스워드를 세팅한다.
				if(temp_header.equals(PWD)){
					pwd_index = i;
				}
				
				//헤더를 다시 만들어줌
				if(i!=1){
					buffer.append("|");
				}
				buffer.append(temp_header);
			}
			
			this.SCHEDULE_INFO.setProperty("MAPPINGHEADER", buffer.toString());
			////////////////////////////////////////////////////////////////////////////////////
			
			
			
			log.info("TARGET MAPPINGHEADER : "+ this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"));

			// int patch_count = 0;
			int colcount = rs.getColumnCount();

			String temp;

			// TEST 메일은 한 건만 발송되게 하자. ( while -> if 로 변경 2005.01.17 )

			while (rs.next()) {
				buffer.setLength(0);
				temp = rs.getString(1);
				
				
				//테스트 발송은 1111111 로 페스워드를 세팅한다.
				if(pwd_index==1 ){
					temp = PWD_STR;
				}else{
					temp = rs.getString(1);
				}
				
				
				DelimConvertor.encodeToBuffer(buffer, (temp == null ? "" : temp.trim()));
				// BUFFERED_WRITER.write( DelimConvertor.encode_(
				// rs.getString(1) ) );

				for (int count = 2; count <= colcount; count++) {
					buffer.append("|");
					
					
					//테스트 발송은 1111111 로 페스워드를 세팅한다.
					if(pwd_index==count ){
						temp = PWD_STR;
					}else{
						temp = rs.getString(count);
					}
					
					DelimConvertor.encodeToBuffer(buffer, (temp == null ? "": temp.trim()));
					// BUFFERED_WRITER.write("|");
					// BUFFERED_WRITER.write( DelimConvertor.encode_(
					// rs.getString(count) ) );
				}
				
				BUFFERED_WRITER.write(buffer.toString());
				BUFFERED_WRITER.newLine();
				BUFFERED_WRITER.flush();
				
				__APPEND_CHECK__ = true;
				log.debug("LINE CREATE....");
			}

			/**
			 * 리스트가 하나도 없다면 Exception을 날린다.
			 */
			if (!__APPEND_CHECK__) {
				throw new NoTargetListException("NO TARGET LIST => "
						+ this.POST_ID);
			}
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			try {
				if(rs != null){
					rs.close();
				}
			}
			catch(Exception ignore) {
			}
			try {
				if(stmt != null){
					stmt.close();
				}
			}
			catch(Exception ignore) {
			}
			try {
				if(__TARGET_CONNECTION__ != null){
					__TARGET_CONNECTION__.destroy();
				}
			}
			catch(Exception ignore) {
			}
			try {
				BUFFERED_WRITER.flush();
			}
			catch(Exception ignore) {
			}
			try {
				if(BUFFERED_WRITER != null){
					BUFFERED_WRITER.close();
				}
			}
			catch(Exception ignore) {
			}
		}
	}
	
	/**
	 * mysql 쿼리에서 샘플데이터를 가져오기위한 쿼리 수정 부분이다.
	 * @param query
	 * @return
	 */
	protected static String setQuerySample_mysql(String query){
		StringBuffer buffer = new StringBuffer();
		buffer.append(query);
		buffer.append(" ");
		buffer.append(QUERY_SELECT_TEST_CNT_MYSQL);
		
		return buffer.toString() ;
	}
	
	/**
	 * mssql 쿼리에서 샘플데이터를 가져오기위한 쿼리 수정 부분이다.
	 * @param query
	 * @return
	 */
	protected static String setQuerySample_mssql(String query){
		String select_str = "SELECT";
		String distinct_str = "DISTINCT";
		String uQuery = query.toUpperCase();
		
		int point_select   = uQuery.indexOf(select_str);
		int point_distinct = uQuery.indexOf(distinct_str);
		
		int point  = 0;
		if(point_distinct >=0 ){
			point      = point_distinct + distinct_str.length();
		}else{
			point      = point_select   + select_str.length();
		}
		
		StringBuffer buffer = new StringBuffer();
		buffer.append(query.substring(0, point));
		buffer.append(" ");
		buffer.append(QUERY_SELECT_TEST_CNT_MSSQL.trim());
		buffer.append(" ");
		buffer.append(query.substring(point));
		
		return buffer.toString();
	}
	/**
	 * Oracle에서 샘플데이터를 가져오기 위한 쿼리 수정 부분이다.
	 * @param query
	 * @return
	 */
	protected static String setQuerySample_oracle(String query){
		StringBuffer buffer = new StringBuffer();
		buffer.append(query);
		buffer.append(" AND ");
		buffer.append(QUERY_SELECT_TEST_CNT_ORACLE);
		
		return buffer.toString() ;
	}
	
	/**
	 * 통합 스풀 패턴으로 전환하여 마지막 파일을 만들어야 한다.
	 */
	protected synchronized void execute_DBInsertProcess() throws Exception {
		String this_day = Cal.getDayDate();
		// 기본리스트 파일 저장 파일이름 결정
		this.INFO_ADDED_FINAL_FILE_NAME = FileElement.CheckSubDirectory(TMP_WORKING_DIRECTORY, this_day) + "/" + this.WORK_FILE_ID + ".infoadd";

		/**
		 * 저장파일을 초기화 한다.
		 */
		if (log.isDebugEnabled()) 
			log.debug(".execute_DBInsertProcess() set spool file :" + this.INFO_ADDED_FINAL_FILE_NAME);
		openWriter(this.INFO_ADDED_FINAL_FILE_NAME);

		if (log.isDebugEnabled()) 
			log.debug(".execute_DBInsertProcess() set source file :" + this.NEXT_BASE_INFO_FILE_NAME);
		openReader(this.NEXT_BASE_INFO_FILE_NAME);
		
		/**
		 * 다음 단계에서 사용할 소스파일을 지정한다.
		 */
		this.NEXT_BASE_INFO_FILE_NAME = this.INFO_ADDED_FINAL_FILE_NAME;

		/**
		 * 스풀에 적을 기본적인 사항을 세팅한다.
		 */
		SpoolAnalyzer SPOOL_ANALYZER = SpoolAnalyzer.getSpoolAnalyzer();

		SPOOL_ANALYZER.setSendType("AUTOTEST");// one to one
		SPOOL_ANALYZER.setNextSpoolGenerate("N");// spool attach
		SPOOL_ANALYZER.setLimitDate("19000000");
		SPOOL_ANALYZER.setPostID(this.POST_ID);
		SPOOL_ANALYZER.setListTable("NOTABLE");

		SPOOL_ANALYZER.setStep(0);

		Hashtable __HEADER_MAP__ = new Hashtable();
		String __TMP_READ_LINE__ = null;

		try {
			SpoolHeaderParser.parseSimple(this.SCHEDULE_INFO.getProperty("MAPPINGHEADER"), "|", __HEADER_MAP__);

			while (BUFFERED_READER.ready()) {
				__TMP_READ_LINE__ = BUFFERED_READER.readLine();

				if (log.isDebugEnabled()) 
					log.debug(" read => " + __TMP_READ_LINE__);

				// 공백 라인일경우에 스킵
				if( __TMP_READ_LINE__ == null || __TMP_READ_LINE__.trim().length() < 5 )
					continue;

				try {
					this.AUTO_KEY_VALUE_PARSER.parseSimple(__TMP_SIMPLE_HASH__, __TMP_READ_LINE__, __HEADER_MAP__);
					
					if( !__TMP_SIMPLE_HASH__.containsKey("TMS_M_ID") || !__TMP_SIMPLE_HASH__.containsKey("TMS_M_NAME") ) {
						continue;
					}
					
					for (Iterator iter = TEST_EMAIL_LIST.iterator(); iter.hasNext();) {
						/**
						 * 미리 만들어놓은 이메일리스트를 쭉! 넣어 준다.
						 */
						SPOOL_ANALYZER.setTokenID(iter.next().toString());
						SPOOL_ANALYZER.setMemberID(__TMP_SIMPLE_HASH__.get("TMS_M_ID").toString().concat("_1"));
						SPOOL_ANALYZER.setMemberName(__TMP_SIMPLE_HASH__.get("TMS_M_NAME").toString());
						SPOOL_ANALYZER.setMapping(__TMP_READ_LINE__);
						BUFFERED_WRITER.write(SPOOL_ANALYZER.composeSingleRcptSend());
						log.info(" Souce==> "+SPOOL_ANALYZER.composeSingleRcptSend());
						BUFFERED_WRITER.newLine();
						BUFFERED_WRITER.flush();
					}
				}
				catch(Exception e) {
					log.error("TEST ID/NAME/EMAIL POPUP FAIL=>" + __TMP_READ_LINE__, e);
					continue;
				}
			}

			log.info(" Souce File Read Done ");
		}
		catch(Exception e) {
			throw e;
		}
		finally {
			try {
				if(BUFFERED_READER != null){
					BUFFERED_READER.close();
				}
			}
			catch(Exception e) {
			}
			try {
				BUFFERED_WRITER.flush();
			}
			catch(Exception e) {
			}
			try {
				if(BUFFERED_WRITER != null){
					BUFFERED_WRITER.close();
				}
			}
			catch(Exception e) {
			}
			log.info(" Exit Souce File Read Routine ");
		}
	}

	protected synchronized void execute_FinalProcess() throws Exception {
		// do nothing
	}

	protected synchronized String StoreLongMapping(String __WORKDAY__, String __SEQNO__, String __MEMBER_ID__, String __MAPPING__) {
		return null;
	}

	protected void execute_HeaderInfoSave() throws Exception {
		//do nothing
	}

	public Object getTargetList() {
		return this.NEXT_BASE_INFO_FILE_NAME;
	}

	protected void updateTaskState(String __STATE__) throws Exception {
		//do nothing
	}

	protected void deleteCurrentList() throws Exception {
		//do nothing
	}

	public String getID() {

		return (this.POST_ID == null) ? null : (this.POST_ID);
	}
}
