/*
 * @(#)BasicListMaker.java            2004. 12. 23.
 *
 * Copyright (c) 1998-2004 Amail, Inc.
 * 708-8 Global Building 10th floor, YeokSamdong, Gangnamgu, Seoul, 
 * Korea republic of. All rights reserved.
 * 
 * This software is the confidential and proprietary information of Amail,
 * Inc. ("Confidential Information"). You shall not disclose such 
 * Confidential Information and shall use it only in accordance with
 * the terms of the license agreement you entered into Amail.
 * 
 */

package jupiter.auto.actor;

import java.sql.SQLException;
import java.util.Properties;

import pluto.config.SqlManager;
import pluto.db.ConnectionPool;
import pluto.db.eMsConnection;
import pluto.db.eMsPreparedStatement;
import pluto.db.eMsResultSet;
import pluto.io.FileElement;
import lombok.extern.slf4j.Slf4j;
import pluto.util.Cal;
import pluto.util.StringConvertUtil;
import venus.spool.common.parser.SpoolHeaderParser;

/**
 * Class description :
 * 
 * @version
 * @author dragon
 *  
 */
@Slf4j
public class SMSBasicListMaker extends BasicListMaker {

	

	public static String QUERY_SMS_INSERT_SCHEDULED_SEND_LIST = null;
	
	static{
		QUERY_SMS_INSERT_SCHEDULED_SEND_LIST = SqlManager.getQuery("SMS", "QUERY_SMS_INSERT_SCHEDULED_SEND_LIST");
	}

	/** Creates a new instance of BasicListMaker */
	public SMSBasicListMaker() {
	}

	/**
	 * 내부변수를 초기화 한다.
	 */
	protected void inner_init(Properties prop) throws Exception {
		super.inner_init(prop);

		this.setName(this.POST_ID + "'s BasicListMaker");
		this.WORK_FILE_ID = this.POST_ID + "_sms_" + Cal.getSerialDate();
	}

	/**
	 * 기본 회원과 매핑 정보저장 파일을 참조하여 루핑 정보를 추가한 파일을 생성한다. step : LOOP_OK 에서 실행 된다.
	 */
	protected void execute_DBInsertProcess() throws Exception {

		String this_day = Cal.getDayDate();

		// 기본리스트 파일 저장 파일이름 결정
		this.INFO_ADDED_FINAL_FILE_NAME = FileElement.CheckSubDirectory(
				TMP_WORKING_DIRECTORY, this_day)
				+ "/" + this.WORK_FILE_ID + ".infoadd";

		// 저장파일을 초기화 한다.
		if (log.isDebugEnabled())
			log.debug(".execute_DBInsertProcess() set spool file :"
					+ this.INFO_ADDED_FINAL_FILE_NAME);
		openWriter(this.INFO_ADDED_FINAL_FILE_NAME);

		if (log.isDebugEnabled())
			log.debug(".execute_DBInsertProcess() set source file :"
					+ this.NEXT_BASE_INFO_FILE_NAME);
		openReader(this.NEXT_BASE_INFO_FILE_NAME);

		// 다음 단계에서 사용할 소스파일을 지정한다.
		this.NEXT_BASE_INFO_FILE_NAME = this.INFO_ADDED_FINAL_FILE_NAME;

		eMsConnection EMS_CONNECTION = null;
		eMsPreparedStatement __INSERT_PS__ = null;
		eMsPreparedStatement __SEQ_SELECT_PS__ = null;

		eMsResultSet __RS_OF_TMS_M_ID_SEQ__ = null;

		String __TMP_READ_LINE__ = null;

		StringBuffer buffer = new StringBuffer(1024);
		
		try {
			EMS_CONNECTION = ConnectionPool.getConnection();
			
			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer,
					QUERY_SMS_INSERT_SCHEDULED_SEND_LIST, this.SCHEDULE_INFO,
					"${", "}", true, false);

			//그냥 넣어보는 쿼리
			__INSERT_PS__ = new eMsPreparedStatement(buffer
					.toString(), "@{", "}");
			__INSERT_PS__.connectTo(EMS_CONNECTION);

			buffer.setLength(0);
			StringConvertUtil.ConvertString(buffer,
					QUERY_SELECT_MAX_MEMBER_SEQ_FROM_LIST_TABLE,
					this.SCHEDULE_INFO, "${", "}", true, false);

			// 안들어갈때 SEQ찾차보는 쿼리
			__SEQ_SELECT_PS__ = new eMsPreparedStatement(buffer
					.toString(), "@{", "}");
			__SEQ_SELECT_PS__.connectTo(EMS_CONNECTION);

			SpoolHeaderParser.parseSimple(this.SCHEDULE_INFO
					.getProperty("MAPPINGHEADER"), "|", __HEADER_MAP__);

			log.info(" Souce File Read Ready ");

			while (BUFFERED_READER.ready()) {
				__TMP_READ_LINE__ = BUFFERED_READER.readLine();

				if (log.isDebugEnabled())
					log.debug(" read => " + __TMP_READ_LINE__);

				// 공백 라인일경우에 스킵
				if (__TMP_READ_LINE__ == null
						|| __TMP_READ_LINE__.trim().length() < 1)
					continue;

				try {
					this.AUTO_KEY_VALUE_PARSER.parseSimple(__TMP_SIMPLE_HASH__,
							__TMP_READ_LINE__, __HEADER_MAP__);
				} catch (Exception e) {
					log.error("ID/NAME/EMAIL POPUP FAIL=>"+ __TMP_READ_LINE__, e);
					continue;
				}

				String MAPPING = null;

				if (__TMP_READ_LINE__.length() > MAPPING_LIMIT) {
					MAPPING = StoreLongMapping(this.WORKDAY, this.SEQNO,__TMP_READ_LINE__);
				} else {
					MAPPING = __TMP_READ_LINE__;
				}

				if (MAPPING == null) {
					log.error("Mapping is null Or Store Filename is NULL.... so skip=>"+ __TMP_READ_LINE__);
					continue;
				}

				// 맵에 매핑 데이터 넣어야 한다.
				// 
				buffer.setLength(0);
				StringConvertUtil.ConvertString(buffer,this.SCHEDULE_INFO.getProperty("CONTENT"),__TMP_SIMPLE_HASH__, "${", "}", false, false);
				__TMP_SIMPLE_HASH__.put("MAPPING", buffer.toString());

				if (!__TMP_SIMPLE_HASH__.containsKey("TMS_M_ID_SEQ")) {
					__TMP_SIMPLE_HASH__.put("TMS_M_ID_SEQ", String.valueOf(System.currentTimeMillis() % 86400000));
				}

				try {
					try {
						__INSERT_PS__.executeUpdate(__TMP_SIMPLE_HASH__);
					} catch (SQLException dup) {
						if (log.isDebugEnabled())
							log.debug(dup.getMessage());
						__RS_OF_TMS_M_ID_SEQ__ = __SEQ_SELECT_PS__
								.executeQuery(__TMP_SIMPLE_HASH__);

						if (__RS_OF_TMS_M_ID_SEQ__.next()) {
							__TMP_SIMPLE_HASH__.put("TMS_M_ID_SEQ",
									__RS_OF_TMS_M_ID_SEQ__.getString(1));
						} else {
							if (log.isDebugEnabled())
								log.debug("MAX SEQ SELECT FAIL....so skip..");
							continue;
						}

						try {
							__RS_OF_TMS_M_ID_SEQ__.close();
						} catch (Exception ignore) {
						}

						__INSERT_PS__.executeUpdate(__TMP_SIMPLE_HASH__);
					}

					BUFFERED_WRITER.write(__TMP_SIMPLE_HASH__.get(
							"TMS_M_ID_SEQ").toString());
					BUFFERED_WRITER.write("|");
					BUFFERED_WRITER.write(__TMP_READ_LINE__);

					BUFFERED_WRITER.newLine();
					BUFFERED_WRITER.flush();
				} catch (Exception ignore) {
					if (log.isDebugEnabled())
						log.debug(ignore.getMessage());
					log.error("INSERT RETRY ERR: "
							+ ignore.toString() + " .. so skip ");
					continue;
				}
			}

			log.info(" Souce File Read Done ");
		} catch (Exception e) {
			log.error(e.toString());
			throw e;
		} finally {
			try {
				if(__SEQ_SELECT_PS__ != null){
					__SEQ_SELECT_PS__.close();
				}
			} catch (Exception e) {
			}
			try {
				if( __INSERT_PS__!= null){
					__INSERT_PS__.close();
				}
			} catch (Exception e) {
			}
			try {
				if(BUFFERED_READER != null){
					BUFFERED_READER.close();
				}
			} catch (Exception e) {
			}
			try {
				BUFFERED_WRITER.flush();
			} catch (Exception e) {
			}
			try {
				if(BUFFERED_WRITER != null){
					BUFFERED_WRITER.close();
				}
			} catch (Exception e) {
			}
			try{
				EMS_CONNECTION.recycle();
			}catch(Exception e){
			}
			log.info(" Exit Souce File Read Routine ");
		}

		exec_CountUpdate();
	}
}
